/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.managers.log.Log;
import com.alee.utils.ImageUtils;
import com.alee.utils.system.JavaVersion;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;

public final class SystemUtils {
    public static final String WINDOWS = "win";
    public static final String MAC = "mac";
    public static final String UNIX = "unix";
    public static final String SOLARIS = "solaris";
    private static JavaVersion javaVersion;
    private static final String osName;
    private static final String shortOsName;
    private static Cursor transparentCursor;

    public static void copyToClipboard(String text) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(text), null);
        }
        catch (Throwable e) {
            Log.error(SystemUtils.class, e);
        }
    }

    public static String getStringFromClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    public static JavaVersion getJavaVersion() {
        if (javaVersion == null) {
            javaVersion = new JavaVersion(SystemUtils.getJavaVersionString());
        }
        return javaVersion;
    }

    public static boolean isJavaVersion(double version, int update) {
        return SystemUtils.getJavaVersion().compareVersion(version, 0, update) >= 0;
    }

    public static boolean isJavaVersion(double major, int minor, int update) {
        return SystemUtils.getJavaVersion().compareVersion(major, minor, update) >= 0;
    }

    public static boolean isJava6orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJava7orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.7, 0, 0) >= 0;
    }

    public static boolean isJava8orAbove() {
        return SystemUtils.getJavaVersion().compareVersion(1.8, 0, 0) >= 0;
    }

    public static String getJavaName() {
        return System.getProperty("java.vm.name");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static String getShortOsName() {
        return shortOsName;
    }

    public static ImageIcon getOsIcon() {
        return SystemUtils.getOsIcon(true);
    }

    public static ImageIcon getOsIcon(boolean color) {
        return SystemUtils.getOsIcon(16, color);
    }

    public static ImageIcon getOsIcon(int size) {
        return SystemUtils.getOsIcon(size, true);
    }

    public static ImageIcon getOsIcon(int size, boolean color) {
        if (size != 16 && size != 32) {
            size = 16;
        }
        String os = SystemUtils.getShortOsName();
        String mark = color ? "_colored" : "";
        return os != null ? new ImageIcon(SystemUtils.class.getResource("icons/os/" + size + "/" + os + mark + ".png")) : null;
    }

    public static boolean isWindows() {
        return shortOsName == WINDOWS;
    }

    public static boolean isMac() {
        return shortOsName == MAC;
    }

    public static boolean isUnix() {
        return shortOsName == UNIX;
    }

    public static boolean isSolaris() {
        return shortOsName == SOLARIS;
    }

    public static String getOsArch() {
        return ManagementFactory.getOperatingSystemMXBean().getArch();
    }

    public static String getOsName() {
        return osName;
    }

    public static String getOsSite() {
        if (SystemUtils.isWindows()) {
            return "http://www.microsoft.com/";
        }
        if (SystemUtils.isMac()) {
            return "http://www.apple.com/";
        }
        if (SystemUtils.isUnix()) {
            return "http://www.unix.org/";
        }
        if (SystemUtils.isSolaris()) {
            return "http://www.oracle.com/";
        }
        return null;
    }

    public static String getOsVersion() {
        return ManagementFactory.getOperatingSystemMXBean().getVersion();
    }

    public static int getOsProcessors() {
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    public static String getJreArch() {
        return SystemUtils.getJreArchName().contains("64") ? "64" : "32";
    }

    public static String getJreArchName() {
        return System.getProperty("sun.arch.data.model");
    }

    public static boolean isCapsLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    public static boolean isNumLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(144);
    }

    public static boolean isScrollLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(145);
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return SystemUtils.getGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static GraphicsEnvironment getGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    public static List<GraphicsDevice> getGraphicsDevices() {
        GraphicsEnvironment graphicsEnvironment = SystemUtils.getGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        GraphicsDevice defaultScreenDevice = graphicsEnvironment.getDefaultScreenDevice();
        ArrayList<GraphicsDevice> devices = new ArrayList<GraphicsDevice>();
        for (GraphicsDevice gd : screenDevices) {
            if (gd.getType() != 0) continue;
            if (gd == defaultScreenDevice) {
                devices.add(0, gd);
                continue;
            }
            devices.add(gd);
        }
        return devices;
    }

    public static Rectangle getMaxWindowBounds(GraphicsConfiguration gc, boolean applyScreenInsets) {
        if (gc != null) {
            Rectangle b = gc.getBounds();
            if (applyScreenInsets) {
                Insets si = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                return new Rectangle(si.left, si.top, b.width - si.left - si.right, b.height - si.top - si.bottom);
            }
            return new Rectangle(0, 0, b.width, b.height);
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public static GraphicsDevice getGraphicsDevice(Rectangle bounds) {
        int maxArea = 0;
        GraphicsDevice device = null;
        for (GraphicsDevice gd : SystemUtils.getGraphicsDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle sb = gc.getBounds();
            if (!bounds.intersects(sb)) continue;
            Rectangle intersection = bounds.intersection(sb);
            int s = intersection.width * intersection.height;
            if (maxArea >= s) continue;
            maxArea = s;
            device = gd;
        }
        return device != null ? device : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    public static Cursor getTransparentCursor() {
        if (transparentCursor == null) {
            Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
            BufferedImage image = ImageUtils.createCompatibleImage(d.width, d.height, 3);
            transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "transparent");
        }
        return transparentCursor;
    }

    static {
        osName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        String lc = osName.toLowerCase(Locale.ENGLISH);
        shortOsName = lc.contains(WINDOWS) ? WINDOWS : (lc.contains(MAC) || lc.contains("darwin") ? MAC : (lc.contains("nix") || lc.contains("nux") ? UNIX : (lc.contains("sunos") ? SOLARIS : null)));
    }
}

