/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.tab.DocumentAdapter;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDataCancellableRunnable;
import com.alee.extended.tab.DocumentDataRunnable;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.extended.window.PopOverAdapter;
import com.alee.extended.window.PopOverEventRunnable;
import com.alee.extended.window.WebPopOver;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.utils.SwingUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.ComponentEventRunnable;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.swing.DocumentEventRunnable;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.WindowCloseAdapter;
import com.alee.utils.swing.WindowEventRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class EventUtils {
    public static final int LEFT_MB = 1;
    public static final int MIDDLE_MB = 2;
    public static final int RIGHT_MB = 3;

    public static MouseAdapter onMousePress(Component component, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(component, null, runnable);
    }

    public static MouseAdapter onMousePress(Component component, final MouseButton mouseButton, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onMouseEnter(Component component, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                runnable.run(e);
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onMouseExit(Component component, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                runnable.run(e);
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onMouseDrag(Component component, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(component, null, runnable);
    }

    public static MouseAdapter onMouseDrag(Component component, final MouseButton mouseButton, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addMouseMotionListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onMouseClick(Component component, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(component, null, runnable);
    }

    public static MouseAdapter onMouseClick(Component component, final MouseButton mouseButton, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onDoubleClick(Component component, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    runnable.run(e);
                }
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static MouseAdapter onMenuTrigger(Component component, final MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtils.isRightMouseButton(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    public static KeyAdapter onKeyType(Component component, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(component, null, runnable);
    }

    public static KeyAdapter onKeyType(Component component, final HotkeyData hotkey, final KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    public static KeyAdapter onKeyPress(Component component, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(component, null, runnable);
    }

    public static KeyAdapter onKeyPress(Component component, final HotkeyData hotkey, final KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    public static KeyAdapter onKeyRelease(Component component, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(component, null, runnable);
    }

    public static KeyAdapter onKeyRelease(Component component, final HotkeyData hotkey, final KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    public static FocusAdapter onFocusGain(Component component, final FocusEventRunnable runnable) {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                runnable.run(e);
            }
        };
        component.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    public static FocusAdapter onFocusLoss(Component component, final FocusEventRunnable runnable) {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                runnable.run(e);
            }
        };
        component.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    public static WindowAdapter onClosing(Window window, final WindowEventRunnable runnable) {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                runnable.run(e);
            }
        };
        window.addWindowListener(windowAdapter);
        return windowAdapter;
    }

    public static WindowCloseAdapter onClose(Window window, final ComponentEventRunnable runnable) {
        WindowCloseAdapter windowAdapter = new WindowCloseAdapter(){

            @Override
            public void closed(ComponentEvent e) {
                runnable.run(e);
            }
        };
        window.addWindowListener(windowAdapter);
        window.addComponentListener(windowAdapter);
        return windowAdapter;
    }

    public static Pair<DocumentChangeListener, PropertyChangeListener> onChange(JTextComponent textComponent, final DocumentEventRunnable runnable) {
        final DocumentChangeListener documentChangeListener = new DocumentChangeListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                runnable.run(e);
            }
        };
        textComponent.getDocument().addDocumentListener(documentChangeListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object newDocument;
                Object oldDocument = e.getOldValue();
                if (oldDocument != null && oldDocument instanceof Document) {
                    ((Document)oldDocument).removeDocumentListener(documentChangeListener);
                }
                if ((newDocument = e.getNewValue()) != null && newDocument instanceof Document) {
                    ((Document)newDocument).addDocumentListener(documentChangeListener);
                }
            }
        };
        textComponent.addPropertyChangeListener("document", propertyChangeListener);
        return new Pair<DocumentChangeListener, PropertyChangeListener>(documentChangeListener, propertyChangeListener);
    }

    public static PopOverAdapter onOpen(WebPopOver popOver, final PopOverEventRunnable runnable) {
        PopOverAdapter popOverAdapter = new PopOverAdapter(){

            @Override
            public void opened(WebPopOver popOver) {
                runnable.run(popOver);
            }
        };
        popOver.addPopOverListener(popOverAdapter);
        return popOverAdapter;
    }

    public static PopOverAdapter onReopen(WebPopOver popOver, final PopOverEventRunnable runnable) {
        PopOverAdapter popOverAdapter = new PopOverAdapter(){

            @Override
            public void reopened(WebPopOver popOver) {
                runnable.run(popOver);
            }
        };
        popOver.addPopOverListener(popOverAdapter);
        return popOverAdapter;
    }

    public static PopOverAdapter onDetach(WebPopOver popOver, final PopOverEventRunnable runnable) {
        PopOverAdapter popOverAdapter = new PopOverAdapter(){

            @Override
            public void detached(WebPopOver popOver) {
                runnable.run(popOver);
            }
        };
        popOver.addPopOverListener(popOverAdapter);
        return popOverAdapter;
    }

    public static PopOverAdapter onClose(WebPopOver popOver, final PopOverEventRunnable runnable) {
        PopOverAdapter popOverAdapter = new PopOverAdapter(){

            @Override
            public void closed(WebPopOver popOver) {
                runnable.run(popOver);
            }
        };
        popOver.addPopOverListener(popOverAdapter);
        return popOverAdapter;
    }

    public static <T extends DocumentData> DocumentAdapter<T> onDocumentOpen(WebDocumentPane<T> documentPane, final DocumentDataRunnable<T> runnable) {
        DocumentAdapter documentAdapter = new DocumentAdapter<T>(){

            @Override
            public void opened(T document, PaneData<T> pane, int index) {
                runnable.run(document, pane, index);
            }
        };
        documentPane.addDocumentListener(documentAdapter);
        return documentAdapter;
    }

    public static <T extends DocumentData> DocumentAdapter<T> onDocumentSelection(WebDocumentPane<T> documentPane, final DocumentDataRunnable<T> runnable) {
        DocumentAdapter documentAdapter = new DocumentAdapter<T>(){

            @Override
            public void selected(T document, PaneData<T> pane, int index) {
                runnable.run(document, pane, index);
            }
        };
        documentPane.addDocumentListener(documentAdapter);
        return documentAdapter;
    }

    public static <T extends DocumentData> DocumentAdapter<T> onDocumentClosing(WebDocumentPane<T> documentPane, final DocumentDataCancellableRunnable<T> runnable) {
        DocumentAdapter documentAdapter = new DocumentAdapter<T>(){

            @Override
            public boolean closing(T document, PaneData<T> pane, int index) {
                return runnable.run(document, pane, index);
            }
        };
        documentPane.addDocumentListener(documentAdapter);
        return documentAdapter;
    }

    public static <T extends DocumentData> DocumentAdapter<T> onDocumentClose(WebDocumentPane<T> documentPane, final DocumentDataRunnable<T> runnable) {
        DocumentAdapter documentAdapter = new DocumentAdapter<T>(){

            @Override
            public void closed(T document, PaneData<T> pane, int index) {
                runnable.run(document, pane, index);
            }
        };
        documentPane.addDocumentListener(documentAdapter);
        return documentAdapter;
    }
}

