/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.extended.panel.AccordionListener;
import com.alee.extended.panel.WebAccordion;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.TextUtils;
import java.util.List;

public class WebAccordionSettingsProcessor
extends SettingsProcessor<WebAccordion, String> {
    private AccordionListener accordionListener;

    public WebAccordionSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    protected void doInit(WebAccordion accordion) {
        this.accordionListener = new AccordionListener(){

            @Override
            public void selectionChanged() {
                WebAccordionSettingsProcessor.this.save();
            }
        };
        accordion.addAccordionListener(this.accordionListener);
    }

    @Override
    protected void doDestroy(WebAccordion accordion) {
        accordion.removeAccordionListener(this.accordionListener);
        this.accordionListener = null;
    }

    @Override
    protected void doLoad(WebAccordion accordion) {
        String string = (String)this.loadValue();
        List<Integer> indices = string == null || string.trim().equals("") ? null : TextUtils.stringToIntList(string, ",");
        accordion.setSelectedIndices(indices);
    }

    @Override
    protected void doSave(WebAccordion accordion) {
        String value = TextUtils.listToString(accordion.getSelectedIndices(), ",");
        this.saveValue(value != null ? value : "");
    }
}

