/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSliderSettingsProcessor
extends SettingsProcessor<JSlider, Integer> {
    private ChangeListener changeListener;

    public JSliderSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    public Integer getDefaultValue() {
        Integer defaultValue = (Integer)super.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = ((JSlider)this.getComponent()).getMinimum();
        }
        return defaultValue;
    }

    @Override
    protected void doInit(JSlider slider) {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSliderSettingsProcessor.this.save();
            }
        };
        slider.addChangeListener(this.changeListener);
    }

    @Override
    protected void doDestroy(JSlider slider) {
        slider.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    @Override
    protected void doLoad(JSlider slider) {
        slider.setValue((Integer)this.loadValue());
    }

    @Override
    protected void doSave(JSlider slider) {
        SettingsManager.set(this.getGroup(), this.getKey(), slider.getValue());
    }
}

