/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.log;

import com.alee.managers.log.LogMessageType;
import com.alee.managers.log.LogPrefixSupplier;
import com.alee.utils.ReflectUtils;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    protected static final Map<Class, Logger> loggers = new WeakHashMap<Class, Logger>();
    protected static final Map<Class, Boolean> loggingEnabled = new WeakHashMap<Class, Boolean>();
    protected static final Object logLock = new Object();
    protected static boolean debugEnabled = false;
    protected static LogPrefixSupplier prefixSupplier = null;
    protected static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            System.setProperty("org.slf4j.simpleLogger.logFile", "System.out");
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugEnabled(boolean debugEnabled) {
        Object object = logLock;
        synchronized (object) {
            Log.debugEnabled = debugEnabled;
        }
    }

    public static LogPrefixSupplier getPrefixSupplier() {
        return prefixSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrefixSupplier(LogPrefixSupplier supplier) {
        Object object = logLock;
        synchronized (object) {
            prefixSupplier = supplier;
        }
    }

    public static void info(String message, Object ... data) {
        Log.info(ReflectUtils.getCallerClass(), message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(Object logFor, String message, Object ... data) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                String msg = data == null || data.length == 0 ? message : String.format(message, data);
                Log.getLogger(logFor).info(Log.getPrefix(LogMessageType.info, msg) + msg);
            }
        }
    }

    public static void debug(String message, Object ... data) {
        Log.debug(ReflectUtils.getCallerClass(), message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(Object logFor, String message, Object ... data) {
        Object object = logLock;
        synchronized (object) {
            if (debugEnabled && Log.isLoggingEnabled(logFor)) {
                String msg = data == null || data.length == 0 ? message : String.format(message, data);
                Log.getLogger(logFor).debug(Log.getPrefix(LogMessageType.debug, msg) + msg);
            }
        }
    }

    public static void warn(String message) {
        Log.warn(ReflectUtils.getCallerClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warn(Object logFor, String message) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                Log.getLogger(logFor).warn(Log.getPrefix(LogMessageType.warn, message) + message);
            }
        }
    }

    public static void warn(String message, Throwable throwable) {
        Log.warn(ReflectUtils.getCallerClass(), message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warn(Object logFor, String message, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                Log.getLogger(logFor).warn(Log.getPrefix(LogMessageType.warn, message, throwable) + message, throwable);
            }
        }
    }

    public static void error(Throwable throwable) {
        Log.error((Object)ReflectUtils.getCallerClass(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                String msg = throwable.toString();
                Log.getLogger(logFor).error(Log.getPrefix(LogMessageType.info, msg, throwable) + msg, throwable);
            }
        }
    }

    public static void error(String message, Throwable throwable) {
        Log.error(ReflectUtils.getCallerClass(), message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, String message, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                Log.getLogger(logFor).error(Log.getPrefix(LogMessageType.info, message, throwable) + message, throwable);
            }
        }
    }

    public static void error(String message) {
        Log.error((Object)ReflectUtils.getCallerClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, String message) {
        Object object = logLock;
        synchronized (object) {
            if (Log.isLoggingEnabled(logFor)) {
                Log.getLogger(logFor).error(Log.getPrefix(LogMessageType.info, message) + message);
            }
        }
    }

    public static String getPrefix(LogMessageType type, String message) {
        return Log.getPrefix(type, message, null);
    }

    public static String getPrefix(LogMessageType type, String message, Throwable throwable) {
        if (prefixSupplier != null) {
            String prefix = prefixSupplier.get(type, message, throwable);
            return prefix != null ? prefix : "";
        }
        return "";
    }

    public static Logger get() {
        return Log.getLogger(ReflectUtils.getCallerClass());
    }

    public static Logger getLogger() {
        return Log.getLogger(ReflectUtils.getCallerClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Object object) {
        Object object2 = logLock;
        synchronized (object2) {
            Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
            Logger logger = loggers.get(type);
            if (logger == null) {
                logger = LoggerFactory.getLogger(type);
                loggers.put(type, logger);
            }
            return logger;
        }
    }

    public static void disableLogging(Object object) {
        Log.setLoggingEnabled(object, false);
    }

    public static void enableLogging(Object object) {
        Log.setLoggingEnabled(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggingEnabled(Object object, boolean enabled) {
        Object object2 = logLock;
        synchronized (object2) {
            Class<?> type;
            Class<?> clazz = type = object instanceof Class ? (Class<?>)object : object.getClass();
            if (!enabled) {
                loggingEnabled.put(type, enabled);
            } else {
                loggingEnabled.remove(type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingEnabled(Object object) {
        Object object2 = logLock;
        synchronized (object2) {
            if (loggingEnabled.size() == 0) {
                return true;
            }
            Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
            Boolean enabled = loggingEnabled.get(type);
            return enabled == null || enabled != false;
        }
    }
}

