/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.LanguageInfo;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Value;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@XStreamAlias(value="Dictionary")
public final class Dictionary
implements Serializable {
    private static final String ID_PREFIX = "DIC";
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String prefix;
    @XStreamAsAttribute
    private String author;
    @XStreamAsAttribute
    private String creationDate;
    @XStreamAsAttribute
    private String notes;
    @XStreamImplicit(itemFieldName="record")
    private List<Record> records;
    @XStreamImplicit(itemFieldName="Dictionary")
    private List<Dictionary> subdictionaries;
    @XStreamAlias(value="LanguageInfo")
    private List<LanguageInfo> languageInfos;

    public Dictionary() {
        this.setId();
    }

    public Dictionary(String prefix) {
        this.setId();
        this.setPrefix(prefix);
    }

    public Dictionary(String prefix, String name) {
        this.setId();
        this.setPrefix(prefix);
        this.setName(name);
    }

    public Dictionary(String prefix, String name, String author) {
        this.setId();
        this.setPrefix(prefix);
        this.setName(name);
        this.setAuthor(author);
    }

    public Dictionary(String prefix, String name, String author, String creationDate) {
        this.setId();
        this.setPrefix(prefix);
        this.setName(name);
        this.setAuthor(author);
        this.setCreationDate(creationDate);
    }

    public Dictionary(String prefix, String name, String author, String creationDate, String notes) {
        this.setId();
        this.setPrefix(prefix);
        this.setName(name);
        this.setAuthor(author);
        this.setCreationDate(creationDate);
        this.setNotes(notes);
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    public void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public List<Dictionary> getSubdictionaries() {
        return this.subdictionaries;
    }

    public void setSubdictionaries(List<Dictionary> subdictionaries) {
        this.subdictionaries = subdictionaries;
    }

    public List<LanguageInfo> getLanguageInfos() {
        return this.languageInfos;
    }

    public void setLanguageInfos(List<LanguageInfo> languageInfos) {
        this.languageInfos = languageInfos;
    }

    public LanguageInfo getLanguageInfo(String language) {
        if (this.languageInfos != null) {
            for (LanguageInfo languageInfo : this.languageInfos) {
                if (!languageInfo.getLang().equals(language)) continue;
                return languageInfo;
            }
        }
        return null;
    }

    public void addLanguageInfo(LanguageInfo info) {
        if (this.languageInfos == null) {
            this.languageInfos = new ArrayList<LanguageInfo>(1);
        }
        Iterator<LanguageInfo> iterator = this.languageInfos.iterator();
        while (iterator.hasNext()) {
            LanguageInfo next = iterator.next();
            if (!next.getLang().equals(info.getLang())) continue;
            iterator.remove();
            break;
        }
        this.languageInfos.add(info);
    }

    private void checkRecords() {
        if (this.records == null) {
            this.records = new ArrayList<Record>(1);
        }
    }

    public Record addRecord(String key, String language, String text) {
        return this.addRecord(key, new Value(language, text));
    }

    public Record addRecord(String key, String language, Character mnemonic, String text) {
        return this.addRecord(key, new Value(language, mnemonic, text));
    }

    public Record addRecord(String key, Value ... values) {
        return this.addRecord(new Record(key, values));
    }

    public Record addRecord(String key, List<Value> values) {
        return this.addRecord(new Record(key, values));
    }

    public Record addRecord(Record record) {
        this.checkRecords();
        for (Record r : this.records) {
            if (!r.getKey().equals(record.getKey())) continue;
            if (record.getHotkey() == null) {
                record.setHotkey(r.getHotkey());
            }
            for (Value value : r.getValues()) {
                if (record.hasValue(value.getLang())) continue;
                record.addValue(value);
            }
            return r;
        }
        this.records.add(record);
        return record;
    }

    public void removeRecord(Record record) {
        if (this.records != null) {
            this.records.remove(record);
        }
    }

    public void removeRecord(String key) {
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                if (!this.records.get(i).getKey().equals(key)) continue;
                this.records.remove(i);
                break;
            }
        }
    }

    public void removeLanguage(String language) {
        if (this.records != null) {
            for (int i = this.records.size() - 1; i >= 0; --i) {
                this.records.get(i).removeValue(language);
                if (this.records.get(i).size() != 0) continue;
                this.records.remove(i);
            }
        }
    }

    public void clear() {
        if (this.records != null) {
            this.records.clear();
        }
    }

    public int size() {
        return this.records != null ? this.records.size() : 0;
    }

    public void addSubdictionary(Dictionary dictionary) {
        this.checkSubdictionaries();
        this.subdictionaries.add(dictionary);
    }

    private void checkSubdictionaries() {
        if (this.subdictionaries == null) {
            this.subdictionaries = new ArrayList<Dictionary>();
        }
    }

    public void removeSubdictionary(Dictionary dictionary) {
        if (this.subdictionaries != null) {
            this.subdictionaries.remove(dictionary);
        }
    }

    public int subdictionaries() {
        return this.subdictionaries != null ? this.subdictionaries.size() : 0;
    }

    public List<String> getSupportedLanguages() {
        return this.getSupportedLanguages(new ArrayList<String>());
    }

    public List<String> getSupportedLanguages(List<String> languages) {
        if (this.records != null) {
            for (Record record : this.records) {
                record.getSupportedLanguages(languages);
            }
        }
        if (this.subdictionaries != null) {
            for (Dictionary dictionary : this.subdictionaries) {
                dictionary.getSupportedLanguages(languages);
            }
        }
        return languages;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Dictionary && ((Dictionary)obj).getId().equals(this.getId());
    }

    public String toString() {
        return (this.name != null ? this.name + " " : "") + (this.size() > 0 ? " (records: " + this.size() + ")" : "") + (this.subdictionaries() > 0 ? " (subdictionaries: " + this.subdictionaries() + ")" : "");
    }
}

