/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.global.StyleConstants;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.renderers.WebTableHeaderCellRenderer;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WebTableHeaderUI
extends BasicTableHeaderUI {
    public static final Color topLineColor = WebTableStyle.headerTopLineColor;
    public static final Color bottomLineColor = WebTableStyle.headerBottomLineColor;
    public static final Color topBgColor = WebTableStyle.headerTopBgColor;
    public static final Color bottomBgColor = WebTableStyle.headerBottomBgColor;

    public static ComponentUI createUI(JComponent c) {
        return new WebTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.header);
        LookAndFeel.installProperty(this.header, "opaque", Boolean.TRUE);
        this.header.setDefaultRenderer(new WebTableHeaderCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int column;
        Graphics2D g2d = (Graphics2D)g;
        Paint bgPaint = WebTableHeaderUI.createBackgroundPaint(0, 1, 0, this.header.getHeight() - 1);
        g2d.setPaint(bgPaint);
        g2d.fillRect(0, 1, this.header.getWidth(), this.header.getHeight() - 1);
        g2d.setColor(topLineColor);
        g2d.drawLine(0, 0, this.header.getWidth(), 0);
        g2d.setPaint(bottomLineColor);
        g2d.drawLine(0, this.header.getHeight() - 1, this.header.getWidth(), this.header.getHeight() - 1);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, aColumn, draggedColumn, cm);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, aColumn, draggedColumn, cm);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            draggedCellRect.x += this.header.getDraggedDistance();
            g2d.setPaint(bgPaint);
            g2d.fillRect(draggedCellRect.x - 1, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height - 1);
            this.paintCell(g, draggedCellRect, draggedColumnIndex, draggedColumn, draggedColumn, cm);
        }
    }

    public static Paint createBackgroundPaint(int x1, int y1, int x2, int y2) {
        if (bottomBgColor == null || CompareUtils.equals(topBgColor, bottomBgColor)) {
            return topBgColor;
        }
        return new GradientPaint(x1, y1, topBgColor, x2, y2, bottomBgColor);
    }

    private void paintCell(Graphics g, Rectangle rect, int columnIndex, TableColumn tc, TableColumn dc, TableColumnModel cm) {
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        g.setColor(StyleConstants.borderColor);
        g.drawLine(rect.x - 1, rect.y + 2, rect.x - 1, rect.y + rect.height - 4);
        JComponent component = (JComponent)this.getHeaderRenderer(columnIndex);
        component.setOpaque(false);
        component.setEnabled(this.header.getTable().isEnabled());
        this.rendererPane.paintComponent(g, component, this.header, rect.x, rect.y, rect.width, rect.height, true);
        if (tc == dc || (ltr ? columnIndex != cm.getColumnCount() - 1 : columnIndex != 0)) {
            g.setColor(WebTableStyle.gridColor);
            g.drawLine(rect.x + rect.width - 1, rect.y + 2, rect.x + rect.width - 1, rect.y + rect.height - 4);
        }
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean hasFocus = !this.header.isPaintingForPrint() && this.header.hasFocus();
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        ps.height = Math.max(ps.height, WebTableStyle.headerHeight);
        return ps;
    }
}

