/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.time;

import com.alee.extended.time.ClockType;
import com.alee.laf.label.WebLabel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WebClock
extends WebLabel {
    protected List<ActionListener> listeners = new ArrayList<ActionListener>();
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    protected ClockType clockType = ClockType.clock;
    protected long timeLeft = 0L;
    protected long initialTimeLeft = 0L;
    protected WebTimer timer;

    public WebClock() {
        this.initClock();
    }

    protected void initClock() {
        this.timer = new WebTimer(100L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebClock.this.clockType.equals((Object)ClockType.stopwatch)) {
                    WebClock.this.timeLeft += 100L;
                } else if (WebClock.this.clockType.equals((Object)ClockType.timer)) {
                    WebClock.this.timeLeft -= 100L;
                    if (WebClock.this.timeLeft <= 1000L) {
                        WebClock.this.timeLeft = 0L;
                        WebClock.this.fireActionPerformed();
                        WebClock.this.timer.stop();
                    }
                }
                WebClock.this.updateTime();
            }
        });
    }

    protected void updateTime() {
        if (this.clockType.equals((Object)ClockType.stopwatch) || this.clockType.equals((Object)ClockType.timer)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 0);
            calendar.set(6, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.setTimeInMillis(calendar.getTimeInMillis() + this.timeLeft);
            this.setText(this.dateFormat.format(calendar.getTime()));
        } else {
            this.setText(this.dateFormat.format(System.currentTimeMillis()));
        }
    }

    public String getTimePattern() {
        return this.dateFormat.toPattern();
    }

    public void setTimePattern(String timePattern) {
        this.dateFormat.applyPattern(timePattern);
        this.updateTime();
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.clockType = clockType;
        this.updateTime();
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long timeLeft) {
        if (this.clockType.equals((Object)ClockType.timer)) {
            this.timeLeft = timeLeft;
            this.initialTimeLeft = timeLeft;
        } else {
            this.timeLeft = 0L;
            this.initialTimeLeft = 0L;
        }
        this.updateTime();
    }

    public void start() {
        this.timer.start();
        this.updateTime();
    }

    public void pause() {
        this.timer.stop();
        this.updateTime();
    }

    public void stop() {
        this.timer.stop();
        this.timeLeft = this.initialTimeLeft;
        this.updateTime();
    }

    public List<ActionListener> getActionListeners() {
        return this.listeners;
    }

    public void addActionListener(ActionListener timerFinished) {
        this.listeners.add(timerFinished);
    }

    public void removeActionListener(ActionListener timerFinished) {
        this.listeners.remove(timerFinished);
    }

    public void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Timer finished");
        for (ActionListener timerFinished : CollectionUtils.copy(this.listeners)) {
            timerFinished.actionPerformed(actionEvent);
        }
    }
}

