/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class FoldCollapser {
    private List<Integer> typesToCollapse = new ArrayList<Integer>(3);

    public FoldCollapser() {
        this(1);
    }

    public FoldCollapser(int typeToCollapse) {
        this.addTypeToCollapse(typeToCollapse);
    }

    public void addTypeToCollapse(int typeToCollapse) {
        this.typesToCollapse.add(typeToCollapse);
    }

    public void collapseFolds(FoldManager fm) {
        int i = 0;
        while (i < fm.getFoldCount()) {
            Fold fold = fm.getFold(i);
            this.collapseImpl(fold);
            ++i;
        }
    }

    protected void collapseImpl(Fold fold) {
        if (this.getShouldCollapse(fold)) {
            fold.setCollapsed(true);
        }
        int i = 0;
        while (i < fold.getChildCount()) {
            this.collapseImpl(fold.getChild(i));
            ++i;
        }
    }

    public boolean getShouldCollapse(Fold fold) {
        int type = fold.getFoldType();
        for (Integer typeToCollapse : this.typesToCollapse) {
            if (type != typeToCollapse) continue;
            return true;
        }
        return false;
    }
}

