/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TokenMap {
    private int size;
    private TokenMapToken[] tokenMap;
    private boolean ignoreCase;
    private static final int DEFAULT_TOKEN_MAP_SIZE = 52;

    public TokenMap() {
        this(52);
    }

    public TokenMap(int size) {
        this(size, false);
    }

    public TokenMap(boolean ignoreCase) {
        this(52, ignoreCase);
    }

    public TokenMap(int size, boolean ignoreCase) {
        this.size = size;
        this.tokenMap = new TokenMapToken[size];
        this.ignoreCase = ignoreCase;
    }

    private void addTokenToBucket(int bucket, TokenMapToken token) {
        TokenMapToken old = this.tokenMap[bucket];
        token.nextToken = old;
        this.tokenMap[bucket] = token;
    }

    public int get(Segment text, int start, int end) {
        return this.get(text.array, start, end);
    }

    /*
     * Unable to fully structure code
     */
    public int get(char[] array1, int start, int end) {
        block6: {
            length1 = end - start + 1;
            hash = this.getHashCode(array1, start, length1);
            token = this.tokenMap[hash];
            if (this.ignoreCase) ** GOTO lbl30
            block0: while (token != null) {
                if (TokenMapToken.access$1(token) == length1) {
                    array2 = TokenMapToken.access$2(token);
                    offset2 = TokenMapToken.access$3(token);
                    offset1 = start;
                    length = length1;
                    while (length-- > 0) {
                        if (array1[offset1++] == array2[offset2++]) continue;
                        token = TokenMapToken.access$4(token);
                        continue block0;
                    }
                    return TokenMapToken.access$5(token);
                }
                token = TokenMapToken.access$4(token);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (TokenMapToken.access$1(token) == length1) {
                    array2 = TokenMapToken.access$2(token);
                    offset2 = TokenMapToken.access$3(token);
                    offset1 = start;
                    length = length1;
                    while (length-- > 0) {
                        if (RSyntaxUtilities.toLowerCase(array1[offset1++]) == array2[offset2++]) continue;
                        token = TokenMapToken.access$4(token);
                        continue block2;
                    }
                    return TokenMapToken.access$5(token);
                }
                token = TokenMapToken.access$4(token);
lbl30:
                // 3 sources

                ** while (token != null)
            }
        }
        return -1;
    }

    private int getHashCode(char[] text, int offset, int length) {
        return (RSyntaxUtilities.toLowerCase(text[offset]) + RSyntaxUtilities.toLowerCase(text[offset + length - 1])) % this.size;
    }

    protected boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    public void put(String string, int tokenType) {
        if (this.isIgnoringCase()) {
            this.put(string.toLowerCase().toCharArray(), tokenType);
        } else {
            this.put(string.toCharArray(), tokenType);
        }
    }

    private void put(char[] string, int tokenType) {
        int hashCode = this.getHashCode(string, 0, string.length);
        this.addTokenToBucket(hashCode, new TokenMapToken(string, tokenType));
    }

    private static final class TokenMapToken {
        private char[] text;
        private int offset;
        private int length;
        private int tokenType;
        private TokenMapToken nextToken;

        private TokenMapToken(char[] text, int tokenType) {
            this.text = text;
            this.offset = 0;
            this.length = text.length;
            this.tokenType = tokenType;
        }

        public String toString() {
            return "[TokenMapToken: " + new String(this.text, this.offset, this.length) + "]";
        }

        static /* synthetic */ int access$1(TokenMapToken tokenMapToken) {
            return tokenMapToken.length;
        }

        static /* synthetic */ char[] access$2(TokenMapToken tokenMapToken) {
            return tokenMapToken.text;
        }

        static /* synthetic */ int access$3(TokenMapToken tokenMapToken) {
            return tokenMapToken.offset;
        }

        static /* synthetic */ TokenMapToken access$4(TokenMapToken tokenMapToken) {
            return tokenMapToken.nextToken;
        }

        static /* synthetic */ int access$5(TokenMapToken tokenMapToken) {
            return tokenMapToken.tokenType;
        }
    }
}

