/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

final class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader r) {
        this.r = r;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    /*
     * Unable to fully structure code
     */
    private String convert() throws IOException {
        i = this.r.read();
        if (i == 123) ** GOTO lbl58
        throw new IOException("Invalid RTF file");
lbl-1000:
        // 1 sources

        {
            ch = (char)i;
            switch (ch) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    ++this.blockCount;
                    break;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    --this.blockCount;
                    break;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            break;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        break;
                    }
                    this.inControlWord = true;
                    break;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        break;
                    }
                    this.sb.append(' ');
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    break;
                }
                default: {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.controlWord.append(ch);
                        break;
                    }
                    this.sb.append(ch);
                }
            }
lbl58:
            // 17 sources

            ** while ((i = this.r.read()) != -1)
        }
lbl59:
        // 1 sources

        return this.sb.toString();
    }

    private void endControlWord() {
        String word = this.controlWord.toString();
        if ("par".equals(word)) {
            this.sb.append('\n');
        } else if ("tab".equals(word)) {
            this.sb.append('\t');
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    public static String getPlainText(byte[] rtf) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(rtf));
    }

    public static String getPlainText(File file) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    public static String getPlainText(InputStream in) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(in, "US-ASCII"));
    }

    private static String getPlainText(Reader r) throws IOException {
        try {
            RtfToText converter = new RtfToText(r);
            String string = converter.convert();
            return string;
        }
        finally {
            r.close();
        }
    }

    public static String getPlainText(String rtf) throws IOException {
        return RtfToText.getPlainText(new StringReader(rtf));
    }
}

