/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;

public final class HtmlUtil {
    private HtmlUtil() {
    }

    public static String escapeForHtml(String s, String newlineReplacement, boolean inPreBlock) {
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = "    ";
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    if (inPreBlock) {
                        sb.append(' ');
                        break;
                    }
                    sb.append("&nbsp;");
                    break;
                }
                case '\n': {
                    sb.append(newlineReplacement);
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\t': {
                    sb.append(tabString);
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getHexString(Color c) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("#");
        int r = c.getRed();
        if (r < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(r));
        int g = c.getGreen();
        if (g < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(g));
        int b = c.getBlue();
        if (b < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b));
        return sb.toString();
    }

    public static String getTextAsHtml(RSyntaxTextArea textArea, int start, int end) {
        Token token;
        StringBuilder sb = new StringBuilder("<pre style='").append("font-family: \"").append(textArea.getFont().getFamily()).append("\", courier;");
        if (textArea.getBackground() != null) {
            sb.append(" background: ").append(HtmlUtil.getHexString(textArea.getBackground())).append("'>");
        }
        Token t = token = textArea.getTokenListFor(start, end);
        while (t != null) {
            if (t.isPaintable()) {
                if (t.isSingleChar('\n')) {
                    sb.append("<br>");
                } else {
                    sb.append(TokenUtils.tokenToHtml(textArea, t));
                }
            }
            t = t.getNextToken();
        }
        sb.append("</pre>");
        return sb.toString();
    }
}

