![clone wars](img/og.png)

# Clone Wars - Open source clones of popular sites

> 100+ open-source clones and alternatives of popular sites like Airbnb, Amazon, Instagram, Netflix, TikTok, Spotify, WhatsApp, YouTube, etc. List contains source code, tutorials, demo links, tech stack, and GitHub stars count. Great for learning purpose!

_-Made by <a href= "https://gourav.io" title="Gourav Goyal"> Gourav Goyal </a>_

## See full tables with better view 👉 [gourav.io/clone-wars](https://gourav.io/clone-wars)

---

I need your help to maintain this list up to date 🙏. See [contribution Guide](#contribution-guide).

[I'm also looking for a maintainer to merge PRs of new clones](https://github.com/GorvGoyl/Clone-Wars/issues/209).

### There are 2 tables:

1. [Clones with Tutorials Table](#clones-with-tutorials)

   Full-stack clones with link to free tutorials.

2. [Clones / Alternatives Table](#clones-and-alternatives)

   Two kinds of projects on this list:

   1. Clones: look quite similar (UI-wise) but aren't fully-functional, mostly made for learning purposes.
   2. Alternatives: fully-functional open-source alternatives of popular software.
      Seeing GitHub stars will give you a rough idea about which one is which.

> Read the story behind this project: [My simple GitHub project went viral 🚀](https://gourav.io/blog/my-simple-github-project-went-viral)

## Clones with Tutorials
| Clone of  | Demo                                                                                                   | Tutorial / Course Site                                                                                                          | Repo                                                                                                                                  | Tech Stack                                                      |
| --------- | ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------- |
| Airbnb    | [YouTube](https://www.youtube.com/watch?v=mx1dbMzd3tU&ab_channel=CodewithAniaKub%C3%B3w&t=9039s)       | [YouTube](https://www.youtube.com/watch?v=mx1dbMzd3tU&ab_channel=CodewithAniaKub%C3%B3w)                                        | [GitHub backend](https://github.com/kubowania/airbnb-sanity-backend), [frontend](https://github.com/kubowania/airbnb-sanity-frontend) | Sanity SDK, Next.js, React Hooks                                |
| Instagram | [YouTube](https://www.youtube.com/watch?v=1hPgQWbWmEk&t=5h2902s)                                       | [freeCodeCamp](https://www.freecodecamp.org/news/build-an-instagram-clone-with-react-native-firebase-firestore-redux-and-expo/) | [GitHub](https://github.com/SimCoderYoutube/InstagramClone)                                                                           | React Native, Firebase Firestore, Firebase storage, Redux, Expo |
| Moodle    | [YouTube](https://www.youtube.com/watch?v=JIFqqdRxmVo&t=45s)                                           | [freeCodeCamp](https://www.freecodecamp.org/news/django-rest-framework-react-tutorial/)                                         | [GitHub](https://github.com/justdjango/teach-me-django)                                                                               | React, Django Rest Framework                                    |
| Netflix   | [YouTube](https://www.youtube.com/watch?v=g8COh40v2jU&t=8241s)                                         | [YouTube](https://www.youtube.com/watch?v=g8COh40v2jU)                                                                          | [GitHub](https://github.com/kubowania/netflix-clone-graphql-datastax)                                                                 | React, Apollo GraphQL, DataStax Astra, Netlify                  |
| Todoist   | [todoist-preview.png](https://raw.githubusercontent.com/karlhadwen/todoist/master/todoist-preview.png) | [freeCodeCamp](https://www.freecodecamp.org/news/react-firebase-todoist-clone/)                                                 | [GitHub](https://github.com/karlhadwen/todoist)                                                                                       | React, Firebase, React, SCSS, BEM naming methodology            |
| Twitter   | [YouTube](https://www.youtube.com/watch?v=la-0ulfn0_M&t=8864s)                                         | [freeCodeCamp](https://www.freecodecamp.org/news/create-a-cross-platform-twitter-clone-with-vue-js/)                            | [GitHub](https://github.com/dannyconnell/qwitter)                                                                                     | Vue.js, Quasar Framework, Firebase                              |
| WhatsApp  | [YouTube](https://www.youtube.com/watch?v=988UZFB0heA&t=5h274s)                                        | [freeCodeCamp](https://www.freecodecamp.org/news/native-android-app-tutorial-whatsapp-clone/)                                   | [GitHub](https://github.com/SimCoderYoutube/WhatsAppClone)                                                                            | Android Studio, Firebase, Genymotion                            |
| Discord   | [YouTube](https://www.youtube.com/watch?v=PtQiiknWUcI)                                                 | [Youtube (Traversy Media)](https://www.youtube.com/watch?v=PtQiiknWUcI)                                                         | [GitHub](https://github.com/divanov11/StudyBud/)                                                                                      | Django                                                          |
| YouTube   | [YouTube](https://youtu.be/FHTbsZEJspU?t=6)                                                            | [Youtube (JavaScript Mastery)](https://www.youtube.com/watch?v=FHTbsZEJspU)                                                     | [GitHub](https://github.com/adrianhajdin/project_youtube_clone)                                                                       | React JS, Rapid API, Material UI 5                              |
| YouTube   | [YouTube](https://www.youtube.com/watch?v=whuIf33v2Ug&t=189s)                                          | [freeCodeCamp](https://www.freecodecamp.org/news/learn-how-to-use-the-yii2-php-framework-to-create-a-youtube-clone/)            | [GitHub](https://github.com/thecodeholic/Yii2-YouTube-Clone)                                                                          | Yii2 PHP Framework                                              |
| YouTube   | [YouTube](https://www.youtube.com/watch?v=WBlScMZgn3w&t=9086s)                                         | [YouTube](https://www.youtube.com/playlist?list=PLA7YMGupLhlF0N0eQfJKAq1j9Xa3xuiM8)                                             | [GitHub](https://github.com/Breens-Mbaka/Youtube-Clone)                                                                               | Android Studio, Kotlin, XML, YouTube API                        |

---

## Clones and Alternatives

_(scroll right on table to see all 5 columns)_

| Clone/Alt of                   | Demo                                                                                                                                                                   | Repo                                                                                                                                       | Tech stack                                                                     | Repo Stars                                                                                                                                                                                     |
| ------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1Password / LastPass           | [bitwarden.com](https://bitwarden.com/)                                                                                                                                | [GitHub](https://github.com/bitwarden/mobile)                                                                                              | C#, Xamarin                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/bitwarden/mobile)                                                                                                                     |
| 2048                           | [gh.artemchep.com](https://gh.artemchep.com/2048/#/)                                                                                                                   | [GitHub](https://github.com/AChep/2048)                                                                                                    | Dart, Flutter                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/AChep/2048)                                                                                                                           |
| 2048                           | [2048-three.vercel.app](https://2048-three.vercel.app/)                                                                                                                | [GitHub](https://github.com/AreebKhan619/2048)                                                                                             | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/AreebKhan619/2048)                                                                                                                    |
| 2048                           | [demo.matsz.dev](https://demo.matsz.dev/2048/)                                                                                                                         | [GitHub](https://github.com/mat-sz/2048)                                                                                                   | React, TypeScript, Redux                                                       | ![GitHub Repo stars](https://img.shields.io/github/stars/mat-sz/2048)                                                                                                                          |
| 2048                           | [guaracy.github.io](https://guaracy.github.io/beads/sites/2048/2048.html)                                                                                              | [GitHub](https://github.com/guaracy/2048-beads)                                                                                            | Beads                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/guaracy/2048-beads)                                                                                                                   |
| 2048                           | [oddrationale.github.io](http://oddrationale.github.io/dart_2048/)                                                                                                     | [GitHub](https://github.com/oddrationale/dart_2048)                                                                                        | Dart                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/oddrationale/dart_2048)                                                                                                               |
| Airbnb                         | [abod-bnb.web.app](https://abod-bnb.web.app/)                                                                                                                          | [GitHub](https://github.com/abodmicheal/React-projects/tree/master/Abodbnb)                                                                | React, Firebase                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/abodmicheal/React-projects)                                                                                                           |
| Airbnb                         | [realbnb.vercel.app](https://realbnb.vercel.app/)                                                                                                                      | [GitHub](https://github.com/shubhsk88/realbnb-frontend)                                                                                    | TypeScript, React, NextJS, Prisma, GraphQL                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/shubhsk88/realbnb-frontend)                                                                                                           |
| Airbnb                  | [airbnb-clone-black-seven.vercel.app/](https://airbnb-clone-black-seven.vercel.app/)                                                                                                                                            | [GitHub](https://github.com/juan-20/Airbnb-clone)                                                                                                   | Next, Tailwind, SEO, TypeScript | ![GitHub Repo stars](https://flat.badgen.net/github/stars/juan-20/Airbnb-clone)                                                                                                                           |
| Airtable                       | [rowy.io](https://rowy.io/)                                                                                                                                            | [GitHub](https://github.com/rowyio/rowy)                                                                                                   | React, Firebase, Firestore, Google Cloud Platform, Cloud Functions, TypeScript | ![GitHub Repo stars](https://img.shields.io/github/stars/rowyio/rowy)                                                                                                                          |
| Airtable                       | [baserow](https://baserow.io/)                                                                                                                                         | [GitLab](https://gitlab.com/bramw/baserow)                                                                                                 | Django, nuxt.js, PostgreSQL                                                    |                                                                                                                                                                                                |
| Algolia                        | [meilisearch.com](https://www.meilisearch.com/)                                                                                                                        | [GitHub](https://github.com/meilisearch/MeiliSearch)                                                                                       | Rust                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/meilisearch/MeiliSearch)                                                                                                              |
| Amazon                         | [amazonna.netlify.app](https://amazonna.netlify.app/) <br/> [youtube](https://youtu.be/MSctN0MOdt0)                                                                    | [GitHub](https://github.com/emmanuelhashy/amazon-clone)                                                                                    | React, Firebase                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/emmanuelhashy/amazon-clone)                                                                                                           |
| Amazon Prime Video             | [prime-clone-e1de6.firebaseapp](https://prime-clone-e1de6.firebaseapp.com/)                                                                                            | [GitHub](https://github.com/peeyush14goyal/AmazonPrime-ReactJS-Clone)                                                                      | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/peeyush14goyal/AmazonPrime-ReactJS-Clone)                                                                                             |
| Apple Music                    | [appo-music.herokuapp](https://appo-music.herokuapp.com/)                                                                                                              | [GitHub](https://github.com/oriravid/Appo-Music)                                                                                           | React, Redux, Ruby on Rails, PostgreSQL                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/oriravid/Appo-Music)                                                                                                                  |
| ArcoMage                       | [arcomage.github.io](https://arcomage.github.io/)                                                                                                                      | [GitHub](https://github.com/arcomage/arcomage-hd)                                                                                          | TypeScript, React, Redux, RxJS, Sass, WebRTC                                   | ![GitHub Repo stars](https://img.shields.io/github/stars/arcomage/arcomage-hd)                                                                                                                 |
| Auth0                          | [ory.sh](https://www.ory.sh/docs/ecosystem/projects/)                                                                                                                  | [GitHub](https://github.com/ory)                                                                                                           | Go                                                                             | ![GitHub Repo stars](https://img.shields.io/github/stars/ory)                                                                                                                                  |
| Bit.ly                         | [polrproject.org](https://polrproject.org/)                                                                                                                            | [GitHub](https://github.com/cydrobolt/polr)                                                                                                | PHP, MySQL                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/cydrobolt/polr)                                                                                                                       |
| Bit.ly                         | [shlink.io](https://shlink.io/)                                                                                                                                        | [GitHub](https://github.com/shlinkio/shlink)                                                                                               | PHP, Mezzio, Doctrine, Symfony                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/shlinkio/shlink)                                                                                                                      |
| Bit.ly                         | [zws.im](https://zws.im/)                                                                                                                                              | [GitHub](https://github.com/zws-im/zws)                                                                                                    | TypeScript,                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/zws-im/zws)                                                                                                                           |
| Bit.ly                         | [kutt.it](https://kutt.it/)                                                                                                                                            | [GitHub](https://github.com/thedevs-network/kutt)                                                                                          | TypeScript,                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/thedevs-network/kutt)                                                                                                                 |
| Bit.ly                         | [shortl.it](https://shortl.it)                                                                                                                                         | [GitHub](https://github.com/CraftException/shortl.it)                                                                                      | TypeScript, NodeJS, EJS, JQuery                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/CraftException/shortl.it)                                                                                                              |
|BrickGame                         | [Retro-Brick-Game](https://nabeelshar.github.io/Retro-Brick-Game/)                                                                                                                                         | [GitHub](https://github.com/Nabeelshar/Retro-Brick-Game)                                                                                      | React, Redux                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Nabeelshar/Retro-Brick-Gamet)                                                                                                              |
| Battleship Game                | [battleboats.ito.wtf](https://battleboats.ito.wtf/)                                                                                                                    | [GitHub](https://github.com/hairarrow/btship)                                                                                              | TypeScript, React                                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/hairarrow/btship)                                                                                                                     |
| Calendly                       | [calendso.com](https://calendso.com/)                                                                                                                                  | [GitHub](https://github.com/calendso/calendso)                                                                                             | Next.js, Typescript, React, Tailwind, Prisma                                   | ![GitHub Repo stars](https://img.shields.io/github/stars/calendso/calendso)                                                                                                                    |
| Clubhouse                      | [jam.systems](https://jam.systems/)                                                                                                                                    | [GitHub](https://github.com/jam-systems/jam)                                                                                               | React, WebRTC                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/jam-systems/jam)                                                                                                                      |
| Clubhouse                      | [dogehouse.tv](https://dogehouse.tv)                                                                                                                                   | [GitHub](https://github.com/benawad/dogehouse)                                                                                             | React, Postgress, Elixir                                                       | ![GitHub Repo stars](https://img.shields.io/github/stars/benawad/dogehouse)                                                                                                                    |
| Codecademy                     | [codecademyclone.netlify.app](https://codecademyclone.netlify.app/)                                                                                                    | [GitHub](https://github.com/shanoysinc/Codecademy-clone)                                                                                   | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/shanoysinc/Codecademy-clone)                                                                                                          |
| DEV.to                         | [devfrom.netlify.app](https://devfrom.netlify.app/)                                                                                                                    | [GitHub](https://github.com/eknoorpreet/dev.to-clone)                                                                                      | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/eknoorpreet/dev.to-clone)                                                                                                             |
| Discord                        | [ericellb.github.io](http://ericellb.github.io/React-Discord-Clone)                                                                                                    | [GitHub](https://github.com/ericellb/React-Discord-Clone)                                                                                  | React, Node, Express, Socket-IO, MySQL                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/ericellb/React-Discord-Clone)                                                                                                         |
| Discord                        | [valkyrieapp](https://valkyrieapp.xyz)                                                                                                                                 | [GitHub](https://github.com/sentrionic/Valkyrie)                                                                                           | React, NestJS, TypeScript, Socket-IO, PostgreSQL                               | ![GitHub Repo stars](https://img.shields.io/github/stars/sentrionic/Valkyrie)                                                                                                                  |
| Discord                        | [dev.fosscord.com](https://dev.fosscord.com/app)                                                                                                                       | [GitHub](https://github.com/fosscord/fosscord)                                                                                             | TypeScript, Express, WebRTC, Websockets, TypeORM, SQLite                       | ![GitHub Repo stars](https://img.shields.io/github/stars/fosscord/fosscord)                                                                                                                    |
| Disney+                        | [github.com (screenshot)](https://github.com/calebnance/expo-disneyplus/blob/master/.gh-assets/screenshare-4.png?raw=true)                                             | [GitHub](https://github.com/calebnance/expo-disneyplus)                                                                                    | React Native, expo                                                             | ![GitHub Repo stars](https://img.shields.io/github/stars/calebnance/expo-disneyplus)                                                                                                           |
| Disney+ Hotstar                | [determined-bardeen-6a04b8.netlify](https://determined-bardeen-6a04b8.netlify.app/)                                                                                    | [GitHub](https://github.com/anandhu720/disney-hotstar-clone.git)                                                                           | ReactJS                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/anandhu720/disney-hotstar-clone)                                                                                                      |
| Doodle                         | [sm2030.user.srcf.net](https://sm2030.user.srcf.net/poll/)                                                                                                             | [GitHub](https://github.com/souramoo/PhpMeeting)                                                                                           | PHP                                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/souramoo/PhpMeeting)                                                                                                                  |
| Dribbble                       | [driwwwle.herokuapp](http://driwwwle.herokuapp.com/)                                                                                                                   | [GitHub](https://github.com/itsnitinr/driwwwle)                                                                                            | MERN, react                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/itsnitinr/driwwwle)                                                                                                                   |
| Dribbble                       | [v.redd.it](https://v.redd.it/a8lhmpjho0051/)                                                                                                                          | [GitHub](https://github.com/diazabdulm/rumbbble)                                                                                           | MongoDB, ExpressJS, React,                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/diazabdulm/rumbbble)                                                                                                                  |
| Dropbox                        | [try.nextcloud.com](https://try.nextcloud.com/)                                                                                                                        | [GitHub](https://github.com/nextcloud/server)                                                                                              | PHP, JS                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/nextcloud/server)                                                                                                                     |
| Dropbox                        | [Live.filegator.io](https://Live.filegator.io)                                                                                                                         | [GitHub](https://github.com/filegator/filegator)                                                                                           | PHP, JS, Vuejs                                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/filegator/filegator)                                                                                                                  |
| Evernote                       | [joplinapp.org](https://joplinapp.org/)                                                                                                                                | [GitHub](https://github.com/laurent22/joplin)                                                                                              | JavaScript, TypeScript                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/laurent22/joplin)                                                                                                                     |
| Express JS | [robiul.dev](https://robiul.dev/i-made-a-custom-version-of-expressjs-framework-cute-express)                                                                                                    | [GitHub](https://github.com/robiulhr/cute-express)                                                                                   | Node js                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/robiulhr/cute-express)                                                                                                          |
| Facebook                       | [odinclone.herokuapp](https://odinclone.herokuapp.com/)                                                                                                                | [GitHub](https://github.com/lucaskenji/odinclone-app)                                                                                      | MERN                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/lucaskenji/odinclone-app)                                                                                                             |
| Facebook                       | [github.com (screenshot)](https://github.com/KristianWEB/fakebooker-frontend#screenshots)                                                                              | [GitHub](https://github.com/KristianWEB/fakebooker-frontend)                                                                               | react, graphql, mongodb                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/KristianWEB/fakebooker-frontend)                                                                                                      |
| Facebook                       | [clonedbook.vercel.app](https://clonedbook.vercel.app/)                                                                                                                | [GitHub](https://github.com/zivavu/Clonedbook)                                                                                             | Next.js, MUI, Firebase, Faker.js                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/zivavu/Clonedbook)                                                                                                                    |
| Firebase                       | [appwrite.io](https://appwrite.io/)                                                                                                                                    | [GitHub](https://github.com/appwrite/appwrite)                                                                                             | PHP                                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/appwrite/appwrite)                                                                                                                    |
| Firebase                       | [supabase.io](https://supabase.io/)                                                                                                                                    | [GitHub](https://github.com/supabase/supabase)                                                                                             | Elixir,React,PostgreSQL,Python                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/supabase/supabase)                                                                                                                    |
| Firebase                       | [nhost.io](https://nhost.io/)                                                                                                                                          | [GitHub](https://github.com/nhost/nhost)                                                                                                   | PostgreSQL, GraphQL, TypeScript, Go                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/nhost/nhost)                                                                                                                          |
| Gmail                          | [github.com (screenshot)](https://github.com/rodydavis/gmail_clone#screenshots)                                                                                        | [GitHub](https://github.com/rodydavis/gmail_clone)                                                                                         | Flutter                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/rodydavis/gmail_clone)                                                                                                                |
| Google                         | [searchify.vercel.app](https://searchify.vercel.app)                                                                                                                   | [GitHub](https://github.com/jusoftdev/searchify)                                                                                           | NextJS, TailwindCSS, Google Search API                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/jusoftdev/searchify)                                                                                                                   |
| Google Analytics               | [plausible.io](https://plausible.io/)                                                                                                                                  | [GitHub](https://github.com/plausible/analytics)                                                                                           | React, Elixir, PostgreSQL, Tailwind                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/plausible/analytics)                                                                                                                  |
| Google Analytics               | [matomo.org](https://matomo.org/)                                                                                                                                      | [GitHub](https://github.com/matomo-org/matomo)                                                                                             | PHP, HTML, MySQL                                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/matomo-org/matomo)                                                                                                                    |
| Google Analytics               | [ackee.electerious.com](https://ackee.electerious.com/)                                                                                                                | [GitHub](https://github.com/electerious/Ackee)                                                                                             | Node, MongoDB                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/electerious/Ackee)                                                                                                                    |
| Google Analytics               | [learnsql.io](https://learnsql.io)                                                                                                                                     | [GitHub](https://github.com/hypercable/hypercable)                                                                                         | Rails, OpenResty, TimescaleDB, postgresql, tailwindcss                         | ![GitHub Repo stars](https://img.shields.io/github/stars/hypercable/hypercable)                                                                                                                |
| Google Drive                   | [mydrive-3.herokuapp](https://mydrive-3.herokuapp.com/) <br/> [mydrive-storage.com](https://mydrive-storage.com/)                                                      | [GitHub](https://github.com/subnub/myDrive)                                                                                                | React, Node.js, mongoDB                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/subnub/myDrive)                                                                                                                       |
| Google Keep                    | [github.com (gif)](https://github.com/anselm94/googlekeepclone/blob/master/docs/mobile-add-todo.gif)                                                                   | [GitHub](https://github.com/anselm94/googlekeepclone)                                                                                      | React, GraphQL, Golang, SQlite                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/anselm94/googlekeepclone)                                                                                                             |
| Google Keep                    | [vue-keep-sepia.vercel.app](https://vue-keep-sepia.vercel.app/)                                                                                                        | [GitHub](https://github.com/wobsoriano/vue-keep)                                                                                           | Vue, TypeScript, Firestore                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/wobsoriano/vue-keep)                                                                                                                  |
| Google Keep                    | [google-keeps-clone.herokuapp](https://google-keeps-clone.herokuapp.com/)                                                                                              | [GitHub](https://github.com/kimlimjustin/google-keep-clone)                                                                                | Django, JS                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/kimlimjustin/google-keep-clone)                                                                                                       |
| Google Forms                   | [google-forms-clone.herokuapp](http://google-forms-clone.herokuapp.com/)                                                                                               | [GitHub](https://github.com/kimlimjustin/google-form-clone)                                                                                | Django, JS                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/kimlimjustin/google-form-clone)                                                                                                       |
| Google Forms                   | [https://handform-c62a3.web.app/](https://handform-c62a3.web.app/)                                                                                                     | [GitHub](https://github.com/ezza022/handform)                                                                                              | React, Firebase                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/ezza022/handform)                                                                                                                     |
| Google Photos                  | [photos-clone.web.app](https://photos-clone.web.app/)                                                                                                                  | [GitHub](https://github.com/mani-barathi/Google-Photos-Clone)                                                                              | React, Redux, Firebase                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/mani-barathi/Google-Photos-Clone)                                                                                                     |
| Google Photos                  | [photoprism.app](https://photoprism.app/)                                                                                                                              | [GitHub](https://github.com/photoprism/photoprism)                                                                                         | Go,TensorFlow                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/photoprism/photoprism)                                                                                                                |
| Google Translate               | [libretranslate.com](https://libretranslate.com/)                                                                                                                      | [GitHub](https://github.com/uav4geo/LibreTranslate)                                                                                        | Python, Flask                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/uav4geo/LibreTranslate)                                                                                                               |
| Hashnode                       | [hashnode-clone-sass.netlify.app](https://hashnode-clone-sass.netlify.app)                                                                                             | [GitHub](https://github.com/Evavic44/hashnode-clone)                                                                                       | HTML, SASS, JavaScript                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/evavic44/hashnode-clone)                                                                                                              |
| Headspace                      | [meditofoundation.org](https://meditofoundation.org/medito-app)                                                                                                        | [GitHub](https://github.com/meditohq/medito-app)                                                                                           | Flutter                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/meditohq/medito-app)                                                                                                                  |
| Hacker News                    | [hackernews-redesign.netlify](https://hackernews-redesign.netlify.app/)                                                                                                | [GitHub](https://github.com/RocktimSaikia/hacker-news-redesign)                                                                            | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/RocktimSaikia/hacker-news-redesign)                                                                                                   |
| Hacker News                    | [news.python](https://news.python.sc/)                                                                                                                                 | [GitHub](https://github.com/sebst/pythonic-news)                                                                                           | Python, Django                                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/sebst/pythonic-news)                                                                                                                  |
| Hacker News                    | [rm-hackernews.netlify.app](https://rm-hackernews.netlify.app)                                                                                                         | [GitHub](https://github.com/rajat-mehra05/hacker-news-clone)                                                                               | Reactjs                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/rajat-mehra05/hacker-news-clone)                                                                                                      |
| Hacker News                    | [hackernews-jaywhen.vercel.app](https://hackernews-jaywhen.vercel.app/)                                                                                                | [GitHub](https://github.com/jaywhen/hackernews)                                                                                            | Next.js                                                                        | ![GitHub Repo stars](https://flat.badgen.net/github/stars/jaywhen/hackernews)                                                                                                                    |
| HotJar         | [Formbricks](https://formbricks.com/)                                                                                                                                  | [GitHub](https://github.com/formbricks/formbricks)                                                                                             | JavaScript                                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/formbricks/formbricks)                                                                                                                    |
| Hulu                    | [fake-hulu-eosin.vercel.app](https://fake-hulu-eosin.vercel.app)                                                                                                | [GitHub](https://github.com/SalahSajar/FakeHulu)                                                                                            | Next.js, Sass, Firebase, tmdb-api                                                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/SalahSajar/FakeHulu)                                                                                                                    |
| IMDB                           | [movie4fun.netlify.app](https://movie4fun.netlify.app/)                                                                                                  | [GitHub](https://github.com/zerone0x/imdb_clone.git)                                                                                     | React, Redux, ReactQuery, tmdb-api                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/zerone0x/imdb_clone)                                                                                                                    |                                                                                                            |
| Instagram                      | [maxgram.zabarka.com](https://maxgram.zabarka.com/)                                                                                                                    | [GitHub](https://github.com/MaxZabarka/instagram-clone)                                                                                    | MongoDB, Express, Reactjs, Node                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/MaxZabarka/instagram-clone)                                                                                                           |
| Instagram                      | [instaclone.net](https://www.instaclone.net/login) <br/>[github.com (gif)](https://github.com/Sandermoen/instaclone/blob/master/screenshots/NgmjOVkZ4L.gif)            | [GitHub](https://github.com/Sandermoen/instaclone)                                                                                         | Reactjs, Express, Nodejs, Mongodb, Socketio                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/Sandermoen/instaclone)                                                                                                                |
| Instagram                      | [github.com (gif)](https://github.com/vipulasri/JetInstagram/blob/master/art/jetinstagram.gif)                                                                         | [GitHub](https://github.com/vipulasri/JetInstagram)                                                                                        | Jetpack Compose                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/vipulasri/JetInstagram)                                                                                                               |
| Instagram                      | [instagram-clone-dbe40.web.app](https://instagram-clone-dbe40.web.app/)                                                                                                | [GitHub](https://github.com/shaan71845/instagram-clone)                                                                                    | React, Firebase                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/shaan71845/instagram-clone)                                                                                                           |
| Intercom                       | [papercups.io](https://www.papercups.io/)                                                                                                                              | [GitHub](https://github.com/papercups-io/papercups)                                                                                        | React, Elixir, Phoenix                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/papercups-io/papercups)                                                                                                               |
| Intercom                       | [chatwoot.com](https://www.chatwoot.com/)                                                                                                                              | [GitHub](https://github.com/chatwoot/chatwoot)                                                                                             | JAMStack, Vue                                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/chatwoot/chatwoot)                                                                                                                    |
| iOS Homescreen                 | [ios-homescreen.now.sh](https://ios-homescreen.now.sh/)                                                                                                                | [GitHub](https://github.com/erickbogarin/ios-homescreen)                                                                                   | React, Next.js, Emotion                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/erickbogarin/ios-homescreen)                                                                                                          |
| Jira                           | [jira.sebastianfdz.com](https://jira.sebastianfdz.com/project/backlog)                                                                                                                | [GitHub](https://github.com/sebastianfdz/jira_clone)                                                                                           | Next.js, React-Query Radix UI, Clerk Auth, Zod, TailwindCSS                                                               | ![GitHub Repo stars](https://flat.badgen.net/github/stars/sebastianfdz/jira_clone)                                                                                                                   |
| Jira                           | [jira.ivorreic.com](https://jira.ivorreic.com)                                                                                                                | [GitHub](https://github.com/oldboyxx/jira_clone)                                                                                           | Express(Typescript), JWT, TypeORM, PostgreSQL, React                                                               | ![GitHub Repo stars](https://flat.badgen.net/github/stars/oldboyxx/jira_clone)                                                                                                                   |
| Jira                           | [jira.trungk18](https://jira.trungk18.com/)                                                                                                                            | [GitHub](https://github.com/trungk18/jira-clone-angular)                                                                                   | Angular, Akita, TailwindCSS, ng-zorro                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/trungk18/jira-clone-angular)                                                                                                           |
| LaunchDarkly                   | [getunleash.io](https://getunleash.io)                                                                                                                                 | [GitHub](https://github.com/Unleash/unleash)                                                                                               | Java, Node.js, Go, Python, Ruby, .Net, JavaScript, React, Android, iOS,        | ![GitHub Repo stars](https://img.shields.io/github/stars/Unleash/unleash)                                                                                                                      |
| LaunchDarkly                   | [flagsmith.com](https://flagsmith.com)                                                                                                                                 | [GitHub](https://github.com/flagsmith/flagsmith-api) <br/> [GitHub](https://github.com/flagsmith/flagsmith-frontend)                       | Python, Django, React                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/flagsmith/flagsmith-api)                                                                                                              |
| Linear.app                     | [youtube.com](https://www.youtube.com/watch?v=XVAek-hE5X8)                                                                                                             | [GitHub](https://github.com/tuan3w/linearapp_clone)                                                                                        | React, Redux, TailwindCSS                                                      | ![GitHub Repo stars](https://img.shields.io/github/stars/tuan3w/linearapp_clone)                                                                                                               |
| MacOS Calculator               | [chamoda.com](https://chamoda.com/react-calculator/)                                                                                                                   | [GitHub](https://github.com/chamoda/react-calculator)                                                                                      | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/chamoda/react-calculator)                                                                                                             |
| MacOS Finder Clone             | [finder-clone.netlify.app](https://finder-clone.netlify.app/)                                                                                                          | [GitHub](https://github.com/Guy6767/finder-clone)                                                                                          | React, Sass                                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/Guy6767/finder-clone)                                                                                                                 |
| Medium / Wordpress / Substack  | [ghost.org](https://ghost.org/)                                                                                                                                        | [GitHub](https://github.com/TryGhost/Ghost)                                                                                                | JAMStack, Ember, Node, MySQL                                                   | ![GitHub Repo stars](https://img.shields.io/github/stars/TryGhost/Ghost)                                                                                                                       |
| Medium                         | [next-realworld.now.sh](https://next-realworld.now.sh/)                                                                                                                | [GitHub](https://github.com/reck1ess/next-realworld-example-app)                                                                           | React, Next.js                                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/reck1ess/next-realworld-example-app)                                                                                                  |
| Messenger                      | [tippindev.com](https://tippindev.com/)                                                                                                                                | [GitHub](https://github.com/rtippin/messenger)                                                                                             | PHP/Laravel, MySQL, Websockets                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/rtippin/messenger)                                                                                                                    |
| MS Paint                       | [jspaint.app](https://jspaint.app)                                                                                                                                     | [GitHub](https://github.com/1j01/jspaint)                                                                                                  | Node.js                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/1j01/jspaint)                                                                                                                         |
| Netflix [Fakeflix]             | [fakeflix.th3wall.codes](https://fakeflix.th3wall.codes)                                                                                                               | [GitHub](https://github.com/Th3Wall/Fakeflix)                                                                                              | React, Redux, Firebase                                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Th3Wall/Fakeflix)                                                                                                                      |
| Netflix                        | [netflix-clone-react-typescript.vercel.app](https://netflix-clone-react-typescript.vercel.app)                                                                                                               | [GitHub](https://github.com/endo-aki22/netflix-clone-react-typescript)                                                                                              | React(v18), RTK(ReduxToolKit), Typescript, TMDB API, MUI, Video.js, Framer Motion, Slick Carousel, Docker                                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/endo-aki22/netflix-clone-react-typescript)                                                                                                                      |
| Netflix                        | [azazel5.github.io](https://azazel5.github.io/NetflixClone/) <br/> [github.com (gif)](https://github.com/Azazel5/NetflixClone/blob/master/flixLive.gif)                | [GitHub](https://github.com/Azazel5/NetflixClone)                                                                                          | React, Redux                                                                   | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Azazel5/NetflixClone)                                                                                                                  |
| Netflix                        | [netflix-clone-dd230.web.app](https://netflix-clone-dd230.web.app/)                                                                                                    | [GitHub](https://github.com/abodmicheal/React-projects/tree/master/Single-Channel-Messanger)                                               | React, Firebase                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/abodmicheal/React-projects)                                                                                                            |
| Netflix                        | [github.com (screenshot)](https://github.com/karlhadwen/netflix/blob/master/netflix-preview.png)                                                                       | [GitHub](https://github.com/karlhadwen/netflix)                                                                                            | React, Firebase                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/karlhadwen/netflix)                                                                                                                    |
| Netflix                        | [spaceflix.herokuapp](http://spaceflix.herokuapp.com/#/)                                                                                                               | [GitHub](https://github.com/ehecker/spaceflix)                                                                                             | Ruby, React, Redux, PostgreSQL, AWS                                            | ![GitHub Repo stars](https://flat.badgen.net/github/stars/ehecker/spaceflix)                                                                                                                     |
| Netflix                        | [expo-netflix.calebnance.now.sh](https://expo-netflix.calebnance.now.sh/)                                                                                              | [GitHub](https://github.com/calebnance/expo-netflix)                                                                                       | React Native, expo                                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/calebnance/expo-netflix)                                                                                                               |
| Netflix                        | [roseflix-rosebilag.vercel](https://roseflix-rosebilag.vercel.app/)                                                                                                    | [GitHub](https://github.com/rosebilag/roseflix/)                                                                                           | React, TypeScript, MongoDB                                                     | ![GitHub Repo stars](https://flat.badgen.net/github/stars/rosebilag/roseflix)                                                                                                                    |
| Netflix                        | [nfx.vercel.app](https://nfx.vercel.app/)                                                                                                    | [GitHub](https://github.com/saurabhchardereal/nfx/)                                                                                           | React, TypeScript, SCSS Modules                                                     | ![GitHub Repo stars](https://flat.badgen.net/github/stars/saurabhchardereal/nfx)                                                                                                                    |
| Netflix                        | [Wep-App](https://android_netflix.surge.sh/) ,[android](https://play.google.com/store/apps/details?id=com.moviestrailer.app)                                           | [GitHub](https://github.com/ismailazdad/NetflixClone_Capacitor_Android)                                                                    | React, Capacitor, Pwa                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/ismailazdad/NetflixClone_Capacitor_Android)                                                                                            |
| Nike                           | [gif](https://github.com/saeed9321/Nike-Website-clone/blob/main/screen-capture.gif)                                                                                    | [GitHub](https://github.com/saeed9321/Nike-Website-clone)                                                                                  | Express, MongoDB                                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/saeed9321/Nike-Website-clone)                                                                                                         |
| Notion                         | [focalboard.com](https://www.focalboard.com/)                                                                                                                          | [GitHub](https://github.com/mattermost/focalboard)                                                                                         | Node, React, Go                                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/mattermost/focalboard)                                                                                                                |
| Okta                          | [topaz.sh](https://www.topaz.sh projects/)                                                                                                                  | [GitHub](https://github.com/aserto-dev/topaz)                                                                                                          | Go                                                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/aserto-dev/topaz)                                                                                                                                   |
| Okta                           | [ory.sh](https://www.ory.sh/docs/ecosystem/projects/)                                                                                                                  | [GitHub](https://github.com/ory)                                                                                                           | Go                                                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/ory)                                                                                                                                   |
| Obsidian                       | [zettlr.com](https://www.zettlr.com/)                                                                                                                                  | [GitHub](https://github.com/Zettlr/Zettlr)                                                                                                 | Electron, Vue, Markdown                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/Zettlr/Zettlr)                                                                                                                        |
| Omegle                         | [start-a-conversation.firebaseapp](https://start-a-conversation.firebaseapp.com/)                                                                                      | [GitHub](https://github.com/NickMandylas/start-a-conversation)                                                                             | React, Firebase, Twilio                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/NickMandylas/start-a-conversation)                                                                                                    |
| Orkut                          | [orkutnostalgia.netlify.app](https://orkutnostalgia.netlify.app/)                                                                                                      | [GitHub](https://github.com/GShadowBroker/orkut-clone-client) <br/> [GitHub](https://github.com/GShadowBroker/orkut-clone-server)          | ReactJS, GraphQL, Apollo, PostgreSQL                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/GShadowBroker/orkut-clone-client) ![GitHub Repo stars](https://img.shields.io/github/stars/GShadowBroker/orkut-clone-server)          |
| PayTM                          | [github.com (gif)](https://github.com/flutter-devs/flutter_paytm_clone#demo)                                                                                           | [GitHub](https://github.com/flutter-devs/flutter_paytm_clone)                                                                              | Flutter                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/flutter-devs/flutter_paytm_clone)                                                                                                     |
| Pinterest                      | [trusting-euler-8aafb8.netlify.app](https://trusting-euler-8aafb8.netlify.app/)                                                                                        | [GitHub](https://github.com/machadop1407/pinterest-clone-frontend) <br/> [GitHub](https://github.com/machadop1407/pinterest-clone-backend) | GraphQL, ReactJS, NodeJS, Mysql                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/machadop1407/pinterest-clone-frontend) ![GitHub Repo stars](https://img.shields.io/github/stars/machadop1407/pinterest-clone-backend) |
| Postman                        | [firecamp.dev](https://firecamp.dev/)                                                                                                                                | [GitHub](https://github.com/firecamp-dev/firecamp)                                                                                                 | Electron, ReactJS, NodeJS, Typescript                                                                       | ![GitHub Repo stars](https://img.shields.io/github/stars/firecamp-dev/firecamp)                                                                                                                        |
| Postman                        | [insomnia.rest](https://insomnia.rest/)                                                                                                                                | [GitHub](https://github.com/Kong/insomnia)                                                                                                 | Electron                                                                       | ![GitHub Repo stars](https://img.shields.io/github/stars/Kong/insomnia)                                                                                                                        |
| Postman                        | [hoppscotch.io](https://hoppscotch.io/)                                                                                                                                | [GitHub](https://github.com/hoppscotch/hoppscotch)                                                                                         | JAMStack, Vue, NuxtJS, firebase                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/hoppscotch/hoppscotch)                                                                                                                |
| Privnote                       | [secret.roushik.com](https://secret.roushik.com/)                                                                                                                      | [GitHub](https://github.com/roushikk/secret_notes)                                                                                         | Django, Postgres, jQuery                                                       | ![GitHub Repo stars](https://img.shields.io/github/stars/roushikk/secret_notes)                                                                                                                |
| Reddit                         | [troddit.com](https://www.troddit.com/)                                                                                                                                | [GitHub](https://github.com/burhan-syed/troddit)                                                                                           | NextJS, React, TailwindCSS, TypeScript                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/burhan-syed/troddit)                                                                                                                  |
| Reddit                         | [redditsyncr.netlify.app](https://redditsyncr.netlify.app/)                                                                                                            | [GitHub](https://github.com/dustinkiselbach/reddit-refactor)                                                                               | React, TypeScript                                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/dustinkiselbach/reddit-refactor)                                                                                                      |
| Reddit                         | [asperitas.now.sh](https://asperitas.now.sh/)                                                                                                                          | [GitHub](https://github.com/d11z/asperitas)                                                                                                | Node.js, React, NoSQL                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/d11z/asperitas)                                                                                                                       |
| Reddit                         | [Lemmy](https://join-lemmy.org/)                                                                                                                          | [GitHub](https://github.com/LemmyNet)                                                                                                | ActivityPub, Rust, Postgres, Docker                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/LemmyNet/lemmy)                                                                                                                       |
| Reddit                         | [kbin](https://kbin.pub/en)                                                                                                                          | [Codeberg](https://codeberg.org/Kbin/kbin-core)                                                                                                | ActivityPub, PHP, Postgres, Docker                                                          | ![Codeberg Release](https://badgers.space/codeberg/stars/Kbin/kbin-core)                                                                                                                       |
| Reddit                         | [Sublinks](https://sublinks.org/)                                                                                                                          | [GitHub](https://github.com/sublinks)                                                                                                | ActivityPub, Java, TypeScript, MariaDB                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/sublinks/sublinks-api)                                                                                                                       |
| Reddit                         | [PieFed](https://join.piefed.social/)                                                                                                                          | [Codeberg](https://codeberg.org/rimu/pyfedi/)                                                                                                | ActivityPub, Python, Postgres, Redis                                                          | ![Codeberg Release](https://badgers.space/codeberg/stars/rimu/pyfedi)                                                                                                                       |
| Retool                         | [budibase.com](https://budibase.com/)                                                                                                                                  | [GitHub](https://github.com/Budibase/budibase)                                                                                             | Node.js, Svelte                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/budibase/budibase)                                                                                                                     |
| Retool                         | [ILLA Cloud](https://www.illacloud.com/)                                                                                                                                  | [GitHub](https://github.com/illacloud/illa-builder)                                                                                             | React, Typescript, Go                                                               | ![GitHub Repo stars](https://flat.badgen.net/github/stars/illacloud/illa-builder)                                                                                                                     |
| Telegram                       | [tinode.co](https://tinode.co/)                                                                                                                                        | [GitHub](https://github.com/tinode/chat)                                                                                                   | Go, React, Java, Swift, MySQL, MongoDB, RethinkDB                              | ![GitHub Repo stars](https://img.shields.io/github/stars/tinode/chat)                                                                                                                          |
| TikTok + Reddit                | [reddit-tiktok.netlify.app](https://reddit-tiktok.netlify.app/)                                                                                                        | [GitHub](https://github.com/hedgecox/Reddit-TikTok-Clone)                                                                                  | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/hedgecox/Reddit-TikTok-Clone)                                                                                                         |
| Twitch                         | [twitchclone.vercel.app](https://twitchclone.vercel.app/)                                                                                                              | [GitHub](https://github.com/alissonsleal/twitch-clone/)                                                                                    | React, Next.JS, TypeScript                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/alissonsleal/twitch-clone)                                                                                                            |
| Slack                          | [mattermost.com](https://mattermost.com/)                                                                                                                              | [GitHub](https://github.com/mattermost/mattermost-webapp)                                                                                  | React, Go                                                                      | ![GitHub Repo stars](https://img.shields.io/github/stars/mattermost/mattermost-webapp)                                                                                                         |
| Slack                          | [rocket.chat](https://rocket.chat/)                                                                                                                                    | [GitHub](https://github.com/RocketChat/Rocket.Chat)                                                                                        | JAMStack, TypeScript                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/RocketChat/Rocket.Chat)                                                                                                               |
| Slack                          | [zulip.com](https://zulip.com/)                                                                                                                                        | [GitHub](https://github.com/zulip/zulip)                                                                                                   | Python, JS, TS                                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/zulip/zulip)                                                                                                                          |
| Slack                          | [github.com (screenshot)](https://github.com/calebnance/expo-slack/blob/master/screenshots/screenshare-3_v1.jpg?raw=true)                                              | [GitHub](https://github.com/calebnance/expo-slack)                                                                                         | React Native, Expo                                                             | ![GitHub Repo stars](https://img.shields.io/github/stars/calebnance/expo-slack)                                                                                                                |
| Slido                          | [askent.berlinchan.com ](https://askent.berlinchan.com/)                                                                                                               | [GitHub](https://github.com/BerlinChan/askent)                                                                                             | React, Material-UI, Apollo GraphQL, Hasura, TypeORM, TypeGraphQL, TypeScript   | ![GitHub Repo stars](https://img.shields.io/github/stars/BerlinChan/askent)                                                                                                                    |
| Sliders Game                   | [Play the game](https://js-sliders-game.rolandjlevy.repl.co/)                                                                                                          | [GitHub](https://github.com/rolandjlevy/js-sliders-game)                                                                                   | Vanilla JavaScript, CSS, MongoDb                                               | ![GitHub Repo stars](https://flat.badgen.net/github/stars/rolandjlevy/js-sliders-game)                                                                                                           |
| Snapchat                       | [towhidkashem.github.io](https://towhidkashem.github.io/snapchat-clone/) <br/> [youtube](https://youtu.be/aRS88v-duKg)                                                 | [GitHub](https://github.com/TowhidKashem/snapchat-clone)                                                                                   | React, Redux, TypeScript, Cypress, Jest, Enzyme                                | ![GitHub Repo stars](https://img.shields.io/github/stars/TowhidKashem/snapchat-clone)                                                                                                          |
| Spotify                        | [spotify.trungk18](https://spotify.trungk18.com/)                                                                                                                      | [GitHub](https://github.com/trungk18/angular-spotify)                                                                                      | Angular 11, Nx, ngrx, TailwindCSS and ng-zorro                                 | ![GitHub Repo stars](https://flat.badgen.net/github/stars/trungk18/angular-spotify)                                                                                                              |
| Spotify                        | [github.com (gif)](https://github.com/JL978/spotify-clone-client/blob/master/Live/Authed.gif)                                                                          | [GitHub](https://github.com/JL978/spotify-clone-client)                                                                                    | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/JL978/spotify-clone-client)                                                                                                            |
| Spotify Web Player             | [spotify-clone-oguz3.web.app](https://spotify-clone-oguz3.web.app/)                                                                                                    | [GitHub](https://github.com/oguz3/spotify-web-player)                                                                                      | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/oguz3/spotify-web-player)                                                                                                              |
| Spotify                        | [screenshot](https://github.com/matpandino/spotify-ui-clone/blob/master/.github/spotify-clone.jpg)                                                                     | [GitHub](https://github.com/matpandino/spotify-ui-clone)                                                                                   | Electron, React, TypeScript                                                    | ![GitHub Repo stars](https://flat.badgen.net/github/stars/matpandino/spotify-ui-clone)                                                                                                           |
| Spotify                        | [drive.google.com (gif)](https://drive.google.com/file/d/1KOHOJDGaLeumGqQenzCeeShPqIudCJBX/view)                                                                       | [GitHub](https://github.com/aashrafh/Oud)                                                                                                  | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/aashrafh/Oud)                                                                                                                          |
| Spotify                        | [tune42-spotify.netlify.app](https://tune42-spotify.netlify.app/)                                                                                                      | [GitHub](https://github.com/Tune42/spotify-clone)                                                                                          | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Tune42/spotify-clone)                                                                                                                  |
| Spotify                        | [expo-spotify.vercel.app](https://expo-spotify.vercel.app/)                                                                                                            | [GitHub](https://github.com/calebnance/expo-spotify)                                                                                       | React Native, Expo                                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/calebnance/expo-spotify)                                                                                                               |
| Spotify                        | [github.com (screenshot)](https://github.com/osamaq/spotify-lite#screenshots)                                                                                          | [GitHub](https://github.com/osamaq/spotify-lite)                                                                                           | React Native                                                                   | ![GitHub Repo stars](https://flat.badgen.net/github/stars/osamaq/spotify-lite)                                                                                                                   |
| Spotify                        | [30sekify.netlify.app](https://30sekify.netlify.app)                                                                                                                   | [GitHub](https://github.com/s-codes14/30sekify)                                                                                            | React, Electron                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/s-codes14/30sekify)                                                                                                                                                                                                                  |
| Spotify                        | [30sekify.netlify.app](https://30sekify.netlify.app)                                                                                                                   | [GitHub](https://github.com/s-codes14/30sekify)                                                                                            | React, Electron                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/s-codes14/30sekify)                                                                                                                    |                                                                                                  |
| Spotify + Soundcloud + YouTube | [kord.app](https://www.kord.app)                                                                                                                                       | [GitHub](https://github.com/bundit/kord-app)                                                                                               | React, Redux, Express, PostgreSQL                                              | ![GitHub Repo stars](https://flat.badgen.net/github/stars/bundit/kord-app)                                                                                                                       |
| Stack Overflow                 | [live.scoold](https://live.scoold.com)                                                                                                                                 | [GitHub](https://github.com/Erudika/scoold)                                                                                                | Java, jQuery, Para                                                             | ![GitHub Repo stars](https://img.shields.io/github/stars/Erudika/scoold)                                                                                                                       |
| Stack Overflow                 | [clone-of-stackoverflow.vercel](https://clone-of-stackoverflow.vercel.app/)                                                                                            | [GitHub](https://github.com/salihozdemir/stackoverflow-clone)                                                                              | ReactJs, NextJs, Express, MongoDB                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/salihozdemir/stackoverflow-clone)                                                                                                     |
| Stack Overflow                 | [drive.google.com (gif)](https://drive.google.com/file/d/1A0B3JPUUY2snG8MLZpyz2LWhvThG2epn/view)                                                                       | [GitHub](https://github.com/Mayank0255/Stack-Overflow-Clone)                                                                               | MySQL, Express, React                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/Mayank0255/Stack-Overflow-Clone)                                                                                                      |
| Stack Overflow                 | [stackunderflow.netlify.app](https://stackunderflow.netlify.app)                                                                                                       | [GitHub](https://github.com/amand33p/stack-underflow-mern-gql)                                                                             | MongoDB, Express, React, NodeJS                                                | ![GitHub Repo stars](https://img.shields.io/github/stars/amand33p/stack-underflow-mern-gql)                                                                                                    |
| Temp-Mail                      | [simplelogin.io](https://simplelogin.io) <br/> [youtube](https://www.youtube.com/watch?v=JMWfsOVrDkw)                                                                  | [GitHub](https://github.com/simple-login/app)                                                                                              | Python, Docker, Vue                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/simple-login/app)                                                                                                                     |
| Tetris Game                    | [hinsxd-tetris.netlify.app](https://hinsxd-tetris.netlify.app/)                                                                                                        | [GitHub](https://github.com/hinsxd/react-tetris)                                                                                           | React, TypeScript                                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/hinsxd/react-tetris)                                                                                                                  |
| Tetris Game                    | [tetris20.netlify.app](https://tetris20.netlify.app/)                                                                                                                  | [GitHub](https://github.com/shanoysinc/Tetris)                                                                                             | TypeScript                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/shanoysinc/Tetris)                                                                                                                    |
| Tetris Game React              | [chvin.github.io](https://chvin.github.io/react-tetris/)                                                                                                               | [GitHub](https://github.com/chvin/react-tetris)                                                                                            | React, Redux, Web Audio Api                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/chvin/react-tetris)                                                                                                                   |
| TikTok                         | [github.com (gif)](https://github.com/kirkwat/tiktok)                                                                                                                            | [GitHub](https://github.com/kirkwat/tiktok)                                                                                   | React Native, Firebase, TypeScript                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/kirkwat/tiktok)                                                                                                           |
| TikTok                         | [youtube.com](https://youtu.be/iYqDUjvsS3o)                                                                                                                            | [GitHub](https://github.com/emmanuelhashy/tik-tok-clone)                                                                                   | React, Firebase                                                                | ![GitHub Repo stars](https://flat.badgen.net/github/stars/emmanuelhashy/tik-tok-clone)                                                                                                           |
| TikTok                         | [youtube.com](https://youtu.be/sMKg6ILYgv0)                                                                                                                            | [GitHub](https://github.com/salvadordeveloper/TikTok-Flutter)                                                                              | Flutter, Firebase                                                              | ![GitHub Repo stars](https://flat.badgen.net/github/stars/salvadordeveloper/TikTok-Flutter)                                                                                                      |
| TikTok + Reddit                | [enrybalassiano.github.io](https://henrybalassiano.github.io/Tik-Tok-Clone/)                                                                                           | [GitHub](https://github.com/HenryBalassiano/Tik-Tok-Clone)                                                                                 | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/HenryBalassiano/Tik-Tok-Clone)                                                                                                         |
| TinyURL                        | [nexturl.vercel.app](https://nexturl.vercel.app/)                                                                                                                      | [GitHub](https://github.com/chuddyjoachim/next-url)                                                                                        | Next.js TypeScript React Mongodb                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/chuddyjoachim/next-url)                                                                                                               |
| Todoist                        | [todoishh.netlify.app](https://todoishh.netlify.app/)                                                                                                                  | [GitHub](https://github.com/anagkazou/todoishh)                                                                                            | React Firebase                                                                 | ![GitHub Repo stars](https://flat.badgen.net/github/stars/anagkazou/todoishh)                                                                                                                    |
| Travian                        | [cosmodream.ga](http://cosmodream.ga/1255-burgomaster/)                                                                                                                | [GitHub](https://github.com/Areso/1255-burgomaster)                                                                                        | Vanilla JS                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/Areso/1255-burgomaster)                                                                                                               |
| Trello                         | [wekan.github.io](https://wekan.github.io/)                                                                                                                            | [GitHub](https://github.com/wekan/wekan)                                                                                                   | Meteor                                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/wekan/wekan)                                                                                                                          |
| Trello                         | [taiga.io](https://www.taiga.io/)                                                                                                                                      | [GitHub](https://github.com/taigaio/taiga-front) <br/> [GitHub](https://github.com/taigaio/taiga-back)                                     | Django, AngularJS                                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/taigaio/taiga-front) ![GitHub Repo stars](https://img.shields.io/github/stars/taigaio/taiga-back)                                     |
| Trello                         | [kanboard.org](https://kanboard.org/)                                                                                                                                  | [GitHub](https://github.com/kanboard/kanboard)                                                                                             | PHP                                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/kanboard/kanboard)                                                                                                                    |
| Trello                         | [trellis-app.herokuapp](https://trellis-app.herokuapp.com/) <br/> [github.com (gif)](https://github.com/ayushagg31/Trellis/blob/master/images/Trellis.gif)             | [GitHub](https://github.com/ayushagg31/Trellis)                                                                                            | React, Redux, Node, Express, MongoDB                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/ayushagg31/Trellis)                                                                                                                   |
| Trello                         | [codesource.io (gif)](https://codesource.io/wp-content/uploads/2020/07/Trelloclone.webm)                                                                               | [GitHub](https://github.com/Dunebook/Trelloclone)                                                                                          | Angular 10                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/Dunebook/Trelloclone)                                                                                                                 |
| Trello                         | [tiquetapp.herokuapp.com](https://tiquetapp.herokuapp.com/)                                                                                                            | [GitHub](https://github.com/FLiotta/Tiquet)                                                                                                | React, Python, Flask, PostgreSQL                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/FLiotta/Tiquet)                                                                                                                       |
| Trello                         | [tberghuis.github.io](https://tberghuis.github.io/trello-board-clone/)                                                                                                 | [GitHub](https://github.com/tberghuis/trello-board-clone)                                                                                  | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/tberghuis/trello-board-clone)                                                                                                         |
| Trello                         | [rupmalya-trello-clone.herokuapp](https://rupmalya-trello-clone.herokuapp.com/signin) <br/> [youtube.com](https://youtu.be/59oQ01VEm30)                                | [GitHub](https://github.com/RupmalyaK/trello-clone)                                                                                        | Express, MongoDB                                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/RupmalyaK/trello-clone)                                                                                                               |
| Trello                         | [project-manager1.herokuapp](https://project-manager1.herokuapp.com/)                                                                                                  | [GitHub](https://github.com/arturmolenda/project-manager)                                                                                  | React, Redux, Node, Express, Socket.io, MongoDB                                | ![GitHub Repo stars](https://img.shields.io/github/stars/arturmolenda/project-manager)                                                                                                         |
| Trello                         | [trello-project-manager.netlify](https://trello-project-manager.netlify.app/)                                                                                          | [GitHub](https://github.com/berabulut/project-manager)                                                                                     | React, Node.js, Firebase, Serverless, AWS Lambda                               | ![GitHub Repo stars](https://img.shields.io/github/stars/berabulut/project-manager)                                                                                                            |
| Mastodon                           | [echoloop.buzz](https://echoloop.buzz/)                                                                                                  | [GitHub](https://github.com/zerone0x/Echo-Frontend.git)                                                                                     | Node.js, Next.Js, Express.Js, TypeScript, TailwindCSS                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/zerone0x/Echo-Frontend)                                                                                                                    |                                   
| Twitter                        | [Mastodon](https://joinmastodon.org/)                                                                                                     | [GitHub](https://github.com/mastodon)                                                                               | ActivityPub, Ruby, Go, Postgres, Redis, Docker | ![GitHub Repo stars](https://img.shields.io/github/stars/mastodon/mastodon)                                                                                                      |
| Twitter                        | [https://tweeetr.netlify.app/](https://tweeetr.netlify.app/) <br/>                                                                                                     | [GitHub](https://github.com/SiddheshDabholkar/Twitter-clone)                                                                               | React,Express js, NodeJS,Graphql,Apollo client,apollo-server,styled-components | ![GitHub Repo stars](https://img.shields.io/github/stars/SiddheshDabholkar/Twitter-clone)                                                                                                      |
| Twitter                        | [twitter-geek.netlify.app](https://twitter-geek.netlify.app/#/) <br/> [github.com (screenshot)](https://github.com/RisingGeek/twitter-clone/blob/master/Live/feed.png) | [GitHub](https://github.com/RisingGeek/twitter-clone) <br/> [GitHub](https://github.com/RisingGeek/twitter-clone-backend)                  | React, Redux, NodeJS, MYSQL                                                    | ![GitHub Repo stars](https://img.shields.io/github/stars/RisingGeek/twitter-clone) ![GitHub Repo stars](https://img.shields.io/github/stars/RisingGeek/twitter-clone-backend)                  |
| Twitter                        | [twitterclone2.netlify.app](https://twitterclone2.netlify.app/login.html)                                                                                              | [GitHub](https://github.com/Dunebook/Twitterclone)                                                                                         | HTML, CSS, JQuery                                                              | ![GitHub Repo stars](https://img.shields.io/github/stars/Dunebook/Twitterclone)                                                                                                                |
| Twitter                        | [tclone.netlify.app](https://tclone.netlify.app/) <br/> [github.com (gif)](https://github.com/muzam1l/tclone/raw/master/docs/tclone-Live2.gif)                         | [GitHub](https://github.com/muzam1l/tclone) <br/> [GitHub](https://github.com/muzam1l/tclone-api)                                          | MERN                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/muzam1l/tclone) ![GitHub Repo stars](https://img.shields.io/github/stars/muzam1l/tclone-api)                                          |
| Twitter                        | [twitterapp-clone.netlify.app](https://twitterapp-clone.netlify.app/home)                                                                                              | [GitHub](https://github.com/Ali-hd/Twitter-Clone) <br/> [GitHub](https://github.com/Ali-hd/TwitterClone-Backend)                           | React, express, mongo, aws, socket.io                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/Ali-hd/Twitter-Clone) ![GitHub Repo stars](https://img.shields.io/github/stars/Ali-hd/TwitterClone-Backend)                           |
| Twitter                        | [twitter-cln.herokuapp](https://twitter-cln.herokuapp.com)                                                                                                             | [GitHub](https://github.com/Abdullah-V/MEVN-stack-twitter-clone)                                                                           | Vue, Express, Mongo                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/Abdullah-V/MEVN-stack-twitter-clone)                                                                                                  |
| Twitter                        | [twitter-web-clone-react.vercel](https://twitter-web-clone-react.vercel.app)                                                                                           | [GitHub](https://github.com/mucahit-sahin/twitter-web-clone-react)                                                                         | React, Redux                                                                   | ![GitHub Repo stars](https://img.shields.io/github/stars/mucahit-sahin/twitter-web-clone-react)                                                                                                |
| Typeform         | [Formbricks](https://formbricks.com/)                                                                                                                                  | [GitHub](https://github.com/formbricks/formbricks)                                                                                             | JavaScript                                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/formbricks/formbricks)                                                                                                                    |
| Typeform / Google Form         | [ohmyform.com](https://ohmyform.com/)                                                                                                                                  | [GitHub](https://github.com/ohmyform/ohmyform)                                                                                             | Python                                                                         | ![GitHub Repo stars](https://img.shields.io/github/stars/ohmyform/ohmyform)                                                                                                                    |
| Typeform                       | [supereasyforms.com](https://supereasyforms.com/)                                                                                                                      | [GitHub](https://github.com/super-easy-forms/super-easy-forms)                                                                             | JavaScript                                                                     | ![GitHub Repo stars](https://img.shields.io/github/stars/super-easy-forms/super-easy-forms)                                                                                                    |
| Uber                           | [github.com (screenshot)](https://github.com/calebnance/expo-uber/blob/master/screenshots/screenshare-3.png?raw=true)                                                  | [GitHub](https://github.com/calebnance/expo-uber)                                                                                          | React native, expo                                                             | ![GitHub Repo stars](https://img.shields.io/github/stars/calebnance/expo-uber)                                                                                                                 |
| Uber                           | [youtube.com](https://youtu.be/ya1lsXS2Wvw)                                                                                                                            | [GitHub](https://github.com/Santos-Enoque/uber_clone_with_flutter)                                                                         | Flutter                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/Santos-Enoque/uber_clone_with_flutter)                                                                                                |
| Uber Eats                     | [enatega.com](https://enatega.com)                                                                 | [GitHub](https://github.com/ninjas-code-official/food-delivery-multivendor)                                                                               | JavaScript, React, React Native, Material UI, GraphQL, Expo                                                                   | ![GitHub Repo stars](https://img.shields.io/github/stars/ninjas-code-official/food-delivery-multivendor)                                                                                                      |
| Ubuntu                         | [vivek9patel.github.io](https://vivek9patel.github.io)                                                                                                                 | [GitHub](https://github.com/vivek9patel/vivek9patel.github.io)                                                                             | React, Tailwind CSS                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/vivek9patel/vivek9patel.github.io)                                                                                                    |
| Udemy                          | [wedemy.up.railway.app](https://wedemy.up.railway.app)                                                                                                                   | [GitHub](https://github.com/Longwater1234/WedemyClient)                                                                                    | Vue 3, TypeScript, Java, Spring, MySQL                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Longwater1234/WedemyClient)                                                                                                            |
| Udemy                          | [wedemy.up.railway.app](https://wedemy.up.railway.app/)                                                                                                                   | [GitHub](https://github.com/Longwater1234/WedemyClient)                                                                                    | Vue 3, TypeScript, ElementUI, Java, Springboot, MySQL, Redis                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/Longwater1234/WedemyClient)                                                                                                            |
| Unsplash                       | [github.com (screenshot)](https://github.com/junipdewan/react-unsplash#react-unsplash)                                                                                 | [GitHub](https://github.com/junipdewan/react-unsplash)                                                                                     | React                                                                          | ![GitHub Repo stars](https://img.shields.io/github/stars/junipdewan/react-unsplash)                                                                                                            |
| Unsplash                       | [github.com (screenshot)](https://github.com/junipdewan/react-unsplash#react-unsplash)                                                                                 | [GitHub](https://github.com/junipdewan/react-unsplash)                                                                                     | React                                                                          | ![GitHub Repo stars](https://flat.badgen.net/github/stars/junipdewan/react-unsplash)                                                                                                             |
| Unsplash                       | [mani-unsplash-clone.netlify](https://mani-unsplash-clone.netlify.app/)                                                                                                | [GitHub](https://github.com/mani-barathi/unsplash-clone)                                                                                   | React, Material-UI                                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/mani-barathi/unsplash-clone)                                                                                                           |                                                  |
| Vimeo                          | [bimeo.herokuapp](https://bimeo.herokuapp.com/#/)                                                                                                                      | [GitHub](https://github.com/TarikGul/vimeo_clone_full_stack_project)                                                                       | React, Redux, Ruby. PostgreSQL                                                 | ![GitHub Repo stars](https://img.shields.io/github/stars/TarikGul/vimeo_clone_full_stack_project)                                                                                              |
| VK                             | [openvk.su](https://openvk.su)                                                                                                                                         | [GitHub](https://github.com/openvk/openvk)                                                                                                 | PHP, HTML, CSS, JQuery, MySQL                                                  | ![GitHub Repo stars](https://img.shields.io/github/stars/openvk/openvk)                                                                                                                        |
| WhatsApp                       | [codesource.io (screenshot)](https://codesource.io/wp-content/uploads/2020/11/Screenshot_20201029-171635-1-709x1536.png)                                               | [GitHub](https://github.com/Ekeminie/whatsapp_ui)                                                                                          | Flutter                                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/Ekeminie/whatsapp_ui)                                                                                                                 |
| WhatsApp                       | [medium.com (article)](https://medium.com/p/5479d83baaa4)                                                                                                              | [GitHub](https://github.com/Urigo/WhatsApp-Clone-Client-Angular) <br/> [GitHub](https://github.com/Urigo/WhatsApp-Clone-server)            | Angular, Express, PostgreSQL, GraphQL, TypeScript                              | ![GitHub Repo stars](https://img.shields.io/github/stars/Urigo/WhatsApp-Clone-Client-Angular) ![GitHub Repo stars](https://img.shields.io/github/stars/Urigo/WhatsApp-Clone-server)            |
| WhatsApp                       | [youtube](https://youtu.be/3TYfkvf4u4M) <br/> [clone-massenger.herokuapp](https://clone-massenger.herokuapp.com/signinsignup)                                          | [GitHub](https://github.com/RupmalyaK/whatsapp-MERN)                                                                                       | MERN                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/RupmalyaK/whatsapp-MERN)                                                                                                              |
| WhatsApp                       | [tinode.co](https://tinode.co/)                                                                                                                                        | [GitHub](https://github.com/tinode/chat)                                                                                                   | Go, React, Java, Swift, MySQL, MongoDB, RethinkDB                              | ![GitHub Repo stars](https://img.shields.io/github/stars/tinode/chat)                                                                                                                          |
| WhatsApp (Web)                 | [whatsapp-clone-web.netlify.app](https://whatsapp-clone-web.netlify.app)                                                                                               | [GitHub](https://github.com/KarenOk/whatsapp-web-clone) <br /> [GitHub](https://github.com/KarenOk/whatsapp-web-clone-backend)             | React, React Context API, Express, JavaScript, Socket.IO                       | ![GitHub Repo stars](https://img.shields.io/github/stars/karenok/whatsapp-web-clone)                                                                                                           |
| Windows 11                     | [win11.blueedge.me](https://andrewstech.me/win11react-add-test)                                                                                               | [GitHub](https://github.com/blueedgetechno/win11React)| React, Redux, Firebase, TailwindCSS, Internationalization                       | ![GitHub Repo stars](https://flat.badgen.net/github/stars/blueedgetechno/win11react)                                                                                                            |
| Wix                            | [grapesjs.com](https://grapesjs.com/)                                                                                                                                  | [GitHub](https://github.com/artf/grapesjs)                                                                                                 | JavaScript, Webpack                                                            | ![GitHub Repo stars](https://img.shields.io/github/stars/artf/grapesjs)                                                                                                                        |
| Workflowy                      | [deepnotes.in](https://deepnotes.in/)                                                                                                                                  | [GitHub](https://github.com/mukeshsoni/deepnotes-editor)                                                                                   | ReactJS, DraftJS                                                               | ![GitHub Repo stars](https://img.shields.io/github/stars/mukeshsoni/deepnotes-editor)                                                                                                          |
| YouTube                        | [yt-clone-7.web.app](https://yt-clone-7.web.app)                                                                                                                       | [GitHub](https://github.com/anandhu720/youtube-clone.git)                                                                                  | ReactJs,Redux,Firebase,YouTube API                                             | ![GitHub Repo stars](https://flat.badgen.net/github/stars/anandhu720/youtube-clone)                                                                                                              |
| YouTube                        | [utubeclone.netlify.app](https://utubeclone.netlify.app/) <br/> [youtube](https://youtu.be/wHLurtOnmyM)                                                                | [GitHub](https://github.com/manikandanraji/youtubeclone-frontend) <br/> [GitHub](https://github.com/manikandanraji/youtubeclone-backend)   | React, Redux, Express, Sequelize                                               | ![GitHub Repo stars](https://flat.badgen.net/github/stars/manikandanraji/youtubeclone-frontend) ![GitHub Repo stars](https://flat.badgen.net/github/stars/manikandanraji/youtubeclone-backend)   |
| YouTube Music                  | [octave-music.web.app](https://octave-music.web.app/)                                                                                                                  | [GitHub](https://github.com/mani-barathi/Octave)                                                                                           | React, Redux, Firebase, Material-UI                                            | ![GitHub Repo stars](https://flat.badgen.net/github/stars/mani-barathi/Octave)                                                                                                                   |
| YouTube Music                  | [beatbump.ml](https://beatbump.ml/)                                                                                                                                    | [GitHub](https://github.com/snuffyDev/Beatbump)                                                                                            | Svelte                                                                         | ![GitHub Repo stars](https://flat.badgen.net/github/stars/snuffyDev/Beatbump)                                                                                                                    |
| YouTube Music                  | [music.creasource.app](https://music.creasource.app)                                                                                                                   | [GitHub](https://github.com/tgambet/musicsource)                                                                                           | Angular                                                                        | ![GitHub Repo stars](https://flat.badgen.net/github/stars/tgambet/musicsource)                                                                                                                   |
| Zapier                         | [n8n.io](https://n8n.io/)                                                                                                                                              | [GitHub](https://github.com/n8n-io/n8n)                                                                                                    | TypeScript, Vue, Docker                                                        | ![GitHub Repo stars](https://img.shields.io/github/stars/n8n-io/n8n)                                                                                                                           |
| Zapier                         | [vimeo.com (gif)](https://vimeo.com/61976251)                                                                                                                          | [GitHub](https://github.com/huginn/huginn)                                                                                                 | Ruby                                                                           | ![GitHub Repo stars](https://img.shields.io/github/stars/huginn/huginn)   


_Some link is broken or clone is not good enough? [report it](https://github.com/GorvGoyl/Clone-Wars/issues/new)_

---

## Contribution Guide

I need your help to maintain this list up to date 🙏.

### Fixing an invalid clone:

If there's some issue with a clone (URL not working, repo not found, clone not good enough, etc.), then feel free to remove or update it with working link. Just edit [readme.md](https://github.com/GorvGoyl/Clone-Wars/blob/main/README.md) and submit a PR. I'll review and merge it.

### Adding new clone:

Before submitting a clone make sure:

- It should be a clone/alternative of some popular software or app.
- Project must have at least minimal functionality, please do not submit any 'UI only' clone.
- Also, no more Trello, 2048 clones unless your tech-stack is different.

Add clone to **1st table** if you can also provide tutorial link else add it to **2nd table**. Maintain alphabetical order while adding.

Edit [readme.md](https://github.com/GorvGoyl/Clone-Wars/blob/main/README.md) (_you may use online md editor like [markdown.site](https://markdown.site/) for better table visualization_) and submit the PR! Make sure there are no merge conflicts.

Any other [feedback](https://github.com/GorvGoyl/Clone-Wars/issues) to improve this project is also welcome :)
