/*
 * Decompiled with CFR 0.152.
 */
package com.lizhou.fileload;

import com.lizhou.domain.DownloadFile;
import com.lizhou.exception.FileNotExistsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileDownload {
    private String filePath = null;
    private List<String> fileFormat = new ArrayList<String>();
    private HttpServletRequest request;

    public FileDownload(HttpServletRequest request) {
        this.request = request;
    }

    public FileDownload(String filePath, HttpServletRequest request) {
        this.request = request;
        this.filePath = filePath;
    }

    public void bindDownloadFilesToScope(String var) throws FileNotExistsException {
        if (this.filePath == null) {
            this.filePath = "D:/uploadFile";
        }
        if (!this.isFileExists(this.filePath)) {
            throw new FileNotExistsException();
        }
        ArrayList<DownloadFile> list = new ArrayList<DownloadFile>();
        this.getDownloadFiles(this.filePath, list);
        this.request.getSession().setAttribute(var, list);
    }

    private void getDownloadFiles(String filePath, List<DownloadFile> list) {
        File file = new File(filePath);
        if (file.isFile()) {
            String uuidFileName = file.getName();
            if (this.isFormat(uuidFileName.substring(uuidFileName.lastIndexOf(".") + 1))) {
                DownloadFile df = new DownloadFile();
                df.setFileName(uuidFileName.substring(uuidFileName.indexOf("#") + 1));
                df.setUuidFileName(uuidFileName);
                df.setFilePath(file.getPath());
                list.add(df);
            }
        } else {
            File[] childFiles;
            File[] fileArray = childFiles = file.listFiles();
            int n = childFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File cf = fileArray[n2];
                this.getDownloadFiles(cf.getPath(), list);
                ++n2;
            }
        }
    }

    public void downloadFile(String var, String uuidFileName, HttpServletResponse response) throws IOException {
        byte[] by = uuidFileName.getBytes("ISO-8859-1");
        uuidFileName = new String(by, "UTF-8");
        List files = (List)this.request.getSession().getAttribute(var);
        for (DownloadFile file : files) {
            if (!file.getUuidFileName().equals(uuidFileName)) continue;
            FileInputStream is = new FileInputStream(file.getFilePath());
            ServletOutputStream os = response.getOutputStream();
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(file.getFileName(), "UTF-8"));
            this.output(is, (OutputStream)os);
            break;
        }
    }

    public void output(InputStream is, OutputStream os) throws IOException {
        byte[] by = new byte[1024];
        int len = 0;
        while ((len = is.read(by)) > 0) {
            os.write(by, 0, len);
        }
        is.close();
        os.close();
    }

    private boolean isFormat(String format) {
        if (this.fileFormat.size() == 0) {
            return true;
        }
        for (String f : this.fileFormat) {
            if (!f.equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileExists(String filePath) {
        boolean b = true;
        File file = new File(filePath);
        if (!file.exists()) {
            b = false;
        }
        return b;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileFormat() {
        if (this.fileFormat.size() == 0) {
            return "*";
        }
        String format = "";
        for (String s : this.fileFormat) {
            format = String.valueOf(format) + "," + s;
        }
        format = format.substring(format.indexOf(",") + 1);
        return format;
    }

    public void setFileFormat(String format) {
        this.fileFormat.add(format);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

