package com.gongchuangsu.ssh.config;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

/**
 * 
 * ˵һһע@EnableWebSecurityͿԴһΪ springSecurityFilterChain Filter
 */
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter{
	@Autowired
	private DataSource dataSource;
	
	protected void configure(HttpSecurity http) throws Exception{
		http
			.authorizeRequests()
				.antMatchers("/static/**", "/register", "/weixin").permitAll()   // ʾ̬Դ
				.antMatchers("/tables").hasRole("ADMIN") // ֻӵROLE_ADMINȨ޵ûܷ/admin
				.antMatchers("/**").authenticated()      // ûֻ֤ܷͨ
				.and()	
			.formLogin()
				.usernameParameter("username")           // ĬΪusername
				.passwordParameter("password")           // ĬΪpassword
				.loginPage("/login")                     // ָ½λãΪĬϵ¼ҳ
				.defaultSuccessUrl("/")                  // ĬΪ¼棨/login
				.failureUrl("/login?error=true")         // õ½ʧܽ
				.permitAll()                             // ûԷʵ½
				.and()
			.rememberMe()
				.tokenValiditySeconds(2419200)           // tokenЧڣĬΪ
				.key("loginKey")                         // ˽ԿƣĬΪSpringSecurity
				.and()
			.logout()                                    // û˳Ӧãеremember-me tokenᱻ
				.logoutUrl("/logout")
				.logoutSuccessUrl("/login")              // ָ˳
				.and()
			.csrf().disable();                           // CSRF		
	}
	
	protected void configure(AuthenticationManagerBuilder auth) throws Exception{
		auth			
			.jdbcAuthentication()
				.dataSource(dataSource)
				// ֤ѯ
				.usersByUsernameQuery(
						"select username, password, enabled " +
						"from user_info where username = ?")
				// Ȩ޲ѯ
				.authoritiesByUsernameQuery(
						"select username, role " + 
						"from user_roles where username = ?");		 
	}
}