package anifire.util
{
	public class InputLanguage
	{
		
		public static const ALL_LANGUAGES:Array = [{
			"name":"Latin",
			"range":[0,127]
		},{
			"name":"Latin",
			"range":[128,255]
		},{
			"name":"Latin",
			"range":[256,383]
		},{
			"name":"Latin",
			"range":[384,591]
		},{
			"name":"IPA Extensions",
			"range":[592,687]
		},{
			"name":"Spacing Modifier Letters",
			"range":[688,767]
		},{
			"name":"Combining Diacritical Marks",
			"range":[768,879]
		},{
			"name":"Greek and Coptic",
			"range":[880,1023]
		},{
			"name":"Cyrillic",
			"range":[1024,1279]
		},{
			"name":"Cyrillic Supplement",
			"range":[1280,1327]
		},{
			"name":"Armenian",
			"range":[1328,1423]
		},{
			"name":"Hebrew",
			"range":[1424,1535]
		},{
			"name":"Arabic",
			"range":[1536,1791]
		},{
			"name":"Syriac",
			"range":[1792,1871]
		},{
			"name":"Arabic",
			"range":[1872,1919]
		},{
			"name":"Thaana",
			"range":[1920,1983]
		},{
			"name":"N\'Ko",
			"range":[1984,2047]
		},{
			"name":"Samaritan",
			"range":[2048,2111]
		},{
			"name":"Mandaic",
			"range":[2112,2143]
		},{
			"name":"Arabic",
			"range":[2208,2303]
		},{
			"name":"Devanagari",
			"range":[2304,2431]
		},{
			"name":"Bengali",
			"range":[2432,2559]
		},{
			"name":"Gurmukhi",
			"range":[2560,2687]
		},{
			"name":"Gujarati",
			"range":[2688,2815]
		},{
			"name":"Oriya",
			"range":[2816,2943]
		},{
			"name":"Tamil",
			"range":[2944,3071]
		},{
			"name":"Telugu",
			"range":[3072,3199]
		},{
			"name":"Kannada",
			"range":[3200,3327]
		},{
			"name":"Malayalam",
			"range":[3328,3455]
		},{
			"name":"Sinhala",
			"range":[3456,3583]
		},{
			"name":"Thai",
			"range":[3584,3711]
		},{
			"name":"Lao",
			"range":[3712,3839]
		},{
			"name":"Tibetan",
			"range":[3840,4095]
		},{
			"name":"Myanmar",
			"range":[4096,4255]
		},{
			"name":"Georgian",
			"range":[4256,4351]
		},{
			"name":"Hangul",
			"range":[4352,4607]
		},{
			"name":"Ethiopic",
			"range":[4608,4991]
		},{
			"name":"Ethiopic Supplement",
			"range":[4992,5023]
		},{
			"name":"Cherokee",
			"range":[5024,5119]
		},{
			"name":"Unified Canadian Aboriginal Syllabics",
			"range":[5120,5759]
		},{
			"name":"Ogham",
			"range":[5760,5791]
		},{
			"name":"Runic",
			"range":[5792,5887]
		},{
			"name":"Tagalog",
			"range":[5888,5919]
		},{
			"name":"Hanunoo",
			"range":[5920,5951]
		},{
			"name":"Buhid",
			"range":[5952,5983]
		},{
			"name":"Tagbanwa",
			"range":[5984,6015]
		},{
			"name":"Khmer",
			"range":[6016,6143]
		},{
			"name":"Mongolian",
			"range":[6144,6319]
		},{
			"name":"Unified Canadian Aboriginal Syllabics Extended",
			"range":[6320,6399]
		},{
			"name":"Limbu",
			"range":[6400,6479]
		},{
			"name":"Tai Le",
			"range":[6480,6527]
		},{
			"name":"Tai Lue",
			"range":[6528,6623]
		},{
			"name":"Khmer Symbols",
			"range":[6624,6655]
		},{
			"name":"Buginese",
			"range":[6656,6687]
		},{
			"name":"Tai Tham",
			"range":[6688,6831]
		},{
			"name":"Combining Diacritical Marks Extended",
			"range":[6832,6911]
		},{
			"name":"Balinese",
			"range":[6912,7039]
		},{
			"name":"Sundanese",
			"range":[7040,7103]
		},{
			"name":"Batak",
			"range":[7104,7167]
		},{
			"name":"Lepcha",
			"range":[7168,7247]
		},{
			"name":"Ol Chiki",
			"range":[7248,7295]
		},{
			"name":"Sundanese Supplement",
			"range":[7360,7375]
		},{
			"name":"Vedic",
			"range":[7376,7423]
		},{
			"name":"Phonetic Extensions",
			"range":[7424,7551]
		},{
			"name":"Phonetic Extensions Supplement",
			"range":[7552,7615]
		},{
			"name":"Combining Diacritical Marks Supplement",
			"range":[7616,7679]
		},{
			"name":"Latin Extended Additional",
			"range":[7680,7935]
		},{
			"name":"Greek Extended",
			"range":[7936,8191]
		},{
			"name":"General Punctuation",
			"range":[8192,8303]
		},{
			"name":"Superscripts and Subscripts",
			"range":[8304,8351]
		},{
			"name":"Currency Symbols",
			"range":[8352,8399]
		},{
			"name":"Combining Diacritical Marks for Symbols",
			"range":[8400,8447]
		},{
			"name":"Letterlike Symbols",
			"range":[8448,8527]
		},{
			"name":"Number Forms",
			"range":[8528,8591]
		},{
			"name":"Arrows",
			"range":[8592,8703]
		},{
			"name":"Mathematical Operators",
			"range":[8704,8959]
		},{
			"name":"Miscellaneous Technical",
			"range":[8960,9215]
		},{
			"name":"Control Pictures",
			"range":[9216,9279]
		},{
			"name":"Optical Character Recognition",
			"range":[9280,9311]
		},{
			"name":"Enclosed Alphanumerics",
			"range":[9312,9471]
		},{
			"name":"Box Drawing",
			"range":[9472,9599]
		},{
			"name":"Block Elements",
			"range":[9600,9631]
		},{
			"name":"Geometric Shapes",
			"range":[9632,9727]
		},{
			"name":"Miscellaneous Symbols",
			"range":[9728,9983]
		},{
			"name":"Dingbats",
			"range":[9984,10175]
		},{
			"name":"Miscellaneous Mathematical Symbols-A",
			"range":[10176,10223]
		},{
			"name":"Supplemental Arrows-A",
			"range":[10224,10239]
		},{
			"name":"Braille",
			"range":[10240,10495]
		},{
			"name":"Supplemental Arrows-B",
			"range":[10496,10623]
		},{
			"name":"Miscellaneous Mathematical Symbols-B",
			"range":[10624,10751]
		},{
			"name":"Supplemental Mathematical Operators",
			"range":[10752,11007]
		},{
			"name":"Miscellaneous Symbols and Arrows",
			"range":[11008,11263]
		},{
			"name":"Glagolitic",
			"range":[11264,11359]
		},{
			"name":"Latin",
			"range":[11360,11391]
		},{
			"name":"Coptic",
			"range":[11392,11519]
		},{
			"name":"Georgian Supplement",
			"range":[11520,11567]
		},{
			"name":"Tifinagh",
			"range":[11568,11647]
		},{
			"name":"Ethiopic Extended",
			"range":[11648,11743]
		},{
			"name":"Cyrillic Extended-A",
			"range":[11744,11775]
		},{
			"name":"Supplemental Punctuation",
			"range":[11776,11903]
		},{
			"name":"CJK Radicals Supplement",
			"range":[11904,12031]
		},{
			"name":"Kangxi Radicals",
			"range":[12032,12255]
		},{
			"name":"Ideographic Description Characters",
			"range":[12272,12287]
		},{
			"name":"CJK Symbols and Punctuation",
			"range":[12288,12351]
		},{
			"name":"Japanese",
			"range":[12352,12447]
		},{
			"name":"Japanese",
			"range":[12448,12543]
		},{
			"name":"Bopomofo",
			"range":[12544,12591]
		},{
			"name":"Hangul",
			"range":[12592,12687]
		},{
			"name":"Kanbun",
			"range":[12688,12703]
		},{
			"name":"Bopomofo Extended",
			"range":[12704,12735]
		},{
			"name":"CJK Strokes",
			"range":[12736,12783]
		},{
			"name":"Katakana Phonetic Extensions",
			"range":[12784,12799]
		},{
			"name":"Enclosed CJK Letters and Months",
			"range":[12800,13055]
		},{
			"name":"CJK Compatibility",
			"range":[13056,13311]
		},{
			"name":"CJK Unified Ideographs",
			"range":[13312,19903]
		},{
			"name":"Yijing Hexagram Symbols",
			"range":[19904,19967]
		},{
			"name":"CJK Unified Ideographs",
			"range":[19968,40959]
		},{
			"name":"Yi Syllables",
			"range":[40960,42127]
		},{
			"name":"Yi Radicals",
			"range":[42128,42191]
		},{
			"name":"Lisu",
			"range":[42192,42239]
		},{
			"name":"Vai",
			"range":[42240,42559]
		},{
			"name":"Cyrillic Extended-B",
			"range":[42560,42655]
		},{
			"name":"Bamum",
			"range":[42656,42751]
		},{
			"name":"Modifier Tone Letters",
			"range":[42752,42783]
		},{
			"name":"Latin",
			"range":[42784,43007]
		},{
			"name":"Syloti Nagri",
			"range":[43008,43055]
		},{
			"name":"Common Indic Number Forms",
			"range":[43056,43071]
		},{
			"name":"Phags-pa",
			"range":[43072,43135]
		},{
			"name":"Saurashtra",
			"range":[43136,43231]
		},{
			"name":"Devanagari",
			"range":[43232,43263]
		},{
			"name":"Kayah Li",
			"range":[43264,43311]
		},{
			"name":"Rejang",
			"range":[43312,43359]
		},{
			"name":"Hangul",
			"range":[43360,43391]
		},{
			"name":"Javanese",
			"range":[43392,43487]
		},{
			"name":"Myanmar Extended-B",
			"range":[43488,43519]
		},{
			"name":"Cham",
			"range":[43520,43615]
		},{
			"name":"Myanmar Extended-A",
			"range":[43616,43647]
		},{
			"name":"Tai Viet",
			"range":[43648,43743]
		},{
			"name":"Meetei Mayek Extensions",
			"range":[43744,43775]
		},{
			"name":"Ethiopic Extended-A",
			"range":[43776,43823]
		},{
			"name":"Latin",
			"range":[43824,43887]
		},{
			"name":"Cherokee",
			"range":[43888,43967]
		},{
			"name":"Meetei Mayek",
			"range":[43968,44031]
		},{
			"name":"Hangul",
			"range":[44032,55215]
		},{
			"name":"Hangul",
			"range":[55216,55295]
		},{
			"name":"High Surrogates",
			"range":[55296,56319]
		},{
			"name":"Low Surrogates",
			"range":[56320,57343]
		},{
			"name":"Private Use Area",
			"range":[57344,63743]
		},{
			"name":"CJK Compatibility Ideographs",
			"range":[63744,64255]
		},{
			"name":"Alphabetic Presentation Forms",
			"range":[64256,64335]
		},{
			"name":"Arabic",
			"range":[64336,65023]
		},{
			"name":"Variation Selectors",
			"range":[65024,65039]
		},{
			"name":"Vertical Forms",
			"range":[65040,65055]
		},{
			"name":"Combining Half Marks",
			"range":[65056,65071]
		},{
			"name":"CJK Compatibility Forms",
			"range":[65072,65103]
		},{
			"name":"Small Form Variants",
			"range":[65104,65135]
		},{
			"name":"Arabic",
			"range":[65136,65279]
		},{
			"name":"Halfwidth and Fullwidth Forms",
			"range":[65280,65519]
		},{
			"name":"Specials",
			"range":[65520,65535]
		}];
		 
		
		public var name:String;
		
		public var range:Array;
		
		public function InputLanguage(param1:String, param2:Array)
		{
			super();
			this.name = param1;
			this.range = param2;
		}
		
		public static function getLanguageFromCharCode(param1:Number) : InputLanguage
		{
			var _loc3_:int = 0;
			var _loc4_:int = 0;
			var _loc6_:InputLanguage = null;
			var _loc2_:Array = InputLanguage.ALL_LANGUAGES;
			var _loc5_:int = _loc2_.length - 1;
			var _loc7_:int = 0;
			var _loc8_:int = 20;
			while(_loc7_ < _loc8_)
			{
				if(_loc5_ < _loc4_)
				{
					break;
				}
				_loc3_ = _loc4_ + Math.floor((_loc5_ - _loc4_) / 2);
				_loc6_ = new InputLanguage(_loc2_[_loc3_].name,_loc2_[_loc3_].range);
				if(_loc6_.containsCharCode(param1))
				{
					return _loc6_;
				}
				if(param1 < _loc6_.range[0])
				{
					_loc5_ = _loc3_ - 1;
				}
				else
				{
					_loc4_ = _loc3_ + 1;
				}
				_loc7_++;
			}
			return null;
		}
		
		public function containsCharCode(param1:Number) : Boolean
		{
			if(this.range)
			{
				return param1 >= this.range[0] && param1 <= this.range[1];
			}
			return false;
		}
		
		public function toString() : String
		{
			if(!this.range)
			{
				return this.name;
			}
			return this.name + "(" + this.range[0].toString(16) + "-" + this.range[1].toString(16) + ")";
		}
	}
}
