/*
    SP0256A - SP0256-012 ROM Data.

    Created by Michel Bernard (michel_bernard@hotmail.com)
    - <http://www.github.com/GmEsoft/SP0256_CTS256A-AL2>
    Copyright (c) 2023 Michel Bernard.
    All rights reserved.


    This file is part of SP0256_CTS256A-AL2.

    SP0256_CTS256A-AL2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SP0256_CTS256A-AL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SP0256_CTS256A-AL2.  If not, see <https://www.gnu.org/licenses/>.
*/

#include "sp0256_012.h"

namespace sp0256_012
{

	const char * labels[] = {
		"(SPB640 Speech FIFO)",
					"pause4",	"pause3",	"pause2",	"pause1",	"pause0",	"Mattel Electronics Presents",
																							"Zero",
		"One",		"Two",		"Three",	"Four",		"Five",		"Six",		"Seven",	"Eight",
		"Nine",		"Ten",		"Eleven",	"Twelve",	"Thirteen",	"Fourteen",	"Fifteen",	"Sixteen",
		"Seventeen","Eighteen",	"Nineteen",	"Twenty",	"Thirty",	"Fourty",	"Fifty",	"Sixty",
		"Seventy",	"Eighty",	"Ninety",	"Hundred",	"Thousand",	"-teen",	"-ty",		"Press",
		"Enter",	"Or",		"And"
	};

	unsigned nlabels = sizeof( labels ) / sizeof( char * );

	/* ======================================================================== */
	/*  MASK table                                                              */
	/* ======================================================================== */
	const uint8_t mask[4097] =
	{
		0xE8,0xBB,0xE8,0x87,0xE8,0x17,0xE8,0x37,0xE8,0xF7,0xE8,0x8F,0xE8,0xCF,0xE2,0xD8,
		0xE2,0x9A,0xE2,0x89,0xE2,0xDD,0xE2,0x37,0xE2,0x2F,0xEA,0x04,0xEA,0x54,0xEA,0x4C,
		0xEA,0xD2,0xEA,0x8A,0xEA,0x8E,0xEA,0xB1,0xEA,0xFD,0xEA,0x53,0xEA,0xAB,0xEA,0x47,
		0xEA,0xCF,0xEA,0xFF,0xE6,0x10,0xE6,0x48,0xE6,0x3C,0xE6,0x62,0xE6,0x8A,0xE6,0xBA,
		0xE6,0x76,0xE6,0x5E,0xE6,0xC1,0xE6,0xB1,0xE6,0xCB,0xEE,0xC8,0xEE,0x98,0xEE,0xF8,
		0xEE,0xC2,0xEE,0x1E,0xEE,0x7E,0xEE,0x2D,0xEE,0x6D,0xEE,0x1D,0xEE,0x5D,0xEE,0x3D,
		0x18,0x2B,0x15,0xC0,0x39,0x24,0x43,0xE2,0x1F,0x00,0x18,0x23,0x24,0xC0,0x28,0x23,
		0x62,0xC6,0x1D,0xA5,0x03,0x20,0x66,0x52,0x0C,0x95,0x03,0x00,0x19,0x2C,0x0C,0x80,
		0x31,0x12,0x62,0xA7,0x1C,0x00,0x18,0x2C,0x0C,0xC0,0x29,0x94,0xE0,0x64,0x9C,0x85,
		0x02,0x38,0x85,0x12,0x9C,0x8C,0x03,0x00,0x10,0x35,0xE7,0x55,0xAD,0x6D,0x7F,0x26,
		0x91,0x85,0xD4,0x3C,0xAB,0xD6,0xCF,0x99,0x7A,0x00,0x10,0x34,0x6F,0xA1,0x86,0xCF,
		0x3E,0xAB,0x0D,0xBB,0x86,0x7C,0x6C,0xB5,0x6D,0xCF,0x24,0xB2,0x88,0x9E,0xA7,0x16,
		0xF3,0xA9,0xD2,0xE6,0x3D,0xD5,0x55,0xFD,0x01,0x00,0x10,0x32,0x74,0x98,0xA9,0xB7,
		0x81,0x1E,0xA9,0x87,0xF4,0x66,0xA3,0xFC,0x8B,0xD2,0x96,0x94,0xFB,0xFF,0x10,0x03,
		0x80,0x8E,0x16,0x0D,0x00,0x10,0x32,0x7C,0x90,0xAB,0xB7,0x81,0x1E,0xA9,0xA7,0x6E,
		0xF7,0x22,0xDD,0xC7,0xAA,0xFE,0xA5,0x9C,0xDE,0xCC,0x7E,0xF4,0x2E,0xAC,0xFA,0xC7,

		0xD9,0x91,0xA5,0xA5,0xE4,0xDC,0x5F,0xF4,0x2B,0x9D,0xFC,0x03,0x00,0x10,0x31,0x8F,
		0xDC,0xFF,0x8C,0x7C,0x97,0xF6,0x41,0xE6,0xE3,0xF4,0xF4,0xF6,0x47,0x23,0xC2,0x84,
		0xB6,0x85,0x74,0xFF,0xD0,0xDD,0xCF,0xEE,0x3F,0xB7,0xEB,0x01,0x00,0x74,0x7B,0xA3,
		0xDC,0x2D,0x3A,0x5A,0xB7,0x56,0xEE,0x45,0xDF,0x5B,0xDA,0xBF,0x68,0xE9,0x3B,0xFD,
		0x1F,0xF5,0x78,0x27,0xFF,0xA2,0x4E,0xF2,0xDC,0x1F,0x00,0x10,0x36,0x76,0x9B,0xA9,
		0xB7,0xBD,0x1A,0x1F,0x66,0xD4,0x85,0xA3,0xBB,0xCB,0x95,0x83,0x00,0x10,0x32,0x6E,
		0xDA,0x27,0xBB,0x7D,0x22,0x1F,0xC6,0x94,0x16,0x9C,0xDE,0x97,0xD6,0xA5,0xD3,0x7F,
		0x52,0x72,0x58,0xF2,0x4F,0xD7,0x85,0x03,0x00,0x10,0x32,0x35,0x96,0xA9,0xB9,0xBD,
		0x1A,0x1F,0x86,0xCE,0x6E,0x13,0x3D,0x09,0xE9,0xF6,0x00,0x10,0x32,0x7B,0x94,0xAB,
		0xB7,0x81,0x1E,0xA9,0x87,0x6E,0xAF,0x1B,0xDD,0xF9,0xAA,0xFE,0xA4,0x57,0xE6,0xCC,
		0x5E,0xF4,0x36,0xAD,0xFA,0xC7,0xD5,0xB5,0xA4,0xA5,0xED,0xDC,0x5F,0xF4,0x73,0x9E,
		0xFC,0x03,0x00,0x10,0x32,0xF7,0x9F,0xA9,0xBD,0x3F,0x22,0x11,0x86,0x6E,0xCF,0xA3,
		0xDB,0xFB,0x46,0xEB,0xC8,0xE9,0x3F,0x00,0x10,0x32,0xAC,0x98,0x27,0xBD,0x81,0x22,
		0x1F,0x87,0xAE,0x7E,0x1C,0x6D,0x81,0xE7,0xFF,0x72,0xE4,0x20,0x00,0xF1,0xE1,0x00,
		0x00,0x11,0xFC,0x13,0xFF,0x13,0xFF,0x00,0xFE,0x13,0xFF,0x00,0x11,0xFF,0x00,0xFF,
		0x00,0xF7,0x00,0x18,0x32,0xDD,0xA0,0x7D,0x81,0x0F,0xC7,0x03,0xE3,0xEA,0x53,0xC6,

		0x75,0xAB,0xF0,0x41,0xE8,0x9E,0x17,0x73,0xA1,0xD2,0xDC,0x62,0xF6,0x14,0x34,0x4D,
		0x0F,0x8C,0xB7,0x54,0x99,0x5A,0xCB,0x5F,0x80,0x84,0x6D,0x88,0xF3,0x65,0x2A,0x73,
		0xBD,0xF5,0x77,0x50,0xAD,0x5D,0xEF,0xA1,0x5A,0xF5,0x45,0x3C,0x80,0x53,0x14,0x83,
		0xC8,0xBC,0xC9,0x05,0x60,0x09,0x03,0x68,0xB0,0xAF,0xA9,0x81,0x00,0x38,0x78,0xD8,
		0x8F,0xD9,0x61,0xA2,0x35,0x77,0x90,0x7F,0x07,0xD3,0xDA,0x80,0xFF,0xEC,0xB4,0x66,
		0xDF,0x31,0xD8,0xD8,0x89,0xBF,0x65,0x9B,0x9D,0x5E,0x82,0x3E,0x12,0x24,0x21,0x6F,
		0xFC,0x24,0x83,0x03,0x00,0xF2,0xF3,0x1F,0x5C,0x3E,0x48,0x90,0x60,0x0D,0xEE,0x03,
		0xA5,0x8B,0x00,0x00,0x1A,0xFD,0x38,0x50,0xA6,0x00,0xF0,0x03,0x21,0x6E,0xC7,0x8D,
		0xD9,0xF3,0xA0,0x30,0xD2,0x6F,0x22,0xF1,0x1A,0x95,0x71,0x89,0x0C,0x44,0x8A,0xC6,
		0xA7,0xD1,0x6B,0xA2,0x33,0xAF,0x9A,0x41,0xD1,0xCE,0xFC,0x2E,0x3B,0x4D,0x74,0xC6,
		0x24,0x13,0x18,0x91,0x61,0x9E,0x94,0xD7,0x75,0xCE,0xD4,0x53,0x0A,0x24,0x2A,0xDB,
		0x8F,0xF2,0x34,0xD0,0x19,0x5B,0x6A,0x80,0x64,0x47,0x79,0xD7,0x2D,0xF7,0x39,0x53,
		0x4B,0x09,0x90,0xC8,0x68,0x1F,0xAB,0xBD,0x46,0x69,0xDA,0x26,0x85,0x08,0xA2,0xFE,
		0x71,0xF1,0x55,0xA9,0xA4,0x74,0xE0,0x87,0x0F,0x1E,0x65,0xCC,0xDC,0x48,0x06,0x2C,
		0x2A,0xF3,0xDB,0xE6,0xB8,0x52,0x9A,0x7D,0xA8,0xA0,0x46,0x85,0x7E,0x97,0x0D,0x47,
		0x3A,0x63,0xFB,0xD4,0x2B,0xB0,0x28,0xBE,0x50,0xC2,0x44,0x67,0xDE,0xA1,0x88,0x16,

		0x19,0xE6,0x53,0x39,0x96,0x28,0x3F,0x86,0x49,0x05,0x80,0xC7,0x06,0x10,0x49,0x27,
		0x71,0x00,0x10,0xC9,0xF8,0x46,0xDB,0x33,0x5F,0x51,0xFB,0x00,0x0B,0xCE,0x76,0x9F,
		0x68,0x36,0xA6,0x0D,0xB2,0x67,0xA8,0x59,0x19,0xA6,0x0A,0xD8,0x57,0x2A,0x30,0x84,
		0x24,0xE0,0x22,0x32,0x8D,0x6B,0xB4,0xCF,0x60,0xB3,0xF4,0xDF,0xDF,0x82,0xC5,0xA0,
		0x69,0x91,0x0C,0x7A,0x76,0xAC,0x1F,0xC9,0x42,0xAD,0x32,0xAF,0x98,0x41,0x8B,0x8A,
		0xF5,0x37,0x59,0x8A,0x75,0xC6,0xDE,0x63,0xC8,0xD8,0xC9,0x1E,0x57,0xC3,0x91,0xCE,
		0xB8,0x88,0xEE,0x15,0x22,0x8B,0x13,0x0E,0xB3,0xD0,0x7D,0x68,0x03,0xF3,0xFB,0x18,
		0x23,0x1C,0x00,0x29,0x18,0x80,0x2A,0xB9,0xA6,0x2E,0x22,0x20,0xD9,0xC1,0x1D,0x36,
		0x63,0x99,0xCE,0xD4,0x46,0x04,0x22,0x33,0xBA,0xC7,0x6A,0xB6,0xCE,0xC9,0xEF,0xD7,
		0x0B,0x24,0x58,0x44,0xA7,0xA1,0x9D,0xFA,0x4D,0x44,0x12,0x47,0x20,0x5D,0x9C,0x32,
		0x2F,0x54,0xC9,0x0A,0x13,0xFA,0x27,0x3C,0xE9,0x34,0xE4,0x02,0xB0,0x26,0x52,0x40,
		0x98,0x93,0x58,0x00,0xC5,0x64,0x8E,0x86,0x7B,0x91,0x07,0x00,0x93,0x38,0xD0,0xF1,
		0x1F,0xE2,0x01,0x58,0xF3,0x39,0x70,0x9E,0x6B,0xEC,0x9E,0x80,0x92,0x1D,0xFE,0x6D,
		0xF5,0x9C,0x67,0x65,0x09,0xE0,0x00,0x00,0x00,0xF1,0xD0,0xDC,0x3C,0x06,0x1C,0x4C,
		0x6E,0x07,0xFC,0xB1,0x54,0x9A,0xDA,0xA7,0x60,0x41,0xA4,0xEB,0x7D,0xA1,0x95,0x2A,
		0xC3,0x16,0x11,0x14,0xD0,0x6C,0x0D,0x1F,0xA6,0x50,0x6B,0x38,0x27,0x82,0x82,0x99,

		0x9D,0xFF,0xC7,0x1C,0xA3,0x4C,0x97,0x34,0x50,0x53,0x95,0x00,0xAA,0xE6,0x91,0x2D,
		0x19,0x00,0x10,0xF2,0x04,0x2F,0xDB,0xD0,0x06,0xF1,0x00,0x10,0x33,0x66,0xA6,0x67,
		0x79,0x85,0x22,0xA9,0x87,0xE6,0x55,0xB5,0x6E,0x00,0x50,0x24,0xF5,0xCC,0xBC,0x67,
		0x9E,0xED,0x0D,0x8A,0xA4,0x9E,0x51,0x9B,0x6B,0xF6,0x5F,0xBA,0x97,0xD1,0xEE,0x45,
		0xCF,0xBF,0xB9,0x3B,0x04,0x8D,0x39,0xF9,0xF9,0x7C,0xAE,0x48,0xEA,0x11,0x7D,0x7B,
		0x69,0xEE,0xA5,0xA6,0x31,0xBD,0x3F,0x1E,0x00,0x10,0x33,0x56,0x22,0x47,0x4D,0x81,
		0xAE,0x92,0x58,0xC6,0x85,0x53,0x68,0xD1,0x6F,0x95,0xEE,0xD7,0xD8,0x67,0x1C,0x35,
		0xF4,0xCE,0x12,0xF2,0x9A,0xFB,0x8D,0xD8,0x98,0x20,0x11,0x86,0x22,0x7A,0x3F,0x5E,
		0xFD,0x47,0x5B,0x57,0xBB,0xFF,0x28,0x4B,0x6B,0xF9,0x1F,0x2D,0x8F,0xED,0xFE,0xF1,
		0x00,0xD0,0x56,0x10,0x33,0xEE,0xD4,0xE5,0xF9,0xBF,0x23,0x2D,0x67,0xB4,0xD5,0x92,
		0xDB,0x97,0xB6,0x68,0x52,0xFB,0xD1,0xF2,0x4F,0x62,0x4F,0xFA,0x71,0xCA,0xEB,0x47,
		0x39,0x5F,0x69,0xFD,0xE8,0x83,0x2D,0xAB,0x8F,0x07,0x00,0xD0,0x3E,0x18,0x33,0xED,
		0x5E,0xF9,0x82,0x8A,0xD2,0x03,0x03,0xEB,0x14,0xC2,0xA6,0x5D,0x33,0xB5,0x26,0xD7,
		0xE2,0xC2,0x90,0xD6,0x86,0xB4,0xFB,0xD1,0x96,0x76,0xFA,0x4F,0x67,0x3A,0x63,0xC8,
		0x90,0xDA,0xF6,0x1E,0x35,0xB2,0x07,0x90,0xAF,0xCC,0x78,0x00,0xD0,0x61,0xD0,0x19,
		0xD0,0x55,0xF1,0x00,0xD0,0x61,0x10,0x37,0x76,0x99,0xAD,0xB3,0x7F,0x1E,0xA2,0xA7,

		0x74,0x8F,0xB3,0x1A,0xCC,0xED,0x8D,0xA4,0x37,0xA8,0xDD,0x9F,0xEE,0x9E,0x1D,0x75,
		0x71,0x29,0xF7,0xA2,0x66,0x30,0xDD,0x7E,0xE5,0x00,0x98,0x23,0xC2,0xC7,0x03,0x00,
		0xD0,0x06,0xD0,0x06,0xD0,0x53,0xD0,0x06,0xF1,0x00,0xD0,0x06,0xD0,0x06,0xD0,0xA7,
		0xF1,0x00,0x10,0x32,0xF6,0x9F,0xA9,0xBD,0x3F,0x22,0x11,0x86,0x6E,0xCF,0xA3,0xBB,
		0xFB,0x46,0xEB,0xC8,0xE9,0xFF,0x3D,0xB4,0x15,0xF1,0x00,0xD8,0xB0,0xD8,0xB4,0xF1,
		0x00,0xD0,0x56,0x10,0x34,0x76,0x9B,0xAB,0xB9,0xBD,0x15,0x1F,0x87,0xEE,0xC6,0x1B,
		0xB5,0x3B,0xEB,0xFE,0xA3,0xA5,0xED,0xDC,0x9F,0x8E,0xBC,0x9D,0xEB,0x96,0xE3,0x01,
		0x00,0x10,0x32,0x6D,0xA0,0xA7,0xBF,0x81,0x15,0x1F,0xCA,0xB4,0xB6,0x9B,0x1E,0x88,
		0x96,0x7D,0x53,0xFF,0xD3,0x77,0x8E,0x6A,0x00,0x7D,0x0A,0xF1,0x00,0xD0,0x56,0x10,
		0x32,0x9C,0xA0,0xA9,0x2D,0xBF,0x22,0x1F,0x68,0xF4,0xF4,0xA3,0xF8,0x93,0xDE,0x80,
		0x55,0x7F,0xD3,0xDA,0xAF,0xE6,0x4F,0x4A,0x03,0x56,0x1C,0x4A,0xCD,0x3C,0x7A,0x43,
		0x9C,0x99,0x77,0x4A,0xF9,0xCD,0x0B,0x4A,0x06,0x00,0x53,0x26,0x78,0x3C,0x00,0xD0,
		0x3E,0xD8,0xD2,0xFE,0xD0,0x56,0xD8,0xBA,0xF1,0x00,0xD0,0x61,0xD0,0x55,0xF3,0xD0,
		0x56,0xD8,0xBA,0xF1,0x00,0xD0,0x61,0xD8,0x9E,0xD0,0x61,0xF5,0xD0,0x56,0xD8,0xBA,
		0xF1,0x00,0xD0,0x06,0xD0,0x06,0xD0,0x53,0xD0,0x06,0xD0,0x06,0xF4,0xD0,0x56,0xD8,
		0xBA,0xF1,0x00,0xD0,0x06,0xD0,0x06,0xD8,0xD1,0xD0,0x56,0xD8,0xBA,0xF1,0x00,0xD8,

		0xCD,0xFE,0xD0,0x56,0xD8,0xBA,0xF1,0x00,0xD8,0xB0,0xD8,0xB4,0xD0,0x56,0xD8,0xBA,
		0xF1,0x00,0xD0,0x56,0x10,0x32,0x6D,0x93,0xAB,0xB1,0xBF,0x1A,0x1F,0x46,0xEE,0xED,
		0x1A,0xAD,0xC7,0x6A,0xF6,0xA2,0x35,0x5B,0xDD,0x9F,0xF4,0xA4,0x9B,0xFC,0xDB,0x8B,
		0x3C,0x00,0x87,0x60,0xF6,0x7A,0x68,0x2B,0xD8,0x13,0xF1,0x00,0xD0,0x3E,0xD8,0xD2,
		0xD0,0x56,0xD8,0x13,0xF1,0x00,0xD0,0x61,0xD0,0x55,0xF3,0xD0,0x56,0xD8,0x13,0xF1,
		0x00,0xD0,0x61,0xD8,0x9E,0xD0,0x61,0xD0,0x56,0xD8,0x13,0xF1,0x00,0xD0,0x06,0xD0,
		0x06,0xD0,0x53,0xD0,0x06,0xD0,0x06,0xF4,0xD0,0x56,0xD8,0x13,0xF1,0x00,0xD0,0x06,
		0xD0,0x06,0xD8,0xD1,0xD0,0x56,0xD8,0x13,0xF1,0x00,0xD8,0xCD,0xF7,0xD0,0x56,0xD8,
		0x13,0xF1,0x00,0xD8,0xB0,0xD8,0xB4,0xD0,0x56,0xD8,0x13,0xF1,0x00,0x10,0x25,0x02,
		0xC0,0x10,0x97,0xBC,0xA4,0x01,0xA8,0x02,0x93,0xCF,0xD8,0x7D,0xB6,0xD6,0xFE,0x6A,
		0x7C,0x1C,0xD2,0x1D,0xD0,0xEE,0x3F,0x5A,0xFE,0x4D,0xFD,0x47,0x4B,0xC6,0xB9,0xFF,
		0x88,0x03,0x20,0x43,0x27,0x97,0xE9,0x40,0x3D,0xBD,0xED,0xD5,0xF8,0x38,0xA3,0x2E,
		0x24,0xDD,0x5D,0xF4,0xCD,0xA4,0xDB,0x8F,0xBA,0x95,0x74,0xFF,0xD1,0x8E,0x72,0xEE,
		0x1F,0x0F,0x00,0xD0,0x3E,0x10,0x35,0x37,0x9A,0xAB,0xB5,0xBF,0x1A,0x1F,0xC7,0x74,
		0x4F,0xB3,0xFA,0x97,0xBE,0x7E,0x15,0x03,0x52,0x33,0x93,0x66,0x60,0x52,0x00,0xAC,
		0xF1,0x06,0x4E,0x1A,0x80,0x3B,0x06,0xC5,0x0C,0xF7,0xEA,0x69,0xED,0xAF,0xC6,0xC7,

		0x21,0xED,0x90,0xE7,0x06,0xA2,0x15,0xF6,0xD4,0x7F,0x3E,0xA4,0x00,0x48,0xE3,0x91,
		0xC7,0x03,0x00,0xD0,0x56,0xD8,0xBA,0xF1,0x00,0xD0,0x56,0xD8,0x13,0xF1,0x00,0x10,
		0x28,0x1D,0xC0,0x18,0x1D,0x7C,0x86,0xDC,0x33,0xB5,0x2E,0x4F,0xE3,0xD2,0x8C,0xD6,
		0x7F,0x75,0xF7,0x51,0x1B,0xB1,0x6E,0x3F,0x7A,0xFB,0xD5,0xFD,0xA1,0x0D,0x00,0xD0,
		0x06,0xF1,0x00,0x10,0x34,0x76,0x9C,0xA9,0xBB,0x7F,0x1D,0x22,0x68,0x74,0x7F,0xAB,
		0xFC,0x8F,0xB2,0x77,0x73,0xFF,0x99,0xCB,0x30,0x62,0xC7,0x5F,0x53,0x82,0x9E,0x4F,
		0xE2,0x01,0x58,0xF2,0xF1,0x67,0x4C,0x44,0x53,0x6F,0xFB,0x3A,0x44,0x90,0xA8,0xE9,
		0x4B,0x77,0x97,0x2B,0xD1,0xE3,0x01,0x00,0xD0,0x19,0xD0,0x55,0xF1,0x00,0x10,0x32,
		0xB4,0xA9,0xA9,0xBB,0x7F,0x1D,0x22,0x48,0xEE,0x96,0x0D,0xDD,0x8F,0x6B,0xFF,0x72,
		0xBB,0x73,0xE8,0x1E,0x6D,0xF9,0x17,0x7D,0x69,0xEB,0xFE,0xA1,0x2C,0xE3,0xDC,0x60,
		0xF4,0xB4,0x9B,0x1A,0xC4,0x9D,0x69,0x73,0x56,0x9B,0xA8,0x4B,0x45,0x37,0x88,0x63,
		0xAB,0xE2,0x01,0x00,0xF1,0x00,0xF1,0x00,0xF1,0x00,0xF1,0x00,0xF1,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	};

}
