package com.glitchcog.fontificator.gui.component.combomenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * Adapted from https://www.crionics.com/public/swing_examples/JMenuExamples1.html
 */
class BlankIcon implements Icon
{
    private Color fillColor;

    private int size;

    public BlankIcon()
    {
        this(null, 11);
    }

    public BlankIcon(Color color, int size)
    {
        fillColor = color;
        this.size = size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        if (fillColor != null)
        {
            g.setColor(fillColor);
            g.drawRect(x, y, size - 1, size - 1);
        }
    }

    @Override
    public int getIconWidth()
    {
        return size;
    }

    @Override
    public int getIconHeight()
    {
        return size;
    }
}