/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.sprite;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.bot.MessageType;
import com.glitchcog.fontificator.config.ConfigColor;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.emoji.EmojiManager;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import com.glitchcog.fontificator.sprite.Sprite;
import com.glitchcog.fontificator.sprite.SpriteCache;
import com.glitchcog.fontificator.sprite.SpriteCharacterKey;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpriteFont {
    private static final Logger logger = Logger.getLogger(SpriteFont.class);
    public static final String NORMAL_ASCII_KEY = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
    public static final int BADGE_MINIMUM_SPACING_PIXELS = 3;
    protected SpriteCache sprites;
    protected Map<Integer, Rectangle> characterBounds;
    protected static final String WORD_BREAKS = " \n\r\t";
    protected static final String LINE_BREAKS = "\n";
    protected int lineScrollOffset;
    protected ConfigFont config;

    public SpriteFont(ConfigFont config) {
        logger.trace("Creating sprite font using config font filename " + (config == null ? "null" : config.getFontFilename()));
        this.config = config;
        this.characterBounds = new HashMap<Integer, Rectangle>();
        this.sprites = new SpriteCache(config);
    }

    private int[] getEmojiDimensions(SpriteCharacterKey c, ConfigEmoji emojiConfig) {
        float w;
        float h;
        float eScale;
        int ih;
        int iw;
        LazyLoadEmoji emoji = c.getEmoji();
        Image img = emoji.getImage(emojiConfig.isAnimationEnabled());
        if (img == null) {
            switch (emojiConfig.getDisplayStrategy()) {
                case SPACE: 
                case BOX_FRAME: 
                case BOX_FILL: {
                    iw = emoji.getWidth();
                    ih = emoji.getHeight();
                    break;
                }
                case UNKNOWN: {
                    return new int[]{this.getCharacterWidth(null, new SpriteCharacterKey(this.config.getUnknownChar()), emojiConfig), 1};
                }
                default: {
                    iw = 0;
                    ih = 1;
                    break;
                }
            }
        } else {
            iw = emoji.getWidth();
            ih = emoji.getHeight();
        }
        float f = eScale = emoji.getType().isBadge() ? (float)emojiConfig.getBadgeScale().intValue() / 100.0f : (float)emojiConfig.getEmojiScale().intValue() / 100.0f;
        if (emoji.getType().isBadge() && emojiConfig.isBadgeScaleToLine() || !emoji.getType().isBadge() && emojiConfig.isEmojiScaleToLine()) {
            float emojiScaleRatio = eScale * (float)this.getLineHeightScaled() / (float)ih;
            h = (float)ih * emojiScaleRatio;
            w = (float)iw * h / (float)ih;
        } else {
            w = eScale * (float)iw;
            h = eScale * (float)ih;
        }
        return new int[]{(int)w, (int)h};
    }

    public int getCharacterWidth(FontMetrics fontMetrics, SpriteCharacterKey c, ConfigEmoji emojiConfig) {
        if (c.isChar()) {
            int baseWidth;
            if (c.isExtended()) {
                if (this.config.isExtendedCharEnabled()) {
                    int baseWidth2 = fontMetrics.charWidth(c.getCodepoint());
                    return (int)((float)baseWidth2 + (float)this.config.getCharSpacing() * this.config.getFontScale());
                }
                baseWidth = this.getCharacterBounds((int)this.config.getUnknownChar()).width;
            } else {
                baseWidth = this.getCharacterBounds((int)c.getCodepoint()).width;
            }
            return (int)((float)(baseWidth + this.config.getCharSpacing()) * this.config.getFontScale());
        }
        int[] eDim = this.getEmojiDimensions(c, emojiConfig);
        int charSpacing = (int)((float)this.config.getCharSpacing() * this.config.getFontScale());
        int extraSpacing = c.getEmoji().getType().isBadge() ? Math.max(charSpacing, (int)(3.0f * this.config.getFontScale())) : charSpacing;
        return eDim[0] + extraSpacing;
    }

    public void calculateCharacterDimensions() {
        this.characterBounds.clear();
        switch (this.config.getFontType()) {
            case FIXED_WIDTH: {
                this.calculateFixedCharacterDimensions();
                break;
            }
            case VARIABLE_WIDTH: {
                this.calculateVariableCharacterDimensions();
                break;
            }
            default: {
                logger.error("Unknown font type: " + (Object)((Object)this.config.getFontType()));
            }
        }
    }

    private void calculateFixedCharacterDimensions() {
        int spriteWidth = this.sprites.getSprite(this.config).getSpriteWidth();
        int spriteHeight = this.sprites.getSprite(this.config).getSpriteHeight();
        int i = 0;
        while (i < this.config.getCharacterKey().length()) {
            char c = this.config.getCharacterKey().charAt(i);
            int index = this.config.getCharacterKey().indexOf(c);
            int gridX = index % this.config.getGridWidth();
            int gridY = index / this.config.getGridWidth();
            Rectangle bounds = new Rectangle();
            bounds.setLocation(gridX * spriteWidth, gridY * spriteHeight);
            bounds.setSize(spriteWidth, spriteHeight);
            this.characterBounds.put(Integer.valueOf(c), bounds);
            ++i;
        }
    }

    private void calculateVariableCharacterDimensions() {
        logger.trace("Calculating character dimensions");
        this.characterBounds.clear();
        Sprite sprite = this.sprites.getSprite(this.config);
        int charWidth = sprite.getSpriteWidth();
        int charHeight = sprite.getSpriteHeight();
        int wholeWidth = sprite.getImage().getWidth();
        int wholeHeight = sprite.getImage().getHeight();
        String key = this.config.getCharacterKey();
        int[] pixelData = new int[wholeWidth * wholeHeight];
        pixelData = sprite.getImage().getRGB(0, 0, wholeWidth, wholeHeight, pixelData, 0, wholeWidth);
        int letterIndex = 0;
        int y = 0;
        while (y < wholeHeight) {
            int x = 0;
            while (x < wholeWidth) {
                char ckey = key.charAt(letterIndex);
                boolean leftEdgeFound = false;
                int leftEdge = 0;
                int rightEdge = 0;
                int localX = 0;
                while (localX < charWidth) {
                    int absoluteX = localX + x;
                    boolean opaquePixelFound = false;
                    int absoluteY = y;
                    while (absoluteY < y + charHeight && !opaquePixelFound) {
                        opaquePixelFound = (pixelData[absoluteX + absoluteY * wholeWidth] >> 24 & 0xFF) > 0;
                        ++absoluteY;
                    }
                    if (opaquePixelFound) {
                        if (!leftEdgeFound) {
                            leftEdge = localX;
                            leftEdgeFound = true;
                        }
                        rightEdge = localX;
                    }
                    ++localX;
                }
                int letterWidth = Math.min(charWidth, ++rightEdge - leftEdge);
                Rectangle bounds = new Rectangle(x + leftEdge, y, letterWidth, charHeight);
                if (!leftEdgeFound) {
                    this.characterBounds.put(Integer.valueOf(ckey), new Rectangle(x + charWidth / 4, y, charWidth / 2, charHeight));
                } else {
                    this.characterBounds.put(Integer.valueOf(ckey), bounds);
                }
                ++letterIndex;
                x += charWidth;
            }
            y += charHeight;
        }
    }

    public Rectangle getCharacterBounds(int c) {
        if (!this.config.getCharacterKey().contains(new String(Character.toChars(c)))) {
            c = this.config.getUnknownChar();
        }
        if (FontType.VARIABLE_WIDTH.equals((Object)this.config.getFontType()) && c == 32) {
            Rectangle spaceBounds = this.characterBounds.get(c);
            spaceBounds.width = (int)((float)this.sprites.getSprite(this.config).getSpriteWidth() * ((float)this.config.getSpaceWidth() / 100.0f));
        }
        return this.characterBounds.get(c);
    }

    public void updateForConfigChange() {
        this.calculateCharacterDimensions();
    }

    public int getLineHeightScaled() {
        return (int)((float)this.getLineHeight() * this.config.getFontScale());
    }

    public int getLineHeight() {
        return this.getFontHeight() + this.config.getLineSpacing();
    }

    public int getFontHeight() {
        return this.sprites.getSprite((ConfigFont)this.config).pixelHeight;
    }

    public int getLineScrollOffset() {
        return this.lineScrollOffset;
    }

    public void setLineScrollOffset(int lineScrollOffset) {
        this.lineScrollOffset = lineScrollOffset;
    }

    public void incrementLineScrollOffset(int delta, int min, int max) {
        int test = this.lineScrollOffset + delta;
        if (test >= min && test < max) {
            this.lineScrollOffset = test;
        } else {
            this.lineScrollOffset = Math.max(this.lineScrollOffset, min);
            this.lineScrollOffset = Math.min(this.lineScrollOffset, max);
        }
    }

    public Dimension getMessageDimensions(Message message, FontMetrics fontMetrics, ConfigMessage messageConfig, ConfigEmoji emojiConfig, EmojiManager emojiManager, int lineWrapLength, boolean lastMessage) {
        return this.drawMessage(null, fontMetrics, message, null, null, messageConfig, emojiConfig, emojiManager, 0, 0, 0, 0, lineWrapLength, false, null, null, lastMessage);
    }

    public Dimension drawMessage(Graphics2D g2d, FontMetrics fontMetrics, Message msg, Color userColor, ConfigColor colorConfig, ConfigMessage messageConfig, ConfigEmoji emojiConfig, EmojiManager emojiManager, int x_init, int y_init, int topLimit, int botLimit, int lineWrapLength, boolean debug, Color debugColor, ImageObserver emojiObserver, boolean lastMessage) {
        if (msg.isJoinType() && !messageConfig.showJoinMessages()) {
            return new Dimension();
        }
        SpriteCharacterKey[] text = msg.getText(emojiManager, messageConfig, emojiConfig);
        int maxCharWidth = 0;
        int c = 0;
        while (c < text.length) {
            maxCharWidth = Math.max(maxCharWidth, this.getCharacterWidth(fontMetrics, text[c], emojiConfig));
            ++c;
        }
        if (maxCharWidth > lineWrapLength) {
            return new Dimension();
        }
        int x = x_init -= this.config.getCharSpacing() / 2;
        int y = y_init;
        int height = this.getLineHeightScaled();
        int maxWidth = 0;
        int width = 0;
        y += this.lineScrollOffset * height;
        boolean forcedBreak = false;
        Color color = Color.WHITE;
        int ci = 0;
        while (ci < text.length) {
            if (colorConfig != null) {
                color = this.getFontColor(msg, ci, messageConfig, colorConfig, userColor);
            }
            if (LINE_BREAKS.contains(String.valueOf(text[ci].getChar()))) {
                x = x_init;
                maxWidth = Math.max(maxWidth, width);
                width = 0;
                y += this.getLineHeightScaled();
                if ((float)ci < msg.getDrawCursor()) {
                    height += this.getLineHeightScaled();
                }
            } else if (WORD_BREAKS.contains(String.valueOf(text[ci].getChar()))) {
                int charWidth = this.getCharacterWidth(fontMetrics, text[ci], emojiConfig);
                x += charWidth;
                width += charWidth;
                forcedBreak = false;
            } else {
                int charWidth;
                int currentWordPixelWidth = 0;
                int nwc = 0;
                while (nwc < text.length - ci && !WORD_BREAKS.contains(String.valueOf(text[ci + nwc].getChar()))) {
                    currentWordPixelWidth += this.getCharacterWidth(fontMetrics, text[ci + nwc], emojiConfig);
                    ++nwc;
                }
                int distanceAlreadyFilled = x - x_init;
                if (distanceAlreadyFilled + currentWordPixelWidth < lineWrapLength) {
                    if (g2d != null && y >= topLimit && y < botLimit && (float)ci < msg.getDrawCursor()) {
                        this.drawCharacter(g2d, fontMetrics, text[ci], x, y, emojiConfig, color, debug, debugColor, emojiObserver);
                    }
                    charWidth = this.getCharacterWidth(fontMetrics, text[ci], emojiConfig);
                    x += charWidth;
                    width += charWidth;
                } else if (!forcedBreak && currentWordPixelWidth < lineWrapLength) {
                    x = x_init;
                    maxWidth = Math.max(maxWidth, width);
                    width = 0;
                    y += this.getLineHeightScaled();
                    if ((float)ci < msg.getDrawCursor()) {
                        height += this.getLineHeightScaled();
                    }
                    if (g2d != null && y >= topLimit && y < botLimit && (float)ci < msg.getDrawCursor()) {
                        this.drawCharacter(g2d, fontMetrics, text[ci], x, y, emojiConfig, color, debug, debugColor, emojiObserver);
                    }
                    charWidth = this.getCharacterWidth(fontMetrics, text[ci], emojiConfig);
                    x += charWidth;
                    width += charWidth;
                } else {
                    forcedBreak = true;
                    distanceAlreadyFilled = x - x_init;
                    int remainderOfTheLine = lineWrapLength - distanceAlreadyFilled;
                    int charWidth2 = this.getCharacterWidth(fontMetrics, text[ci], emojiConfig);
                    if (charWidth2 > remainderOfTheLine) {
                        x = x_init;
                        maxWidth = Math.max(maxWidth, width);
                        width = 0;
                        y += this.getLineHeightScaled();
                        if ((float)ci < msg.getDrawCursor()) {
                            height += this.getLineHeightScaled();
                        }
                    }
                    if (g2d != null && y >= topLimit && y < botLimit && (float)ci < msg.getDrawCursor()) {
                        this.drawCharacter(g2d, fontMetrics, text[ci], x, y, emojiConfig, color, debug, debugColor, emojiObserver);
                    }
                    x += charWidth2;
                    width += charWidth2;
                }
            }
            ++ci;
        }
        if (!lastMessage) {
            height += this.config.getMessageSpacing();
        }
        return new Dimension(maxWidth, height);
    }

    private void drawCharacter(Graphics2D g2d, FontMetrics fontMetrics, SpriteCharacterKey sck, int x, int y, ConfigEmoji emojiConfig, Color color, boolean debug, Color debugColor, ImageObserver emojiObserver) {
        int drawX = x + this.config.getCharSpacing() / 2;
        int drawY = y;
        if (sck.isChar()) {
            boolean drawUnknownChar;
            boolean validNormalChar = !sck.isExtended() && this.characterBounds.containsKey(sck.getCodepoint());
            boolean bl = drawUnknownChar = !validNormalChar && !this.config.isExtendedCharEnabled();
            if (drawUnknownChar) {
                sck = new SpriteCharacterKey(this.config.getUnknownChar());
            }
            if (validNormalChar || drawUnknownChar) {
                Rectangle bounds = this.characterBounds.get(sck.getCodepoint());
                this.sprites.getSprite(this.config).draw(g2d, drawX, drawY, bounds.width, bounds.height, bounds, this.config.getFontScale(), color);
                if (debug) {
                    g2d.setColor(debugColor);
                    g2d.drawRect(drawX, drawY, (int)((float)bounds.width * this.config.getFontScale()), (int)((float)bounds.height * this.config.getFontScale()));
                }
            } else {
                g2d.setColor(color);
                g2d.drawString(sck.toString(), (float)drawX, (float)(drawY + (fontMetrics.getHeight() - fontMetrics.getDescent())) - (float)this.config.getBaselineOffset() * this.config.getFontScale());
            }
        } else {
            int[] eDim = this.getEmojiDimensions(sck, emojiConfig);
            int yOffset = (int)((float)(this.sprites.getSprite(this.config).getSpriteDrawHeight(this.config.getFontScale()) / 2) - (float)this.config.getBaselineOffset() * this.config.getFontScale()) - (sck.isBadge() ? emojiConfig.getBadgeHeightOffset() : 0);
            drawY += yOffset - eDim[1] / 2;
            Image eImage = sck.getEmoji().getImage(emojiConfig.isAnimationEnabled());
            if (eImage == null) {
                g2d.setColor(color);
                switch (emojiConfig.getDisplayStrategy()) {
                    case BOX_FILL: {
                        g2d.fillRect(drawX, drawY, eDim[0] + 1, eDim[1] + 1);
                        break;
                    }
                    case BOX_FRAME: {
                        g2d.drawRect(drawX, drawY, eDim[0], eDim[1]);
                        break;
                    }
                    case UNKNOWN: {
                        this.drawCharacter(g2d, fontMetrics, new SpriteCharacterKey(this.config.getUnknownChar()), x, y, emojiConfig, color, debug, debugColor, emojiObserver);
                        break;
                    }
                }
            } else {
                if (sck.getEmoji().isColoringRequired()) {
                    g2d.setColor(sck.getEmojiBgColor());
                    g2d.fillRect(drawX, drawY, eDim[0] + 1, eDim[1] + 1);
                }
                g2d.drawImage(eImage, drawX, drawY, eDim[0], eDim[1], emojiObserver);
            }
        }
    }

    public Color getFontColor(Message msg, int c, ConfigMessage messageConfig, ConfigColor colorConfig, Color userColor) {
        boolean timestampIndexEncountered;
        boolean bl = timestampIndexEncountered = messageConfig.showTimestamps() && c < msg.getIndexTimestamp(messageConfig);
        if (msg.isJoinType()) {
            if (timestampIndexEncountered) {
                return colorConfig.isColorJoin() && colorConfig.isColorTimestamp() ? colorConfig.getHighlight() : colorConfig.getFgColor();
            }
            return colorConfig.isColorJoin() ? colorConfig.getHighlight() : colorConfig.getFgColor();
        }
        if (timestampIndexEncountered) {
            return colorConfig.isColorTimestamp() ? userColor : colorConfig.getFgColor();
        }
        if (messageConfig.showUsernames() && c >= msg.getIndexUsername(messageConfig)[0] && c < msg.getIndexUsername(messageConfig)[1]) {
            return colorConfig.isColorUsername() ? userColor : colorConfig.getFgColor();
        }
        if (colorConfig.isColorMessage() || MessageType.ACTION.equals((Object)msg.getType())) {
            return userColor;
        }
        return colorConfig.getFgColor();
    }
}

