/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.sprite;

import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import java.awt.Color;

public class SpriteCharacterKey {
    private int codepoint;
    private boolean extended;
    private LazyLoadEmoji emoji;
    private Color emojiBgColorOverride;
    private boolean badge;

    public SpriteCharacterKey(char character) {
        this(character, null, false);
    }

    public SpriteCharacterKey(int codepoint) {
        this(codepoint, null, false);
    }

    public SpriteCharacterKey(LazyLoadEmoji emoji, boolean badge) {
        this(127, emoji, badge);
    }

    private SpriteCharacterKey(int codepoint, LazyLoadEmoji emoji, boolean badge) {
        this.codepoint = codepoint;
        this.extended = !" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f".contains(Character.toString(Character.toChars(this.codepoint)[0]));
        this.emoji = emoji;
        this.badge = badge;
    }

    public char getChar() {
        return Character.toChars(this.codepoint)[0];
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public LazyLoadEmoji getEmoji() {
        return this.emoji;
    }

    public boolean isChar() {
        return this.emoji == null;
    }

    public boolean isEmoji() {
        return !this.isChar() && !this.badge;
    }

    public boolean isBadge() {
        return !this.isChar() & this.badge;
    }

    public String toString() {
        return this.isEmoji() ? "[E]" : new String(Character.toChars(this.codepoint));
    }

    public boolean isExtended() {
        return this.extended;
    }

    public Color getEmojiBgColor() {
        if (this.emojiBgColorOverride != null) {
            return this.emojiBgColorOverride;
        }
        return this.emoji == null ? null : this.emoji.getBgColor();
    }

    public void setEmojiBgColorOverride(Color emojiColorOverride) {
        this.emojiBgColorOverride = emojiColorOverride;
    }
}

