/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.sprite;

import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.sprite.Sprite;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpriteCache {
    private static final Logger logger = Logger.getLogger(SpriteCache.class);
    private Map<String, Sprite> cache = new HashMap<String, Sprite>();

    public SpriteCache(ConfigFont fontConfig) {
        this();
        this.getSprite(fontConfig);
    }

    public SpriteCache() {
        this.cache.put(null, new Sprite());
    }

    public Sprite getSprite(ConfigFont fontConfig) {
        Sprite sprite;
        if (!this.cache.containsKey(fontConfig.getFontFilename())) {
            try {
                sprite = new Sprite(fontConfig.getFontFilename(), fontConfig.getGridWidth(), fontConfig.getGridHeight());
                this.cache.put(fontConfig.getFontFilename(), sprite);
            }
            catch (Exception e) {
                logger.error(e.toString(), e);
                ChatWindow.popup.handleProblem("Unable to load sprite from file " + fontConfig.getFontFilename(), e);
                this.cache.put(fontConfig.getFontFilename(), this.cache.get(null));
            }
        }
        if (this.cache.containsKey(fontConfig.getFontFilename()) && (sprite = this.cache.get(fontConfig.getFontFilename())) != null) {
            sprite.setGridDimensions(fontConfig);
            return sprite;
        }
        logger.error("SpriteCache returning empty default Sprite");
        return this.cache.get(null);
    }
}

