/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.sprite;

import com.glitchcog.fontificator.config.ConfigFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class Sprite {
    private static final Logger logger = Logger.getLogger(Sprite.class);
    private BufferedImage img;
    private Map<Color, BufferedImage> coloredImgs;
    protected int gridWidth;
    protected int gridHeight;
    protected int pixelWidth;
    protected int pixelHeight;
    private ShortLookupTable swapTable;
    private BufferedImageOp swapOp;

    public Sprite() {
        logger.trace("Sprite default construstor");
        this.gridWidth = 8;
        this.pixelWidth = 8;
        this.pixelHeight = 8;
        this.img = new BufferedImage(this.pixelWidth, this.pixelHeight, 2);
        this.coloredImgs = new HashMap<Color, BufferedImage>();
        this.setupSwap();
    }

    public Sprite(String filename, int gridWidth, int gridHeight) throws Exception {
        this(filename);
        logger.trace("Sprite grid specified: (" + gridWidth + "x" + gridHeight + ")");
        this.setGridDimensions(gridWidth, gridHeight);
        this.setupSwap();
        this.addToColorCache(Color.WHITE);
    }

    public Sprite(String fontSpriteFilename) throws IOException {
        logger.trace("Loading sprite from " + fontSpriteFilename);
        this.coloredImgs = new HashMap<Color, BufferedImage>();
        this.setImage(fontSpriteFilename);
        this.setupSwap();
    }

    private void setupSwap() {
        short[][] lookupArray = new short[4][256];
        int i = 0;
        while (i < lookupArray.length) {
            int c = 0;
            while (c < lookupArray[i].length) {
                lookupArray[i][c] = c;
                c = (short)(c + 1);
            }
            ++i;
        }
        this.swapTable = new ShortLookupTable(0, lookupArray);
        this.swapOp = new LookupOp(this.swapTable, null);
    }

    private boolean setImage(String filename) throws IOException {
        logger.trace("Setting image for " + filename);
        if (filename.startsWith("preset://")) {
            String classPathUrlStr = filename.substring("preset://".length());
            URL url = this.getClass().getClassLoader().getResource(classPathUrlStr);
            logger.trace("Sprite URL: " + url);
            this.img = ImageIO.read(url);
        } else {
            File file = new File(filename);
            BufferedImage testImg = ImageIO.read(file);
            if (testImg.getType() != 6) {
                this.img = new BufferedImage(testImg.getWidth(), testImg.getHeight(), 6);
                this.img.getGraphics().drawImage(testImg, 0, 0, null);
                this.img.getGraphics().dispose();
            } else {
                this.img = testImg;
            }
        }
        if (this.img == null) {
            logger.error("Unable to load image " + filename);
            return false;
        }
        return true;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setGridDimensions(ConfigFont config) {
        this.setGridDimensions(config.getGridWidth(), config.getGridHeight());
    }

    private void setGridDimensions(int gridWidth, int gridHeight) {
        this.setGridWidth(gridWidth);
        this.setGridHeight(gridHeight);
    }

    private void setGridWidth(int gridWidth) {
        if (gridWidth < 1) {
            logger.error("Grid width must be at least 1");
            gridWidth = 1;
        }
        this.gridWidth = gridWidth;
        this.pixelWidth = this.img.getWidth(null) / gridWidth;
    }

    public void setGridHeight(int gridHeight) {
        if (gridHeight < 1) {
            logger.error("Grid height must be at least 1");
            gridHeight = 1;
        }
        this.gridHeight = gridHeight;
        this.pixelHeight = this.img.getHeight(null) / gridHeight;
    }

    public int getSpriteWidth() {
        return this.pixelWidth;
    }

    public int getSpriteHeight() {
        return this.pixelHeight;
    }

    public int getSpriteDrawWidth(float scale) {
        return (int)((float)this.pixelWidth * scale);
    }

    public int getSpriteDrawHeight(float scale) {
        return (int)((float)this.pixelHeight * scale);
    }

    private static BufferedImage copyImage(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
    }

    private BufferedImage addToColorCache(Color drawColor) {
        int i = 0;
        while (i < 256) {
            this.swapTable.getTable()[0][i] = (short)((float)i / 255.0f * (float)drawColor.getRed());
            this.swapTable.getTable()[1][i] = (short)((float)i / 255.0f * (float)drawColor.getGreen());
            this.swapTable.getTable()[2][i] = (short)((float)i / 255.0f * (float)drawColor.getBlue());
            i = (short)(i + 1);
        }
        BufferedImage coloredImg = Sprite.copyImage(this.img);
        coloredImg = this.swapOp.filter(this.img, coloredImg);
        this.coloredImgs.put(drawColor, coloredImg);
        return coloredImg;
    }

    public void draw(Graphics2D g2d, int x, int y, int frame, float scale, Color color) {
        int sourceX = frame % this.gridWidth * this.pixelWidth;
        int sourceY = frame / this.gridWidth * this.pixelHeight;
        BufferedImage drawImg = this.coloredImgs.get(color);
        if (drawImg == null) {
            drawImg = this.addToColorCache(color);
            this.coloredImgs.put(color, drawImg);
        }
        g2d.drawImage(drawImg, x, y, x + (int)((float)this.pixelWidth * scale), y + (int)((float)this.pixelHeight * scale), sourceX, sourceY, sourceX + this.pixelWidth, sourceY + this.pixelHeight, null);
    }

    public void draw(Graphics2D g2d, int x, int y, Rectangle source, float scale, Color color) {
        this.draw(g2d, x, y, this.pixelWidth, this.pixelHeight, source, scale, color);
    }

    public void draw(Graphics2D g2d, int x, int y, int w, int h, Rectangle source, float scale, Color color) {
        BufferedImage drawImg = this.coloredImgs.get(color);
        if (drawImg == null) {
            drawImg = this.addToColorCache(color);
            this.coloredImgs.put(color, drawImg);
        }
        g2d.drawImage(drawImg, x, y, x + (int)((float)w * scale), y + (int)((float)h * scale), source.x, source.y, source.x + source.width, source.y + source.height, null);
    }
}

