/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.emoji;

public class EmojiWorkerReport {
    private final String message;
    private final int percentComplete;
    private final boolean error;
    private final boolean canceled;
    private final boolean halted;

    public EmojiWorkerReport(String message, int percentComplete) {
        this(message, percentComplete, false, false, false);
    }

    public EmojiWorkerReport(String message, int percentComplete, boolean error, boolean canceled, boolean halted) {
        this.message = message;
        this.percentComplete = percentComplete;
        this.error = error;
        this.canceled = canceled;
        this.halted = halted;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public String getPercentText() {
        String ps = Integer.toString(this.percentComplete);
        while (ps.length() < 3) {
            ps = " " + ps;
        }
        return String.valueOf(ps) + "%";
    }

    public boolean isComplete() {
        return this.percentComplete == 100 && !this.isError() && !this.isCanceled();
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isHalted() {
        return this.halted;
    }

    public String toString() {
        return "EmojiWorkerReport: " + this.message + " " + this.getPercentText();
    }
}

