/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.emoji;

import com.glitchcog.fontificator.emoji.EmojiJob;
import com.glitchcog.fontificator.emoji.EmojiManager;
import com.glitchcog.fontificator.emoji.EmojiOperation;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import com.glitchcog.fontificator.emoji.TypedEmojiMap;
import com.glitchcog.fontificator.emoji.loader.EmojiApiLoader;
import com.glitchcog.fontificator.emoji.loader.EmojiParser;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.emoji.EmojiLoadProgressPanel;
import com.glitchcog.fontificator.gui.emoji.EmojiWorkerReport;
import com.glitchcog.fontificator.gui.emoji.exception.EmojiCancelException;
import com.glitchcog.fontificator.gui.emoji.exception.EmojiHaltException;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class EmojiWorker
extends SwingWorker<Integer, EmojiWorkerReport> {
    private static final Logger logger = Logger.getLogger(EmojiWorker.class);
    private static final String TWITCH_BADGE_PRIME = "https://static-cdn.jtvnw.net/badges/v1/a1dd5073-19c3-4911-8cb4-c464a7bc1510/1";
    private static final String FFZ_BASE_NO_EMOTES_URL = "https://api.frankerfacez.com/v1/_room/";
    private static final Integer[] TWITCH_EMOTE_IDS_GLOBAL = new Integer[]{27, 15, 25, 21, 19, 22, 18, 29, 28, 17, 16, 26, 24, 20, 33, 30, 45, 38, 40, 44, 34, 31, 41, 42, 39, 36, 32, 37, 46, 69, 47, 50, 70, 66, 51, 48, 67, 49, 52, 68, 65, 71, 88, 72, 169, 91, 166, 74, 87, 167, 73, 170, 92, 86, 168, 90, 171, 361, 357, 354, 243, 881, 244, 358, 355, 245, 359, 360, 356, 973, 1896, 1904, 1900, 1905, 1897, 3632, 1901, 1906, 1902, 3666, 1898, 3412, 1903, 1899, 7427, 3668, 4337, 9804, 9803, 9800, 3792, 4338, 4057, 4339, 9801, 4240, 9802, 5253, 9805, 27679, 9809, 22998, 9806, 27509, 27903, 14706, 20225, 28087, 9807, 9808, 22639, 27602, 28328, 35063, 46881, 30134, 38436, 47005, 30259, 46248, 38586, 46249, 47007, 32035, 44499, 34875, 47008, 56879, 47010, 49106, 54089, 50901, 56880, 47011, 51838, 54090, 47302, 52492, 47420, 55338, 56881, 70433, 62835, 58765, 58127, 62836, 62833, 68856, 58135, 56882, 58136, 56883, 64138, 62834, 72748, 72752, 72753, 72751, 72750, 72749};
    private static final String[] TWITCH_EMOTES_GLOBAL = new String[]{"JKanStyle", "OptimizePrime", "StoneLightning", "TheRinger", "PazPazowitz", "EagleEye", "CougarHunt", "RedCoat", "BionicBunion", "Kappa", "JonCarnage", "PicoMause", "MrDestructoid", "MVGame", "BCWarrior", "SuperVinlin", "GingerPower", "DansGame", "SwiftRage", "PJSalt", "StrawBeary", "BlargNaut", "FreakinStinkin", "KevinTurtle", "Kreygasm", "FPSMarksman", "NoNoSpot", "NinjaTroll", "SSSsss", "PunchTrees", "FunRun", "UleetBackup", "ArsonNoSexy", "SMSkull", "SMOrc", "FrankerZ", "OneHand", "TinyFace", "HassanChop", "BloodTrail", "TheTarFu", "UnSane", "EvilFetus", "DBstyle", "AsianGlow", "BibleThump", "ShazBotstix", "PogChamp", "Jebaited", "OMGScoots", "PMSTwin", "Volcania", "WinWaker", "FuzzyOtterOO", "ItsBoshyTime", "DatSheffy", "TriHard", "BORT", "FUNgineer", "ResidentSleeper", "4Head", "SoonerLater", "OpieOP", "HotPokket", "Poooound", "TooSpicy", "FailFish", "RuleFive", "BrainSlug", "DAESuppy", "WholeWheat", "WTRuck", "ThunBeast", "TF2John", "RalpherZ", "Kippa", "Keepo", "DogFace", "BigBrother", "BatChest", "SoBayed", "PeoplesChamp", "GrammarKing", "UncleNox", "PanicVis", "ANELE", "BrokeBack", "PipeHype", "YouWHY", "RitzMitz", "EleGiggle", "KZskull", "TheThing", "AtIvy", "AtWW", "GasJoker", "KAPOW", "MechaSupes", "NightBat", "shazamicon", "Shazam", "PJHarley", "AtGL", "SriHead", "DatHass", "BabyRage", "panicBasket", "PermaSmug", "BuddhaBar", "RaccAttack", "ShibeZ", "WutFace", "PRChase", "Mau5", "HeyGuys", "AthenaPMS", "NotATK", "mcaT", "TTours", "PraiseIt", "tbBaconBiscuit", "deIlluminati", "deExcite", "HumbleLife", "OSbeaver", "OSdeo", "OSfrog", "OSkomodo", "OSsloth", "OSrob", "OSbury", "CorgiDerp", "TheKing", "ArgieB8", "ShadyLulu", "DOOMGuy", "VaultBoy", "KappaPride", "tbChickenBiscuit", "tbSriracha", "tbSausageBiscuit", "tbSpicy", "tbQuesarito", "CoolCat", "DendiFace", "PuppeyFace", "NotLikeThis", "riPepperonis", "duDudu", "bleedPurple", "twitchRaid", "SeemsGood", "MingLee", "KappaRoss", "PeteZaroll", "PeteZarollTie", "Stormtrooper", "Sullustan", "Ackbar", "ItsATrap"};
    private static final Integer[] TWITCH_EMOTE_IDS_BASIC = new Integer[]{1, 12, 7, 2, 3, 13, 8, 9, 4, 14, 5, 10, 11, 6};
    private static final String[] TWITCH_EMOTES_BASIC = new String[]{"B-?\\)", "\\:-?[z|Z|\\|]", "\\:-?\\)", "\\:-?\\(", "\\:-?(p|P)", "\\;-?(p|P)", "\\<3", "\\;-?\\)", "R-?\\)", "[o|O](_|\\.)[o|O]", "\\:-?D", "\\:-?(o|O)", "\\>\\;\\(", "\\:-?[\\\\/]"};
    private EmojiManager manager;
    private EmojiApiLoader loader;
    private EmojiParser parser;
    private EmojiJob job;
    private boolean terminateWork = false;
    private boolean silentlyTerminateWork = false;
    private EmojiLoadProgressPanel progressPanel;
    private final EmojiWorkerReport initialReport;

    public EmojiWorker(EmojiManager manager, EmojiLoadProgressPanel progressPanel, EmojiJob job, LogBox logBox, EmojiWorkerReport initialReport) {
        this.manager = manager;
        this.progressPanel = progressPanel;
        this.job = job;
        this.initialReport = initialReport;
        logBox.log(initialReport.getMessage());
        this.loader = new EmojiApiLoader();
        this.parser = new EmojiParser(logBox);
    }

    @Override
    protected Integer doInBackground() throws Exception {
        if (this.job.getType() == null || this.job.getOp() == null) {
            return 1;
        }
        try {
            this.terminateWork = false;
            EmojiOperation opType = this.job.getOp();
            EmojiType emojiType = this.job.getType();
            String channel = this.job.getChannel();
            String oauth = this.job.getOauth();
            if (EmojiOperation.LOAD == opType) {
                this.loader.prepLoad(emojiType, channel, oauth);
                String data = this.runLoader(emojiType);
                if (data != null) {
                    this.parser.putJsonEmojiIntoManager(this.manager, emojiType, data);
                }
                if (emojiType == EmojiType.FRANKERFACEZ_BADGE) {
                    this.loader.prepLoad(FFZ_BASE_NO_EMOTES_URL + channel);
                    String ffzRoomJson = this.runLoader(emojiType);
                    this.parser.parseFrankerFaceZModBadge(this.manager, ffzRoomJson);
                }
                if (emojiType == EmojiType.TWITCH_BADGE) {
                    TypedEmojiMap tbMap = this.manager.getEmojiByType(EmojiType.TWITCH_BADGE);
                    tbMap.put("prime", new LazyLoadEmoji("prime", TWITCH_BADGE_PRIME, EmojiType.TWITCH_BADGE));
                }
                Thread.sleep(1L);
            } else if (EmojiOperation.CACHE == opType) {
                LazyLoadEmoji emoji;
                ArrayList ids;
                ArrayList<String> regexes;
                if (emojiType.isTwitchEmote()) {
                    regexes = new ArrayList<String>(TWITCH_EMOTES_BASIC.length + TWITCH_EMOTES_GLOBAL.length);
                    Collections.addAll(regexes, TWITCH_EMOTES_BASIC);
                    Collections.addAll(regexes, TWITCH_EMOTES_GLOBAL);
                    ids = new ArrayList(TWITCH_EMOTE_IDS_BASIC.length + TWITCH_EMOTE_IDS_GLOBAL.length);
                    Collections.addAll(ids, TWITCH_EMOTE_IDS_BASIC);
                    Collections.addAll(ids, TWITCH_EMOTE_IDS_GLOBAL);
                } else if (emojiType.isFrankerFaceZEmote()) {
                    Collection<String> ffzChannelRegexes = this.manager.getEmojiByType(EmojiType.FRANKERFACEZ_CHANNEL).keySet();
                    Collection<String> ffzGlobalRegexes = this.manager.getEmojiByType(EmojiType.FRANKERFACEZ_GLOBAL).keySet();
                    regexes = new ArrayList(ffzChannelRegexes.size() + ffzGlobalRegexes.size());
                    regexes.addAll(ffzChannelRegexes);
                    regexes.addAll(ffzGlobalRegexes);
                    ids = new ArrayList();
                } else if (emojiType.isBetterTtvEmote()) {
                    Collection<String> bttvChannelRegexes = this.manager.getEmojiByType(EmojiType.BETTER_TTV_CHANNEL).keySet();
                    Collection<String> bttvGlobalRegexes = this.manager.getEmojiByType(EmojiType.BETTER_TTV_GLOBAL).keySet();
                    regexes = new ArrayList(bttvChannelRegexes.size() + bttvGlobalRegexes.size());
                    regexes.addAll(bttvChannelRegexes);
                    regexes.addAll(bttvGlobalRegexes);
                    ids = new ArrayList();
                } else {
                    regexes = new ArrayList();
                    ids = new ArrayList();
                }
                this.publish(new EmojiWorkerReport("Caching " + emojiType.getDescription(), 0));
                Thread.sleep(1L);
                int count = 0;
                ArrayList<LazyLoadEmoji> emojiToCache = new ArrayList<LazyLoadEmoji>();
                for (String regex : regexes) {
                    emoji = this.manager.getEmojiWords(emojiType, regex, null);
                    emojiToCache.add(emoji);
                }
                for (Integer id : ids) {
                    emoji = this.manager.getEmojiById(id, null, null);
                    emojiToCache.add(emoji);
                }
                for (LazyLoadEmoji emoji2 : emojiToCache) {
                    if (emoji2 != null) {
                        emoji2.cacheImage();
                    }
                    int percentComplete = (int)(100.0f * (float)(++count) / (float)emojiToCache.size());
                    this.publish(new EmojiWorkerReport("Caching " + emojiType.getDescription(), percentComplete));
                    if (this.terminateWork) {
                        throw new EmojiCancelException();
                    }
                    Thread.sleep(1L);
                }
                this.publish(new EmojiWorkerReport(String.valueOf(emojiType.getDescription()) + " caching complete", 100));
                Thread.sleep(1L);
            }
            return 0;
        }
        catch (EmojiHaltException e) {
            this.publish(new EmojiWorkerReport(String.valueOf(this.job.toString()) + " halted", 100, false, false, true));
            try {
                Thread.sleep(1L);
            }
            catch (Exception sleepException) {
                logger.debug("Couldn't sleep for halt", sleepException);
            }
            throw e;
        }
        catch (EmojiCancelException e) {
            this.publish(new EmojiWorkerReport(String.valueOf(this.job.toString()) + " canceled", 100, false, true, false));
            try {
                Thread.sleep(1L);
            }
            catch (Exception sleepException) {
                logger.debug("Couldn't sleep for cancel", sleepException);
            }
            throw e;
        }
        catch (FileNotFoundException e) {
            this.publish(new EmojiWorkerReport("URL not found trying to " + this.job.toString(), 100, true, false, true));
            Thread.sleep(1L);
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMsg = "Unknown error trying to " + this.job.getOp().getDescription() + " " + this.job.getType().getDescription() + (this.job.getChannel() != null ? " for channel " + this.job.getChannel() : "");
            this.publish(new EmojiWorkerReport(errorMsg, 100, true, false, true));
            Thread.sleep(1L);
            return 3;
        }
    }

    private String runLoader(EmojiType emojiType) throws Exception {
        String data = null;
        if (this.loader.initLoad()) {
            while (!this.loader.isLoadComplete()) {
                int percentComplete = this.loader.loadChunk();
                this.publish(new EmojiWorkerReport("Downloading " + emojiType.getDescription(), percentComplete));
                if (this.terminateWork) {
                    throw new EmojiCancelException();
                }
                if (this.silentlyTerminateWork) {
                    throw new EmojiHaltException();
                }
                Thread.sleep(1L);
            }
            data = this.loader.getLoadedJson();
            this.loader.reset();
            if (this.terminateWork) {
                throw new EmojiCancelException();
            }
            if (this.silentlyTerminateWork) {
                throw new EmojiHaltException();
            }
            this.publish(new EmojiWorkerReport("Parsing " + emojiType.getDescription() + " data...", 0));
        } else {
            logger.debug("EmojiApiLoader run for " + emojiType.getDescription() + " without required call to prepLoad.");
        }
        this.publish(new EmojiWorkerReport(String.valueOf(emojiType.getDescription()) + " loading complete", 100));
        this.loader.reset();
        return data;
    }

    @Override
    protected void process(List<EmojiWorkerReport> reports) {
        if (reports != null && !reports.isEmpty()) {
            EmojiWorkerReport latestReport = reports.get(reports.size() - 1);
            reports.clear();
            this.progressPanel.update(latestReport);
        }
    }

    public void cancel() {
        this.terminateWork = true;
    }

    public void haltCurrentJob() {
        this.silentlyTerminateWork = true;
    }

    public boolean isWorkTerminatedAlready() {
        return this.terminateWork || this.silentlyTerminateWork;
    }

    public EmojiWorkerReport getInitialReport() {
        return this.initialReport;
    }

    public EmojiJob getEmojiJob() {
        return this.job;
    }
}

