/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.emoji;

import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.emoji.EmojiJob;
import com.glitchcog.fontificator.emoji.EmojiOperation;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelEmoji;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.emoji.EmojiWorker;
import com.glitchcog.fontificator.gui.emoji.EmojiWorkerReport;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class EmojiLoadProgressPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(EmojiLoadProgressPanel.class);
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_VALUE_TEXT = "    ";
    private JProgressBar bar;
    private JLabel percentValue;
    private JButton cancelButton;
    private JButton manualButton;
    private JButton resetButton;
    private LogBox emojiLogBox;
    private ChatPanel chat;
    private ConfigEmoji emojiConfig;
    private ConcurrentLinkedQueue<EmojiWorker> workerTaskListLoad;
    private ConcurrentLinkedQueue<EmojiWorker> workerTaskListCache;
    private EmojiWorker currentWorker;
    private final ControlPanelEmoji emojiControlPanel;

    public EmojiLoadProgressPanel(ChatPanel chatPanel, final ControlPanelEmoji emojiControlPanel) {
        this.chat = chatPanel;
        this.emojiControlPanel = emojiControlPanel;
        this.workerTaskListLoad = new ConcurrentLinkedQueue();
        this.workerTaskListCache = new ConcurrentLinkedQueue();
        this.currentWorker = null;
        this.emojiLogBox = new LogBox();
        this.bar = new JProgressBar(0, 0, 100);
        this.percentValue = new JLabel(EMPTY_VALUE_TEXT);
        this.percentValue.setFont(new Font("Monospaced", 0, 12));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel any emoji or badge loading or caching currently running or queued to run");
        this.manualButton = new JButton("Load/Cache");
        this.manualButton.setToolTipText("Manually load and or cache all emoji and badges");
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Reset all work done loading and or caching emoji and badges");
        this.handleButtonEnables();
        ActionListener bal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                if (EmojiLoadProgressPanel.this.cancelButton.equals(source)) {
                    if (EmojiLoadProgressPanel.this.currentWorker != null) {
                        EmojiLoadProgressPanel.this.reset();
                    }
                } else if (EmojiLoadProgressPanel.this.resetButton.equals(source)) {
                    EmojiLoadProgressPanel.this.workerTaskListLoad.clear();
                    EmojiLoadProgressPanel.this.workerTaskListCache.clear();
                    EmojiLoadProgressPanel.this.emojiConfig.resetWorkCompleted();
                    EmojiLoadProgressPanel.this.log("Reset all loaded and or cached emoji");
                    EmojiLoadProgressPanel.this.chat.repaint();
                } else if (EmojiLoadProgressPanel.this.manualButton.equals(source)) {
                    EmojiLoadProgressPanel.this.reset();
                    emojiControlPanel.loadAndRunEmojiWork();
                }
                EmojiLoadProgressPanel.this.handleButtonEnables();
            }
        };
        this.cancelButton.addActionListener(bal);
        this.resetButton.addActionListener(bal);
        this.manualButton.addActionListener(bal);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel workPanel = new JPanel(new GridBagLayout());
        gbc.fill = 1;
        gbc.weightx = 1.0;
        workPanel.add((Component)this.bar, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        workPanel.add((Component)this.percentValue, gbc);
        ++gbc.gridx;
        workPanel.add((Component)this.cancelButton, gbc);
        ++gbc.gridx;
        workPanel.add((Component)this.manualButton, gbc);
        ++gbc.gridx;
        workPanel.add((Component)this.resetButton, gbc);
        gbc = ControlPanelBase.getGbc();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.emojiLogBox, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)workPanel, gbc);
    }

    public synchronized boolean isCurrentlyRunning() {
        return this.currentWorker != null;
    }

    public synchronized void handleButtonEnables() {
        this.cancelButton.setEnabled(this.isCurrentlyRunning());
        this.resetButton.setEnabled(this.emojiConfig != null && this.emojiConfig.isAnyWorkDone());
        int remainingJobs = this.emojiControlPanel.countJobs();
        this.manualButton.setEnabled(remainingJobs > 0 && this.currentWorker == null && this.workerTaskListLoad.isEmpty() && this.workerTaskListCache.isEmpty());
        logger.trace("Cancel: " + this.cancelButton.isEnabled() + " b/c currWork " + (this.currentWorker == null ? "is null" : "is NOT null") + "; Reset: " + this.resetButton.isEnabled() + " b/c " + (this.emojiConfig != null && this.emojiConfig.isAnyWorkDone() ? "some work is done" : "no work has been done") + "; Manual: " + this.manualButton.isEnabled() + " b/c there " + (remainingJobs == 1 ? "is" : "are") + " " + remainingJobs + " job" + (remainingJobs == 1 ? "" : "s") + " left undone and " + (this.currentWorker == null && this.workerTaskListLoad.isEmpty() && this.workerTaskListCache.isEmpty() ? "nothing" : "something") + " is currently running or is queued");
    }

    public void setEmojiConfig(ConfigEmoji emojiConfig) {
        this.emojiConfig = emojiConfig;
    }

    public synchronized void update(EmojiWorkerReport report) {
        if (report.isCanceled()) {
            this.emojiLogBox.log(report.getMessage());
            this.blankAllValues();
            this.reset();
            this.handleButtonEnables();
        } else if (report.isError()) {
            this.emojiLogBox.log(report.getMessage());
            this.blankAllValues();
            if (this.currentWorker != null) {
                this.currentWorker.haltCurrentJob();
            }
            this.currentWorker = null;
            this.initiateNextWork();
        } else {
            this.bar.setValue(report.getPercentComplete());
            this.percentValue.setText(report.getPercentText());
            if (report.isComplete()) {
                this.emojiLogBox.log(report.getMessage());
                if (this.currentWorker != null) {
                    this.emojiConfig.setWorkCompleted(this.currentWorker.getEmojiJob());
                }
                this.initiateNextWork();
            }
        }
        this.repaint();
    }

    private synchronized void reset() {
        this.cancelButton.setEnabled(false);
        this.blankAllValues();
        this.workerTaskListLoad.clear();
        this.workerTaskListCache.clear();
        this.currentWorker = null;
    }

    private synchronized void blankAllValues() {
        this.percentValue.setText(EMPTY_VALUE_TEXT);
        this.bar.setValue(0);
    }

    public synchronized void addWorkToQueue(EmojiWorker emojiWorker) {
        ConcurrentLinkedQueue<EmojiWorker> taskList = this.getTaskList(emojiWorker.getEmojiJob());
        for (EmojiWorker worker : taskList) {
            if (worker.isCancelled() || !worker.getEmojiJob().equals(emojiWorker.getEmojiJob())) continue;
            return;
        }
        taskList.add(emojiWorker);
    }

    public synchronized void initiateWork() {
        ConcurrentLinkedQueue<EmojiWorker> taskList = this.getTaskList();
        if (!taskList.isEmpty()) {
            this.currentWorker = taskList.poll();
            this.setLocation(this.getParent().getLocation().x + (this.getParent().getWidth() - this.getWidth()) / 2, this.getParent().getLocation().y + (this.getParent().getHeight() - this.getHeight()) / 2);
            this.cancelButton.setEnabled(true);
            this.update(this.currentWorker.getInitialReport());
            this.currentWorker.execute();
        }
    }

    private synchronized void initiateNextWork() {
        this.percentValue.setText(EMPTY_VALUE_TEXT);
        ConcurrentLinkedQueue<EmojiWorker> taskList = this.getTaskList();
        this.currentWorker = taskList.poll();
        this.chat.repaint();
        if (this.currentWorker == null) {
            this.reset();
            this.handleButtonEnables();
        } else {
            this.currentWorker.execute();
        }
    }

    public synchronized void removeWorkFromQueue(EmojiJob job) {
        if (this.currentWorker != null && this.jobMatch(job, this.currentWorker)) {
            logger.trace("Canceling " + job.toString());
            this.currentWorker.haltCurrentJob();
        }
        ConcurrentLinkedQueue<EmojiWorker> taskList = this.getTaskList(job);
        for (EmojiWorker worker : taskList) {
            if (!this.jobMatch(job, worker)) continue;
            logger.trace("Canceling " + job.toString());
            worker.haltCurrentJob();
            this.workerTaskListLoad.remove(worker);
        }
    }

    private synchronized ConcurrentLinkedQueue<EmojiWorker> getTaskList(EmojiJob job) {
        return job.getOp() == EmojiOperation.CACHE ? this.workerTaskListCache : this.workerTaskListLoad;
    }

    private synchronized ConcurrentLinkedQueue<EmojiWorker> getTaskList() {
        return this.workerTaskListLoad.isEmpty() ? this.workerTaskListCache : this.workerTaskListLoad;
    }

    private synchronized boolean jobMatch(EmojiJob job, EmojiWorker worker) {
        return worker != null && worker.getEmojiJob() != null && !worker.isDone() && !worker.isCancelled() && worker.getEmojiJob().equals(job);
    }

    public void log(String msg) {
        this.emojiLogBox.log(msg);
    }
}

