/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.config.ConfigCensor;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.component.ListInput;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.messages.MessageCheckList;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MessageCensorPanel
extends ControlPanelBase {
    private static final Logger logger = Logger.getLogger(MessageCensorPanel.class);
    private static final long serialVersionUID = 1L;
    private JCheckBox enableCensorshipBox;
    private JCheckBox purgeOnTwitchBanBox;
    private JCheckBox censorAllUrlsBox;
    private JCheckBox censorFirstPostUrlsBox;
    private JCheckBox censorUnknownCharsBox;
    private LabeledSlider unknownCharSlider;
    private ListInput userWhitelist;
    private ListInput userBlacklist;
    private ListInput bannedWordList;
    private MessageCheckList messageList;
    private ConfigCensor config;
    final String URL_REGEX = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    final Pattern URL_PATTERN = Pattern.compile("(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

    public MessageCensorPanel(FontificatorProperties fProps, ChatWindow chatWindow, ControlWindow ctrlWindow, LogBox logBox) {
        super("Chat Window", fProps, chatWindow, logBox);
    }

    @Override
    protected void build() {
        this.setBorder(new TitledBorder(ControlPanelBase.getBaseBorder(), "Message Censorship Configuration", 2, 2));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        this.enableCensorshipBox = new JCheckBox("Enable message censoring");
        this.purgeOnTwitchBanBox = new JCheckBox("Purge messages on Twitch ban/timeout");
        this.censorAllUrlsBox = new JCheckBox("Censor all messages containing URLs");
        this.censorFirstPostUrlsBox = new JCheckBox("Censor messages containing URLs in a user's initial post");
        this.censorUnknownCharsBox = new JCheckBox("Censor messages containing a specified percentage of extended characters:");
        String minLabel = "> 0";
        this.unknownCharSlider = new LabeledSlider("", "%", 0, 100, Math.max(Math.max(Integer.toString(0).length(), Integer.toString(100).length()), "> 0".length())){
            private static final long serialVersionUID = 1L;

            @Override
            public String getValueString() {
                if (this.getValue() == this.slider.getMinimum()) {
                    return "> 0";
                }
                return super.getValueString();
            }
        };
        ActionListener bl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageCensorPanel.this.updateConfig();
                MessageCensorPanel.this.chat.repaint();
                MessageCensorPanel.this.chat.initMessageRollout();
            }
        };
        this.userWhitelist = new ListInput("User Whitelist", "Exempt from all censorship", this, bl);
        this.userBlacklist = new ListInput("User Blacklist", "Every message censored", this, bl);
        this.bannedWordList = new ListInput("Banned Words", "Containing censors message", this, bl);
        this.enableCensorshipBox.addActionListener(bl);
        this.purgeOnTwitchBanBox.addActionListener(bl);
        this.censorAllUrlsBox.addActionListener(bl);
        this.censorFirstPostUrlsBox.addActionListener(bl);
        this.censorUnknownCharsBox.addActionListener(bl);
        this.unknownCharSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MessageCensorPanel.this.config.setUnknownCharPercentage(MessageCensorPanel.this.unknownCharSlider.getValue());
            }
        });
        this.messageList = new MessageCheckList(this.chat, this);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        this.add((Component)new JLabel("Censorship rules affect the visualization only; they don't influence the visibility of IRC posts."), gbc);
        ++gbc.gridy;
        this.add((Component)this.enableCensorshipBox, gbc);
        ++gbc.gridy;
        this.add((Component)this.purgeOnTwitchBanBox, gbc);
        ++gbc.gridy;
        this.add((Component)this.censorAllUrlsBox, gbc);
        ++gbc.gridy;
        this.add((Component)this.censorFirstPostUrlsBox, gbc);
        ++gbc.gridy;
        JPanel unknownPanel = new JPanel(new GridBagLayout());
        GridBagConstraints uGbc = MessageCensorPanel.getGbc();
        uGbc.anchor = 17;
        uGbc.weightx = 1.0;
        uGbc.fill = 0;
        unknownPanel.add((Component)this.censorUnknownCharsBox, uGbc);
        ++uGbc.gridy;
        uGbc.anchor = 13;
        uGbc.weightx = 1.0;
        uGbc.weighty = 1.0;
        uGbc.fill = 1;
        unknownPanel.add((Component)this.unknownCharSlider, uGbc);
        this.add((Component)unknownPanel, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.33;
        gbc.gridwidth = 1;
        this.add((Component)this.userWhitelist, gbc);
        ++gbc.gridx;
        this.add((Component)this.userBlacklist, gbc);
        ++gbc.gridx;
        this.add((Component)this.bannedWordList, gbc);
        ++gbc.gridx;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.messageList, gbc);
        ++gbc.gridy;
    }

    public void addMessage(Message msg) {
        this.messageList.addMessage(msg);
    }

    public void updateManualTable() {
        this.messageList.revalidateTable();
    }

    public void addBan(String bannedUser) {
        this.userBlacklist.addItem(bannedUser);
        this.recheckCensorship();
    }

    public void removeBan(String bannedUser) {
        this.userBlacklist.removeItem(bannedUser);
        this.recheckCensorship();
    }

    public void purgeMessagesForUser(String username, String reason) {
        if (!this.config.isCensorshipEnabled() || !this.config.isPurgeOnTwitchBan() || username == null) {
            return;
        }
        if (reason == null) {
            reason = "TWITCH PURGE";
        }
        Message[] messageArray = this.chat.getMessages();
        int n = messageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Message msg = messageArray[n2];
            if (msg.getUsername() != null && username.toLowerCase().equals(msg.getUsername().toLowerCase())) {
                msg.setCensoredReason(reason);
                msg.setCensored(true, this.config.isCensorshipEnabled());
                msg.setPurged(true);
            }
            ++n2;
        }
        this.refreshListAndMessages();
    }

    public void undoPurge() {
        Message[] messageArray = this.chat.getMessages();
        int n = messageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Message msg = messageArray[n2];
            msg.setPurged(false);
            msg.resetCensorship(false);
            ++n2;
        }
        this.refreshListAndMessages();
    }

    public void recheckCensorship() {
        this.recheckCensorship(false);
    }

    public void recheckCensorship(boolean overrideManual) {
        Message[] messageArray = this.chat.getMessages();
        int n = messageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Message msg = messageArray[n2];
            msg.resetCensorship(overrideManual);
            this.checkCensor(msg);
            ++n2;
        }
        this.refreshListAndMessages();
    }

    private void refreshListAndMessages() {
        this.messageList.revalidateTable();
        this.chat.initMessageRollout();
        this.chat.repaint();
    }

    public void checkCensor(Message msg) {
        if (msg.isManualCensorship()) {
            return;
        }
        if (this.userWhitelist.contains(msg.getUsername())) {
            msg.setCensoredReason("USER WHITELIST");
            return;
        }
        if (this.userBlacklist.contains(msg.getUsername())) {
            msg.setCensoredReason("USER BLACKLIST");
            msg.setCensored(true, this.chat.isCensorshipEnabled());
            return;
        }
        String banned = this.containsBannedWord(msg.getContent());
        if (banned != null) {
            msg.setCensoredReason("BANNED WORD: \"" + banned + "\"");
            msg.setCensored(true, this.enableCensorshipBox.isSelected());
            return;
        }
        boolean containsUrl = this.URL_PATTERN.matcher(msg.getContent()).find();
        if (containsUrl) {
            if (this.censorAllUrlsBox.isSelected()) {
                msg.setCensored(true, this.enableCensorshipBox.isSelected());
                msg.setCensoredReason("URL");
                return;
            }
            if (msg.getUserPostCount() < 2 && this.censorFirstPostUrlsBox.isSelected()) {
                msg.setCensored(true, this.enableCensorshipBox.isSelected());
                msg.setCensoredReason("1ST POST URL");
                return;
            }
        }
        float percentUnknownChars = 100.0f * this.getPercentUnknownChars(msg.getContent());
        if (this.censorUnknownCharsBox.isSelected() && percentUnknownChars > 0.0f && percentUnknownChars >= (float)this.unknownCharSlider.getValue()) {
            msg.setCensored(true, this.enableCensorshipBox.isSelected());
            msg.setCensoredReason("UNKNOWN CHARACTERS");
            return;
        }
    }

    private String containsBannedWord(String text) {
        String[] words;
        String[] stringArray = words = text.split("[^\\w']+");
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!word.trim().isEmpty() && this.bannedWordList.contains(word)) {
                return word;
            }
            ++n2;
        }
        return null;
    }

    private float getPercentUnknownChars(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        int count = 0;
        int c = 0;
        while (c < text.length()) {
            if (text.charAt(c) < ' ' || text.charAt(c) > '\u007f') {
                ++count;
            }
            ++c;
        }
        return (float)count / (float)text.length();
    }

    private void toggleEnableds() {
        boolean all = this.enableCensorshipBox.isSelected();
        this.purgeOnTwitchBanBox.setEnabled(all);
        this.censorAllUrlsBox.setEnabled(all);
        this.censorFirstPostUrlsBox.setEnabled(all && !this.censorAllUrlsBox.isSelected());
        this.censorUnknownCharsBox.setEnabled(all);
        this.unknownCharSlider.setEnabled(all && this.censorUnknownCharsBox.isSelected());
        this.userWhitelist.setEnabled(all);
        this.userBlacklist.setEnabled(all);
        this.bannedWordList.setEnabled(all);
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getCensorConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.enableCensorshipBox.setSelected(this.config.isCensorshipEnabled());
        this.purgeOnTwitchBanBox.setSelected(this.config.isPurgeOnTwitchBan());
        this.censorAllUrlsBox.setSelected(this.config.isCensorAllUrls());
        this.censorFirstPostUrlsBox.setSelected(this.config.isCensorFirstUrls());
        this.censorUnknownCharsBox.setSelected(this.config.isCensorUnknownChars());
        this.unknownCharSlider.setValue(this.config.getUnknownCharPercentage());
        this.userWhitelist.setList(this.config.getUserWhitelist());
        this.userBlacklist.setList(this.config.getUserBlacklist());
        this.bannedWordList.setList(this.config.getBannedWords());
        this.toggleEnableds();
        this.userWhitelist.revalidate();
        this.userBlacklist.revalidate();
        this.bannedWordList.revalidate();
        this.repaint();
    }

    @Override
    protected LoadConfigReport validateInput() {
        return new LoadConfigReport();
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setCensorshipEnabled(this.enableCensorshipBox.isSelected());
        this.config.setPurgeOnTwitchBan(this.purgeOnTwitchBanBox.isSelected());
        this.config.setCensorAllUrls(this.censorAllUrlsBox.isSelected());
        this.config.setCensorFirstUrls(this.censorFirstPostUrlsBox.isSelected());
        this.config.setCensorUnknownChars(this.censorUnknownCharsBox.isSelected());
        this.config.setUnknownCharPercentage(this.unknownCharSlider.getValue());
        this.config.setUserWhitelist(this.userWhitelist.getList());
        this.config.setUserBlacklist(this.userBlacklist.getList());
        this.config.setBannedWords(this.bannedWordList.getList());
        this.toggleEnableds();
    }

    public void updateConfig() {
        try {
            this.fillConfigFromInput();
            this.fProps.setProperty("censorEnabled", Boolean.toString(this.config.isCensorshipEnabled()));
            this.fProps.setProperty("censorPurgeOnTwitchBan", Boolean.toString(this.config.isPurgeOnTwitchBan()));
            this.fProps.setProperty("censorUrl", Boolean.toString(this.config.isCensorAllUrls()));
            this.fProps.setProperty("censorFirstUrl", Boolean.toString(this.config.isCensorFirstUrls()));
            this.fProps.setProperty("censorUnknownChars", Boolean.toString(this.config.isCensorUnknownChars()));
            this.fProps.setProperty("censorUnknownCharsPercent", Integer.toString(this.config.getUnknownCharPercentage()));
            this.fProps.setProperty("censorWhitelist", this.config.getUserWhiteListString());
            this.fProps.setProperty("censorBlacklist", this.config.getUserBlackListString());
            this.fProps.setProperty("censorBannedWords", this.config.getBannedWordsString());
        }
        catch (Exception e) {
            logger.error("Unable to update config from censorship UI input", e);
        }
    }
}

