/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogBox
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTextArea output = new JTextArea();
    private String authCode = null;

    public LogBox() {
        super(22, 31);
        this.output.setFont(new Font("Monospaced", 0, 12));
        this.output.setWrapStyleWord(true);
        this.output.setLineWrap(true);
        this.output.setEditable(false);
        this.output.setBackground(this.getBackground());
        super.setViewportView(this.output);
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void log(LoadConfigReport report) {
        for (String msg : report.getMessages()) {
            this.log(msg);
        }
    }

    public void log(String line) {
        if (this.authCode != null && line.contains(this.authCode)) {
            String blocks = "";
            int i = 0;
            while (i < this.authCode.length()) {
                blocks = String.valueOf(blocks) + "*";
                ++i;
            }
            line = line.replaceAll(this.authCode, blocks);
        }
        if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        this.output.append(String.valueOf(this.output.getText().isEmpty() ? "" : "\n") + line);
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    public void clear() {
        this.output.setText("");
    }
}

