/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.bot.MessageType;
import com.glitchcog.fontificator.config.ConfigColor;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.config.MessageCasing;
import com.glitchcog.fontificator.config.UsernameCaseResolutionType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.component.ColorButton;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.CollagePanel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelFont;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownFont;
import com.glitchcog.fontificator.sprite.SpriteCharacterKey;
import com.glitchcog.fontificator.sprite.SpriteFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;

public class ExamplePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CollagePanel.class);
    private static final String[] PANGRAMS = new String[]{"Pack my box with five dozen liquor jugs.", "Jackdaws love my big sphinx of quartz.", "We quickly seized the black axle and just saved it from going past him.", "Six big juicy steaks sizzled in a pan as five workmen left the quarry.", "While making deep excavations we found some quaint bronze jewelry.", "Jaded zombies acted quaintly but kept driving their oxen forward.", "A mad boxer shot a quick, gloved jab to the jaw of his dizzy opponent.", "The job requires extra pluck and zeal from every young wage earner.", "A quart jar of oil mixed with zinc oxide makes a very bright paint.", "Whenever the black fox jumped the squirrel gazed suspiciously.", "We promptly judged antique ivory buckles for the next prize.", "How razorback-jumping frogs can level six piqued gymnasts!", "Crazy Fredericka bought many very exquisite opal jewels.", "Sixty zippers were quickly picked from the woven jute bag.", "Amazingly few discotheques provide jukeboxes.", "Heavy boxes perform quick waltzes and jigs.", "Jinxed wizards pluck ivy from the big quilt.", "Big Fuji waves pitch enzymed kex liquor.", "The quick brown fox jumps over a lazy dog.", "Pack my box with five dozen liquor jugs.", "Jackdaws love my big sphinx of quartz.", "The five boxing wizards jump quickly.", "How quickly daft jumping zebras vex.", "Quick zephyrs blow, vexing daft Jim.", "Sphinx of black quartz, judge my vow.", "Waltz, nymph, for quick jigs vex Bud.", "How vexingly quick daft zebras jump!", "Bright vixens jump; dozy fowl quack."};
    private JTextField lineFormatInput;
    private ColorButton fontColorButton;
    private ColorButton bgColorButton;
    private static final String TEXT_FONTNAME = "[FONTNAME]";
    private static final String TEXT_PANGRAM = "[PANGRAM]";
    private static final String TEXT_ASCII = "[ASCII]";

    public ExamplePanel(ControlPanelBase basePanel) {
        this.build(basePanel);
    }

    private void build(ControlPanelBase basePanel) {
        this.fontColorButton = new ColorButton("Font Tint", Color.WHITE, "Color to tint the font in the example image", basePanel);
        this.bgColorButton = new ColorButton("Backgroud", Color.DARK_GRAY.darker(), "Color to make the background", basePanel);
        this.lineFormatInput = new JTextField("[FONTNAME] [PANGRAM] [ASCII]");
        JButton saveExample = new JButton("Generate/Save Example");
        saveExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExamplePanel.this.generateExampleImage();
            }
        });
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.fontColorButton, gbc);
        ++gbc.gridx;
        this.add((Component)this.bgColorButton, gbc);
        gbc.fill = 2;
        gbc.weightx = 0.9;
        ++gbc.gridx;
        this.add((Component)this.lineFormatInput, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.1;
        ++gbc.gridx;
        this.add((Component)saveExample, gbc);
    }

    private static Message getExampleMessage(String fontFilename, String format) {
        String messageText = format;
        messageText = messageText.replaceAll(Pattern.quote(TEXT_FONTNAME), Matcher.quoteReplacement(ControlPanelFont.getFontGameName(fontFilename)));
        messageText = messageText.replaceAll(Pattern.quote(TEXT_PANGRAM), Matcher.quoteReplacement(PANGRAMS[Math.abs(fontFilename.hashCode()) % PANGRAMS.length]));
        messageText = messageText.replaceAll(Pattern.quote(TEXT_ASCII), Matcher.quoteReplacement(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f"));
        return new Message(MessageType.MANUAL, "", messageText, null);
    }

    private void generateExampleImage() {
        Message exampleMsg;
        SpriteFont font;
        Properties emptyProps = new Properties();
        LoadConfigReport ignoreReport = new LoadConfigReport();
        ConfigFont fontConfig = new ConfigFont();
        fontConfig.load(emptyProps, ignoreReport);
        fontConfig.setBorderFilename("preset://borders/dw3_border.png");
        fontConfig.setFontFilename("preset://fonts/dw3_font.png");
        fontConfig.setFontType(FontType.FIXED_WIDTH);
        fontConfig.setUnknownChar('\u007f');
        fontConfig.setExtendedCharEnabled(false);
        fontConfig.setCharacterKey(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
        fontConfig.setGridWidth(8);
        fontConfig.setGridHeight(12);
        fontConfig.setFontScale(1.0f);
        fontConfig.setBorderScale(0.0f);
        fontConfig.setBorderInsetX(0);
        fontConfig.setBorderInsetY(0);
        fontConfig.setSpaceWidth(25);
        fontConfig.setBaselineOffset(0);
        int heightOffset = 6;
        fontConfig.setLineSpacing(12);
        fontConfig.setCharSpacing(0);
        ConfigColor colorConfig = new ConfigColor();
        colorConfig.load(emptyProps, ignoreReport);
        colorConfig.setBgColor(Color.WHITE);
        colorConfig.setFgColor(Color.WHITE);
        colorConfig.setBorderColor(Color.WHITE);
        colorConfig.setHighlight(Color.GREEN);
        colorConfig.setChromaColor(Color.GREEN);
        colorConfig.setColorUsername(false);
        colorConfig.setColorTimestamp(false);
        colorConfig.setColorMessage(false);
        colorConfig.setColorJoin(false);
        colorConfig.setUseTwitchColors(true);
        ConfigMessage messageConfig = new ConfigMessage();
        messageConfig.load(emptyProps, ignoreReport);
        messageConfig.setJoinMessages(false);
        messageConfig.setShowUsernames(false);
        messageConfig.setShowTimestamps(false);
        messageConfig.setTimeFormat("[HH:mm:ss]");
        messageConfig.setQueueSize(Integer.MAX_VALUE);
        messageConfig.setMessageSpeed(Integer.MAX_VALUE, null);
        messageConfig.setExpirationTime(Integer.MAX_VALUE, null);
        messageConfig.setHideEmptyBorder(false);
        messageConfig.setHideEmptyBackground(false);
        messageConfig.setCaseResolutionType(UsernameCaseResolutionType.NONE);
        messageConfig.setSpecifyCaseAllowed(false);
        messageConfig.setMessageCasing(MessageCasing.MIXED_CASE);
        ConfigEmoji emojiConfig = new ConfigEmoji();
        emojiConfig.load(emptyProps, ignoreReport);
        emojiConfig.setEmojiEnabled(false);
        List<DropdownFont> allFonts = ControlPanelFont.getAllFonts();
        int y = 0;
        int xOffset = 5;
        int height = 0;
        int width = 0;
        for (DropdownFont ddFont : allFonts) {
            fontConfig.setFontFilename(ddFont.getFontFilename());
            fontConfig.setFontType(ddFont.getDefaultType());
            fontConfig.setCharSpacing(ddFont.getDefaultType() == FontType.FIXED_WIDTH ? 0 : 1);
            font = new SpriteFont(fontConfig);
            font.updateForConfigChange();
            exampleMsg = ExamplePanel.getExampleMessage(ddFont.getFontFilename(), this.lineFormatInput.getText());
            SpriteCharacterKey[] text = exampleMsg.getText(null, messageConfig, emojiConfig);
            height += font.getLineHeightScaled();
            int msgWidth = 10;
            int c = 0;
            while (c < text.length) {
                msgWidth += font.getCharacterWidth(null, text[c], emojiConfig);
                ++c;
            }
            width = Math.max(width, msgWidth);
        }
        BufferedImage exampleImage = new BufferedImage(width, height, 1);
        Graphics2D exampleGraphics = (Graphics2D)exampleImage.getGraphics();
        for (DropdownFont ddFont : allFonts) {
            fontConfig.setFontFilename(ddFont.getFontFilename());
            fontConfig.setFontType(ddFont.getDefaultType());
            fontConfig.setCharSpacing(ddFont.getDefaultType() == FontType.FIXED_WIDTH ? 0 : 1);
            font = new SpriteFont(fontConfig);
            font.updateForConfigChange();
            exampleMsg = ExamplePanel.getExampleMessage(ddFont.getFontFilename(), this.lineFormatInput.getText());
            exampleMsg.setCompletelyDrawn();
            exampleGraphics.setColor(this.bgColorButton.getColor());
            int heightScaled = font.getLineHeightScaled();
            exampleGraphics.fillRect(0, y, width, y + heightScaled);
            colorConfig.setFgColor(this.fontColorButton.getColor());
            font.drawMessage(exampleGraphics, exampleGraphics.getFontMetrics(), exampleMsg, this.fontColorButton.getColor(), colorConfig, messageConfig, emojiConfig, null, 5, (int)((float)y + 6.0f * fontConfig.getFontScale()), 0, Integer.MAX_VALUE, Integer.MAX_VALUE, false, null, null, true);
            y += heightScaled;
        }
        JFileChooser exampleImageChooser = new JFileChooser();
        FileNameExtensionFilter pngFileFilter = new FileNameExtensionFilter("PNG Image (*.png)", "png");
        exampleImageChooser.setFileFilter(pngFileFilter);
        File saveFile = ControlWindow.getTargetSaveFile(exampleImageChooser, "png");
        if (saveFile != null) {
            try {
                ImageIO.write((RenderedImage)exampleImage, "png", saveFile);
            }
            catch (Exception e) {
                logger.error("Unable to save example image", e);
            }
        }
    }
}

