/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.ChatViewerBot;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelChat;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelColor;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelDebug;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelEmoji;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelFont;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelIrc;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelMessage;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.controls.panel.MessageCensorPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class ControlTabs
extends JTabbedPane {
    private static final Logger logger = Logger.getLogger(ControlTabs.class);
    private static final long serialVersionUID = 1L;
    private ChatViewerBot bot;
    private FontificatorProperties fProps;
    private ControlPanelBase[] subpanels;
    private ControlPanelIrc ircPanel;
    private ControlPanelChat chatPanel;
    private ControlPanelFont fontPanel;
    private ControlPanelColor colorPanel;
    private ControlPanelMessage messagePanel;
    private ControlPanelEmoji emojiPanel;
    private ControlPanelDebug debugPanel;
    private MessageCensorPanel censorPanel;
    private LogBox logBox;

    public ControlTabs(FontificatorProperties fProps, ChatViewerBot bot, MessageCensorPanel censorPanel, LogBox logBox) {
        super(1, 1);
        this.fProps = fProps;
        this.bot = bot;
        this.censorPanel = censorPanel;
        this.logBox = logBox;
    }

    public void build(ChatWindow chatWindow, ControlWindow ctrlWindow) {
        logger.trace("Building ControlMainPanel");
        this.emojiPanel = new ControlPanelEmoji(this.fProps, chatWindow, this.bot, this.logBox);
        this.ircPanel = new ControlPanelIrc(this.fProps, chatWindow, this.emojiPanel, this.bot, this.logBox);
        this.logBox.setAuthCode(this.fProps.getIrcConfig().getAuthorization());
        this.chatPanel = new ControlPanelChat(this.fProps, chatWindow, ctrlWindow, this.logBox);
        this.colorPanel = new ControlPanelColor(this.fProps, chatWindow, this.logBox);
        this.fontPanel = new ControlPanelFont(this.fProps, chatWindow, this.logBox, this.colorPanel);
        this.messagePanel = new ControlPanelMessage(this.fProps, chatWindow, this.bot, this.logBox);
        this.debugPanel = new ControlPanelDebug(this.fProps, chatWindow, ctrlWindow);
        this.subpanels = new ControlPanelBase[6];
        this.subpanels[0] = this.ircPanel;
        this.subpanels[1] = this.chatPanel;
        this.subpanels[2] = this.fontPanel;
        this.subpanels[3] = this.messagePanel;
        this.subpanels[4] = this.colorPanel;
        this.subpanels[5] = this.emojiPanel;
        int i = 0;
        while (i < this.subpanels.length) {
            this.addControlTab(this.subpanels[i]);
            ++i;
        }
    }

    public void refreshUiFromConfig(FontificatorProperties fProps) {
        int i = 0;
        while (i < this.subpanels.length) {
            this.subpanels[i].fillInputFromConfig();
            ++i;
        }
        this.censorPanel.fillInputFromConfig();
    }

    public boolean refreshConfigFromUi() {
        LoadConfigReport report = new LoadConfigReport();
        int i = 0;
        while (i < this.subpanels.length) {
            report.addFromReport(this.subpanels[i].validateInput());
            ++i;
        }
        if (report.isErrorFree()) {
            i = 0;
            while (i < this.subpanels.length) {
                try {
                    this.subpanels[i].fillConfigFromInput();
                }
                catch (Exception e) {
                    report.addError("Excepton thrown trying to interpret input on the " + this.subpanels[i].getLabel() + " tab", LoadConfigErrorType.UNKNOWN_ERROR);
                }
                ++i;
            }
        }
        if (!report.isErrorFree()) {
            ChatWindow.popup.handleProblem(report);
        }
        return report.isErrorFree();
    }

    public void setAlwaysOnTopConfig(boolean alwaysOnTop) {
        this.chatPanel.setAlwaysOnTop(alwaysOnTop);
    }

    public void setRememberChatWindowPosition(boolean rememberPosition) {
        this.chatPanel.setRememberPosition(rememberPosition);
    }

    public void setChatWindowPosition() {
        this.chatPanel.setRememberedPosition();
    }

    public void setAntiAlias(boolean antiAlias) {
        this.chatPanel.setAntiAlias(antiAlias);
    }

    public void toggleDebugTab() {
        int debugTabIndex = this.indexOfComponent(this.debugPanel);
        if (debugTabIndex < 0) {
            this.addControlTab(this.debugPanel);
            this.debugPanel.setDebugging(true);
        } else {
            this.removeTabAt(debugTabIndex);
            this.debugPanel.setDebugging(false);
        }
    }

    private void addControlTab(ControlPanelBase cpTab) {
        this.addTab(cpTab.getLabel(), cpTab);
    }

    public ControlPanelDebug getDebugTab() {
        return this.debugPanel;
    }
}

