/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.ChatViewerBot;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.MessageCasing;
import com.glitchcog.fontificator.config.UsernameCaseResolutionType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledInput;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ControlPanelMessage
extends ControlPanelBase {
    private static final long serialVersionUID = 1L;
    private JCheckBox usernamesBox;
    private JCheckBox timestampsBox;
    private LabeledInput usernameFormatInput;
    private LabeledInput contentBreakerInput;
    private LabeledInput timeFormatInput;
    private JButton usernameFormatUpdateButton;
    private JButton formatRestButton;
    private JButton contentBreakerUpdateButton;
    private JButton timeFormatUpdateButton;
    private JCheckBox joinMessagesBox;
    private LabeledSlider queueSizeSlider;
    private LabeledSlider messageSpeedSlider;
    private LabeledSlider expirationTimeSlider;
    private JCheckBox hideEmptyBorder;
    private JCheckBox hideEmptyBackground;
    private ConfigMessage config;
    private JComboBox<UsernameCaseResolutionType> caseTypeDropdown;
    private JCheckBox specifyCaseBox;
    private JComboBox<MessageCasing> messageCasingDropdown;

    public ControlPanelMessage(FontificatorProperties fProps, ChatWindow chatWindow, ChatViewerBot bot, LogBox logBox) {
        super("Message", fProps, chatWindow, logBox);
        bot.setMessageConfig(this.config);
    }

    @Override
    protected void build() {
        this.usernamesBox = new JCheckBox("Show Usernames");
        this.joinMessagesBox = new JCheckBox("Show Joins");
        this.timestampsBox = new JCheckBox("Show Timestamps");
        this.usernameFormatInput = new LabeledInput(null, 9);
        this.contentBreakerInput = new LabeledInput(null, 9);
        this.timeFormatInput = new LabeledInput(null, 9);
        this.usernameFormatUpdateButton = new JButton("Update Username Format");
        this.formatRestButton = new JButton("Reset");
        this.contentBreakerUpdateButton = new JButton("Update Content Breaker Format");
        this.timeFormatUpdateButton = new JButton("Update Time Format");
        this.queueSizeSlider = new LabeledSlider("Message Queue Size", "messages", 1, 5000);
        this.formatRestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMessage.this.usernameFormatInput.setText("%user%");
                ControlPanelMessage.this.contentBreakerInput.setText(": ");
                ControlPanelMessage.this.toggleEnableds();
            }
        });
        String maxSpeedLabel = "MAX";
        this.messageSpeedSlider = new LabeledSlider("Message Speed", "char/sec", 1, 121, "MAX".length()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getValueString() {
                if (this.getValue() == this.slider.getMaximum()) {
                    return "MAX";
                }
                return super.getValueString();
            }
        };
        String minExpirationLabel = "NEVER";
        this.expirationTimeSlider = new LabeledSlider("Hide Messages After ", "sec", 0, 720, "NEVER".length()){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getUnitLabelStr() {
                if (this.getValue() == this.slider.getMinimum()) {
                    return this.padValue("", super.getUnitLabelStr().length());
                }
                return super.getUnitLabelStr();
            }

            @Override
            public String getValueString() {
                if (this.getValue() == this.slider.getMinimum()) {
                    return "NEVER";
                }
                return super.getValueString();
            }
        };
        JLabel hideLabel = new JLabel("When No Messages Are Displayed: ");
        this.hideEmptyBorder = new JCheckBox("Hide Border");
        this.hideEmptyBackground = new JCheckBox("Hide Background");
        this.caseTypeDropdown = new JComboBox<UsernameCaseResolutionType>(UsernameCaseResolutionType.values());
        this.specifyCaseBox = new JCheckBox("Permit users to specify their own username case in posts");
        this.messageCasingDropdown = new JComboBox<MessageCasing>(MessageCasing.values());
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ControlPanelMessage.this.toggleEnableds();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ControlPanelMessage.this.toggleEnableds();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ControlPanelMessage.this.toggleEnableds();
            }
        };
        this.usernameFormatInput.addDocumentListener(docListener);
        this.timeFormatInput.addDocumentListener(docListener);
        this.contentBreakerInput.addDocumentListener(docListener);
        this.caseTypeDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsernameCaseResolutionType type = (UsernameCaseResolutionType)((Object)ControlPanelMessage.this.caseTypeDropdown.getSelectedItem());
                boolean changed = ControlPanelMessage.this.config.getCaseResolutionType() != type;
                ControlPanelMessage.this.config.setCaseResolutionType(type);
                if (changed) {
                    ControlPanelMessage.this.chatWindow.clearUsernameCases();
                }
            }
        });
        this.messageCasingDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMessage.this.config.setMessageCasing((MessageCasing)((Object)ControlPanelMessage.this.messageCasingDropdown.getSelectedItem()));
                ControlPanelMessage.this.chat.repaint();
            }
        });
        ActionListener boxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (ControlPanelMessage.this.usernamesBox.equals(source)) {
                    ControlPanelMessage.this.config.setShowUsernames(source.isSelected());
                    ControlPanelMessage.this.toggleEnableds();
                } else if (ControlPanelMessage.this.joinMessagesBox.equals(source)) {
                    ControlPanelMessage.this.config.setJoinMessages(source.isSelected());
                } else if (ControlPanelMessage.this.timestampsBox.equals(source)) {
                    ControlPanelMessage.this.config.setShowTimestamps(source.isSelected());
                    ControlPanelMessage.this.toggleEnableds();
                } else if (ControlPanelMessage.this.specifyCaseBox.equals(source)) {
                    ControlPanelMessage.this.config.setSpecifyCaseAllowed(ControlPanelMessage.this.specifyCaseBox.isSelected());
                    ControlPanelMessage.this.chatWindow.clearUsernameCases();
                } else if (ControlPanelMessage.this.hideEmptyBorder.equals(source)) {
                    ControlPanelMessage.this.config.setHideEmptyBorder(ControlPanelMessage.this.hideEmptyBorder.isSelected());
                } else if (ControlPanelMessage.this.hideEmptyBackground.equals(source)) {
                    ControlPanelMessage.this.config.setHideEmptyBackground(ControlPanelMessage.this.hideEmptyBackground.isSelected());
                }
                ControlPanelMessage.this.chat.repaint();
            }
        };
        this.usernamesBox.addActionListener(boxListener);
        this.joinMessagesBox.addActionListener(boxListener);
        this.timestampsBox.addActionListener(boxListener);
        this.specifyCaseBox.addActionListener(boxListener);
        this.hideEmptyBorder.addActionListener(boxListener);
        this.hideEmptyBackground.addActionListener(boxListener);
        ActionListener updateButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ControlPanelMessage.this.timeFormatUpdateButton) {
                    LoadConfigReport report = new LoadConfigReport();
                    ControlPanelMessage.this.config.validateTimeFormat(report, ControlPanelMessage.this.timeFormatInput.getText());
                    if (report.isErrorFree()) {
                        ControlPanelMessage.this.config.setTimeFormat(ControlPanelMessage.this.timeFormatInput.getText());
                        ControlPanelMessage.this.toggleEnableds();
                        ControlPanelMessage.this.chat.repaint();
                    } else {
                        ChatWindow.popup.handleProblem(report);
                    }
                } else if (e.getSource() == ControlPanelMessage.this.usernameFormatUpdateButton) {
                    ControlPanelMessage.this.config.setUsernameFormat(ControlPanelMessage.this.usernameFormatInput.getText());
                    ControlPanelMessage.this.toggleEnableds();
                    ControlPanelMessage.this.chat.repaint();
                } else if (e.getSource() == ControlPanelMessage.this.contentBreakerUpdateButton) {
                    ControlPanelMessage.this.config.setContentBreaker(ControlPanelMessage.this.contentBreakerInput.getText());
                    ControlPanelMessage.this.toggleEnableds();
                    ControlPanelMessage.this.chat.repaint();
                }
            }
        };
        this.usernameFormatUpdateButton.addActionListener(updateButtonListener);
        this.timeFormatUpdateButton.addActionListener(updateButtonListener);
        this.contentBreakerUpdateButton.addActionListener(updateButtonListener);
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    if (ControlPanelMessage.this.queueSizeSlider.getSlider().equals(source)) {
                        ControlPanelMessage.this.config.setQueueSize(ControlPanelMessage.this.queueSizeSlider.getValue());
                    } else if (ControlPanelMessage.this.messageSpeedSlider.getSlider().equals(source)) {
                        ControlPanelMessage.this.config.setMessageSpeed(ControlPanelMessage.this.messageSpeedSlider.getValue(), ControlPanelMessage.this.chat.getMessageProgressor());
                    } else if (ControlPanelMessage.this.expirationTimeSlider.getSlider().equals(source)) {
                        ControlPanelMessage.this.config.setExpirationTime(ControlPanelMessage.this.expirationTimeSlider.getValue(), ControlPanelMessage.this.chat.getMessageExpirer());
                        ControlPanelMessage.this.chat.repaint();
                    }
                }
            }
        };
        this.messageSpeedSlider.addChangeListener(cl);
        this.expirationTimeSlider.addChangeListener(cl);
        this.queueSizeSlider.addChangeListener(cl);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 11;
        this.gbc.fill = 0;
        JPanel topOptions = new JPanel(new GridBagLayout());
        topOptions.setBorder(new TitledBorder(this.baseBorder, "Message Format Options", 2, 2));
        JPanel optionsA = new JPanel(new GridBagLayout());
        JPanel optionsB = new JPanel(new GridBagLayout());
        GridBagConstraints tfGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, DEFAULT_INSETS, 0, 0);
        JPanel formatPanel = new JPanel(new GridBagLayout());
        formatPanel.add((Component)this.usernameFormatInput, tfGbc);
        ++tfGbc.gridx;
        formatPanel.add((Component)this.usernameFormatUpdateButton, tfGbc);
        ++tfGbc.gridx;
        formatPanel.add((Component)this.formatRestButton, tfGbc);
        tfGbc.gridx = 0;
        tfGbc.gridwidth = 2;
        ++tfGbc.gridy;
        tfGbc.gridx = 0;
        formatPanel.add((Component)this.contentBreakerInput, tfGbc);
        ++tfGbc.gridx;
        formatPanel.add((Component)this.contentBreakerUpdateButton, tfGbc);
        ++tfGbc.gridy;
        tfGbc.gridx = 0;
        formatPanel.add((Component)this.timeFormatInput, tfGbc);
        ++tfGbc.gridx;
        formatPanel.add((Component)this.timeFormatUpdateButton, tfGbc);
        GridBagConstraints aGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, DEFAULT_INSETS, 0, 0);
        optionsA.add((Component)this.usernamesBox, aGbc);
        ++aGbc.gridy;
        aGbc.anchor = 17;
        optionsA.add((Component)this.timestampsBox, aGbc);
        ++aGbc.gridy;
        optionsA.add((Component)this.joinMessagesBox, aGbc);
        aGbc.gridy = 0;
        ++aGbc.gridx;
        aGbc.gridheight = 3;
        optionsA.add((Component)formatPanel, aGbc);
        GridBagConstraints bGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, DEFAULT_INSETS, 0, 0);
        bGbc.gridwidth = 3;
        bGbc.fill = 2;
        optionsB.add((Component)this.queueSizeSlider, bGbc);
        ++bGbc.gridy;
        optionsB.add((Component)this.messageSpeedSlider, bGbc);
        ++bGbc.gridy;
        optionsB.add((Component)this.expirationTimeSlider, bGbc);
        ++bGbc.gridy;
        bGbc.fill = 0;
        bGbc.weightx = 0.333;
        bGbc.gridwidth = 1;
        bGbc.anchor = 13;
        optionsB.add((Component)hideLabel, bGbc);
        ++bGbc.gridx;
        bGbc.anchor = 10;
        optionsB.add((Component)this.hideEmptyBorder, bGbc);
        ++bGbc.gridx;
        bGbc.anchor = 17;
        optionsB.add((Component)this.hideEmptyBackground, bGbc);
        bGbc.gridx = 0;
        bGbc.gridwidth = 3;
        ++bGbc.gridy;
        bGbc.anchor = 10;
        bGbc.weightx = 1.0;
        GridBagConstraints topOpGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, DEFAULT_INSETS, 0, 0);
        topOpGbc.anchor = 15;
        topOptions.add((Component)optionsA, topOpGbc);
        ++topOpGbc.gridy;
        topOpGbc.anchor = 11;
        topOptions.add((Component)optionsB, topOpGbc);
        ++topOpGbc.gridy;
        this.gbc.anchor = 10;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.add((Component)topOptions, this.gbc);
        ++this.gbc.gridy;
        JPanel usernameOptions = new JPanel(new GridLayout(3, 1));
        usernameOptions.setBorder(new TitledBorder(this.baseBorder, "Username Options", 2, 2));
        usernameOptions.add(new JLabel("Default Method for Handling Username Casing"));
        usernameOptions.add(this.caseTypeDropdown);
        usernameOptions.add(this.specifyCaseBox);
        JPanel casingOptions = new JPanel();
        casingOptions.setBorder(new TitledBorder(this.baseBorder, "Message Casing Options", 2, 2));
        casingOptions.add(new JLabel("Force uppercase or lowercase: "));
        casingOptions.add(this.messageCasingDropdown);
        this.add((Component)usernameOptions, this.gbc);
        ++this.gbc.gridy;
        this.add((Component)casingOptions, this.gbc);
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        this.gbc.anchor = 15;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.add((Component)new JPanel(), this.gbc);
        ++this.gbc.gridy;
    }

    private void toggleEnableds() {
        this.usernameFormatInput.setEnabled(this.config.showUsernames());
        this.timeFormatInput.setEnabled(this.config.showTimestamps());
        boolean ufModified = false;
        boolean tfModified = false;
        boolean cbModified = false;
        try {
            tfModified = !this.timeFormatInput.getText().equals(this.config.getTimeFormat());
            ufModified = !this.usernameFormatInput.getText().equals(this.config.getUsernameFormat());
            cbModified = !this.contentBreakerInput.getText().equals(this.config.getContentBreaker());
            SimpleDateFormat df = new SimpleDateFormat(this.timeFormatInput.getText());
            df.format(new Date());
        }
        catch (Exception e) {
            tfModified = false;
        }
        this.usernameFormatUpdateButton.setEnabled(ufModified);
        this.timeFormatUpdateButton.setEnabled(this.config.showTimestamps() && tfModified);
        this.contentBreakerUpdateButton.setEnabled(cbModified);
        this.formatRestButton.setEnabled(!this.config.getUsernameFormat().equals("%user%") || !this.config.getContentBreaker().equals(": "));
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getMessageConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.usernamesBox.setSelected(this.config.showUsernames());
        this.timestampsBox.setSelected(this.config.showTimestamps());
        this.usernameFormatInput.setText(this.config.getUsernameFormat());
        this.timeFormatInput.setText(this.config.getTimeFormat());
        this.contentBreakerInput.setText(this.config.getContentBreaker());
        this.config.setUsernameFormat(this.usernameFormatInput.getText());
        this.config.setTimeFormat(this.timeFormatInput.getText());
        this.config.setContentBreaker(this.contentBreakerInput.getText());
        this.toggleEnableds();
        this.joinMessagesBox.setSelected(this.config.showJoinMessages());
        this.queueSizeSlider.setValue(this.config.getQueueSize());
        this.messageSpeedSlider.setValue(this.config.getMessageSpeed());
        this.expirationTimeSlider.setValue(this.config.getExpirationTime());
        this.hideEmptyBorder.setSelected(this.config.isHideEmptyBorder());
        this.hideEmptyBackground.setSelected(this.config.isHideEmptyBackground());
        this.caseTypeDropdown.setSelectedItem((Object)this.config.getCaseResolutionType());
        this.specifyCaseBox.setSelected(this.config.isSpecifyCaseAllowed());
        this.messageCasingDropdown.setSelectedItem((Object)this.config.getMessageCasing());
    }

    @Override
    protected LoadConfigReport validateInput() {
        LoadConfigReport report = new LoadConfigReport();
        this.config.validateStrings(report, this.timeFormatInput.getText(), Integer.toString(this.queueSizeSlider.getValue()), Integer.toString(this.messageSpeedSlider.getValue()), Integer.toString(this.expirationTimeSlider.getValue()));
        return report;
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setShowUsernames(this.usernamesBox.isSelected());
        this.config.setJoinMessages(this.joinMessagesBox.isSelected());
        this.config.setShowTimestamps(this.timestampsBox.isSelected());
        this.config.setUsernameFormat(this.usernameFormatInput.getText());
        this.config.setTimeFormat(this.timeFormatInput.getText());
        this.config.setContentBreaker(this.contentBreakerInput.getText());
        this.toggleEnableds();
        this.config.setQueueSize(this.queueSizeSlider.getValue());
        this.config.setMessageSpeed(this.messageSpeedSlider.getValue(), this.chat.getMessageProgressor());
        this.config.setExpirationTime(this.expirationTimeSlider.getValue(), this.chat.getMessageExpirer());
        this.config.setHideEmptyBorder(this.hideEmptyBorder.isSelected());
        this.config.setHideEmptyBackground(this.hideEmptyBackground.isSelected());
        this.config.setCaseResolutionType((UsernameCaseResolutionType)((Object)this.caseTypeDropdown.getSelectedItem()));
        this.config.setSpecifyCaseAllowed(this.specifyCaseBox.isSelected());
        this.config.setMessageCasing((MessageCasing)((Object)this.messageCasingDropdown.getSelectedItem()));
    }
}

