/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.ChatViewerBot;
import com.glitchcog.fontificator.config.ConfigIrc;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledInput;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelEmoji;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.NickAlreadyInUseException;

public class ControlPanelIrc
extends ControlPanelBase {
    private static final Logger logger = Logger.getLogger(ControlPanelIrc.class);
    private static final long serialVersionUID = 1L;
    private static final String BUTTON_TEXT_CONNECT = "Connect";
    private static final String BUTTON_TEXT_DISCONNECT = "Disconnect";
    private ChatViewerBot bot;
    private JButton connectButton;
    private LabeledInput userInput;
    private LabeledInput hostInput;
    private LabeledInput portInput;
    private JCheckBox anonymous;
    private LabeledInput authInput;
    private JButton authHelpButton;
    private LabeledInput chanInput;
    private JButton clearChatButton;
    private JCheckBox autoReconnectBox;
    private ConfigIrc config;
    private ControlPanelEmoji emojiControl;

    public ControlPanelIrc(FontificatorProperties fProps, ChatWindow chatWindow, ControlPanelEmoji emojiControl, ChatViewerBot bot, LogBox logBox) {
        super("Connection", fProps, chatWindow, logBox);
        this.emojiControl = emojiControl;
        this.bot = bot;
        this.bot.setControlPanel(this);
    }

    private void connect() throws NumberFormatException, NickAlreadyInUseException, IOException, IrcException, Exception {
        this.anonymous.setEnabled(false);
        this.fillConfigFromInput();
        boolean anon = this.config.isAnonymous();
        this.logBox.setAuthCode(this.config.getAuthorization());
        String user = this.config.getUsername();
        String host = this.config.getHost();
        int port = Integer.parseInt(this.config.getPort());
        String auth = this.config.getAuthorization();
        if (anon) {
            String rndNumStr = "" + new Random().nextInt(99999);
            while (rndNumStr.length() < 5) {
                rndNumStr = "0" + rndNumStr;
            }
            user = "justinfan" + rndNumStr;
        }
        this.bot.setUsername(user);
        logger.trace("Attempting to connect " + user + " to " + host + ":" + port);
        this.bot.reset();
        if (anon) {
            this.bot.connect(host, port);
        } else {
            this.bot.connect(host, port, auth);
        }
        this.joinChannel();
    }

    public void joinChannel() {
        String host = this.config.getHost();
        String connectChannel = this.config.getChannel();
        if ("irc.twitch.tv".equals(host)) {
            connectChannel = connectChannel.toLowerCase();
        }
        this.bot.joinChannel(connectChannel);
    }

    private LoadConfigReport validateInputForConnect() {
        LoadConfigReport report = this.validateInput();
        if (this.userInput.getText().isEmpty() && !this.anonymous.isSelected()) {
            report.addError("An input value for Username is required", LoadConfigErrorType.MISSING_VALUE);
        }
        if (this.authInput.getText().trim().isEmpty() && !this.anonymous.isSelected()) {
            report.addError("An input value for the OAuth Token is required", LoadConfigErrorType.MISSING_VALUE);
        }
        if (this.chanInput.getText().isEmpty()) {
            report.addError("An input value for the Channel is required", LoadConfigErrorType.MISSING_VALUE);
        }
        if (this.hostInput.getText().trim().isEmpty()) {
            report.addError("An input value for Host is required", LoadConfigErrorType.MISSING_VALUE);
        }
        if (this.portInput.getText().isEmpty()) {
            report.addError("An input value for the Port is required", LoadConfigErrorType.MISSING_VALUE);
        } else {
            try {
                int port = Integer.parseInt(this.portInput.getText());
                if (port < 0 || port > 65535) {
                    report.addError("Port value is out of range", LoadConfigErrorType.VALUE_OUT_OF_RANGE);
                }
            }
            catch (Exception e) {
                report.addError("Port value must be a valid integer", LoadConfigErrorType.PARSE_ERROR_INT);
            }
        }
        return report;
    }

    @Override
    protected void build() {
        this.userInput = new LabeledInput("Username", 11);
        this.authInput = new LabeledInput("OAuth Token", true, 25);
        this.authHelpButton = new JButton("Get OAuth Token");
        this.chanInput = new LabeledInput("Channel", 11);
        this.hostInput = new LabeledInput("Host", 7);
        this.portInput = new LabeledInput("Port", 3);
        this.anonymous = new JCheckBox("Read Only (Credentials not required)");
        this.anonymous.setToolTipText("Connect without credentials, but also without access to custom Twitch badges");
        this.anonymous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelIrc.this.userInput.setEnabled(!ControlPanelIrc.this.anonymous.isSelected());
                ControlPanelIrc.this.authInput.setEnabled(!ControlPanelIrc.this.anonymous.isSelected());
                ControlPanelIrc.this.config.setAnonymous(ControlPanelIrc.this.anonymous.isSelected());
            }
        });
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ControlPanelIrc.this.fillConfigFromInput();
                }
                catch (Exception ex) {
                    logger.trace(ex.toString(), ex);
                }
            }
        };
        this.userInput.addFocusListener(fl);
        this.authInput.addFocusListener(fl);
        this.chanInput.addFocusListener(fl);
        this.hostInput.addFocusListener(fl);
        this.portInput.addFocusListener(fl);
        this.authHelpButton.addActionListener(new ActionListener(){
            final String url = "http://www.twitchapps.com/tmi/";

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://www.twitchapps.com/tmi/"));
                }
                catch (IOException ex) {
                    ChatWindow.popup.handleProblem("Unable to open website at URL: http://www.twitchapps.com/tmi/");
                }
            }
        });
        this.connectButton = new JButton(BUTTON_TEXT_CONNECT);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                source.setText(ControlPanelIrc.this.bot.isConnected() ? ControlPanelIrc.BUTTON_TEXT_DISCONNECT : ControlPanelIrc.BUTTON_TEXT_CONNECT);
                if (ControlPanelIrc.this.bot.isConnected()) {
                    ControlPanelIrc.this.bot.setDisconnectExpected(true);
                    ControlPanelIrc.this.bot.disconnect();
                } else {
                    try {
                        LoadConfigReport report = ControlPanelIrc.this.validateInputForConnect();
                        if (report.isErrorFree()) {
                            ControlPanelIrc.this.connect();
                            ControlPanelIrc.this.emojiControl.loadAndRunEmojiWork();
                        } else {
                            ChatWindow.popup.handleProblem(report);
                        }
                    }
                    catch (NumberFormatException ex) {
                        ChatWindow.popup.handleProblem("Invalid login port value", ex);
                    }
                    catch (NickAlreadyInUseException ex) {
                        ChatWindow.popup.handleProblem("Nickname already in use", ex);
                    }
                    catch (IOException ex) {
                        ChatWindow.popup.handleProblem("Error connecting to the IRC server. Verify the Internet connection and then the host and port values.", ex);
                    }
                    catch (IrcException ex) {
                        ChatWindow.popup.handleProblem("The host IRC server rejected the connection", ex);
                    }
                    catch (Exception ex) {
                        ChatWindow.popup.handleProblem("Unanticipated error connecting", ex);
                    }
                }
            }
        });
        this.clearChatButton = new JButton("Clear Chat");
        this.clearChatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelIrc.this.chat.clearChat();
                ControlPanelIrc.this.chat.repaint();
            }
        });
        this.autoReconnectBox = new JCheckBox("Automatically attempt to reconnect if connection is lost");
        this.autoReconnectBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelIrc.this.config.setAutoReconnect(ControlPanelIrc.this.autoReconnectBox.isSelected());
            }
        });
        JPanel everything = new JPanel(new GridBagLayout());
        everything.setBorder(new TitledBorder(this.baseBorder, "IRC Connection Properties / Clear Chat", 2, 2));
        JPanel topRow = new JPanel(new GridBagLayout());
        JPanel midRow = new JPanel(new GridBagLayout());
        JPanel botRow = new JPanel(new GridBagLayout());
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        topRow.add((Component)this.anonymous, this.gbc);
        ++this.gbc.gridx;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        topRow.add((Component)this.userInput, this.gbc);
        ++this.gbc.gridx;
        topRow.add((Component)this.chanInput, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridx = 0;
        midRow.add((Component)this.authInput, this.gbc);
        ++this.gbc.gridx;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        midRow.add((Component)this.authHelpButton, this.gbc);
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 0;
        botRow.add((Component)this.hostInput, this.gbc);
        ++this.gbc.gridx;
        botRow.add((Component)this.portInput, this.gbc);
        ++this.gbc.gridx;
        this.gbc.anchor = 12;
        botRow.add((Component)this.connectButton, this.gbc);
        ++this.gbc.gridx;
        botRow.add((Component)this.clearChatButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        everything.add((Component)topRow, this.gbc);
        ++this.gbc.gridy;
        everything.add((Component)midRow, this.gbc);
        ++this.gbc.gridy;
        everything.add((Component)botRow, this.gbc);
        ++this.gbc.gridy;
        everything.add((Component)this.autoReconnectBox, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 11;
        this.add((Component)everything, this.gbc);
        ++this.gbc.gridy;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.anchor = 15;
        this.gbc.fill = 1;
        this.add((Component)this.logBox, this.gbc);
    }

    public void toggleConnect(boolean connected) {
        this.userInput.setEnabled(!this.anonymous.isSelected() && !connected);
        this.authInput.setEnabled(!this.anonymous.isSelected() && !connected);
        this.chanInput.setEnabled(!connected);
        this.hostInput.setEnabled(!connected);
        this.portInput.setEnabled(!connected);
        this.anonymous.setEnabled(!connected);
        this.connectButton.setText(connected ? BUTTON_TEXT_DISCONNECT : BUTTON_TEXT_CONNECT);
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getIrcConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.userInput.setText(this.config.getUsername());
        this.chanInput.setText(this.config.getChannel());
        this.authInput.setText(this.config.getAuthorization());
        this.anonymous.setSelected(this.config.isAnonymous());
        this.logBox.setAuthCode(this.config.getAuthorization());
        this.hostInput.setText(this.config.getHost());
        this.portInput.setText(this.config.getPort());
        this.autoReconnectBox.setSelected(this.config.isAutoReconnect());
        this.userInput.setEnabled(!this.anonymous.isSelected());
        this.authInput.setEnabled(!this.anonymous.isSelected());
    }

    @Override
    protected LoadConfigReport validateInput() {
        return new LoadConfigReport();
    }

    @Override
    public void fillConfigFromInput() throws Exception {
        this.config.setUsername(this.userInput.getText());
        this.config.setAuthorization(this.authInput.getText());
        this.config.setAnonymous(this.anonymous.isSelected());
        this.config.setChannel(this.chanInput.getText());
        this.config.setHost(this.hostInput.getText());
        this.config.setPort(this.portInput.getText());
        this.config.setAutoReconnect(this.autoReconnectBox.isSelected());
    }

    public void log(String line) {
        this.logBox.log(line);
    }

    public String getChannelNoHash() {
        return this.config.getChannelNoHash();
    }

    public boolean isAutoReconnect() {
        return this.autoReconnectBox.isSelected();
    }
}

