/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.AssetIndexLoader;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.CharacterPicker;
import com.glitchcog.fontificator.gui.component.LabeledInput;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.component.combomenu.ComboMenuBar;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelColor;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownBorder;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownFont;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ControlPanelFont
extends ControlPanelBase {
    private static final Logger logger = Logger.getLogger(ControlPanelFont.class);
    private static final long serialVersionUID = 1L;
    public static final DropdownLabel CUSTOM_KEY = new DropdownLabel(null, "Custom...");
    private static final Color SCALE_EVEN = Color.BLACK;
    private static final Color SCALE_UNEVEN = new Color(6688819);
    private static final Map<DropdownLabel, DropdownFont> PRESET_FONT_FILE_MAP = AssetIndexLoader.loadFonts();
    private static Map<DropdownLabel, DropdownBorder> PRESET_BORDER_FILE_MAP = AssetIndexLoader.loadBorders();
    private LabeledInput fontFilenameInput;
    private ComboMenuBar fontPresetDropdown;
    private JCheckBox fontTypeCheckbox;
    private LabeledInput borderFilenameInput;
    private ComboMenuBar borderPresetDropdown;
    private LabeledInput gridWidthInput;
    private LabeledInput gridHeightInput;
    private JFileChooser fontPngPicker;
    private JFileChooser borderPngPicker;
    private LabeledSlider fontScaleSlider;
    private LabeledSlider borderScaleSlider;
    private LabeledSlider borderInsetXSlider;
    private LabeledSlider borderInsetYSlider;
    private LabeledInput characterKeyInput;
    private LabeledSlider spaceWidthSlider;
    private LabeledSlider baselineOffsetSlider;
    private LabeledSlider lineSpacingSlider;
    private LabeledSlider charSpacingSlider;
    private LabeledSlider messageSpacingSlider;
    private JButton unknownCharPopupButton;
    private CharacterPicker charPicker;
    private JLabel unknownCharLabel;
    private JCheckBox extendedCharBox;
    private ConfigFont config;
    private ChangeListener sliderListener;
    private ActionListener fontTypeListener;
    private ControlPanelColor colorPanel;

    public static String getFontGameName(String filename) {
        for (Map.Entry<DropdownLabel, DropdownFont> e : PRESET_FONT_FILE_MAP.entrySet()) {
            String fontFilename;
            if (CUSTOM_KEY.equals(e.getKey()) || !(fontFilename = e.getValue().getFontFilename()).equals(filename)) continue;
            return e.getKey().getLabel();
        }
        return "Unknown";
    }

    public static List<DropdownFont> getAllFonts() {
        ArrayList<DropdownFont> allFonts = new ArrayList<DropdownFont>();
        for (DropdownLabel ddfKey : PRESET_FONT_FILE_MAP.keySet()) {
            if (CUSTOM_KEY.equals(ddfKey)) continue;
            allFonts.add(PRESET_FONT_FILE_MAP.get(ddfKey));
        }
        return allFonts;
    }

    public static String getBorderGameName(String filename) {
        for (Map.Entry<DropdownLabel, DropdownBorder> e : PRESET_BORDER_FILE_MAP.entrySet()) {
            String borderFilename;
            if (CUSTOM_KEY.equals(e.getKey()) || !(borderFilename = e.getValue().getBorderFilename()).equals(filename)) continue;
            return e.getKey().getLabel();
        }
        return "Unknown";
    }

    public ControlPanelFont(FontificatorProperties fProps, ChatWindow chatWindow, LogBox logBox, ControlPanelColor colorPanel) {
        super("Font/Border", fProps, chatWindow, logBox);
        this.colorPanel = colorPanel;
        this.fontTypeCheckbox.addActionListener(this.fontTypeListener);
        this.fontPngPicker = new JFileChooser();
        this.borderPngPicker = new JFileChooser();
        FileFilter pngFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "PNG Image (*.png)";
            }
        };
        this.fontPngPicker.setFileFilter(pngFilter);
        this.borderPngPicker.setFileFilter(pngFilter);
    }

    @Override
    protected void build() {
        this.sliderListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (ControlPanelFont.this.fontScaleSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setFontScale(ControlPanelFont.this.fontScaleSlider.getScaledValue());
                    ControlPanelFont.this.fontScaleSlider.setValueTextColor((float)((int)ControlPanelFont.this.config.getFontScale()) == ControlPanelFont.this.config.getFontScale() ? SCALE_EVEN : SCALE_UNEVEN);
                } else if (ControlPanelFont.this.borderScaleSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setBorderScale(ControlPanelFont.this.borderScaleSlider.getScaledValue());
                    ControlPanelFont.this.borderScaleSlider.setValueTextColor((float)((int)ControlPanelFont.this.config.getBorderScale()) == ControlPanelFont.this.config.getBorderScale() ? SCALE_EVEN : SCALE_UNEVEN);
                } else if (ControlPanelFont.this.borderInsetXSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setBorderInsetX(ControlPanelFont.this.borderInsetXSlider.getValue());
                } else if (ControlPanelFont.this.borderInsetYSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setBorderInsetY(ControlPanelFont.this.borderInsetYSlider.getValue());
                } else if (ControlPanelFont.this.spaceWidthSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setSpaceWidth(ControlPanelFont.this.spaceWidthSlider.getValue());
                } else if (ControlPanelFont.this.baselineOffsetSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setBaselineOffset(ControlPanelFont.this.baselineOffsetSlider.getValue());
                } else if (ControlPanelFont.this.lineSpacingSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setLineSpacing(ControlPanelFont.this.lineSpacingSlider.getValue());
                } else if (ControlPanelFont.this.charSpacingSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setCharSpacing(ControlPanelFont.this.charSpacingSlider.getValue());
                } else if (ControlPanelFont.this.messageSpacingSlider.getSlider().equals(source)) {
                    ControlPanelFont.this.config.setMessageSpacing(ControlPanelFont.this.messageSpacingSlider.getValue());
                }
                ControlPanelFont.this.chat.repaint();
            }
        };
        ActionListener fontAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                DropdownLabel key = new DropdownLabel(source.getText());
                if (CUSTOM_KEY.equals(key)) {
                    int selectionResult = ControlPanelFont.this.fontPngPicker.showDialog(ControlWindow.me, "Select Font PNG");
                    if (selectionResult == 0) {
                        ControlPanelFont.this.fontFilenameInput.setText(ControlPanelFont.this.fontPngPicker.getSelectedFile().getAbsolutePath());
                        ControlPanelFont.this.fontPresetDropdown.setSelectedText(ControlPanelFont.this.fontPngPicker.getSelectedFile().getName());
                    }
                } else {
                    ControlPanelFont.this.fontFilenameInput.setText(((DropdownFont)PRESET_FONT_FILE_MAP.get(key)).getFontFilename());
                    ControlPanelFont.this.fontTypeCheckbox.setSelected(FontType.VARIABLE_WIDTH.equals((Object)((DropdownFont)PRESET_FONT_FILE_MAP.get(key)).getDefaultType()));
                    ControlPanelFont.this.spaceWidthSlider.setEnabled(ControlPanelFont.this.fontTypeCheckbox.isSelected());
                }
                ControlPanelFont.this.updateFontOrBorder(true);
            }
        };
        ActionListener borderAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                DropdownLabel key = new DropdownLabel(source.getText());
                if (CUSTOM_KEY.equals(key)) {
                    int selectionResult = ControlPanelFont.this.borderPngPicker.showDialog(ControlWindow.me, "Select Border PNG");
                    if (selectionResult == 0) {
                        ControlPanelFont.this.borderFilenameInput.setText(ControlPanelFont.this.borderPngPicker.getSelectedFile().getAbsolutePath());
                        ControlPanelFont.this.borderPresetDropdown.setSelectedText(ControlPanelFont.this.borderPngPicker.getSelectedFile().getName());
                    }
                } else {
                    DropdownBorder border = (DropdownBorder)PRESET_BORDER_FILE_MAP.get(key);
                    ControlPanelFont.this.borderFilenameInput.setText(border.getBorderFilename());
                    ControlPanelFont.this.colorPanel.setBorderColor(border.getDefaultTint());
                }
                ControlPanelFont.this.updateFontOrBorder(false);
            }
        };
        this.fontTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelFont.this.config.setFontType(ControlPanelFont.this.fontTypeCheckbox.isSelected() ? FontType.VARIABLE_WIDTH : FontType.FIXED_WIDTH);
                ControlPanelFont.this.spaceWidthSlider.setEnabled(ControlPanelFont.this.fontTypeCheckbox.isSelected());
                ControlPanelFont.this.updateFontOrBorder(true);
            }
        };
        this.extendedCharBox = new JCheckBox("Display Extended Characters");
        this.extendedCharBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ecbSelected = ControlPanelFont.this.extendedCharBox.isSelected();
                ControlPanelFont.this.config.setExtendedCharEnabled(ecbSelected);
                ControlPanelFont.this.unknownCharPopupButton.setEnabled(!ecbSelected);
                ControlPanelFont.this.unknownCharLabel.setEnabled(!ecbSelected);
                ControlPanelFont.this.chat.repaint();
            }
        });
        this.unknownCharLabel = new JLabel("");
        this.charPicker = new CharacterPicker(ControlWindow.me, this.fProps.getFontConfig(), this.unknownCharLabel, this.chat);
        Map<String, List<String>> fontMenuMap = this.getMenuMapFromPresets(PRESET_FONT_FILE_MAP.keySet());
        fontMenuMap.put(CUSTOM_KEY.getLabel(), null);
        Map<String, List<String>> borderMenuMap = this.getMenuMapFromPresets(PRESET_BORDER_FILE_MAP.keySet());
        borderMenuMap.put(CUSTOM_KEY.getLabel(), null);
        this.fontTypeCheckbox = new JCheckBox("Variable Width Characters");
        this.fontFilenameInput = new LabeledInput("Font Filename", 32);
        this.fontPresetDropdown = new ComboMenuBar(fontMenuMap, fontAl);
        this.borderFilenameInput = new LabeledInput("Border Filename", 32);
        this.borderPresetDropdown = new ComboMenuBar(borderMenuMap, borderAl);
        this.gridWidthInput = new LabeledInput("Grid Width", 4);
        this.gridHeightInput = new LabeledInput("Grid Height", 4);
        this.fontScaleSlider = new LabeledSlider("Font Size", "x", 1, 32, 0.25f);
        this.borderScaleSlider = new LabeledSlider("Border Size", "x", 0, 32, 0.25f);
        this.borderInsetXSlider = new LabeledSlider("X", "pixels", -256, 256);
        this.borderInsetYSlider = new LabeledSlider("Y", "pixels", -256, 256);
        this.characterKeyInput = new LabeledInput("Character Key", 32);
        this.spaceWidthSlider = new LabeledSlider("Space Width", "%", 0, 250);
        this.baselineOffsetSlider = new LabeledSlider("Baseline Height Offset", "pixels", -32, 64);
        this.lineSpacingSlider = new LabeledSlider("Line Spacing", "pixels", -16, 32);
        this.charSpacingSlider = new LabeledSlider("Char Spacing", "pixels", -16, 32);
        this.messageSpacingSlider = new LabeledSlider("Message Spacing", "pixels", 0, 128);
        this.unknownCharPopupButton = new JButton("Select Missing Character");
        this.unknownCharPopupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelFont.this.charPicker.setVisible(true);
            }
        });
        this.fontFilenameInput.setEnabled(false);
        this.borderFilenameInput.setEnabled(false);
        this.fontScaleSlider.addChangeListener(this.sliderListener);
        this.borderScaleSlider.addChangeListener(this.sliderListener);
        this.borderInsetXSlider.addChangeListener(this.sliderListener);
        this.borderInsetYSlider.addChangeListener(this.sliderListener);
        this.spaceWidthSlider.addChangeListener(this.sliderListener);
        this.baselineOffsetSlider.addChangeListener(this.sliderListener);
        this.lineSpacingSlider.addChangeListener(this.sliderListener);
        this.charSpacingSlider.addChangeListener(this.sliderListener);
        this.messageSpacingSlider.addChangeListener(this.sliderListener);
        JPanel fontPanel = new JPanel(new GridBagLayout());
        JPanel borderPanel = new JPanel(new GridBagLayout());
        JPanel unknownPanel = new JPanel(new GridBagLayout());
        fontPanel.setBorder(new TitledBorder(this.baseBorder, "Font"));
        borderPanel.setBorder(new TitledBorder(this.baseBorder, "Border"));
        unknownPanel.setBorder(new TitledBorder(this.baseBorder, "Extended and Unicode Characters"));
        GridBagConstraints fontGbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, DEFAULT_INSETS, 0, 0);
        GridBagConstraints borderGbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, DEFAULT_INSETS, 0, 0);
        GridBagConstraints unknownGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, DEFAULT_INSETS, 0, 0);
        JPanel fontFilterAndDropdown = new JPanel(new GridBagLayout());
        GridBagConstraints ffadGbc = ControlPanelBase.getGbc();
        ffadGbc.anchor = 17;
        ffadGbc.fill = 0;
        ffadGbc.weightx = 0.0;
        fontFilterAndDropdown.add((Component)this.fontPresetDropdown.getFilter(), ffadGbc);
        ++ffadGbc.gridx;
        fontFilterAndDropdown.add((Component)this.fontPresetDropdown, ffadGbc);
        fontPanel.add((Component)fontFilterAndDropdown, fontGbc);
        ++fontGbc.gridx;
        fontGbc.weightx = 1.0;
        fontGbc.fill = 2;
        fontPanel.add((Component)this.fontScaleSlider, fontGbc);
        fontGbc.gridwidth = 2;
        fontGbc.gridx = 0;
        ++fontGbc.gridy;
        fontPanel.add((Component)this.lineSpacingSlider, fontGbc);
        ++fontGbc.gridy;
        fontPanel.add((Component)this.charSpacingSlider, fontGbc);
        ++fontGbc.gridy;
        fontPanel.add((Component)this.messageSpacingSlider, fontGbc);
        ++fontGbc.gridy;
        JPanel variableWidthPanel = new JPanel(new GridBagLayout());
        GridBagConstraints vwpGbc = ControlPanelFont.getGbc();
        vwpGbc.anchor = 13;
        vwpGbc.weightx = 0.0;
        vwpGbc.fill = 0;
        variableWidthPanel.add((Component)this.fontTypeCheckbox, vwpGbc);
        vwpGbc.anchor = 17;
        vwpGbc.weightx = 1.0;
        vwpGbc.fill = 2;
        ++vwpGbc.gridx;
        variableWidthPanel.add((Component)this.spaceWidthSlider, vwpGbc);
        fontPanel.add((Component)variableWidthPanel, fontGbc);
        ++fontGbc.gridy;
        fontPanel.add((Component)this.baselineOffsetSlider, fontGbc);
        ++fontGbc.gridy;
        JPanel borderFilterAndDropdown = new JPanel(new GridBagLayout());
        GridBagConstraints bfadGbc = ControlPanelBase.getGbc();
        bfadGbc.anchor = 17;
        bfadGbc.fill = 0;
        bfadGbc.weightx = 0.0;
        borderFilterAndDropdown.add((Component)this.borderPresetDropdown.getFilter(), bfadGbc);
        ++bfadGbc.gridx;
        borderFilterAndDropdown.add((Component)this.borderPresetDropdown, bfadGbc);
        borderPanel.add((Component)borderFilterAndDropdown, borderGbc);
        ++borderGbc.gridx;
        borderGbc.weightx = 1.0;
        borderGbc.fill = 2;
        borderPanel.add((Component)this.borderScaleSlider, borderGbc);
        borderGbc.gridwidth = 2;
        borderGbc.gridx = 0;
        ++borderGbc.gridy;
        borderGbc.anchor = 10;
        borderPanel.add((Component)new JLabel("Font Insets Off Border"), borderGbc);
        ++borderGbc.gridy;
        borderPanel.add((Component)this.borderInsetXSlider, borderGbc);
        ++borderGbc.gridy;
        borderPanel.add((Component)this.borderInsetYSlider, borderGbc);
        ++borderGbc.gridy;
        unknownPanel.add((Component)this.extendedCharBox, unknownGbc);
        ++unknownGbc.gridx;
        unknownPanel.add((Component)this.unknownCharPopupButton, unknownGbc);
        ++unknownGbc.gridx;
        unknownPanel.add((Component)this.unknownCharLabel, unknownGbc);
        ++unknownGbc.gridx;
        JPanel everything = new JPanel(new GridBagLayout());
        GridBagConstraints eGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, DEFAULT_INSETS, 10, 10);
        everything.add((Component)fontPanel, eGbc);
        ++eGbc.gridy;
        everything.add((Component)borderPanel, eGbc);
        ++eGbc.gridy;
        everything.add((Component)unknownPanel, eGbc);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.add((Component)everything, this.gbc);
        ++this.gbc.gridy;
        this.gbc.weighty = 1.0;
        this.gbc.anchor = 15;
        this.add((Component)new JPanel(), this.gbc);
    }

    private Map<String, List<String>> getMenuMapFromPresets(Collection<DropdownLabel> keys) {
        LinkedHashMap<String, List<String>> menuMap = new LinkedHashMap<String, List<String>>();
        for (DropdownLabel key : keys) {
            String menu = key.getGroup();
            String item = key.getLabel();
            ArrayList<String> items = (ArrayList<String>)menuMap.get(menu);
            if (items == null) {
                items = new ArrayList<String>();
                menuMap.put(menu, items);
            }
            items.add(item);
        }
        return menuMap;
    }

    private boolean updateFontOrBorder(boolean isFont) {
        LoadConfigReport report = new LoadConfigReport();
        if (isFont) {
            this.config.validateFontFile(report, this.fontFilenameInput.getText());
            this.config.validateStrings(report, this.gridWidthInput.getText(), this.gridHeightInput.getText(), this.characterKeyInput.getText(), Character.toString(this.charPicker.getSelectedChar()));
        } else {
            this.config.validateBorderFile(report, this.borderFilenameInput.getText());
        }
        if (report.isErrorFree()) {
            try {
                this.fillConfigFromInput();
                if (isFont) {
                    this.chat.reloadFontFromConfig();
                } else {
                    this.chat.reloadBorderFromConfig();
                }
                this.chat.repaint();
                return true;
            }
            catch (Exception ex) {
                logger.error(ex.toString(), ex);
                ChatWindow.popup.handleProblem("Unable to load " + (isFont ? "font" : "border") + " image", ex);
            }
        } else {
            ChatWindow.popup.handleProblem(report);
        }
        return false;
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getFontConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.borderFilenameInput.setText(this.config.getBorderFilename());
        this.fontFilenameInput.setText(this.config.getFontFilename());
        this.gridWidthInput.setText(Integer.toString(this.config.getGridWidth()));
        this.gridHeightInput.setText(Integer.toString(this.config.getGridHeight()));
        this.fontScaleSlider.setScaledValue(this.config.getFontScale());
        this.borderScaleSlider.setScaledValue(this.config.getBorderScale());
        this.borderInsetXSlider.setValue(this.config.getBorderInsetX());
        this.borderInsetYSlider.setValue(this.config.getBorderInsetY());
        this.characterKeyInput.setText(this.config.getCharacterKey());
        this.extendedCharBox.setSelected(this.config.isExtendedCharEnabled());
        this.charPicker.setSelectedChar(this.config.getUnknownChar());
        this.spaceWidthSlider.setValue(this.config.getSpaceWidth());
        this.baselineOffsetSlider.setValue(this.config.getBaselineOffset());
        this.lineSpacingSlider.setValue(this.config.getLineSpacing());
        this.charSpacingSlider.setValue(this.config.getCharSpacing());
        this.messageSpacingSlider.setValue(this.config.getMessageSpacing());
        this.fontTypeCheckbox.setSelected(FontType.VARIABLE_WIDTH.equals((Object)this.config.getFontType()));
        this.spaceWidthSlider.setEnabled(this.fontTypeCheckbox.isSelected());
        boolean ecbSelected = this.extendedCharBox.isSelected();
        this.unknownCharPopupButton.setEnabled(!ecbSelected);
        this.unknownCharLabel.setEnabled(!ecbSelected);
        boolean found = false;
        for (Map.Entry<DropdownLabel, DropdownFont> entry : PRESET_FONT_FILE_MAP.entrySet()) {
            if (entry.getValue() == null || !this.config.getFontFilename().equals(entry.getValue().getFontFilename())) continue;
            found = true;
            this.fontPresetDropdown.setSelectedText(entry.getKey().getLabel());
        }
        if (!found) {
            String string = new File(this.fontFilenameInput.getText()).getName();
            this.fontPresetDropdown.setSelectedText(string);
        }
        found = false;
        for (Map.Entry<DropdownLabel, Object> entry : PRESET_BORDER_FILE_MAP.entrySet()) {
            if (entry.getValue() == null || !this.config.getBorderFilename().equals(((DropdownBorder)entry.getValue()).getBorderFilename())) continue;
            found = true;
            this.borderPresetDropdown.setSelectedText(entry.getKey().getLabel());
        }
        if (!found) {
            String string = new File(this.borderFilenameInput.getText()).getName();
            this.borderPresetDropdown.setSelectedText(string);
        }
        this.updateFontOrBorder(true);
        this.updateFontOrBorder(false);
    }

    @Override
    protected LoadConfigReport validateInput() {
        LoadConfigReport report = new LoadConfigReport();
        this.config.validateFontFile(report, this.fontFilenameInput.getText());
        this.config.validateBorderFile(report, this.borderFilenameInput.getText());
        String widthStr = this.gridWidthInput.getText();
        String heightStr = this.gridHeightInput.getText();
        String charKey = this.characterKeyInput.getText();
        String unknownStr = Character.toString(this.charPicker.getSelectedChar());
        this.config.validateStrings(report, widthStr, heightStr, charKey, unknownStr);
        return report;
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setBorderFilename(this.borderFilenameInput.getText());
        this.config.setFontFilename(this.fontFilenameInput.getText());
        this.config.setFontType(this.fontTypeCheckbox.isSelected() ? FontType.VARIABLE_WIDTH : FontType.FIXED_WIDTH);
        this.config.setGridWidth(Integer.parseInt(this.gridWidthInput.getText()));
        this.config.setGridHeight(Integer.parseInt(this.gridHeightInput.getText()));
        this.config.setFontScale(this.fontScaleSlider.getScaledValue());
        this.config.setBorderScale(this.borderScaleSlider.getScaledValue());
        this.config.setBorderInsetX(this.borderInsetXSlider.getValue());
        this.config.setBorderInsetY(this.borderInsetYSlider.getValue());
        this.config.setCharacterKey(this.characterKeyInput.getText());
        this.config.setExtendedCharEnabled(this.extendedCharBox.isSelected());
        this.config.setUnknownChar(this.charPicker.getSelectedChar());
        this.config.setSpaceWidth(this.spaceWidthSlider.getValue());
        this.config.setBaselineOffset(this.baselineOffsetSlider.getValue());
        this.config.setLineSpacing(this.lineSpacingSlider.getValue());
        this.config.setCharSpacing(this.charSpacingSlider.getValue());
        this.config.setMessageSpacing(this.messageSpacingSlider.getValue());
    }
}

