/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.bot.ChatViewerBot;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.EmojiLoadingDisplayStragegy;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.emoji.EmojiJob;
import com.glitchcog.fontificator.emoji.EmojiOperation;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.emoji.EmojiLoadProgressPanel;
import com.glitchcog.fontificator.gui.emoji.EmojiWorker;
import com.glitchcog.fontificator.gui.emoji.EmojiWorkerReport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanelEmoji
extends ControlPanelBase {
    private static final long serialVersionUID = 1L;
    private EmojiLoadProgressPanel progressPanel;
    private JCheckBox enableAll;
    private JCheckBox enableAnimation;
    private JCheckBox enableTwitchBadges;
    private JCheckBox enableFfzBadges;
    private JCheckBox emojiScaleToLineHeight;
    private LabeledSlider emojiScale;
    private JCheckBox badgeScaleToLineHeight;
    private LabeledSlider badgeScale;
    private LabeledSlider badgeHeightOffset;
    private JLabel emojiLoadingDisplayStratLabel;
    private JComboBox<EmojiLoadingDisplayStragegy> emojiLoadingDisplayStrat;
    private JCheckBox enableTwitterEmoji;
    private JCheckBox enableTwitch;
    private JCheckBox cacheTwitch;
    private JCheckBox enableFrankerFaceZ;
    private JCheckBox cacheFrankerFaceZ;
    private JCheckBox enableBetterTtv;
    private JCheckBox cacheBetterTtv;
    private ConfigEmoji config;
    private JPanel scaleAndDisplayPanel;
    private JPanel twitchPanel;
    private JPanel frankerPanel;
    private JPanel betterPanel;
    private final ChatViewerBot bot;

    public ControlPanelEmoji(FontificatorProperties fProps, ChatWindow chatWindow, ChatViewerBot bot, LogBox logBox) {
        super("Emoji", fProps, chatWindow, logBox);
        this.progressPanel.setEmojiConfig(this.config);
        this.bot = bot;
    }

    private void resolveEnables() {
        boolean all = this.enableAll.isSelected();
        boolean badges = this.enableTwitchBadges.isSelected() || this.enableFfzBadges.isSelected();
        this.scaleAndDisplayPanel.setEnabled(all || badges);
        this.emojiScaleToLineHeight.setEnabled(all);
        this.badgeScaleToLineHeight.setEnabled(badges);
        this.emojiScale.setEnabled(all);
        this.badgeScale.setEnabled(badges);
        this.badgeHeightOffset.setEnabled(badges);
        this.emojiLoadingDisplayStratLabel.setEnabled(all || badges);
        this.emojiLoadingDisplayStrat.setEnabled(all || badges);
        this.enableTwitterEmoji.setEnabled(all);
        this.twitchPanel.setEnabled(all);
        this.enableTwitch.setEnabled(all);
        this.cacheTwitch.setEnabled(all && this.enableTwitch.isSelected());
        this.frankerPanel.setEnabled(all);
        this.enableFrankerFaceZ.setEnabled(all);
        this.cacheFrankerFaceZ.setEnabled(all && this.enableFrankerFaceZ.isSelected());
        this.betterPanel.setEnabled(all);
        this.enableBetterTtv.setEnabled(all);
        this.cacheBetterTtv.setEnabled(all && this.enableBetterTtv.isSelected());
        this.progressPanel.handleButtonEnables();
    }

    @Override
    protected void build() {
        this.enableAll = new JCheckBox("Enable Emoji");
        this.enableAnimation = new JCheckBox("Enable Animation");
        this.enableTwitchBadges = new JCheckBox("Enable Twitch Badges");
        this.enableFfzBadges = new JCheckBox("Enable FrankerFaceZ Badges");
        this.progressPanel = new EmojiLoadProgressPanel(this.chat, this);
        this.emojiScaleToLineHeight = new JCheckBox("Relative to Line Height");
        this.emojiScale = new LabeledSlider("Emoji Scale", "%", 10, 500, 100, 3);
        this.badgeScaleToLineHeight = new JCheckBox("Relative to Line Height");
        this.badgeScale = new LabeledSlider("Badge Scale", "%", 10, 500, 100, 3);
        this.badgeHeightOffset = new LabeledSlider("Badge Height Offset", "pixels", -32, 64, 0, 3);
        this.emojiLoadingDisplayStratLabel = new JLabel("Loading Display Strategy:");
        this.emojiLoadingDisplayStrat = new JComboBox<EmojiLoadingDisplayStragegy>(EmojiLoadingDisplayStragegy.values());
        this.enableTwitterEmoji = new JCheckBox("Enable Twitter Emoji");
        this.enableTwitterEmoji.setToolTipText("Use Twitter emoji for extended character emoji instead of the local default font");
        this.enableTwitch = new JCheckBox("Enable Twitch Emotes");
        this.cacheTwitch = new JCheckBox("Cache Global Twitch Emotes");
        this.enableFrankerFaceZ = new JCheckBox("Enable FrankerFaceZ Emotes");
        this.cacheFrankerFaceZ = new JCheckBox("Cache FrankerFaceZ Emotes");
        this.enableBetterTtv = new JCheckBox("Enable BetterTTV Emotes");
        this.cacheBetterTtv = new JCheckBox("Cache BetterTTV Emotes");
        this.emojiScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanelEmoji.this.config.setEmojiScale(ControlPanelEmoji.this.emojiScale.getValue());
                ControlPanelEmoji.this.chat.repaint();
            }
        });
        this.badgeScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanelEmoji.this.config.setBadgeScale(ControlPanelEmoji.this.badgeScale.getValue());
                ControlPanelEmoji.this.chat.repaint();
            }
        });
        this.badgeHeightOffset.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanelEmoji.this.config.setBadgeHeightOffset(ControlPanelEmoji.this.badgeHeightOffset.getValue());
                ControlPanelEmoji.this.chat.repaint();
            }
        });
        this.emojiLoadingDisplayStrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEmoji.this.config.setDisplayStrategy((EmojiLoadingDisplayStragegy)((Object)ControlPanelEmoji.this.emojiLoadingDisplayStrat.getSelectedItem()));
                ControlPanelEmoji.this.chat.repaint();
            }
        });
        this.enableTwitterEmoji.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelEmoji.this.config.setTwitterEnabled(ControlPanelEmoji.this.enableTwitterEmoji.isSelected());
                ControlPanelEmoji.this.chat.repaint();
            }
        });
        ActionListener cbal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (ControlPanelEmoji.this.bot.isConnected()) {
                    EmojiJob job;
                    EmojiJob jobB;
                    EmojiJob jobA;
                    HashSet<EmojiJob> jobsToRun = new HashSet<EmojiJob>();
                    HashSet<EmojiJob> jobsToCancel = new HashSet<EmojiJob>();
                    boolean clickAll = ControlPanelEmoji.this.enableAll.equals(source);
                    boolean clickFfzLoad = clickAll || ControlPanelEmoji.this.enableFrankerFaceZ.equals(source);
                    boolean clickFfzCache = clickAll || ControlPanelEmoji.this.cacheFrankerFaceZ.equals(source);
                    boolean clickBttvLoad = clickAll || ControlPanelEmoji.this.enableBetterTtv.equals(source);
                    boolean clickBttvCache = clickAll || ControlPanelEmoji.this.cacheBetterTtv.equals(source);
                    boolean clickTwitchBadges = !ControlPanelEmoji.this.config.isTwitchBadgesLoaded(ControlPanelEmoji.this.getConnectChannel()) && ControlPanelEmoji.this.enableTwitchBadges.equals(source);
                    boolean clickFfzBadges = !ControlPanelEmoji.this.config.isFfzBadgesLoaded(ControlPanelEmoji.this.getConnectChannel()) && ControlPanelEmoji.this.enableFfzBadges.equals(source);
                    String oauth = ControlPanelEmoji.this.fProps.getProperty("ircAuth");
                    if (clickFfzLoad && !ControlPanelEmoji.this.config.isFfzLoaded(ControlPanelEmoji.this.getConnectChannel())) {
                        jobA = new EmojiJob(oauth, EmojiType.FRANKERFACEZ_CHANNEL, EmojiOperation.LOAD, ControlPanelEmoji.this.getConnectChannel());
                        jobB = new EmojiJob(oauth, EmojiType.FRANKERFACEZ_GLOBAL, EmojiOperation.LOAD);
                        if (ControlPanelEmoji.this.enableAll.isSelected() && ControlPanelEmoji.this.enableFrankerFaceZ.isSelected()) {
                            jobsToRun.add(jobA);
                            jobsToRun.add(jobB);
                        } else {
                            jobsToCancel.add(jobA);
                            jobsToCancel.add(jobB);
                        }
                    }
                    if (clickBttvLoad && !ControlPanelEmoji.this.config.isBttvLoaded(ControlPanelEmoji.this.getConnectChannel())) {
                        jobA = new EmojiJob(oauth, EmojiType.BETTER_TTV_CHANNEL, EmojiOperation.LOAD, ControlPanelEmoji.this.getConnectChannel());
                        jobB = new EmojiJob(oauth, EmojiType.BETTER_TTV_GLOBAL, EmojiOperation.LOAD);
                        if (ControlPanelEmoji.this.enableAll.isSelected() && ControlPanelEmoji.this.enableBetterTtv.isSelected()) {
                            jobsToRun.add(jobA);
                            jobsToRun.add(jobB);
                        } else {
                            jobsToCancel.add(jobA);
                            jobsToCancel.add(jobB);
                        }
                    }
                    if (clickFfzCache && !ControlPanelEmoji.this.config.isFfzCached()) {
                        jobA = new EmojiJob(oauth, EmojiType.FRANKERFACEZ_CHANNEL, EmojiOperation.CACHE);
                        jobB = new EmojiJob(oauth, EmojiType.FRANKERFACEZ_GLOBAL, EmojiOperation.CACHE);
                        if (ControlPanelEmoji.this.enableAll.isSelected() && ControlPanelEmoji.this.cacheFrankerFaceZ.isSelected()) {
                            jobsToRun.add(jobA);
                            jobsToRun.add(jobB);
                        } else {
                            jobsToCancel.add(jobA);
                            jobsToCancel.add(jobB);
                        }
                    }
                    if (clickBttvCache && !ControlPanelEmoji.this.config.isBttvCached()) {
                        jobA = new EmojiJob(oauth, EmojiType.BETTER_TTV_CHANNEL, EmojiOperation.CACHE);
                        jobB = new EmojiJob(oauth, EmojiType.BETTER_TTV_GLOBAL, EmojiOperation.CACHE);
                        if (ControlPanelEmoji.this.enableAll.isSelected() && ControlPanelEmoji.this.cacheBetterTtv.isSelected()) {
                            jobsToRun.add(jobA);
                            jobsToRun.add(jobB);
                        } else {
                            jobsToCancel.add(jobA);
                            jobsToCancel.add(jobB);
                        }
                    }
                    if (clickTwitchBadges && !ControlPanelEmoji.this.config.isTwitchBadgesLoaded(ControlPanelEmoji.this.getConnectChannel())) {
                        job = new EmojiJob(oauth, EmojiType.TWITCH_BADGE, EmojiOperation.LOAD, ControlPanelEmoji.this.getConnectChannel());
                        if (ControlPanelEmoji.this.enableTwitchBadges.isSelected()) {
                            jobsToRun.add(job);
                        } else {
                            jobsToCancel.add(job);
                        }
                    }
                    if (clickFfzBadges && !ControlPanelEmoji.this.config.isFfzBadgesLoaded(ControlPanelEmoji.this.getConnectChannel())) {
                        job = new EmojiJob(oauth, EmojiType.FRANKERFACEZ_BADGE, EmojiOperation.LOAD, ControlPanelEmoji.this.getConnectChannel());
                        if (ControlPanelEmoji.this.enableFfzBadges.isSelected()) {
                            jobsToRun.add(job);
                        } else {
                            jobsToCancel.add(job);
                        }
                    }
                    ControlPanelEmoji.this.loadEmojiWork(jobsToRun);
                    ControlPanelEmoji.this.cancelEmojiWork(jobsToCancel);
                    if (!jobsToRun.isEmpty() && !ControlPanelEmoji.this.progressPanel.isCurrentlyRunning()) {
                        ControlPanelEmoji.this.runEmojiWork();
                    }
                }
                ControlPanelEmoji.this.config.setEmojiEnabled(ControlPanelEmoji.this.enableAll.isSelected());
                ControlPanelEmoji.this.config.setAnimationEnabled(ControlPanelEmoji.this.enableAnimation.isSelected());
                ControlPanelEmoji.this.config.setTwitchBadgesEnabled(ControlPanelEmoji.this.enableTwitchBadges.isSelected());
                ControlPanelEmoji.this.config.setFfzBadgesEnabled(ControlPanelEmoji.this.enableFfzBadges.isSelected());
                ControlPanelEmoji.this.config.setTwitchEnabled(ControlPanelEmoji.this.enableTwitch.isSelected());
                ControlPanelEmoji.this.config.setTwitchCacheEnabled(ControlPanelEmoji.this.cacheTwitch.isSelected());
                ControlPanelEmoji.this.config.setFfzEnabled(ControlPanelEmoji.this.enableFrankerFaceZ.isSelected());
                ControlPanelEmoji.this.config.setFfzCacheEnabled(ControlPanelEmoji.this.cacheFrankerFaceZ.isSelected());
                ControlPanelEmoji.this.config.setBttvEnabled(ControlPanelEmoji.this.enableBetterTtv.isSelected());
                ControlPanelEmoji.this.config.setBttvCacheEnabled(ControlPanelEmoji.this.cacheBetterTtv.isSelected());
                ControlPanelEmoji.this.config.setEmojiScaleToLine(ControlPanelEmoji.this.emojiScaleToLineHeight.isSelected());
                ControlPanelEmoji.this.config.setBadgeScaleToLine(ControlPanelEmoji.this.badgeScaleToLineHeight.isSelected());
                ControlPanelEmoji.this.config.setTwitterEnabled(ControlPanelEmoji.this.enableTwitterEmoji.isSelected());
                ControlPanelEmoji.this.resolveEnables();
                ControlPanelEmoji.this.chat.repaint();
            }
        };
        this.enableAll.addActionListener(cbal);
        this.enableAnimation.addActionListener(cbal);
        this.enableTwitchBadges.addActionListener(cbal);
        this.enableFfzBadges.addActionListener(cbal);
        this.emojiScaleToLineHeight.addActionListener(cbal);
        this.badgeScaleToLineHeight.addActionListener(cbal);
        this.enableTwitch.addActionListener(cbal);
        this.cacheTwitch.addActionListener(cbal);
        this.enableFrankerFaceZ.addActionListener(cbal);
        this.cacheFrankerFaceZ.addActionListener(cbal);
        this.enableBetterTtv.addActionListener(cbal);
        this.cacheBetterTtv.addActionListener(cbal);
        JPanel allEnabledPanel = new JPanel(new GridBagLayout());
        GridBagConstraints allGbc = ControlPanelEmoji.getGbc();
        allGbc.weighty = 1.0;
        allGbc.fill = 0;
        allGbc.anchor = 17;
        allGbc.weightx = 0.25;
        allEnabledPanel.add((Component)this.enableAll, allGbc);
        ++allGbc.gridx;
        allEnabledPanel.add((Component)this.enableAnimation, allGbc);
        ++allGbc.gridx;
        allGbc.anchor = 13;
        allEnabledPanel.add((Component)this.enableTwitchBadges, allGbc);
        ++allGbc.gridx;
        allEnabledPanel.add((Component)this.enableFfzBadges, allGbc);
        ++allGbc.gridx;
        this.scaleAndDisplayPanel = new JPanel(new GridBagLayout());
        this.scaleAndDisplayPanel.setBorder(this.baseBorder);
        GridBagConstraints scaleAndDisplayGbc = ControlPanelEmoji.getGbc();
        scaleAndDisplayGbc.anchor = 10;
        scaleAndDisplayGbc.fill = 2;
        scaleAndDisplayGbc.weightx = 1.0;
        this.scaleAndDisplayPanel.add((Component)this.emojiScale, scaleAndDisplayGbc);
        ++scaleAndDisplayGbc.gridx;
        scaleAndDisplayGbc.fill = 0;
        scaleAndDisplayGbc.weightx = 0.0;
        this.scaleAndDisplayPanel.add((Component)this.emojiScaleToLineHeight, scaleAndDisplayGbc);
        scaleAndDisplayGbc.gridx = 0;
        ++scaleAndDisplayGbc.gridy;
        scaleAndDisplayGbc.anchor = 10;
        scaleAndDisplayGbc.fill = 2;
        scaleAndDisplayGbc.weightx = 1.0;
        this.scaleAndDisplayPanel.add((Component)this.badgeScale, scaleAndDisplayGbc);
        ++scaleAndDisplayGbc.gridx;
        scaleAndDisplayGbc.fill = 0;
        scaleAndDisplayGbc.weightx = 0.0;
        this.scaleAndDisplayPanel.add((Component)this.badgeScaleToLineHeight, scaleAndDisplayGbc);
        scaleAndDisplayGbc.gridx = 0;
        ++scaleAndDisplayGbc.gridy;
        scaleAndDisplayGbc.fill = 2;
        scaleAndDisplayGbc.gridwidth = 2;
        this.scaleAndDisplayPanel.add((Component)this.badgeHeightOffset, scaleAndDisplayGbc);
        ++scaleAndDisplayGbc.gridy;
        scaleAndDisplayGbc.gridwidth = 2;
        scaleAndDisplayGbc.weightx = 1.0;
        scaleAndDisplayGbc.fill = 2;
        this.scaleAndDisplayPanel.add((Component)new JSeparator(0), scaleAndDisplayGbc);
        ++scaleAndDisplayGbc.gridy;
        JPanel bottomOfScaleDisplayPanel = new JPanel(new GridBagLayout());
        GridBagConstraints bosdpGbc = ControlPanelEmoji.getGbc();
        bottomOfScaleDisplayPanel.add((Component)this.emojiLoadingDisplayStratLabel, bosdpGbc);
        ++bosdpGbc.gridx;
        bottomOfScaleDisplayPanel.add(this.emojiLoadingDisplayStrat, bosdpGbc);
        ++bosdpGbc.gridx;
        bottomOfScaleDisplayPanel.add((Component)this.enableTwitterEmoji, bosdpGbc);
        this.scaleAndDisplayPanel.add((Component)bottomOfScaleDisplayPanel, scaleAndDisplayGbc);
        this.twitchPanel = new JPanel(new GridBagLayout());
        this.twitchPanel.setBorder(BorderFactory.createTitledBorder(this.baseBorder, "Twitch Emotes"));
        GridBagConstraints twitchGbc = ControlPanelEmoji.getGbc();
        this.twitchPanel.add((Component)this.enableTwitch, twitchGbc);
        ++twitchGbc.gridy;
        this.twitchPanel.add((Component)this.cacheTwitch, twitchGbc);
        ++twitchGbc.gridy;
        this.frankerPanel = new JPanel(new GridBagLayout());
        this.frankerPanel.setBorder(BorderFactory.createTitledBorder(this.baseBorder, "FrankerFaceZ Emotes"));
        GridBagConstraints frankerGbc = ControlPanelEmoji.getGbc();
        this.frankerPanel.add((Component)this.enableFrankerFaceZ, frankerGbc);
        ++frankerGbc.gridy;
        this.frankerPanel.add((Component)this.cacheFrankerFaceZ, frankerGbc);
        ++frankerGbc.gridy;
        this.betterPanel = new JPanel(new GridBagLayout());
        this.betterPanel.setBorder(BorderFactory.createTitledBorder(this.baseBorder, "BetterTTV Emotes"));
        GridBagConstraints betterGbc = ControlPanelEmoji.getGbc();
        this.betterPanel.add((Component)this.enableBetterTtv, betterGbc);
        ++betterGbc.gridy;
        this.betterPanel.add((Component)this.cacheBetterTtv, betterGbc);
        ++betterGbc.gridy;
        this.gbc.anchor = 11;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = 3;
        this.add((Component)allEnabledPanel, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.add((Component)this.twitchPanel, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.frankerPanel, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.betterPanel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 3;
        this.add((Component)this.scaleAndDisplayPanel, this.gbc);
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        this.gbc.anchor = 15;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 1;
        this.add((Component)this.progressPanel, this.gbc);
        ++this.gbc.gridy;
    }

    private String getConnectChannel() {
        return this.fProps.getIrcConfig().getChannelNoHash();
    }

    public void loadAndRunEmojiWork() {
        boolean atLeastOneBadgeSelected;
        boolean bl = atLeastOneBadgeSelected = this.enableTwitchBadges.isSelected() || this.enableFfzBadges.isSelected();
        if (this.enableAll.isSelected() || atLeastOneBadgeSelected) {
            Set<EmojiJob> jobs = this.collectJobs();
            if (jobs.isEmpty()) {
                this.progressPanel.log("No new work found.");
            } else {
                this.loadEmojiWork(jobs);
            }
            this.runEmojiWork();
        }
        this.progressPanel.handleButtonEnables();
    }

    public int countJobs() {
        int count = 0;
        if (this.config == null) {
            return count;
        }
        String channel = this.getConnectChannel();
        if (this.enableAll.isSelected()) {
            boolean workTwitchLoad = this.config.isTwitchLoaded() == false && this.enableTwitch.isSelected();
            boolean workTwitchCache = this.config.isTwitchCached() == false && this.cacheTwitch.isSelected();
            boolean workFfzLoad = !this.config.isFfzLoaded(channel) && this.enableFrankerFaceZ.isSelected();
            boolean workFfzGlobalLoad = this.config.isFfzGlobalLoaded() == false && this.enableFrankerFaceZ.isSelected();
            boolean workFfzCache = !this.config.isFfzCached() && this.cacheFrankerFaceZ.isSelected();
            boolean workBttvLoad = !this.config.isBttvLoaded(channel) && this.enableBetterTtv.isSelected();
            boolean workBttvGlobalLoad = this.config.isBttvGlobalLoaded() == false && this.enableBetterTtv.isSelected();
            boolean workBttvCache = !this.config.isBttvCached() && this.cacheBetterTtv.isSelected();
            count += ControlPanelEmoji.countBooleans(workTwitchLoad, workTwitchCache, workFfzLoad, workFfzGlobalLoad, workFfzCache, workBttvLoad, workBttvGlobalLoad, workBttvCache);
        }
        boolean workTwitchBadges = this.enableTwitchBadges.isSelected() && !this.config.isTwitchBadgesLoaded(channel);
        boolean workFfzBadges = this.enableFfzBadges.isSelected() && !this.config.isFfzBadgesLoaded(channel);
        return count += ControlPanelEmoji.countBooleans(workTwitchBadges, workFfzBadges);
    }

    private static int countBooleans(boolean ... bools) {
        int count = 0;
        int i = 0;
        while (i < bools.length) {
            if (bools[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Set<EmojiJob> collectJobs() {
        boolean workFfzBadges;
        HashSet<EmojiJob> jobs = new HashSet<EmojiJob>();
        if (this.config == null) {
            return jobs;
        }
        String channel = this.getConnectChannel();
        String oauth = this.fProps.getProperty("ircAuth");
        if (this.enableAll.isSelected()) {
            boolean workBttvCache;
            boolean workFfzLoad = !this.config.isFfzLoaded(channel) && this.enableFrankerFaceZ.isSelected();
            boolean workFfzGlobalLoad = this.config.isFfzGlobalLoaded() == false && this.enableFrankerFaceZ.isSelected();
            boolean workFfzCache = !this.config.isFfzCached() && this.cacheFrankerFaceZ.isSelected();
            boolean workBttvLoad = !this.config.isBttvLoaded(channel) && this.enableBetterTtv.isSelected();
            boolean workBttvGlobalLoad = this.config.isBttvGlobalLoaded() == false && this.enableBetterTtv.isSelected();
            boolean bl = workBttvCache = !this.config.isBttvCached() && this.cacheBetterTtv.isSelected();
            if (workFfzLoad) {
                jobs.add(new EmojiJob(oauth, EmojiType.FRANKERFACEZ_CHANNEL, EmojiOperation.LOAD, channel));
                if (channel == null) {
                    ChatWindow.popup.handleProblem("Please specify a channel on the Connection tab to load emoji");
                    jobs.clear();
                    return jobs;
                }
            }
            if (workFfzGlobalLoad) {
                jobs.add(new EmojiJob(oauth, EmojiType.FRANKERFACEZ_GLOBAL, EmojiOperation.LOAD));
            }
            if (workFfzCache) {
                jobs.add(new EmojiJob(oauth, EmojiType.FRANKERFACEZ_CHANNEL, EmojiOperation.CACHE));
                jobs.add(new EmojiJob(oauth, EmojiType.FRANKERFACEZ_GLOBAL, EmojiOperation.CACHE));
            }
            if (workBttvLoad) {
                jobs.add(new EmojiJob(oauth, EmojiType.BETTER_TTV_CHANNEL, EmojiOperation.LOAD, channel));
                if (channel == null) {
                    ChatWindow.popup.handleProblem("Please specify a channel on the Connection tab to load emoji");
                    jobs.clear();
                    return jobs;
                }
            }
            if (workBttvGlobalLoad) {
                jobs.add(new EmojiJob(oauth, EmojiType.BETTER_TTV_GLOBAL, EmojiOperation.LOAD));
            }
            if (workBttvCache) {
                jobs.add(new EmojiJob(oauth, EmojiType.BETTER_TTV_CHANNEL, EmojiOperation.CACHE));
                jobs.add(new EmojiJob(oauth, EmojiType.BETTER_TTV_GLOBAL, EmojiOperation.CACHE));
            }
        }
        boolean workTwitchBadges = this.enableTwitchBadges.isSelected() && !this.config.isTwitchBadgesLoaded(channel);
        boolean bl = workFfzBadges = this.enableFfzBadges.isSelected() && !this.config.isFfzBadgesLoaded(channel);
        if (workTwitchBadges) {
            jobs.add(new EmojiJob(oauth, EmojiType.TWITCH_BADGE, EmojiOperation.LOAD, channel));
            if (channel == null) {
                ChatWindow.popup.handleProblem("Please specify a channel on the Connection tab to load badges");
                jobs.clear();
                return jobs;
            }
        }
        if (workFfzBadges) {
            jobs.add(new EmojiJob(oauth, EmojiType.FRANKERFACEZ_BADGE, EmojiOperation.LOAD, channel));
            if (channel == null) {
                ChatWindow.popup.handleProblem("Please specify a channel on the Connection tab to load badges");
                jobs.clear();
                return jobs;
            }
        }
        return jobs;
    }

    private void loadEmojiWork(Collection<EmojiJob> jobs) {
        for (EmojiJob job : jobs) {
            EmojiWorkerReport initialReport = new EmojiWorkerReport(job.toString(), 0);
            EmojiWorker worker = new EmojiWorker(this.chat.getEmojiManager(), this.progressPanel, job, this.logBox, initialReport);
            this.progressPanel.addWorkToQueue(worker);
        }
    }

    private void cancelEmojiWork(Collection<EmojiJob> jobs) {
        for (EmojiJob job : jobs) {
            this.progressPanel.removeWorkFromQueue(job);
        }
    }

    private void runEmojiWork() {
        this.progressPanel.initiateWork();
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getEmojiConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.enableAll.setSelected(this.config.isEmojiEnabled());
        this.enableAnimation.setSelected(this.config.isAnimationEnabled());
        this.enableTwitchBadges.setSelected(this.config.isTwitchBadgesEnabled());
        this.enableFfzBadges.setSelected(this.config.isFfzBadgesEnabled());
        this.emojiScaleToLineHeight.setSelected(this.config.isEmojiScaleToLine());
        this.badgeScaleToLineHeight.setSelected(this.config.isBadgeScaleToLine());
        this.emojiScale.setValue(this.config.getEmojiScale());
        this.badgeScale.setValue(this.config.getBadgeScale());
        this.emojiLoadingDisplayStrat.setSelectedItem((Object)this.config.getDisplayStrategy());
        this.enableTwitch.setSelected(this.config.isTwitchEnabled());
        this.cacheTwitch.setSelected(this.config.isTwitchCacheEnabled());
        this.enableFrankerFaceZ.setSelected(this.config.isFfzEnabled());
        this.cacheFrankerFaceZ.setSelected(this.config.isFfzCacheEnabled());
        this.enableBetterTtv.setSelected(this.config.isBttvEnabled());
        this.cacheBetterTtv.setSelected(this.config.isBttvCacheEnabled());
        this.enableAnimation.setSelected(this.config.isAnimationEnabled());
        this.enableTwitterEmoji.setSelected(this.config.isTwitterEnabled());
        this.resolveEnables();
    }

    @Override
    protected LoadConfigReport validateInput() {
        return new LoadConfigReport();
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setEmojiEnabled(this.enableAll.isSelected());
        this.config.setAnimationEnabled(this.enableAnimation.isSelected());
        this.config.setTwitchBadgesEnabled(this.enableTwitchBadges.isSelected());
        this.config.setFfzBadgesEnabled(this.enableFfzBadges.isSelected());
        this.config.setEmojiScaleToLine(this.emojiScaleToLineHeight.isSelected());
        this.config.setBadgeScaleToLine(this.badgeScaleToLineHeight.isSelected());
        this.config.setEmojiScale(this.emojiScale.getValue());
        this.config.setBadgeScale(this.badgeScale.getValue());
        this.config.setDisplayStrategy((EmojiLoadingDisplayStragegy)((Object)this.emojiLoadingDisplayStrat.getSelectedItem()));
        this.config.setTwitchEnabled(this.enableTwitch.isSelected());
        this.config.setTwitchCacheEnabled(this.cacheTwitch.isSelected());
        this.config.setFfzEnabled(this.enableFrankerFaceZ.isSelected());
        this.config.setFfzCacheEnabled(this.cacheFrankerFaceZ.isSelected());
        this.config.setBttvEnabled(this.enableBetterTtv.isSelected());
        this.config.setBttvCacheEnabled(this.cacheBetterTtv.isSelected());
        this.config.setAnimationEnabled(this.enableAnimation.isSelected());
        this.config.setTwitterEnabled(this.enableTwitterEmoji.isSelected());
    }
}

