/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.DebugAppender;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.ColorButton;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.CollagePanel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.ExamplePanel;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ControlPanelDebug
extends ControlPanelBase {
    private static final long serialVersionUID = 1L;
    private boolean debugging = false;
    private ControlWindow ctrlWindow;
    private DebugAppender debugAppender;
    private JButton postTestMessage;
    private JToggleButton postMessagesButton;
    private LabeledSlider postRateSlider;
    private JCheckBox drawTextGridBox;
    private ColorButton textGridColorButton;
    private JCheckBox drawBorderGridBox;
    private ColorButton borderGridColorButton;
    private Random rnd;
    private Timer postClock;
    private String[] TEST_USERNAMES = new String[]{"Mario", "Luigi", "Peach", "Toad", "Bowser", "Shyguy", "Yoshi", "Birdo", "Goomba", "Koopa", "Link", "Zelda", "Impa", "Shiek", "Navi", "Tingle", "Error", "Bagu", "Agahnim", "Ganon", "Ganondorf", "Ryu", "Chun-Li", "Ken", "Blanka", "Guile", "Sagat", "Vega", "Zangief", "Balrog", "Dhalsim", "Samus", "Ridley", "Kraid", "Simon", "Alucard", "Kirby", "Chell", "GLaDOS", "Guycott", "Pacman", "Guybrush", "Sonic", "Tails", "Knuckles", "Robotnik", "Eggman", "Bulbasaur", "Squirtle", "Charmander", "Pikachu", "Zubat", "Caterpie", "Jigglypuff", "Psyduck", "Meowth", "Mewtwo", "Snorlax", "Magikarp", "Ness", "Paula", "Jeff", "Poo", "Lucas", "Claus", "Flint", "Hinawa", "Chrono", "Marle", "Lucca", "Robo", "Magus", "Frog", "Ayla", "Gato", "Lavos", "Schala", "Dalton", "Serge", "Lynx", "Kid", "Harle", "Alena", "Talloon", "Ragnar", "Brey", "Cristo", "Maya", "Nara", "Maribel", "Kiefer", "Gabo", "Melvin", "Aira", "Hargon", "Malroth", "Kandar", "Baramos", "Zoma", "Estark", "Aamon", "Balzack", "Psaro", "Necrosaro", "Terra", "Locke", "Celes", "Edgar", "Sabin", "Kefka", "Cloud", "Tifa", "Aerith", "Barret", "Sephiroth"};
    private String[] TEST_MESSAGES = new String[]{"You presumptuous little twit. I'll have you for lunch!", "Thank you Mario! But our princess is in another castle!", "It's dangerous to go alone. Take this.", "It's a secret to everybody.", "I feel asleep!!", "Now it is the beginning of a fantastic story!", "Let us make a journey to the cave of monsters!", "A winner is you!", "Let's play money making game.", "A Slime draws near! Command?", "I am Error.", "Hey, listen!", "Bagu is my name. Show my note to river man.", "What a horrible night to have a curse.", "The morning sun has vanquished the horrible night.", "You now prossess Dracula's Rib", "Take my daughter, please!!", "Get a Silk Bag from the Graveyard Duck to live longer.", "All your base are belong to us.", "The morning sun has vanquished the horrible night.", "Get a silk bag from the graveyard duck to live longer.", "Someone set us up the bomb.", "Are you a bad enough dude to rescue the president?", "That's the second biggest monkey head I've ever seen!", "Now you're thinking with portals.", "Would you kindly?", "The cake is a lie.", "We've both said a lot of things that you're going to regret.", "It's like my Rattata is in the top percentage of rattatas.", "You have died of dysentery.", "Curse you Link!", "Time passes, people move. Like a river's flow, it never ends.", "I... I shall consume. Consume... consume everything...", "You've met with a terrible fate, haven't you?", "I really am the richest duck in the world.", "The fate of the forest nay the world depends upon thee.", "Well excuuuuuse me, princess!", "Bombs! Bombs are the answer!", "The name of the Archfiend Baramos is yet unknown in the world of men.", "But Thou Must!", "'Tis about as useful as a chocolate teapot.", "Thou wilt regret thy coming indeed! You shall be dead for good, for I wilt surely feast on thine innards!", "What is a man? A miserable little pile of secrets! But enough talk! Have at you!", "I'll not ask you to return to our side, but I demand you cease your attack.", "Perhaps you can save his haunted soul.", "Machines aren't capable of evil. Humans make them that way.", "Lower thine guard, and thou'rt allowing the enemy in.", "Old man breathe, but dead on inside!", "Do you wish to fight me?", "Beat me up and earn fifteen silver points!", "This is not enough golds.", "Your fists of evil are about to meet my steel wall of niceness.", "Thanks a million!", "You have completed a great game.", "You spoony bard!", "Welcome to die!", "You must defeat my Dragon Punch to stand a chance!", "You did quite well, but you need more training to defeat me!", "It's natural for a sumo wrestler to become the world's strongest!", "Can't you do better than that?", "Seeing you in action is a joke!", "Now you realize the powers I possess!", "Are you man enough to fight with me?", "Go home and be a family man!", "Get up!! It's too early for you to be defeated!", "Attack me if you dare, I will crush you!", "There is no chance for you to beat me! Challenge someone else!", "I'm the strongest woman in the world!", "My strength is much greater than yours!", "Next time we meet, I'm gonna break your arms!", "Now you've realized the inner mysteries of yoga!", "I will meditate and then destroy you!!", "Get up you wimp!", "Hey, What happened? I'm not through with you yet!", "Handsome fighters never lose a battle!", "Thank you for a gorgeous time!", "You are not a warrior, you're a beginner!", "I am not satisfied until I have the world's strongest title again!", "Get lost, you can't compare with my powers!", "Anyone who opposes me will be destroyed!"};

    private void postRandomMessage() {
        String username = this.TEST_USERNAMES[this.rnd.nextInt(this.TEST_USERNAMES.length)];
        String message = this.TEST_MESSAGES[this.rnd.nextInt(this.TEST_MESSAGES.length)];
        this.ctrlWindow.addManualMessage(username, message);
    }

    public ControlPanelDebug(FontificatorProperties fProps, ChatWindow chatWindow, ControlWindow ctrlWindow) {
        super("Debug", fProps, chatWindow, new LogBox());
        this.ctrlWindow = ctrlWindow;
        this.rnd = new Random();
        this.debugAppender = new DebugAppender(this.logBox);
    }

    public boolean isDrawTextGrid() {
        return this.isDebugging() && this.drawTextGridBox.isSelected();
    }

    public boolean isDrawBorderGrid() {
        return this.isDebugging() && this.drawBorderGridBox.isSelected();
    }

    public Color getTextGridColor() {
        return this.textGridColorButton.getColor();
    }

    public Color getBorderGridColor() {
        return this.borderGridColorButton.getColor();
    }

    @Override
    protected void build() {
        this.postTestMessage = new JButton("Post Debug Message");
        this.postTestMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelDebug.this.ctrlWindow.addManualMessage("Test", " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            }
        });
        this.postMessagesButton = new JToggleButton("Post Messages");
        this.postRateSlider = new LabeledSlider("Post Rate ", " / min", 1, 120, 30, 3);
        this.postClock = new Timer(60000 / this.postRateSlider.getValue(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelDebug.this.postRandomMessage();
            }
        });
        this.postRateSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!((JSlider)e.getSource()).getValueIsAdjusting()) {
                    ControlPanelDebug.this.postClock.setDelay(60000 / ControlPanelDebug.this.postRateSlider.getValue());
                    if (ControlPanelDebug.this.postClock.isRunning()) {
                        ControlPanelDebug.this.postRandomMessage();
                        ControlPanelDebug.this.postClock.restart();
                    }
                }
            }
        });
        this.postMessagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelDebug.this.postRandomMessage();
                if (ControlPanelDebug.this.postMessagesButton.isSelected()) {
                    ControlPanelDebug.this.postClock.start();
                } else {
                    ControlPanelDebug.this.postClock.stop();
                }
            }
        });
        this.drawTextGridBox = new JCheckBox("Draw Text Grid");
        this.textGridColorButton = new ColorButton("Text Grid Color", new Color(0x99FF88), "Color of the border grid", this);
        this.drawBorderGridBox = new JCheckBox("Draw Border Grid");
        this.borderGridColorButton = new ColorButton("Border Grid Color", new Color(0x9988FF), "Color of the border grid", this);
        ActionListener refreshListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanelDebug.this.chat != null) {
                    ControlPanelDebug.this.chat.repaint();
                }
            }
        };
        this.drawTextGridBox.addActionListener(refreshListener);
        this.drawBorderGridBox.addActionListener(refreshListener);
        JPanel topPanel = new JPanel(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        topPanel.add((Component)this.postTestMessage, this.gbc);
        ++this.gbc.gridx;
        topPanel.add((Component)this.postMessagesButton, this.gbc);
        ++this.gbc.gridx;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        topPanel.add((Component)this.postRateSlider, this.gbc);
        this.gbc.gridwidth = 4;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.add((Component)topPanel, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.5;
        this.gbc.fill = 2;
        this.add((Component)this.drawTextGridBox, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.textGridColorButton, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.drawBorderGridBox, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.borderGridColorButton, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 4;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.1;
        CollagePanel collagePanel = new CollagePanel(this.chat);
        this.add((Component)collagePanel, this.gbc);
        ++this.gbc.gridy;
        ExamplePanel examplePanel = new ExamplePanel(this);
        this.add((Component)examplePanel, this.gbc);
        ++this.gbc.gridy;
        this.gbc.weighty = 0.9;
        this.gbc.anchor = 15;
        this.gbc.fill = 1;
        this.gbc.gridwidth = 4;
        this.add((Component)this.logBox, this.gbc);
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
    }

    @Override
    protected LoadConfigReport validateInput() {
        return new LoadConfigReport();
    }

    @Override
    public void fillConfigFromInput() throws Exception {
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
        if (debugging) {
            Thread.setDefaultUncaughtExceptionHandler(this.debugAppender);
            BasicConfigurator.configure(this.debugAppender);
        } else {
            this.postClock.stop();
            this.postMessagesButton.setSelected(false);
            this.drawTextGridBox.setSelected(false);
            this.drawBorderGridBox.setSelected(false);
            this.chat.repaint();
            Thread.setDefaultUncaughtExceptionHandler(null);
            Logger.getRootLogger().removeAppender(this.debugAppender);
        }
    }

    public boolean isDebugging() {
        return this.debugging;
    }
}

