/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.ConfigColor;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.ColorButton;
import com.glitchcog.fontificator.gui.component.palette.Palette;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ControlPanelColor
extends ControlPanelBase {
    private static final long serialVersionUID = 1L;
    private ColorButton bgColorButton;
    private ColorButton fgColorButton;
    private ColorButton borderColorButton;
    private ColorButton highlightButton;
    private ColorButton chromaColorButton;
    private Palette palette;
    private JCheckBox useTwitchBox;
    private JCheckBox joinBox;
    private JCheckBox usernameBox;
    private JCheckBox timestampBox;
    private JCheckBox messageBox;
    private ConfigColor config;

    public ControlPanelColor(FontificatorProperties fProps, ChatWindow chatWindow, LogBox logBox) {
        super("Color", fProps, chatWindow, logBox);
    }

    @Override
    protected void build() {
        this.useTwitchBox = new JCheckBox("Override Palette with Twitch Username Colors when Available");
        this.joinBox = new JCheckBox("Color Join Messages");
        this.usernameBox = new JCheckBox("Color Usernames");
        this.timestampBox = new JCheckBox("Color Timestamps");
        this.messageBox = new JCheckBox("Color Messages");
        ActionListener boxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (ControlPanelColor.this.useTwitchBox.equals(source)) {
                    ControlPanelColor.this.config.setUseTwitchColors(source.isSelected());
                } else if (ControlPanelColor.this.joinBox.equals(source)) {
                    ControlPanelColor.this.config.setColorJoin(source.isSelected());
                } else if (ControlPanelColor.this.usernameBox.equals(source)) {
                    ControlPanelColor.this.config.setColorUsername(source.isSelected());
                } else if (ControlPanelColor.this.timestampBox.equals(source)) {
                    ControlPanelColor.this.config.setColorTimestamp(source.isSelected());
                } else if (ControlPanelColor.this.messageBox.equals(source)) {
                    ControlPanelColor.this.config.setColorMessage(source.isSelected());
                }
                ControlPanelColor.this.chat.repaint();
            }
        };
        this.useTwitchBox.addActionListener(boxListener);
        this.joinBox.addActionListener(boxListener);
        this.usernameBox.addActionListener(boxListener);
        this.timestampBox.addActionListener(boxListener);
        this.messageBox.addActionListener(boxListener);
        this.bgColorButton = new ColorButton("Background", Color.BLACK, "Set the color of the background of the chat", this);
        this.chromaColorButton = new ColorButton("Chroma Key", Color.GREEN, "Set the color for the chroma key border region", this);
        this.fgColorButton = new ColorButton("Text Tint", Color.WHITE, "Set the color of the text of the chat", this);
        this.borderColorButton = new ColorButton("Border Tint", Color.WHITE, "Set the color of the border of the chat", this);
        this.highlightButton = new ColorButton("Highlight Tint", Color.YELLOW, "Set the default color used to highlight the text of the chat", this);
        this.palette = new Palette(Color.BLACK, this);
        JPanel topColorPanel = new JPanel(new GridLayout(2, 1));
        JPanel botOptionsPanel = new JPanel(new GridBagLayout());
        JPanel palettePanel = new JPanel(new GridBagLayout());
        topColorPanel.setBorder(new TitledBorder(this.baseBorder, "Color Selections", 2, 2));
        palettePanel.setBorder(new TitledBorder(this.baseBorder, "Palette of Colors drawn from, per Username", 2, 2));
        botOptionsPanel.setBorder(new TitledBorder(this.baseBorder, "Color Options", 2, 2));
        JPanel colorPanelA = new JPanel(new GridLayout(1, 2));
        colorPanelA.add(this.bgColorButton);
        colorPanelA.add(this.chromaColorButton);
        JPanel colorPanelB = new JPanel(new GridLayout(1, 3));
        colorPanelB.add(this.fgColorButton);
        colorPanelB.add(this.highlightButton);
        colorPanelB.add(this.borderColorButton);
        topColorPanel.add(colorPanelA);
        topColorPanel.add(colorPanelB);
        GridBagConstraints ppGbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, NO_INSETS, 0, 0);
        palettePanel.add((Component)this.palette, ppGbc);
        ++ppGbc.gridy;
        palettePanel.add((Component)this.useTwitchBox, ppGbc);
        GridBagConstraints optionsGbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, DEFAULT_INSETS, 0, 0);
        botOptionsPanel.add((Component)this.joinBox, optionsGbc);
        ++optionsGbc.gridx;
        botOptionsPanel.add((Component)this.usernameBox, optionsGbc);
        optionsGbc.gridx = 0;
        ++optionsGbc.gridy;
        botOptionsPanel.add((Component)this.timestampBox, optionsGbc);
        ++optionsGbc.gridx;
        botOptionsPanel.add((Component)this.messageBox, optionsGbc);
        this.gbc.anchor = 11;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.add((Component)topColorPanel, this.gbc);
        ++this.gbc.gridy;
        this.add((Component)palettePanel, this.gbc);
        ++this.gbc.gridy;
        this.add((Component)botOptionsPanel, this.gbc);
        ++this.gbc.gridy;
        this.gbc.anchor = 15;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.add((Component)new JPanel(), this.gbc);
        ++this.gbc.gridy;
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getColorConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.bgColorButton.setColor(this.config.getBgColor());
        this.fgColorButton.setColor(this.config.getFgColor());
        this.borderColorButton.setColor(this.config.getBorderColor());
        this.highlightButton.setColor(this.config.getHighlight());
        this.chromaColorButton.setColor(this.config.getChromaColor());
        this.palette.reset();
        for (Color col : this.config.getPalette()) {
            this.palette.addColor(col);
        }
        this.palette.refreshComponents();
        this.useTwitchBox.setSelected(this.config.isUseTwitchColors());
        this.joinBox.setSelected(this.config.isColorJoin());
        this.usernameBox.setSelected(this.config.isColorUsername());
        this.messageBox.setSelected(this.config.isColorMessage());
        this.timestampBox.setSelected(this.config.isColorTimestamp());
        this.palette.setBgColor(this.config.getBgColor());
    }

    @Override
    protected LoadConfigReport validateInput() {
        return new LoadConfigReport();
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setBgColor(this.bgColorButton.getColor());
        this.config.setFgColor(this.fgColorButton.getColor());
        this.config.setBorderColor(this.borderColorButton.getColor());
        this.config.setHighlight(this.highlightButton.getColor());
        this.config.setChromaColor(this.chromaColorButton.getColor());
        this.config.setPalette(this.palette.getColors());
        this.config.setUseTwitchColors(this.useTwitchBox.isSelected());
        this.config.setColorJoin(this.joinBox.isSelected());
        this.config.setColorUsername(this.usernameBox.isSelected());
        this.config.setColorMessage(this.messageBox.isSelected());
        this.config.setColorTimestamp(this.timestampBox.isSelected());
        this.palette.setBgColor(this.bgColorButton.getColor());
    }

    public void setBorderColor(Color borderColor) {
        this.borderColorButton.setColor(borderColor);
        this.config.setBorderColor(borderColor);
    }
}

