/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.ConfigChat;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledInput;
import com.glitchcog.fontificator.gui.component.LabeledSlider;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ControlPanelChat
extends ControlPanelBase {
    private static final long serialVersionUID = 1L;
    private JCheckBox resizableBox;
    private JCheckBox scrollableBox;
    private JCheckBox reverseScrollBox;
    private JCheckBox chatFromBottomBox;
    private LabeledInput widthInput;
    private LabeledInput heightInput;
    private ConfigChat config;
    private ComponentListener resizeListener;
    private JButton updateSizeButton;
    private JCheckBox chromaEnabledBox;
    private JCheckBox chromaInvertBox;
    private LabeledInput[] chromaBorderInput;
    private JButton updateChromaSizeButton;
    private LabeledSlider chromaCornerSlider;
    private ControlWindow ctrlWindow;

    public ControlPanelChat(FontificatorProperties fProps, ChatWindow chatWindow, ControlWindow ctrlWindow, LogBox logBox) {
        super("Chat Window", fProps, chatWindow, logBox);
        this.ctrlWindow = ctrlWindow;
        this.resizeListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = (Component)e.getSource();
                int w = ((JFrame)c).getContentPane().getWidth();
                int h = ((JFrame)c).getContentPane().getHeight();
                ControlPanelChat.this.widthInput.setText(Integer.toString(w));
                ControlPanelChat.this.heightInput.setText(Integer.toString(h));
                ControlPanelChat.this.config.setWidth(w);
                ControlPanelChat.this.config.setHeight(h);
                ControlPanelChat.this.updateSizeButton.setEnabled(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ControlPanelChat.this.rememberChatWindowPosition();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
        this.chatWindow.addComponentListener(this.resizeListener);
    }

    private void rememberChatWindowPosition() {
        if (this.config.isRememberPosition() && this.chatWindow != null && this.chatWindow.isVisible()) {
            int x = (int)this.chatWindow.getLocationOnScreen().getX();
            int y = (int)this.chatWindow.getLocationOnScreen().getY();
            this.config.setChatWindowPositionX(x);
            this.config.setChatWindowPositionY(y);
        }
    }

    @Override
    protected void build() {
        this.resizableBox = new JCheckBox("Resize Chat by Dragging");
        this.scrollableBox = new JCheckBox("Mouse Wheel Scrolls Chat");
        this.reverseScrollBox = new JCheckBox("Reverse Chat Order");
        this.chatFromBottomBox = new JCheckBox("Chat Starts from Bottom");
        this.widthInput = new LabeledInput("Width", 3);
        this.heightInput = new LabeledInput("Height", 3);
        DocumentListener chatSizeDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.somethingChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.somethingChanged(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.somethingChanged(e);
            }

            private void somethingChanged(DocumentEvent e) {
                try {
                    int w = Integer.parseInt(ControlPanelChat.this.widthInput.getText());
                    int h = Integer.parseInt(ControlPanelChat.this.heightInput.getText());
                    ControlPanelChat.this.updateSizeButton.setEnabled(w != ControlPanelChat.this.config.getWidth() || h != ControlPanelChat.this.config.getHeight());
                }
                catch (Exception ex) {
                    ControlPanelChat.this.updateSizeButton.setEnabled(false);
                }
            }
        };
        DocumentListener chromaDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ControlPanelChat.this.toggleChromaButtonEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ControlPanelChat.this.toggleChromaButtonEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ControlPanelChat.this.toggleChromaButtonEnabled();
            }
        };
        this.widthInput.addDocumentListener(chatSizeDocListener);
        this.heightInput.addDocumentListener(chatSizeDocListener);
        this.updateSizeButton = new JButton("Update Chat Size");
        this.chromaEnabledBox = new JCheckBox("Enable Chroma Key Border");
        this.chromaInvertBox = new JCheckBox("Invert Chroma Key Border");
        this.chromaCornerSlider = new LabeledSlider("Corner Radius", "pixels", 0, 128);
        String[] chromaLabels = new String[]{"Left", "Top", "Right", "Bottom"};
        this.chromaBorderInput = new LabeledInput[chromaLabels.length];
        int i = 0;
        while (i < this.chromaBorderInput.length) {
            this.chromaBorderInput[i] = new LabeledInput(chromaLabels[i], 4);
            this.chromaBorderInput[i].addDocumentListener(chromaDocListener);
            ++i;
        }
        this.updateChromaSizeButton = new JButton("Update Chroma Border");
        ActionListener boxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (ControlPanelChat.this.resizableBox.equals(source)) {
                    ControlPanelChat.this.chatWindow.setResizable(ControlPanelChat.this.resizableBox.isSelected());
                    ControlPanelChat.this.config.setResizable(ControlPanelChat.this.resizableBox.isSelected());
                } else if (ControlPanelChat.this.scrollableBox.equals(source)) {
                    ControlPanelChat.this.config.setScrollable(ControlPanelChat.this.scrollableBox.isSelected());
                    if (!ControlPanelChat.this.scrollableBox.isSelected()) {
                        ControlPanelChat.this.chat.resetScrollOffset();
                    }
                } else if (ControlPanelChat.this.reverseScrollBox.equals(source)) {
                    ControlPanelChat.this.config.setReverseScrolling(ControlPanelChat.this.reverseScrollBox.isSelected());
                } else if (ControlPanelChat.this.chatFromBottomBox.equals(source)) {
                    ControlPanelChat.this.chat.resetScrollOffset();
                    ControlPanelChat.this.config.setChatFromBottom(ControlPanelChat.this.chatFromBottomBox.isSelected());
                } else if (ControlPanelChat.this.chromaEnabledBox.equals(source)) {
                    ControlPanelChat.this.config.setChromaEnabled(ControlPanelChat.this.chromaEnabledBox.isSelected());
                    ControlPanelChat.this.toggleChromaInputFields();
                } else if (ControlPanelChat.this.chromaInvertBox.equals(source)) {
                    ControlPanelChat.this.config.setChromaInvert(ControlPanelChat.this.chromaInvertBox.isSelected());
                }
                ControlPanelChat.this.chat.repaint();
            }
        };
        this.resizableBox.addActionListener(boxListener);
        this.scrollableBox.addActionListener(boxListener);
        this.reverseScrollBox.addActionListener(boxListener);
        this.chatFromBottomBox.addActionListener(boxListener);
        this.chromaEnabledBox.addActionListener(boxListener);
        this.chromaInvertBox.addActionListener(boxListener);
        ActionListener dimListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoadConfigReport report = new LoadConfigReport();
                    ControlPanelChat.this.config.validateDimStrings(report, ControlPanelChat.this.widthInput.getText(), ControlPanelChat.this.heightInput.getText());
                    if (report.isErrorFree()) {
                        int width = Integer.parseInt(ControlPanelChat.this.widthInput.getText());
                        int height = Integer.parseInt(ControlPanelChat.this.heightInput.getText());
                        ControlPanelChat.this.config.setWidth(width);
                        ControlPanelChat.this.config.setHeight(height);
                        ControlPanelChat.this.chatWindow.getContentPane().setPreferredSize(new Dimension(ControlPanelChat.this.config.getWidth(), ControlPanelChat.this.config.getHeight()));
                        ControlPanelChat.this.chatWindow.getContentPane().setSize(ControlPanelChat.this.config.getWidth(), ControlPanelChat.this.config.getHeight());
                        ControlPanelChat.this.chatWindow.pack();
                    } else {
                        ChatWindow.popup.handleProblem(report);
                    }
                }
                catch (Exception ex) {
                    ChatWindow.popup.handleProblem("Chat Width and Chat Height values could not be parsed", ex);
                }
            }
        };
        this.updateSizeButton.addActionListener(dimListener);
        ActionListener chromaDimListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoadConfigReport report = new LoadConfigReport();
                    ControlPanelChat.this.config.validateChromaDimStrings(report, ControlPanelChat.this.chromaBorderInput[0].getText(), ControlPanelChat.this.chromaBorderInput[1].getText(), ControlPanelChat.this.chromaBorderInput[2].getText(), ControlPanelChat.this.chromaBorderInput[3].getText());
                    if (report.isErrorFree()) {
                        ControlPanelChat.this.inputToConfigChromaBorders();
                        ControlPanelChat.this.chat.repaint();
                    } else {
                        ChatWindow.popup.handleProblem(report);
                    }
                }
                catch (Exception ex) {
                    ChatWindow.popup.handleProblem("Chat Chroma border values could not be parsed", ex);
                }
            }
        };
        this.updateChromaSizeButton.addActionListener(chromaDimListener);
        this.chromaCornerSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanelChat.this.config.setChromaCornerRadius(ControlPanelChat.this.chromaCornerSlider.getValue());
                ControlPanelChat.this.chat.repaint();
            }
        });
        JPanel chatDimPanel = new JPanel(new GridBagLayout());
        JPanel chatOptionsPanel = new JPanel(new GridBagLayout());
        JPanel chromaDimPanel = new JPanel(new GridBagLayout());
        chatDimPanel.setBorder(new TitledBorder(this.baseBorder, "Chat Window Size", 2, 2));
        chatOptionsPanel.setBorder(new TitledBorder(this.baseBorder, "Chat Window Options", 2, 2));
        chromaDimPanel.setBorder(this.baseBorder);
        GridBagConstraints dGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, DEFAULT_INSETS, 0, 0);
        dGbc.gridx = 0;
        dGbc.gridy = 0;
        dGbc.gridwidth = 1;
        chatDimPanel.add((Component)this.widthInput, dGbc);
        ++dGbc.gridx;
        chatDimPanel.add((Component)this.heightInput, dGbc);
        dGbc.gridx = 0;
        ++dGbc.gridy;
        dGbc.gridwidth = 2;
        chatDimPanel.add((Component)this.updateSizeButton, dGbc);
        ++dGbc.gridy;
        chatDimPanel.add((Component)this.resizableBox, dGbc);
        ++dGbc.gridy;
        GridBagConstraints coGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 3, DEFAULT_INSETS, 0, 0);
        coGbc.anchor = 17;
        chatOptionsPanel.add((Component)this.scrollableBox, coGbc);
        ++coGbc.gridy;
        chatOptionsPanel.add((Component)this.reverseScrollBox, coGbc);
        ++coGbc.gridy;
        chatOptionsPanel.add((Component)this.chatFromBottomBox, coGbc);
        ++coGbc.gridy;
        GridBagConstraints chromaGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 3, NO_INSETS, 0, 0);
        chromaGbc.gridwidth = 3;
        chromaDimPanel.add((Component)this.chromaEnabledBox, chromaGbc);
        ++chromaGbc.gridy;
        chromaDimPanel.add((Component)this.chromaBorderInput[1], chromaGbc);
        ++chromaGbc.gridy;
        chromaGbc.gridwidth = 1;
        chromaGbc.anchor = 13;
        chromaDimPanel.add((Component)this.chromaBorderInput[0], chromaGbc);
        ++chromaGbc.gridx;
        chromaGbc.anchor = 10;
        chromaDimPanel.add((Component)this.updateChromaSizeButton, chromaGbc);
        ++chromaGbc.gridx;
        chromaGbc.anchor = 17;
        chromaDimPanel.add((Component)this.chromaBorderInput[2], chromaGbc);
        chromaGbc.gridx = 0;
        chromaGbc.anchor = 10;
        ++chromaGbc.gridy;
        chromaGbc.gridwidth = 3;
        chromaDimPanel.add((Component)this.chromaBorderInput[3], chromaGbc);
        ++chromaGbc.gridy;
        chromaDimPanel.add((Component)this.chromaInvertBox, chromaGbc);
        ++chromaGbc.gridy;
        chromaDimPanel.add((Component)this.chromaCornerSlider, chromaGbc);
        JPanel everything = new JPanel(new GridBagLayout());
        GridBagConstraints eGbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, NO_INSETS, 0, 0);
        eGbc.weighty = 0.5;
        eGbc.weightx = 0.5;
        eGbc.fill = 2;
        eGbc.insets = new Insets(0, 3, 0, 3);
        everything.add((Component)chatDimPanel, eGbc);
        eGbc.weightx = 0.5;
        ++eGbc.gridx;
        everything.add((Component)chatOptionsPanel, eGbc);
        eGbc.weightx = 1.0;
        eGbc.weighty = 0.0;
        eGbc.gridx = 0;
        ++eGbc.gridy;
        eGbc.gridwidth = 2;
        eGbc.fill = 1;
        eGbc.anchor = 10;
        everything.add((Component)chromaDimPanel, eGbc);
        ++eGbc.gridy;
        this.gbc.anchor = 11;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.add((Component)everything, this.gbc);
    }

    private void inputToConfigChromaBorders() {
        int[] values = new int[this.chromaBorderInput.length];
        int i = 0;
        while (i < this.chromaBorderInput.length) {
            values[i] = Integer.parseInt(this.chromaBorderInput[i].getText());
            ++i;
        }
        this.config.setChromaBorder(values[0], values[1], values[2], values[3]);
    }

    private void toggleChromaInputFields() {
        boolean enabled = this.config.isChromaEnabled();
        this.updateChromaSizeButton.setEnabled(enabled);
        int i = 0;
        while (i < this.chromaBorderInput.length) {
            this.chromaBorderInput[i].setEnabled(enabled);
            ++i;
        }
        this.chromaInvertBox.setEnabled(enabled);
        this.chromaCornerSlider.setEnabled(enabled);
        if (enabled) {
            this.toggleChromaButtonEnabled();
        }
    }

    private void toggleChromaButtonEnabled() {
        try {
            boolean differenceFound = Integer.parseInt(this.chromaBorderInput[0].getText()) != this.config.getChromaBorder().x || Integer.parseInt(this.chromaBorderInput[1].getText()) != this.config.getChromaBorder().y || Integer.parseInt(this.chromaBorderInput[2].getText()) != this.config.getChromaBorder().width || Integer.parseInt(this.chromaBorderInput[3].getText()) != this.config.getChromaBorder().height;
            this.updateChromaSizeButton.setEnabled(differenceFound);
        }
        catch (Exception ex) {
            this.updateChromaSizeButton.setEnabled(false);
        }
    }

    @Override
    protected void fillInputFromProperties(FontificatorProperties fProps) {
        this.config = fProps.getChatConfig();
        this.fillInputFromConfig();
    }

    @Override
    protected void fillInputFromConfig() {
        this.resizableBox.setSelected(this.config.isResizable());
        this.scrollableBox.setSelected(this.config.isScrollable());
        this.reverseScrollBox.setSelected(this.config.isReverseScrolling());
        this.chatFromBottomBox.setSelected(this.config.isChatFromBottom());
        this.widthInput.setText(this.config.getWidth() == null ? null : Integer.toString(this.config.getWidth()));
        this.heightInput.setText(this.config.getHeight() == null ? null : Integer.toString(this.config.getHeight()));
        this.chromaEnabledBox.setSelected(this.config.isChromaEnabled());
        this.chromaBorderInput[0].setText(Integer.toString(this.config.getChromaBorder().x));
        this.chromaBorderInput[1].setText(Integer.toString(this.config.getChromaBorder().y));
        this.chromaBorderInput[2].setText(Integer.toString(this.config.getChromaBorder().width));
        this.chromaBorderInput[3].setText(Integer.toString(this.config.getChromaBorder().height));
        this.chromaInvertBox.setSelected(this.config.isChromaInvert());
        this.chromaCornerSlider.setValue(this.config.getChromaCornerRadius());
        this.chatWindow.setChatSize(this.config);
        this.toggleChromaInputFields();
        if (this.ctrlWindow != null) {
            this.fillInputAfterLoading();
        }
    }

    public void fillInputAfterLoading() {
        this.ctrlWindow.setAlwaysOnTopMenu(this.config.isAlwaysOnTop());
        this.ctrlWindow.setRememberPositionMenu(this.config.isRememberPosition());
        this.ctrlWindow.setAntiAliasMenu(this.config.isAntiAlias());
        this.setRememberedPosition();
    }

    @Override
    protected LoadConfigReport validateInput() {
        LoadConfigReport report = new LoadConfigReport();
        this.config.validateDimStrings(report, this.widthInput.getText(), this.heightInput.getText());
        this.config.validateChromaDimStrings(report, this.chromaBorderInput[0].getText(), this.chromaBorderInput[1].getText(), this.chromaBorderInput[2].getText(), this.chromaBorderInput[3].getText());
        return report;
    }

    @Override
    protected void fillConfigFromInput() throws Exception {
        this.config.setResizable(this.resizableBox.isSelected());
        this.config.setScrollable(this.scrollableBox.isSelected());
        this.config.setReverseScrolling(this.reverseScrollBox.isSelected());
        this.config.setChatFromBottom(this.chatFromBottomBox.isSelected());
        this.config.setAlwaysOnTop(this.chatWindow.isAlwaysOnTop());
        this.rememberChatWindowPosition();
        int width = Integer.parseInt(this.widthInput.getText());
        int height = Integer.parseInt(this.heightInput.getText());
        this.config.setWidth(width);
        this.config.setHeight(height);
        this.config.setChromaEnabled(this.chromaEnabledBox.isSelected());
        this.inputToConfigChromaBorders();
        this.config.setChromaCornerRadius(this.chromaCornerSlider.getValue());
        this.config.setChromaInvert(this.chromaInvertBox.isSelected());
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.config.setAlwaysOnTop(alwaysOnTop);
    }

    public void setRememberPosition(boolean rememberPosition) {
        this.config.setRememberPosition(rememberPosition);
    }

    public void setRememberedPosition() {
        if (this.config != null && this.config.isRememberPosition()) {
            int cwpx = this.config.getChatWindowPositionX();
            int cwpy = this.config.getChatWindowPositionY();
            GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int totalWidth = 0;
            int totalHeight = 0;
            GraphicsDevice[] graphicsDeviceArray = devs;
            int n = devs.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice dev = graphicsDeviceArray[n2];
                if (dev.getDisplayMode() != null) {
                    totalWidth += dev.getDisplayMode().getWidth();
                    totalHeight += dev.getDisplayMode().getHeight();
                }
                ++n2;
            }
            totalHeight -= this.chatWindow.getHeight();
            if (cwpx > (totalWidth -= this.chatWindow.getWidth())) {
                cwpx = totalWidth;
            }
            if (cwpy > totalHeight) {
                cwpy = totalHeight;
            }
            if (cwpx < 0) {
                cwpx = 0;
            }
            if (cwpy < 0) {
                cwpy = 0;
            }
            this.chatWindow.setLocation(cwpx, cwpy);
        }
    }

    public void setAntiAlias(boolean antiAlias) {
        this.config.setAntiAlias(antiAlias);
    }
}

