/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class ControlPanelBase
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected String label;
    protected static final Insets DEFAULT_INSETS = new Insets(2, 4, 2, 4);
    protected static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    protected final ChatWindow chatWindow;
    protected final ChatPanel chat;
    protected GridBagConstraints gbc;
    protected FontificatorProperties fProps;
    protected Border baseBorder;
    protected LogBox logBox;

    public static Border getBaseBorder() {
        return BorderFactory.createLineBorder(Color.GRAY);
    }

    public static GridBagConstraints getGbc() {
        return new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, DEFAULT_INSETS, 0, 0);
    }

    public ControlPanelBase(String label, FontificatorProperties fProps, ChatWindow chatWindow, LogBox logBox) {
        this.fProps = fProps;
        this.logBox = logBox;
        this.label = label;
        this.chatWindow = chatWindow;
        this.chat = chatWindow.getChatPanel();
        this.setLayout(new GridBagLayout());
        this.gbc = ControlPanelBase.getGbc();
        this.baseBorder = ControlPanelBase.getBaseBorder();
        this.build();
        this.fillInputFromProperties(fProps);
    }

    public String getLabel() {
        return this.label;
    }

    protected abstract void build();

    protected abstract void fillInputFromProperties(FontificatorProperties var1);

    protected abstract void fillInputFromConfig();

    public void update() {
        LoadConfigReport report = this.validateInput();
        if (report.isErrorFree()) {
            try {
                this.fillConfigFromInput();
                this.chat.repaint();
            }
            catch (Exception ex) {
                ChatWindow.popup.handleProblem("Unexpected Error: " + ex.toString(), ex);
            }
        } else {
            ChatWindow.popup.handleProblem(report);
        }
    }

    protected abstract LoadConfigReport validateInput();

    protected abstract void fillConfigFromInput() throws Exception;
}

