/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.panel;

import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;

public class CollagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CollagePanel.class);
    private ChatPanel chat;
    private Font font;
    private JButton addCaptureButton;
    private JButton remCaptureButton;
    private JCheckBox transparencyBox;
    private JTextField imageLabelInput;
    private JTextArea headerTextInput;
    private JButton saveButton;
    private JButton resetButton;
    private List<BufferedImage> images;
    private JFileChooser collageChooser;
    private JPanel previewPanel;
    private BufferedImage previewImage;
    private static final String TEXT_FONT = "%FONTNAME%";
    private static final String TEXT_BORDER = "%BORDERNAME%";
    private static final String DEFAULT_HEADER_TEXT = "Chat Game Fontificator ~ github.com/GlitchCog/ChatGameFontificator ~ [FREE & OPEN SOURCE]";
    private final Color drawBlockColor = Color.DARK_GRAY;
    private final Color drawTextColor = Color.WHITE;

    public CollagePanel(ChatPanel chat) {
        this.chat = chat;
        this.font = new Font("SansSerif", 0, 14);
        this.collageChooser = new JFileChooser();
        FileNameExtensionFilter pngFileFilter = new FileNameExtensionFilter("PNG Image (*.png)", "png");
        this.collageChooser.setFileFilter(pngFileFilter);
        this.images = new ArrayList<BufferedImage>();
        this.build();
    }

    private void build() {
        this.addCaptureButton = new JButton("+Screenshot");
        this.remCaptureButton = new JButton("Undo");
        this.transparencyBox = new JCheckBox("Image Transparency");
        this.imageLabelInput = new JTextField(TEXT_FONT, 12);
        this.headerTextInput = new JTextArea(DEFAULT_HEADER_TEXT);
        this.headerTextInput.setLineWrap(true);
        this.headerTextInput.setWrapStyleWord(true);
        this.saveButton = new JButton("Save Collage");
        this.resetButton = new JButton("Reset");
        this.previewPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (CollagePanel.this.previewImage != null) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    double zoom = Math.min((double)this.getWidth() / (double)CollagePanel.this.previewImage.getWidth(), (double)this.getHeight() / (double)CollagePanel.this.previewImage.getHeight());
                    int dw = (int)((double)CollagePanel.this.previewImage.getWidth() * zoom);
                    int dh = (int)((double)CollagePanel.this.previewImage.getHeight() * zoom);
                    int dx = (this.getWidth() - dw) / 2;
                    int dy = (this.getHeight() - dh) / 2;
                    g2d.drawImage(CollagePanel.this.previewImage, dx, dy, dx + dw, dy + dh, 0, 0, CollagePanel.this.previewImage.getWidth(), CollagePanel.this.previewImage.getHeight(), null);
                }
            }
        };
        this.addCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollagePanel.this.addCapture();
                CollagePanel.this.refreshPreviewImage();
            }
        });
        this.remCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CollagePanel.this.images.size() > 0) {
                    CollagePanel.this.images.remove(CollagePanel.this.images.size() - 1);
                    CollagePanel.this.refreshPreviewImage();
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage collageImage = CollagePanel.this.generateCollageImage();
                if (collageImage != null) {
                    CollagePanel.this.saveToFile(collageImage);
                }
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollagePanel.this.images.clear();
                CollagePanel.this.refreshPreviewImage();
            }
        });
        this.setBorder(new TitledBorder(ControlPanelBase.getBaseBorder(), "Collage Generator", 2, 2));
        this.setLayout(new GridLayout(1, 3));
        JPanel left = new JPanel(new GridBagLayout());
        GridBagConstraints lgbc = ControlPanelBase.getGbc();
        lgbc.weighty = 0.0;
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints rgbc = ControlPanelBase.getGbc();
        rgbc.weighty = 0.0;
        JPanel addRemPanel = new JPanel(new GridBagLayout());
        GridBagConstraints addRemGbc = ControlPanelBase.getGbc();
        addRemPanel.add((Component)this.addCaptureButton, addRemGbc);
        ++addRemGbc.gridx;
        addRemPanel.add((Component)this.remCaptureButton, addRemGbc);
        ++addRemGbc.gridx;
        JPanel labelPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelGbc = ControlPanelBase.getGbc();
        labelPanel.add((Component)new JLabel("Label:"), labelGbc);
        ++labelGbc.gridx;
        labelGbc.fill = 1;
        labelGbc.weightx = 1.0;
        labelPanel.add((Component)this.imageLabelInput, labelGbc);
        ++labelGbc.gridx;
        lgbc.fill = 2;
        lgbc.anchor = 10;
        lgbc.weightx = 1.0;
        left.add((Component)addRemPanel, lgbc);
        ++lgbc.gridy;
        left.add((Component)labelPanel, lgbc);
        ++lgbc.gridy;
        left.add((Component)this.transparencyBox, lgbc);
        ++lgbc.gridy;
        left.add((Component)this.resetButton, lgbc);
        ++lgbc.gridy;
        lgbc.weighty = 1.0;
        lgbc.fill = 1;
        left.add(new JPanel());
        rgbc.fill = 2;
        rgbc.weightx = 1.0;
        right.add((Component)this.saveButton, rgbc);
        ++rgbc.gridy;
        right.add((Component)new JLabel("Header text:"), rgbc);
        ++rgbc.gridy;
        rgbc.weighty = 1.0;
        rgbc.fill = 1;
        right.add((Component)new JScrollPane(this.headerTextInput, 20, 31), rgbc);
        ++rgbc.gridy;
        this.add(left);
        this.add(this.previewPanel);
        this.add(right);
    }

    private void refreshPreviewImage() {
        this.previewImage = this.generateCollageImage();
        this.previewPanel.repaint();
    }

    private void addCapture() {
        String imageText = this.getImageText();
        int labelHeight = imageText.isEmpty() ? 0 : 24;
        int width = this.chat.getWidth();
        int height = this.chat.getHeight() + labelHeight;
        BufferedImage chatImage = new BufferedImage(width, height, this.transparencyBox.isSelected() ? 2 : 1);
        Graphics chatGraphics = chatImage.getGraphics();
        this.chat.paint(chatGraphics);
        if (!imageText.isEmpty()) {
            try {
                chatGraphics.setColor(this.drawBlockColor);
                chatGraphics.fillRect(1, this.chat.getHeight(), width - 2, labelHeight - 1);
                chatGraphics.setColor(this.drawTextColor);
                chatGraphics.setFont(this.font);
                chatGraphics.drawString(imageText, 6, height - 8);
            }
            catch (Exception e) {
                logger.error("Unable to write text to image", e);
            }
        }
        this.images.add(chatImage);
    }

    private String getImageText() {
        String text = this.imageLabelInput.getText();
        text = text.replaceAll(TEXT_FONT, this.chat.getFontGameName());
        text = text.replaceAll(TEXT_BORDER, this.chat.getBorderGameName());
        return text;
    }

    private BufferedImage generateCollageImage() {
        if (this.images == null || this.images.isEmpty()) {
            return null;
        }
        int headerHeight = this.headerTextInput.getText().isEmpty() ? 0 : 24;
        int maxWidth = 0;
        int maxHeight = 0;
        for (BufferedImage bi : this.images) {
            maxWidth = Math.max(maxWidth, bi.getWidth());
            maxHeight = Math.max(maxHeight, bi.getHeight());
        }
        int gridWidth = (int)Math.ceil(Math.sqrt(this.images.size()));
        int gridHeight = (int)Math.ceil((double)this.images.size() / (double)gridWidth);
        BufferedImage collageImage = new BufferedImage(maxWidth * gridWidth, maxHeight * gridHeight + headerHeight, 1);
        Graphics2D collageGraphics = (Graphics2D)collageImage.getGraphics();
        collageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        collageGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int i = 0;
        while (i < this.images.size()) {
            int x = i % gridWidth;
            int y = i / gridWidth;
            int offsetX = (maxWidth - this.images.get(i).getWidth()) / 2;
            int offsetY = (maxHeight - this.images.get(i).getHeight()) / 2 + headerHeight;
            collageGraphics.drawImage((Image)this.images.get(i), x * maxWidth + offsetX, y * maxHeight + offsetY, null);
            ++i;
        }
        if (!this.headerTextInput.getText().isEmpty()) {
            collageGraphics.setColor(this.drawBlockColor);
            collageGraphics.fillRect(0, 0, collageImage.getWidth(), headerHeight);
            collageGraphics.setColor(this.drawTextColor);
            collageGraphics.drawString(this.headerTextInput.getText(), 3, 16);
        }
        return collageImage;
    }

    private boolean saveToFile(BufferedImage collageImage) {
        File saveFile = ControlWindow.getTargetSaveFile(this.collageChooser, "png");
        if (saveFile != null && collageImage != null) {
            try {
                ImageIO.write((RenderedImage)collageImage, "png", saveFile);
                return true;
            }
            catch (Exception e) {
                logger.error("Unable to save collage", e);
                return false;
            }
        }
        return false;
    }
}

