/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.messages;

import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.LabeledInput;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class MessagePostPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel manualInfo;
    private LabeledInput usernameInput;
    private LabeledInput textInput;
    private JCheckBox retainMessageBox;
    private JButton submitButton;
    private JButton clearButton;
    private ControlWindow ctrlWindow;

    public MessagePostPanel(ControlWindow ctrlWindow) {
        this.ctrlWindow = ctrlWindow;
        this.build();
    }

    private void build() {
        this.setBorder(new TitledBorder(ControlPanelBase.getBaseBorder(), "Manually Post Message to Chat", 2, 2));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.manualInfo = new JLabel("This message will be posted to the visualization only; it will not be sent to the IRC channel.");
        this.usernameInput = new LabeledInput("Username", 8);
        this.textInput = new LabeledInput("Message", 32);
        this.textInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessagePostPanel.this.submit();
            }
        });
        this.retainMessageBox = new JCheckBox("Retain message input after post");
        this.submitButton = new JButton("Post");
        this.clearButton = new JButton("Clear");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                if (MessagePostPanel.this.submitButton.equals(source)) {
                    MessagePostPanel.this.submit();
                } else if (MessagePostPanel.this.clearButton.equals(source)) {
                    MessagePostPanel.this.reset();
                }
            }
        };
        this.submitButton.addActionListener(al);
        this.clearButton.addActionListener(al);
        this.add((Component)this.manualInfo, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.usernameInput, gbc);
        ++gbc.gridx;
        this.add((Component)this.textInput, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, gbc);
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        buttonPanel.add((Component)this.retainMessageBox, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        buttonPanel.add((Component)this.submitButton, gbc);
        ++gbc.gridx;
        buttonPanel.add((Component)this.clearButton, gbc);
    }

    private void reset() {
        this.usernameInput.setText("");
        this.textInput.setText("");
    }

    public void submit() {
        List<String> report = this.validateInput();
        if (report.isEmpty()) {
            this.ctrlWindow.addManualMessage(this.usernameInput.getText(), this.textInput.getText());
            if (!this.retainMessageBox.isSelected()) {
                this.reset();
            }
        } else {
            ChatWindow.popup.handleProblem(report);
        }
    }

    private List<String> validateInput() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.usernameInput.getText().isEmpty()) {
            errors.add("Please enter a username under which to post");
        }
        if (this.textInput.getText().isEmpty()) {
            errors.add("Please enter a message to post");
        }
        return errors;
    }
}

