/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.messages;

import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.messages.MessagePostPanel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.glitchcog.fontificator.gui.controls.panel.MessageCensorPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;

public class MessageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessagePostPanel postPanel;
    private MessageCensorPanel censorPanel;

    public MessageDialog(FontificatorProperties fProps, ChatWindow chatWindow, ControlWindow ctrlWindow, LogBox logBox) {
        super(chatWindow);
        ChatWindow.setupHideOnEscape(this);
        this.setDefaultCloseOperation(1);
        this.build(fProps, chatWindow, ctrlWindow, logBox);
    }

    private void build(FontificatorProperties fProps, ChatWindow chatWindow, ControlWindow ctrlWindow, LogBox logBox) {
        this.setTitle("Message Management");
        this.postPanel = new MessagePostPanel(ctrlWindow);
        this.censorPanel = new MessageCensorPanel(fProps, chatWindow, ctrlWindow, logBox);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.censorPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)this.postPanel, gbc);
        ++gbc.gridy;
        this.setSize(700, 500);
        this.setMinimumSize(this.getSize());
        this.setSize(700, 700);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public MessageCensorPanel getCensorPanel() {
        return this.censorPanel;
    }
}

