/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.messages;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.messages.MessageCheckList;
import javax.swing.table.DefaultTableModel;

public class MessageCheckListModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final int TOGGLE_COLUMN_INDEX = 4;
    private static final String[] HEADER = new String[]{"Timestamp", "User", "Message", "Offense", "Censored"};
    private ChatPanel chat;
    private MessageCheckList list;

    public MessageCheckListModel(ChatPanel chat, MessageCheckList list) {
        this.chat = chat;
        this.list = list;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 4 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4;
    }

    @Override
    public int getRowCount() {
        return this.chat == null ? 0 : this.chat.getMessageQueue().size();
    }

    @Override
    public int getColumnCount() {
        return HEADER.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return HEADER[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Message[] messages = this.getMessages();
        Message msg = messages[messages.length - rowIndex - 1];
        if (columnIndex == 0) {
            return msg.getTimestamp();
        }
        if (columnIndex == 1) {
            return msg.getUsername();
        }
        if (columnIndex == 2) {
            return msg.getContent();
        }
        if (columnIndex == 3) {
            return msg.getCensoredReason();
        }
        if (columnIndex == 4) {
            return msg.isCensored();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            Message[] messages = this.getMessages();
            Message msg = messages[messages.length - rowIndex - 1];
            msg.setCensored((Boolean)(aValue == null ? Boolean.valueOf(false) : aValue), this.chat.isCensorshipEnabled());
            msg.setManualCensorship(true);
            this.list.revalidateTable();
            this.chat.repaint();
            this.chat.initMessageRollout();
        }
    }

    private Message[] getMessages() {
        return this.chat.getMessageQueue().toArray(new Message[this.chat.getMessageQueue().size()]);
    }
}

