/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls.messages;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.messages.MessageCheckListModel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.MessageCensorPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class MessageCheckList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable messageTable;
    private TableModel model;
    private JButton undoPurge;
    private JButton undoManualCensorship;

    public MessageCheckList(ChatPanel chat, final MessageCensorPanel censorPanel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        this.undoPurge = new JButton("Undo Purge");
        this.undoPurge.setToolTipText("Adds purged messages from a Twitch ban or timeout back into chat");
        this.undoPurge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                censorPanel.undoPurge();
            }
        });
        this.undoManualCensorship = new JButton("Reapply Rules");
        this.undoManualCensorship.setToolTipText("Undoes any manual censoring or uncensoring done with the checkboxes");
        this.undoManualCensorship.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                censorPanel.recheckCensorship(true);
            }
        });
        this.model = new MessageCheckListModel(chat, this);
        this.messageTable = new JTable(this.model);
        this.messageTable.setAutoResizeMode(4);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        this.add((Component)new JLabel("Manually toggle message censorship:"), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)this.undoManualCensorship, gbc);
        ++gbc.gridx;
        this.add((Component)this.undoPurge, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)new JScrollPane(this.messageTable, 20, 31), gbc);
        ++gbc.gridy;
    }

    public void addMessage(Message msg) {
        int row = 0;
        this.model.setValueAt(msg.getTimestamp(), row, 1);
        this.model.setValueAt(msg.getUsername(), row, 2);
        this.model.setValueAt(msg.getContent(), row, 3);
        this.model.setValueAt("", row, 4);
        this.model.setValueAt(Boolean.FALSE, row, 5);
    }

    public void revalidateTable() {
        this.messageTable.revalidate();
        this.messageTable.repaint();
    }
}

