/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.controls;

import com.glitchcog.fontificator.bot.ChatViewerBot;
import com.glitchcog.fontificator.bot.MessageType;
import com.glitchcog.fontificator.bot.TwitchPrivmsg;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.AssetIndexLoader;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.component.MenuComponent;
import com.glitchcog.fontificator.gui.controls.ScreenshotOptions;
import com.glitchcog.fontificator.gui.controls.messages.MessageDialog;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelDebug;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelFont;
import com.glitchcog.fontificator.gui.controls.panel.ControlTabs;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;

public class ControlWindow
extends JDialog {
    private static final Logger logger = Logger.getLogger(ControlWindow.class);
    private static final long serialVersionUID = 1L;
    private final String DEFAULT_CONFIG_FILE_EXTENSION = "cgf";
    private final String DEFAULT_SCREENSHOT_FILE_EXTENSION = "png";
    private ControlTabs controlTabs;
    private ChatViewerBot bot;
    private ChatWindow chatWindow;
    private MessageDialog messageDialog;
    private FontificatorProperties fProps;
    private JEditorPane aboutPane;
    private static String ABOUT_CONTENTS = "<html><table bgcolor=#EEEEEE width=100% border=1><tr><td><center><font face=\"Arial, Helvetica\"><b>Chat Game Fontificator</b> is a Twitch chat display that makes<br />the chat look like the text boxes from various video games.<br /><br />It is free, open source, and in the public domain to the furthest<br />extent I am permitted to forfeit my copyright over this software.<br /><br />Please enjoy!<br /><br />By Matt Yanos<br /><br /><a href=\"www.github.com/GlitchCog/ChatGameFontificator\">www.github.com/GlitchCog/ChatGameFontificator</a></font></center></td></tr></table></html>";
    private String helpText;
    public static ControlWindow me;
    private JDialog help;
    private JFileChooser opener;
    private JFileChooser configSaver;
    private JFileChooser screenshotSaver;
    private ScreenshotOptions screenshotOptions;

    public ControlWindow(JFrame parent, FontificatorProperties fProps, LogBox logBox) {
        block15: {
            super(parent);
            this.DEFAULT_CONFIG_FILE_EXTENSION = "cgf";
            this.DEFAULT_SCREENSHOT_FILE_EXTENSION = "png";
            BufferedReader br = null;
            try {
                try {
                    String line;
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("help.html");
                    br = new BufferedReader(new InputStreamReader(is));
                    StringBuilder helpBuilder = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        helpBuilder.append(line);
                    }
                    this.helpText = helpBuilder.toString();
                }
                catch (Exception e) {
                    this.helpText = "Unable to load help file";
                    logger.error(this.helpText, e);
                    ChatWindow.popup.handleProblem(this.helpText);
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception e2) {
                            logger.error(e2.toString(), e2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        logger.error(e.toString(), e);
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error(e.toString(), e);
                }
            }
        }
        me = this;
        this.setTitle("Fontificator Configuration");
        this.setDefaultCloseOperation(1);
        this.fProps = fProps;
        FileNameExtensionFilter cgfFileFilter = new FileNameExtensionFilter("Chat Game Fontificator Configuration (*.cgf)", "cgf".toLowerCase());
        FileNameExtensionFilter pngFileFilter = new FileNameExtensionFilter("PNG Image (*.png)", "png".toLowerCase());
        this.opener = new JFileChooser();
        this.opener.setFileFilter(cgfFileFilter);
        this.configSaver = new JFileChooser();
        this.configSaver.setFileFilter(cgfFileFilter);
        this.screenshotOptions = new ScreenshotOptions();
        this.screenshotSaver = new JFileChooser();
        this.screenshotSaver.setFileFilter(pngFileFilter);
        this.screenshotSaver.setAccessory(this.screenshotOptions);
    }

    public void loadLastData(ChatWindow chatWindow) {
        this.chatWindow = chatWindow;
        ChatWindow.setupHideOnEscape(this);
        LoadConfigReport report = new LoadConfigReport();
        this.fProps.clear();
        try {
            File lastDirectory;
            report = this.fProps.loadLast();
            if (report.getDirectory() != null && (lastDirectory = new File(report.getDirectory())).exists() && lastDirectory.isDirectory()) {
                this.opener.setCurrentDirectory(lastDirectory);
                this.configSaver.setCurrentDirectory(lastDirectory);
            }
        }
        catch (Exception e) {
            String errorMsg = "Unknown error loading last config file";
            logger.error("Unknown error loading last config file", e);
            report.addError("Unknown error loading last config file", LoadConfigErrorType.UNKNOWN_ERROR);
        }
        if (!report.isErrorFree()) {
            boolean overwriteExistingValues = report.isProblem();
            if (overwriteExistingValues) {
                this.fProps.forgetLastConfigFile();
            }
            this.fProps.loadDefaultValues(overwriteExistingValues);
        }
    }

    public void build(LogBox logBox) {
        this.constructAboutPopup();
        this.messageDialog = new MessageDialog(this.fProps, this.chatWindow, this, logBox);
        this.bot = new ChatViewerBot();
        this.bot.setUsername(this.fProps.getIrcConfig().getUsername());
        this.controlTabs = new ControlTabs(this.fProps, this.bot, this.messageDialog.getCensorPanel(), logBox);
        this.controlTabs.build(this.chatWindow, this);
        this.bot.setChatPanel(this.chatWindow.getChatPanel());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.controlTabs);
        this.initMenus();
        this.setAlwaysOnTopMenu(this.fProps.getChatConfig().isAlwaysOnTop());
        this.setRememberPositionMenu(this.fProps.getChatConfig().isRememberPosition());
        this.setAntiAliasMenu(this.fProps.getChatConfig().isAntiAlias());
        this.setupHelp();
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
    }

    private void setupHelp() {
        String helpTitle = "Chat Game Fontificator Help";
        this.help = new JDialog((Dialog)this, true);
        this.help.setTitle("Chat Game Fontificator Help");
        this.help.setSize(640, 480);
        this.help.setLayout(new GridBagLayout());
        JEditorPane helpPane = new JEditorPane();
        helpPane.setContentType("text/html");
        helpPane.setText(this.helpText);
        helpPane.setEditable(false);
        JScrollPane scrollHelp = new JScrollPane(helpPane, 22, 31);
        JButton ok = new JButton("Close");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlWindow.this.help.setVisible(false);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 11;
        this.help.add((Component)new JLabel("The function of each option available in the Control Window tabs is explained below"), gbc);
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        this.help.add((Component)scrollHelp, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.weighty = 0.0;
        this.help.add((Component)ok, gbc);
        this.help.setResizable(false);
    }

    private void initMenus() {
        JMenuBar menuBar = new JMenuBar();
        String[] mainMenuText = new String[]{"File", "Presets", "View", "Message", "Help"};
        int[] mainMnomonics = new int[]{70, 80, 86, 77, 72};
        JMenu[] menus = new JMenu[mainMenuText.length];
        int i = 0;
        while (i < mainMenuText.length) {
            menus[i] = new JMenu(mainMenuText[i]);
            menus[i].setMnemonic(mainMnomonics[i]);
            ++i;
        }
        String strFileOpen = "Open Configuration";
        String strFileSave = "Save Configuration";
        String strFileRestore = "Restore Default Configuration";
        String strScreenshot = "Screenshot";
        String strFileExit = "Exit";
        MenuComponent[] fileComponents = new MenuComponent[]{new MenuComponent("Open Configuration", 79, KeyStroke.getKeyStroke(79, 2)), new MenuComponent("Save Configuration", 83, KeyStroke.getKeyStroke(83, 2)), new MenuComponent("Restore Default Configuration", 82, null), new MenuComponent("Screenshot", 67, KeyStroke.getKeyStroke(119, 0)), new MenuComponent("Exit", 88, KeyStroke.getKeyStroke(81, 2))};
        String strAntiAlias = "Anti-Aliased";
        String strViewTop = "Always On Top";
        String strRememberPos = "Remember Chat Window Position";
        String strViewHide = "Hide Control Window";
        MenuComponent[] menuComponentArray = new MenuComponent[5];
        menuComponentArray[0] = new MenuComponent("Anti-Aliased", 65, null, true);
        menuComponentArray[2] = new MenuComponent("Always On Top", 84, null, true);
        menuComponentArray[3] = new MenuComponent("Remember Chat Window Position", 80, null, true);
        menuComponentArray[4] = new MenuComponent("Hide Control Window", 72, KeyStroke.getKeyStroke(72, 2));
        MenuComponent[] viewComponents = menuComponentArray;
        String strMsgMsg = "Message Management";
        MenuComponent[] messageComponents = new MenuComponent[]{new MenuComponent("Message Management", 77, KeyStroke.getKeyStroke(77, 2))};
        String strHelpHelp = "Help";
        String strHelpDebug = "Debug Mode";
        String strHelpAbout = "About";
        MenuComponent[] menuComponentArray2 = new MenuComponent[4];
        menuComponentArray2[0] = new MenuComponent("Help", 82, null);
        menuComponentArray2[1] = new MenuComponent("Debug Mode", 68, null, true);
        menuComponentArray2[3] = new MenuComponent("About", 65, null);
        MenuComponent[] helpComponents = menuComponentArray2;
        MenuComponent[][] allMenuComponents = new MenuComponent[][]{fileComponents, new MenuComponent[0], viewComponents, messageComponents, helpComponents};
        ActionListener mal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                if ("Open Configuration".equals(mi.getText())) {
                    ControlWindow.this.open();
                } else if ("Save Configuration".equals(mi.getText())) {
                    ControlWindow.this.saveConfig();
                } else if ("Restore Default Configuration".equals(mi.getText())) {
                    ControlWindow.this.restoreDefaults(true);
                    ControlWindow.this.controlTabs.refreshUiFromConfig(ControlWindow.this.fProps);
                } else if ("Screenshot".equals(mi.getText())) {
                    ControlWindow.this.saveScreenshot();
                } else if ("Exit".equals(mi.getText())) {
                    ControlWindow.this.attemptToExit();
                } else if ("Anti-Aliased".equals(mi.getText())) {
                    JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)e.getSource();
                    ControlWindow.this.controlTabs.setAntiAlias(checkBox.isSelected());
                    ControlWindow.this.chatWindow.getChatPanel().repaint();
                } else if ("Always On Top".equals(mi.getText())) {
                    JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)e.getSource();
                    ((JFrame)ControlWindow.this.getParent()).setAlwaysOnTop(checkBox.isSelected());
                    ControlWindow.this.controlTabs.setAlwaysOnTopConfig(checkBox.isSelected());
                } else if ("Remember Chat Window Position".equals(mi.getText())) {
                    JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)e.getSource();
                    ControlWindow.this.controlTabs.setRememberChatWindowPosition(checkBox.isSelected());
                    if (checkBox.isSelected()) {
                        int sx = (int)ControlWindow.this.chatWindow.getLocationOnScreen().getX();
                        int sy = (int)ControlWindow.this.chatWindow.getLocationOnScreen().getY();
                        ControlWindow.this.fProps.getChatConfig().setChatWindowPositionX(sx);
                        ControlWindow.this.fProps.getChatConfig().setChatWindowPositionY(sy);
                    }
                } else if ("Hide Control Window".equals(mi.getText())) {
                    ControlWindow.this.setVisible(false);
                } else if ("Message Management".equals(mi.getText())) {
                    ControlWindow.this.messageDialog.showDialog();
                } else if ("Help".equals(mi.getText())) {
                    ControlWindow.this.help.setVisible(true);
                } else if ("Debug Mode".equals(mi.getText())) {
                    ControlWindow.this.toggleDebugTab();
                } else if ("About".equals(mi.getText())) {
                    ControlWindow.this.showAboutPane();
                }
            }
        };
        JMenuItem item = null;
        int i2 = 0;
        while (i2 < allMenuComponents.length) {
            int j = 0;
            while (j < allMenuComponents[i2].length) {
                MenuComponent mc = allMenuComponents[i2][j];
                if (mc == null) {
                    menus[i2].add(new JSeparator());
                } else {
                    item = mc.checkbox ? new JCheckBoxMenuItem(mc.label) : new JMenuItem(mc.label);
                    item.addActionListener(mal);
                    item.setMnemonic(mc.mnemonic);
                    if (mc.accelerator != null) {
                        item.setAccelerator(mc.accelerator);
                    }
                    menus[i2].add(item);
                }
                ++j;
            }
            menuBar.add(menus[i2]);
            ++i2;
        }
        Map<String, List<String[]>> presetMapSubmenuToItem = AssetIndexLoader.loadPresets();
        final ArrayList<String[]> allPresets = new ArrayList<String[]>();
        for (String key : presetMapSubmenuToItem.keySet()) {
            for (String[] value : presetMapSubmenuToItem.get(key)) {
                allPresets.add(value);
            }
        }
        ActionListener presetListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sourceText = ((JMenuItem)e.getSource()).getText();
                for (String[] presets : allPresets) {
                    if (!presets[0].equals(sourceText)) continue;
                    ControlWindow.this.loadPreset(presets[0], presets[1]);
                    break;
                }
            }
        };
        for (String submenuKey : presetMapSubmenuToItem.keySet()) {
            List<String[]> submenuItems = presetMapSubmenuToItem.get(submenuKey);
            if (submenuKey != null) {
                JMenu submenu = new JMenu(submenuKey);
                for (String[] itemAndFilename : submenuItems) {
                    JMenuItem submenuItem = new JMenuItem(itemAndFilename[0]);
                    submenuItem.addActionListener(presetListener);
                    submenu.add(submenuItem);
                }
                menus[1].add(submenu);
                continue;
            }
            for (String[] submenuRootItemAndFilename : submenuItems) {
                JMenuItem submenuRootItem = new JMenuItem(submenuRootItemAndFilename[0]);
                submenuRootItem.addActionListener(presetListener);
                menus[1].add(submenuRootItem);
            }
        }
        int i3 = 0;
        while (i3 < menus.length) {
            menuBar.add(menus[i3]);
            ++i3;
        }
        this.setJMenuBar(menuBar);
    }

    private void restoreDefaults(boolean overrideExistingValues) {
        int result;
        boolean okayToProceed = this.fProps.checkForUnsavedProps(this, this);
        if (okayToProceed && (result = JOptionPane.showConfirmDialog(this, "Reset to default configuration?", "Confirm", 0)) == 0) {
            this.fProps.loadDefaultValues(overrideExistingValues);
            this.controlTabs.refreshUiFromConfig(this.fProps);
            this.chatWindow.getChatPanel().repaint();
        }
    }

    private void open() {
        int result;
        boolean okayToProceed = this.fProps.checkForUnsavedProps(this, this);
        if (okayToProceed && (result = this.opener.showOpenDialog(me)) == 0) {
            try {
                LoadConfigReport report = this.fProps.loadFile(this.opener.getSelectedFile());
                if (report.isProblem()) {
                    throw new Exception("Configuration file open error");
                }
                this.controlTabs.refreshUiFromConfig(this.fProps);
                this.chatWindow.getChatPanel().repaint();
            }
            catch (Exception ex) {
                String errorMsg = "Unable to open file " + (this.opener.getSelectedFile() == null ? "null" : this.opener.getSelectedFile().getName());
                logger.error(errorMsg, ex);
                ChatWindow.popup.handleProblem(errorMsg);
            }
        }
    }

    private void loadPreset(String presetName, String presetFilename) {
        boolean okayToProceed = this.fProps.checkForUnsavedProps(this, this);
        if (okayToProceed) {
            try {
                LoadConfigReport report = this.fProps.loadFile(presetFilename);
                if (report.isProblem()) {
                    logger.error("Unsuccessful call to FontificatorProperties.loadFile(String)");
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                logger.error(ex.toString(), ex);
                ChatWindow.popup.handleProblem("Unable to load preset " + presetName + " (" + presetFilename + ")");
            }
            this.controlTabs.refreshUiFromConfig(this.fProps);
            this.chatWindow.getChatPanel().repaint();
        }
    }

    public static File getTargetSaveFile(JFileChooser chooser, String extension) {
        int overwrite = 0;
        do {
            int result = chooser.showSaveDialog(me);
            overwrite = 0;
            if (result != 0) continue;
            File saveFile = chooser.getSelectedFile();
            if (chooser.getFileFilter() instanceof FileNameExtensionFilter) {
                String[] exts = ((FileNameExtensionFilter)chooser.getFileFilter()).getExtensions();
                boolean endsInExt = false;
                String[] stringArray = exts;
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (saveFile.getName().toLowerCase().endsWith(ext.toLowerCase())) {
                        endsInExt = true;
                        break;
                    }
                    ++n2;
                }
                if (extension != null && !endsInExt) {
                    saveFile = new File(String.valueOf(saveFile.getPath()) + "." + extension);
                }
            }
            if (saveFile.exists()) {
                overwrite = JOptionPane.showConfirmDialog(me, "File " + saveFile.getName() + " already exists. Overwrite?", "Overwrite?", 1, 3);
            }
            if (overwrite != 0) continue;
            return saveFile;
        } while (overwrite == true);
        return null;
    }

    public boolean saveConfig() {
        boolean configReadyToSave = this.controlTabs.refreshConfigFromUi();
        File saveFile = null;
        if (configReadyToSave) {
            saveFile = ControlWindow.getTargetSaveFile(this.configSaver, "cgf");
        }
        if (saveFile != null) {
            try {
                this.fProps.saveFile(saveFile);
                return true;
            }
            catch (Exception ex) {
                logger.error("Configuration file save error", ex);
                return false;
            }
        }
        return false;
    }

    private boolean saveScreenshot() {
        File saveFile;
        ChatPanel chat = this.chatWindow.getChatPanel();
        BufferedImage chatImage = new BufferedImage(chat.getWidth(), chat.getHeight(), this.screenshotOptions.isTransparencyEnabled() ? 2 : 1);
        Graphics chatGraphics = chatImage.getGraphics();
        chat.paint(chatGraphics);
        boolean chromaEnabled = Boolean.toString(true).equalsIgnoreCase(this.fProps.getProperty("chromaEnabled"));
        if (this.screenshotOptions.isTransparencyEnabled() && chromaEnabled) {
            int chromaKey = new Color(Integer.parseInt(this.fProps.getProperty("chromaKey"), 16)).getRGB();
            int transparentPixel = new Color(0, true).getRGB();
            int r = 0;
            while (r < chatImage.getHeight()) {
                int c = 0;
                while (c < chatImage.getWidth()) {
                    if (chatImage.getRGB(c, r) == chromaKey) {
                        chatImage.setRGB(c, r, transparentPixel);
                    }
                    ++c;
                }
                ++r;
            }
        }
        if ((saveFile = ControlWindow.getTargetSaveFile(this.screenshotSaver, "png")) != null) {
            try {
                if (this.screenshotOptions.isMetadataEnabled()) {
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("PNG").next();
                    ImageOutputStream stream = ImageIO.createImageOutputStream(saveFile);
                    writer.setOutput(stream);
                    IIOMetadata metadata = writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(chatImage), writer.getDefaultWriteParam());
                    IIOMetadataNode title = this.generateMetadataNode("Title", "CGF Screenshot");
                    IIOMetadataNode software = this.generateMetadataNode("Software", "Chat Game Fontificator");
                    String fontGameName = ControlPanelFont.getFontGameName(this.fProps.getProperty("fontFile"));
                    String borderGameName = ControlPanelFont.getBorderGameName(this.fProps.getProperty("fontBorderFile"));
                    IIOMetadataNode description = this.generateMetadataNode("Description", String.valueOf(fontGameName) + " Font / " + borderGameName + " Border");
                    IIOMetadataNode text = new IIOMetadataNode("tEXt");
                    text.appendChild(title);
                    text.appendChild(software);
                    text.appendChild(description);
                    String metadataFormatStr = "javax_imageio_png_1.0";
                    IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
                    root.appendChild(text);
                    metadata.mergeTree("javax_imageio_png_1.0", root);
                    writer.write(metadata, new IIOImage(chatImage, null, metadata), writer.getDefaultWriteParam());
                    stream.close();
                } else {
                    ImageIO.write((RenderedImage)chatImage, "png", saveFile);
                }
                return true;
            }
            catch (Exception e) {
                logger.error("Unable to save screenshot", e);
                return false;
            }
        }
        return false;
    }

    private IIOMetadataNode generateMetadataNode(String key, String value) {
        IIOMetadataNode node = new IIOMetadataNode("tEXtEntry");
        node.setAttribute("keyword", key);
        node.setAttribute("value", value);
        return node;
    }

    public void setAlwaysOnTopMenu(boolean alwaysOnTop) {
        ((JCheckBoxMenuItem)this.getJMenuBar().getMenu(2).getItem(2)).setSelected(alwaysOnTop);
    }

    public void setRememberPositionMenu(boolean rememberPosition) {
        ((JCheckBoxMenuItem)this.getJMenuBar().getMenu(2).getItem(3)).setSelected(rememberPosition);
    }

    public void setAntiAliasMenu(boolean antiAlias) {
        ((JCheckBoxMenuItem)this.getJMenuBar().getMenu(2).getItem(0)).setSelected(antiAlias);
    }

    public void clearUsernameCases() {
        this.bot.clearUsernameCases();
    }

    public void addManualMessage(String username, String message) {
        this.bot.sendMessageToChat(MessageType.MANUAL, message, new TwitchPrivmsg(username));
    }

    public void disconnect() {
        this.bot.disconnect();
    }

    public void attemptToExit() {
        this.attemptToExit(this);
    }

    public void attemptToExit(Component parent) {
        boolean okayToProceed = this.fProps.checkForUnsavedProps(this, parent);
        if (okayToProceed) {
            this.disconnect();
            System.exit(0);
        }
    }

    private void constructAboutPopup() {
        this.aboutPane = new JEditorPane("text/html", ABOUT_CONTENTS);
        this.aboutPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(URI.create("https://" + e.getDescription()));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.aboutPane.setEditable(false);
    }

    private void toggleDebugTab() {
        this.controlTabs.toggleDebugTab();
    }

    private void showAboutPane() {
        JOptionPane.showMessageDialog(this, this.aboutPane, "About", -1);
    }

    public MessageDialog getMessageDialog() {
        return this.messageDialog;
    }

    public void loadAfterInit() {
        this.controlTabs.setChatWindowPosition();
    }

    public ControlPanelDebug getDebugPanel() {
        return this.controlTabs.getDebugTab();
    }
}

