/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component.palette;

import com.glitchcog.fontificator.gui.component.palette.ColorSwatch;
import com.glitchcog.fontificator.gui.component.palette.DashTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SwatchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<ColorSwatch> swatches;
    private MouseListener ml;
    private GridBagConstraints gbc;
    private DashTimer dashTimer;

    public SwatchPanel(Color bgColor) {
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.dashTimer = new DashTimer(this);
        this.ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ColorSwatch source = (ColorSwatch)e.getSource();
                source.toggleSelected();
                if (SwatchPanel.this.anySwatchesSelected()) {
                    SwatchPanel.this.dashTimer.start();
                } else {
                    SwatchPanel.this.dashTimer.stop();
                }
                SwatchPanel.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.swatches = new ArrayList<ColorSwatch>();
        this.setBackground(bgColor);
        Color borderColor = bgColor.darker();
        if (borderColor.equals(bgColor)) {
            borderColor = bgColor.brighter();
        }
        this.setBorder(BorderFactory.createLineBorder(borderColor));
    }

    private boolean anySwatchesSelected() {
        for (ColorSwatch swatch : this.swatches) {
            if (!swatch.isSelected()) continue;
            return true;
        }
        return false;
    }

    public List<Color> getColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (ColorSwatch swatch : this.swatches) {
            colors.add(swatch.getColor());
        }
        return colors;
    }

    public void clearSelection() {
        for (ColorSwatch swatch : this.swatches) {
            swatch.setSelected(false);
        }
        this.dashTimer.stop();
        this.repaint();
    }

    public void addColor(Color addition) {
        this.clearSelection();
        ColorSwatch swatch = new ColorSwatch(addition, this.dashTimer, this.ml);
        this.swatches.add(swatch);
        this.gbc.gridx = this.getCount();
        this.add((Component)swatch, this.gbc);
    }

    public void removeSelectedColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (ColorSwatch swatch : this.swatches) {
            if (swatch.isSelected()) continue;
            colors.add(swatch.getColor());
        }
        this.swatches.clear();
        this.removeAll();
        for (Color color : colors) {
            this.addColor(color);
        }
    }

    public boolean isEmpty() {
        return this.swatches.isEmpty();
    }

    public int getCount() {
        return this.swatches == null ? 0 : this.swatches.size();
    }

    public void clear() {
        this.clearSelection();
        this.swatches.clear();
        this.removeAll();
        this.validate();
        this.repaint();
    }
}

