/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component.palette;

import com.glitchcog.fontificator.gui.component.palette.SwatchPanel;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Palette
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JButton buttonAdd;
    private JButton buttonRem;
    private SwatchPanel swatchPanel;
    private JScrollPane paletteScrollPane;
    private final ControlPanelBase control;

    public Palette(Color bgColor, ControlPanelBase controlPanel) {
        this(null, bgColor, controlPanel);
    }

    public Palette(final String label, Color bgColor, ControlPanelBase controlPanel) {
        super(new GridBagLayout());
        this.control = controlPanel;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.buttonAdd = new JButton("+");
        this.buttonRem = new JButton("-");
        if (label != null) {
            this.label = new JLabel(label);
        }
        this.swatchPanel = new SwatchPanel(bgColor);
        gbc.weightx = 0.0;
        if (label != null) {
            gbc.gridheight = 2;
            this.add((Component)this.label, gbc);
            ++gbc.gridx;
        }
        gbc.gridheight = 1;
        this.add((Component)this.buttonAdd, gbc);
        ++gbc.gridy;
        this.add((Component)this.buttonRem, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.gridheight = 2;
        this.paletteScrollPane = new JScrollPane(this.swatchPanel, 21, 30);
        this.paletteScrollPane.setPreferredSize(new Dimension(512, this.getHeight()));
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.anchor = 13;
        this.add((Component)this.paletteScrollPane, gbc);
        ++gbc.gridx;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                if (source == Palette.this.buttonAdd) {
                    Color c = JColorChooser.showDialog(ControlWindow.me, "Add Color to Palette" + (label == null ? "" : " for " + label), Palette.this.swatchPanel.isEmpty() ? null : Palette.this.swatchPanel.getColors().get(Palette.this.swatchPanel.getCount() - 1));
                    if (c != null) {
                        Palette.this.addColor(c);
                        Palette.this.control.update();
                        Palette.this.validate();
                        Palette.this.repaint();
                    }
                } else if (source == Palette.this.buttonRem) {
                    Palette.this.swatchPanel.removeSelectedColors();
                    Palette.this.control.update();
                    Palette.this.validate();
                    Palette.this.repaint();
                }
            }
        };
        this.buttonAdd.addActionListener(al);
        this.buttonRem.addActionListener(al);
    }

    public List<Color> getColors() {
        return this.swatchPanel.getColors();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setBgColor(Color bgColor) {
        this.swatchPanel.setBackground(bgColor);
    }

    public void addColor(Color col) {
        this.swatchPanel.addColor(col);
    }

    public void reset() {
        this.swatchPanel.clear();
    }

    public void refreshComponents() {
        this.swatchPanel.validate();
        this.swatchPanel.repaint();
    }
}

