/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component.palette;

import com.glitchcog.fontificator.gui.component.palette.DashTimer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ColorSwatch
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int BORDER_THICKNESS = 2;
    private DashTimer dashTimer;
    private boolean selected;
    private static final Border BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.WHITE, 2), BorderFactory.createLineBorder(Color.BLACK, 2));

    public ColorSwatch(Color color, DashTimer dashTimer, MouseListener ml) {
        this.dashTimer = dashTimer;
        this.setBackground(color);
        this.setBorder(BORDER);
        this.addMouseListener(ml);
    }

    public Color getColor() {
        return this.getBackground();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void toggleSelected() {
        this.setSelected(!this.selected);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isSelected()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(Color.BLACK);
            BasicStroke stroke = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f, 3.0f, 3.0f}, this.dashTimer.getOffset());
            g2d.setStroke(stroke);
            int halfThickness = Math.max(1, 1);
            g2d.drawRect(halfThickness, halfThickness, this.getWidth() - 2, this.getHeight() - 2);
        }
    }
}

