/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component.combomenu;

import com.glitchcog.fontificator.game.GameGenre;
import com.glitchcog.fontificator.game.GameSystem;
import com.glitchcog.fontificator.game.VideoGame;
import javax.swing.JMenuItem;

public class GameFontMenuItem
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private VideoGame game;

    public GameFontMenuItem(String text) {
        this(text, new VideoGame(text));
    }

    public GameFontMenuItem(String text, VideoGame game) {
        super(text);
        this.game = game;
    }

    public VideoGame getGame() {
        return this.game;
    }

    public boolean isMatchingFilterGame(String filter) {
        filter = filter.toLowerCase().trim();
        return this.game.getName().toLowerCase().contains(filter);
    }

    public boolean isMatchingFilterSystem(String filter) {
        GameSystem[] gameSystemArray = GameSystem.values();
        int n = gameSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameSystem system = gameSystemArray[n2];
            if (system.matchesName(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isMatchingFilterGenre(String filter) {
        GameGenre[] gameGenreArray = GameGenre.values();
        int n = gameGenreArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameGenre genre = gameGenreArray[n2];
            if (genre.matchesName(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

