/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component.combomenu;

import com.glitchcog.fontificator.gui.component.combomenu.ComboMenu;
import com.glitchcog.fontificator.gui.component.combomenu.GameFontMenuItem;
import com.glitchcog.fontificator.gui.component.combomenu.HintTextField;
import com.glitchcog.fontificator.gui.component.combomenu.MenuIcon;
import com.glitchcog.fontificator.gui.component.combomenu.MenuScrollItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenu mainMenu;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    public static final int SCROLL_COUNT = 12;
    private int firstIndex = 0;
    private Dimension preferredSize;
    private HintTextField filterInput;
    private Map<JMenuItem, MenuVisibilityStatus> allMenuItems;
    private Map<JMenu, MenuVisibilityStatus> allMenuFolders;

    public HintTextField getFilter() {
        return this.filterInput;
    }

    public ComboMenuBar(Map<String, List<String>> menuTextMap, ActionListener al) {
        this.setPreferredSize(new Dimension(240, 24));
        this.filterInput = new HintTextField("Filter", 7);
        this.filterInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComboMenuBar.this.applyFilter(ComboMenuBar.this.filterInput.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ComboMenuBar.this.applyFilter(ComboMenuBar.this.filterInput.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ComboMenuBar.this.applyFilter(ComboMenuBar.this.filterInput.getText());
            }
        });
        Set<String> menuLabels = menuTextMap.keySet();
        this.allMenuItems = new LinkedHashMap<JMenuItem, MenuVisibilityStatus>();
        this.allMenuFolders = new LinkedHashMap<JMenu, MenuVisibilityStatus>();
        ArrayList<JMenuItem> rootItems = new ArrayList<JMenuItem>();
        for (String label : menuLabels) {
            JMenuItem item;
            MenuVisibilityStatus status = new MenuVisibilityStatus();
            if (menuTextMap.get(label) == null) {
                item = new JMenuItem(label);
                item.addActionListener(al);
                rootItems.add(item);
                this.allMenuItems.put(item, status);
                continue;
            }
            item = new JMenu(label);
            this.allMenuFolders.put((JMenu)item, status);
            this.allMenuItems.put(item, status);
        }
        ComboMenu menu = new ComboMenu();
        for (JMenuItem m : this.allMenuItems.keySet()) {
            List<String> submenuText = menuTextMap.get(m.getText());
            if (submenuText == null) continue;
            for (String submenuLabel : submenuText) {
                GameFontMenuItem item = new GameFontMenuItem(submenuLabel);
                item.addActionListener(al);
                m.add(item);
            }
            menu.add(m);
        }
        for (JMenuItem item : rootItems) {
            menu.add(item);
        }
        this.setup(menu);
        this.setupScroll(menu);
        this.mainMenu = menu;
    }

    private void setup(final JMenu menu) {
        Color color = UIManager.getColor("Menu.selectionBackground");
        UIManager.put("Menu.selectionBackground", UIManager.getColor("Menu.background"));
        menu.updateUI();
        UIManager.put("Menu.selectionBackground", color);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                menu.setText(item.getText());
                menu.requestFocus();
            }
        };
        this.setListener(menu, listener);
        this.add(menu);
    }

    private void setupScroll(JMenu menu) {
        this.upItem = new MenuScrollItem(this, MenuIcon.UP);
        this.downItem = new MenuScrollItem(this, MenuIcon.DOWN);
        PopupMenuListener menuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ComboMenuBar.this.updateScroll();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        MenuSelectionManager.defaultManager().clearSelectedPath();
        menu.getPopupMenu().addPopupMenuListener(menuListener);
    }

    private void setListener(JMenuItem item, ActionListener listener) {
        if (item instanceof JMenu) {
            JMenu menu = (JMenu)item;
            int n = menu.getItemCount();
            int i = 0;
            while (i < n) {
                this.setListener(menu.getItem(i), listener);
                ++i;
            }
        } else if (item != null) {
            item.addActionListener(listener);
        }
    }

    private void applyFilter(String filterText) {
        this.resetMenu();
        for (JMenu menuFolder : this.allMenuFolders.keySet()) {
            boolean atLeastOneHit = false;
            boolean matchesMenu = menuFolder.getText().toLowerCase().contains(filterText.toLowerCase().trim());
            int i = 0;
            while (i < menuFolder.getItemCount()) {
                GameFontMenuItem gfmi = (GameFontMenuItem)menuFolder.getItem(i);
                boolean matchesGame = gfmi.isMatchingFilterGame(filterText);
                boolean matchesGenre = gfmi.isMatchingFilterGenre(filterText);
                boolean matchesSystem = gfmi.isMatchingFilterSystem(filterText);
                boolean hit = matchesMenu || matchesGame || matchesGenre || matchesSystem;
                gfmi.setVisible(hit);
                if (hit) {
                    atLeastOneHit = true;
                }
                ++i;
            }
            this.allMenuItems.get(menuFolder).setFiltered(!atLeastOneHit);
        }
        this.setMenuItemFilterVisibility();
    }

    private void setMenuItemFilterVisibility() {
        for (JMenuItem menuFolder : this.allMenuItems.keySet()) {
            boolean menuFolderVisibility = !this.allMenuItems.get(menuFolder).isFiltered() && !menuFolder.getText().isEmpty();
            menuFolder.setVisible(menuFolderVisibility);
        }
    }

    private List<JMenuItem> getInBoundScrollMenuFolders() {
        ArrayList<JMenuItem> menuItemKeyList = new ArrayList<JMenuItem>();
        for (JMenuItem menuFolder : this.allMenuItems.keySet()) {
            if (this.allMenuItems.get(menuFolder).isOutOfScrollBounds()) continue;
            menuItemKeyList.add(menuFolder);
        }
        return menuItemKeyList;
    }

    public void updateScroll() {
        List<JMenuItem> menuKeyList = this.getKeyList();
        this.firstIndex = Math.min(this.firstIndex, menuKeyList.size() - 12);
        this.firstIndex = Math.max(this.firstIndex, 0);
        int lastIndex = this.firstIndex + Math.min(menuKeyList.size(), 12);
        int runningUnfilteredCount = 0;
        int i = 0;
        while (i < menuKeyList.size()) {
            JMenuItem jmi = menuKeyList.get(i);
            MenuVisibilityStatus status = this.allMenuItems.get(jmi);
            boolean inScrollBounds = !status.isFiltered() && runningUnfilteredCount >= this.firstIndex && runningUnfilteredCount < lastIndex;
            status.setOutOfScrollBounds(!inScrollBounds);
            if (!status.isFiltered()) {
                ++runningUnfilteredCount;
            }
            ++i;
        }
        this.mainMenu.getPopupMenu().removeAll();
        this.setMenuItemFilterVisibility();
        this.upItem.setEnabled(this.firstIndex > 0);
        this.mainMenu.getPopupMenu().add(this.upItem);
        List<JMenuItem> inBoundsScrollMenuFolders = this.getInBoundScrollMenuFolders();
        for (JMenuItem menuFolder : inBoundsScrollMenuFolders) {
            this.mainMenu.getPopupMenu().add(menuFolder);
        }
        this.downItem.setEnabled(lastIndex < runningUnfilteredCount);
        this.mainMenu.getPopupMenu().add(this.downItem);
        JComponent parent = (JComponent)this.upItem.getParent();
        parent.revalidate();
        parent.repaint();
    }

    private void resetMenu() {
        this.firstIndex = 0;
        this.mainMenu.getPopupMenu().removeAll();
        for (JMenuItem menuFolder : this.allMenuItems.keySet()) {
            this.allMenuItems.get(menuFolder).reset();
            menuFolder.setVisible(true);
            if (!(menuFolder instanceof JMenu)) continue;
            JMenu jMenuFolder = (JMenu)menuFolder;
            int i = 0;
            while (i < jMenuFolder.getItemCount()) {
                jMenuFolder.getItem(i).setVisible(true);
                ++i;
            }
        }
        for (JMenuItem menuFolder : this.allMenuItems.keySet()) {
            menuFolder.setVisible(true);
            this.mainMenu.getPopupMenu().add(menuFolder);
        }
    }

    public String getSelectedItem() {
        return this.mainMenu.getText();
    }

    public void setSelectedText(String label) {
        this.mainMenu.setText(label);
    }

    @Override
    public void setPreferredSize(Dimension size) {
        this.preferredSize = size;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            Dimension menuD = this.getItemSize(this.mainMenu);
            Insets margin = this.mainMenu.getMargin();
            Dimension retD = new Dimension(menuD.width, margin.top + margin.bottom + menuD.height);
            this.mainMenu.setPreferredSize(retD);
            this.preferredSize = retD;
        }
        return this.preferredSize;
    }

    private Dimension getItemSize(JMenu menu) {
        Dimension d = new Dimension(0, 0);
        int n = menu.getItemCount();
        int i = 0;
        while (i < n) {
            JMenuItem item = menu.getItem(i);
            Dimension itemD = item instanceof JMenu ? this.getItemSize((JMenu)item) : (item != null ? item.getPreferredSize() : new Dimension(0, 0));
            d.width = Math.max(d.width, itemD.width);
            d.height = Math.max(d.height, itemD.height);
            ++i;
        }
        return d;
    }

    private List<JMenuItem> getKeyList() {
        ArrayList<JMenuItem> menuItemKeyList = new ArrayList<JMenuItem>();
        for (JMenuItem menuFolder : this.allMenuItems.keySet()) {
            if (menuFolder.getText().isEmpty()) continue;
            menuItemKeyList.add(menuFolder);
        }
        return menuItemKeyList;
    }

    public void incrementFirstIndex(int increment) {
        this.firstIndex += increment;
    }

    private class MenuVisibilityStatus {
        private boolean filtered;
        private boolean outOfScrollBounds;

        private MenuVisibilityStatus() {
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        public void setOutOfScrollBounds(boolean outOfScrollBounds) {
            this.outOfScrollBounds = outOfScrollBounds;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public boolean isOutOfScrollBounds() {
            return this.outOfScrollBounds;
        }

        public void reset() {
            this.filtered = false;
            this.outOfScrollBounds = false;
        }

        public String toString() {
            return "Filtered=" + this.filtered + "; OutOfScrollBounds=" + this.outOfScrollBounds;
        }
    }
}

