/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component;

import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import com.glitchcog.fontificator.gui.controls.panel.MessageCensorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListInput
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JLabel description;
    private JTextField input;
    private List list;
    private JButton add;
    private JButton remove;
    private MessageCensorPanel censor;

    public ListInput(String label, String description, MessageCensorPanel censor, ActionListener lial) {
        this.censor = censor;
        this.build(label, description, 5, lial);
    }

    private void build(String label, String description, int size, ActionListener lial) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = ControlPanelBase.getGbc();
        gbc.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = this.label = label == null ? null : new JLabel(label);
        if (description != null) {
            this.description = new JLabel(description);
            Font defFont = this.description.getFont();
            this.description.setFont(new Font(defFont.getName(), defFont.getStyle(), defFont.getSize() - 2));
        }
        this.input = new JTextField(12);
        this.list = new List(size);
        this.list.setMultipleMode(true);
        this.add = new JButton("\u271a");
        this.add.setBackground(Color.WHITE);
        this.add.setMargin(new Insets(0, 0, 0, 0));
        this.remove = new JButton("\u2718");
        this.remove.setBackground(Color.WHITE);
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        if (lial != null) {
            this.add.addActionListener(lial);
            this.remove.addActionListener(lial);
        }
        if (!this.add.getFont().canDisplay(this.add.getText().charAt(0))) {
            this.add.setText("+");
        }
        if (!this.remove.getFont().canDisplay(this.remove.getText().charAt(0))) {
            this.add.setText("-");
        }
        this.list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ListInput.this.enableRemoveButton();
            }
        });
        this.input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.change(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.change(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.change(e);
            }

            private void change(DocumentEvent e) {
                ListInput.this.enableAddButton();
            }
        });
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListInput.this.enableAddButton();
                if (ListInput.this.add.isEnabled()) {
                    ListInput.this.addInput();
                }
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                if (ListInput.this.add.equals(source)) {
                    ListInput.this.addInput();
                } else if (ListInput.this.remove.equals(source)) {
                    String[] selectedItems = ListInput.this.list.getSelectedItems();
                    ListInput.this.input.setText(selectedItems.length == 1 ? selectedItems[0] : "");
                    String[] stringArray = selectedItems;
                    int n = selectedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        ListInput.this.list.remove(item);
                        ++n2;
                    }
                    ListInput.this.remove.setEnabled(false);
                    ListInput.this.censor.recheckCensorship();
                }
            }
        };
        this.add.addActionListener(al);
        this.remove.addActionListener(al);
        this.add.setEnabled(false);
        this.remove.setEnabled(false);
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints ipGbc = ControlPanelBase.getGbc();
        ipGbc.insets = new Insets(0, 0, 0, 0);
        ipGbc.weightx = 1.0;
        ipGbc.fill = 1;
        inputPanel.add((Component)this.input, ipGbc);
        ++ipGbc.gridx;
        ipGbc.weightx = 0.0;
        ipGbc.fill = 3;
        inputPanel.add((Component)this.add, ipGbc);
        ++ipGbc.gridx;
        inputPanel.add((Component)this.remove, ipGbc);
        ++ipGbc.gridx;
        gbc.anchor = 10;
        if (this.label != null) {
            this.add((Component)this.label, gbc);
            ++gbc.gridy;
        }
        if (this.description != null) {
            this.add((Component)this.description, gbc);
            ++gbc.gridy;
        }
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)inputPanel, gbc);
        gbc.anchor = 11;
        gbc.fill = 1;
        ++gbc.gridy;
        this.add((Component)this.list, gbc);
        ++gbc.gridy;
    }

    private void addInput() {
        if (!this.input.getText().isEmpty() && !this.contains(this.input.getText().trim())) {
            this.addItem(this.input.getText());
            this.input.setText("");
            this.censor.recheckCensorship();
            this.censor.updateConfig();
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    public boolean contains(String value) {
        String[] stringArray = this.list.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addItem(String value) {
        if (value != null && !value.trim().isEmpty()) {
            if (value.contains(",")) {
                ChatWindow.popup.handleProblem("Value cannot contain a comma.");
            } else if (value.contains(" ") || value.contains("\t")) {
                ChatWindow.popup.handleProblem("Please insert only a single value.");
            } else {
                this.list.add(value.trim());
            }
        }
    }

    public void removeItem(String value) {
        String[] stringArray = this.list.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equalsIgnoreCase(value)) {
                this.list.remove(item);
            }
            ++n2;
        }
    }

    public void setList(String[] itemList) {
        this.list.removeAll();
        String[] stringArray = itemList;
        int n = itemList.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!(item == null || item.trim().isEmpty() || item.trim().contains(",") || item.trim().contains(" ") || item.trim().contains("\t"))) {
                this.list.add(item.trim());
            }
            ++n2;
        }
    }

    public String[] getList() {
        return this.list.getItems();
    }

    private void enableAddButton() {
        this.add.setEnabled(!this.input.getText().isEmpty() && !this.input.getText().contains(",") && !this.input.getText().contains(" ") && !this.input.getText().contains("\t"));
    }

    private void enableRemoveButton() {
        this.remove.setEnabled(this.list.getSelectedItems().length > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.description.setEnabled(enabled);
        this.input.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.enableAddButton();
        this.enableRemoveButton();
        if (!enabled) {
            this.input.setText("");
        }
    }
}

