/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LabeledSlider
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final float NO_SCALE = 1.0f;
    protected JSlider slider;
    private JLabel label;
    private String unitLabelStr;
    private JLabel unitLabel;
    private int maxValueDigits;
    private float scale;

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max) {
        this(labelStr, unitLabelStr, min, max, Math.max(Integer.toString(min).length(), Integer.toString(max).length()));
    }

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max, float scale) {
        this(labelStr, unitLabelStr, min, max, Math.max(Integer.toString(min).length(), Integer.toString(max).length()), scale);
    }

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max, int maxValueDigits) {
        this(labelStr, unitLabelStr, min, max, min, maxValueDigits);
    }

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max, int maxValueDigits, float scale) {
        this(labelStr, unitLabelStr, min, max, min, maxValueDigits, scale);
    }

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max, int value, int maxValueDigits) {
        this(labelStr, unitLabelStr, min, max, value, maxValueDigits, 1.0f);
    }

    public LabeledSlider(String labelStr, String unitLabelStr, int min, int max, int value, int maxValueDigits, float scale) {
        this.scale = scale;
        this.unitLabelStr = unitLabelStr;
        this.slider = new JSlider(0, min, max, value);
        this.label = new JLabel(labelStr);
        this.unitLabel = new JLabel(String.valueOf(this.slider.getValue()) + " " + unitLabelStr);
        this.maxValueDigits = maxValueDigits;
        this.setUnitLabel();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LabeledSlider.this.setUnitLabel();
            }
        });
        this.addComponents();
    }

    protected void addComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.label, gbc);
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        ++gbc.gridx;
        gbc.fill = 2;
        this.add((Component)this.slider, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        ++gbc.gridx;
        this.add((Component)this.unitLabel, gbc);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.unitLabel.setEnabled(enabled);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public float getScaledValue() {
        return (float)this.getValue() * this.scale;
    }

    public String getValueString() {
        if (this.scale == 1.0f) {
            return Integer.toString(this.getValue());
        }
        return String.format("%.2f", Float.valueOf(this.getScaledValue()));
    }

    protected void setUnitLabel() {
        this.unitLabel.setText("<html><nobr><tt><b>" + this.padValue(this.getValueString()) + " " + this.getUnitLabelStr() + "</b></tt></nobr></html>");
    }

    private String padValue(String valStr) {
        return this.padValue(valStr, this.maxValueDigits);
    }

    protected String padValue(String valStr, int length) {
        while (valStr.length() < length) {
            valStr = " " + valStr;
        }
        valStr = valStr.replaceAll(" ", "&nbsp;");
        return valStr;
    }

    public void addChangeListener(ChangeListener cl) {
        this.slider.addChangeListener(cl);
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public void setScaledValue(float value) {
        this.setValue((int)(value / this.scale));
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setValueTextColor(Color textColor) {
        this.unitLabel.setForeground(textColor);
    }

    protected String getUnitLabelStr() {
        return this.unitLabelStr;
    }
}

